/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.ui.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.contribution.xref.core.IDeferredXReference;
import org.eclipse.contribution.xref.core.IXReferenceAdapter;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.TreeParent;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.internal.ui.ras.XRefUIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class XRefUIUtils {
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    public static ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = XRefUIUtils.getElementAt(editor, caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_0, ajc$tjp_1);
            }
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    private static IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block11: {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IJavaElement[] children = unit.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] instanceof SourceType) {
                                return children[i];
                            }
                            ++i;
                        }
                        break block11;
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_2, ajc$tjp_3);
                    JavaModelException x = javaModelException2;
                    if (x.isDoesNotExist()) break block11;
                    JavaPlugin.log((IStatus)x.getStatus());
                }
            }
        }
        return null;
    }

    public static void revealInEditor(IJavaElement j) {
        try {
            IEditorPart p = JavaUI.openInEditor((IJavaElement)j);
            JavaUI.revealInEditor((IEditorPart)p, (IJavaElement)j);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(exception2, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public static void revealInEditor(IResource r) {
        try {
            IMarker m = r.createMarker("org.eclipse.core.resources.marker");
            IDE.openEditor((IWorkbenchPage)XRefUIUtils.getActiveWorkbenchWindow().getActivePage(), (IMarker)m, (boolean)true);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(coreException2, ajc$tjp_6, ajc$tjp_7);
        }
    }

    public static void evaluateXReferences(IDeferredXReference xr, TreeViewer viewer, Shell shell) {
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)xr);
            if (!(viewer.getContentProvider() instanceof XReferenceContentProvider)) {
                return;
            }
            ((XReferenceContentProvider)viewer.getContentProvider()).refresh();
            viewer.refresh();
            viewer.expandToLevel(3);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(interruptedException2, ajc$tjp_8, ajc$tjp_9);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(invocationTargetException2, ajc$tjp_10, ajc$tjp_9);
            InvocationTargetException invEx = invocationTargetException2;
            System.err.println("Something nasty here, " + xr + " could not be evaluated: " + invEx);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return XReferenceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static List getXRefAdapterForSelection(IWorkbenchPart part, ISelection selection, boolean showParentCrosscutting) {
        ArrayList xrefAdapterList = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getXRefAdapterList((IJavaElement)first, showParentCrosscutting);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getXRefAdapterList(javaElement, showParentCrosscutting);
        }
        return xrefAdapterList;
    }

    private static List getXRefAdapterList(IJavaElement javaElement, boolean showParentCrosscutting) {
        ArrayList<IXReferenceAdapter> xrefAdapterList = new ArrayList<IXReferenceAdapter>();
        if (javaElement != null && showParentCrosscutting) {
            ICompilationUnit parent = (ICompilationUnit)javaElement.getAncestor(5);
            if (parent != null) {
                try {
                    IType[] types = parent.getAllTypes();
                    int i = 0;
                    while (i < types.length) {
                        IAdaptable a;
                        if (types[i] instanceof SourceType && types[i].getParent() instanceof ICompilationUnit && (a = (IAdaptable)((SourceType)types[i])) != null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(classNotFoundException2, ajc$tjp_11, ajc$tjp_12);
                                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                                }
                            }
                            xrefAdapterList.add((IXReferenceAdapter)a.getAdapter((Class)clazz));
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_13, ajc$tjp_12);
                }
            }
        } else {
            IAdaptable a = (IAdaptable)javaElement;
            if (a != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException3 = classNotFoundException;
                        XRefUIFFDC.aspectOf().ajc$before$org_eclipse_contribution_xref_ras_FFDC$1$31280822(classNotFoundException3, ajc$tjp_14, ajc$tjp_12);
                        throw new NoClassDefFoundError(classNotFoundException3.getMessage());
                    }
                }
                xrefAdapterList.add((IXReferenceAdapter)a.getAdapter((Class)clazz));
            }
        }
        return xrefAdapterList;
    }

    public static ISelection getCurrentSelection() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getSelectionService().getSelection();
        }
        return null;
    }

    public static TreeObject getTreeObjectForSelection(TreeViewer viewer, ISelection selection, IWorkbenchPart part) {
        if (selection instanceof IStructuredSelection) {
            Object data;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)first);
            }
            if (first instanceof TreeObject && (data = ((TreeObject)first).getData()) instanceof IJavaElement) {
                return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), (IJavaElement)data);
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = XRefUIUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return XRefUIUtils.getTreeObjectForJavaElement(viewer.getTree().getItems(), javaElement);
        }
        return null;
    }

    public static TreeObject getTreeObjectForJavaElement(TreeItem[] items, IJavaElement javaElement) {
        int i = 0;
        while (i < items.length) {
            Object o = items[i].getData();
            TreeParent treeParent = null;
            TreeObject treeObject = null;
            if (o instanceof TreeParent) {
                treeParent = (TreeParent)o;
            } else if (o instanceof TreeObject) {
                treeObject = (TreeObject)o;
            }
            TreeObject element = null;
            element = treeParent == null ? treeObject : treeParent;
            if (element != null && element.getData() != null && element.getData().equals(javaElement)) {
                return element;
            }
            element = XRefUIUtils.getTreeObjectForJavaElement(items[i].getItems(), javaElement);
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static void setSelection(IWorkbenchPart part, ISelection selection, TreeViewer viewer) {
        TreeObject o = XRefUIUtils.getTreeObjectForSelection(viewer, selection, part);
        if (o != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)o), true);
            viewer.reveal((Object)o);
        } else if (selection != null) {
            viewer.setSelection(selection, true);
            viewer.reveal((Object)selection);
        }
    }

    static {
        Factory factory = new Factory("XRefUIUtils.java", Class.forName("org.eclipse.contribution.xref.ui.utils.XRefUIUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 101);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-computeHighlightRangeSourceReference-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.internal.ui.javaeditor.JavaEditor:-editor:--org.eclipse.jdt.core.ISourceReference-"), 72);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-java.lang.reflect.InvocationTargetException-invEx-"), 183);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-java.lang.ClassNotFoundException-<missing>-"), 233);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getXRefAdapterList-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.core.IJavaElement:boolean:-javaElement:showParentCrosscutting:--java.util.List-"), 222);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.core.JavaModelException-<missing>-"), 237);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-java.lang.ClassNotFoundException-<missing>-"), 243);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.core.JavaModelException-x-"), 143);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getElementAt-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.internal.ui.javaeditor.JavaEditor:int:boolean:-editor:offset:reconcile:--org.eclipse.jdt.core.IJavaElement-"), 118);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-java.lang.Exception-<missing>-"), 157);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-revealInEditor-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.jdt.core.IJavaElement:-j:--void-"), 155);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.core.runtime.CoreException-<missing>-"), 167);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-revealInEditor-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.core.resources.IResource:-r:--void-"), 165);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.contribution.xref.ui.utils.XRefUIUtils-java.lang.InterruptedException-<missing>-"), 181);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-evaluateXReferences-org.eclipse.contribution.xref.ui.utils.XRefUIUtils-org.eclipse.contribution.xref.core.IDeferredXReference:org.eclipse.jface.viewers.TreeViewer:org.eclipse.swt.widgets.Shell:-xr:viewer:shell:--void-"), 174);
    }
}

