/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ajdocexport;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ajdocexport.AJdocOptionsManager;
import org.eclipse.ajdt.ajdocexport.AJdocTreeWizardPage;
import org.eclipse.ajdt.ajdocexport.AJdocWizardPage;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocLinkDialogLabelProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocLinkRef;
import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AJdocStandardWizardPage
extends AJdocWizardPage {
    private final int STYLESHEETSTATUS = 1;
    private final int LINK_REFERENCES = 2;
    private AJdocOptionsManager fStore;
    private Composite fUpperComposite;
    private Group fBasicOptionsGroup;
    private Group fTagsGroup;
    private Button fTitleButton;
    private Text fTitleText;
    private Text fStyleSheetText;
    private FlaggedButton fDeprecatedList;
    private FlaggedButton fDeprecatedCheck;
    private FlaggedButton fIndexCheck;
    private FlaggedButton fSeperatedIndexCheck;
    private Button fStyleSheetBrowseButton;
    private Button fStyleSheetButton;
    private CheckedListDialogField fListDialogField;
    private StatusInfo fStyleSheetStatus;
    private StatusInfo fLinkRefStatus;
    private ArrayList fButtonsList;
    private AJdocTreeWizardPage fFirstPage;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public AJdocStandardWizardPage(String pageName, AJdocTreeWizardPage firstPage, AJdocOptionsManager store) {
        super(pageName);
        this.fFirstPage = firstPage;
        this.setDescription(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.description"));
        this.fStore = store;
        this.fButtonsList = new ArrayList();
        this.fStyleSheetStatus = new StatusInfo();
        this.fLinkRefStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fUpperComposite = new Composite(parent, 0);
        this.fUpperComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        this.fUpperComposite.setLayout((Layout)layout);
        this.createBasicOptionsGroup(this.fUpperComposite);
        this.createTagOptionsGroup(this.fUpperComposite);
        this.createListDialogField(this.fUpperComposite);
        this.createStyleSheetGroup(this.fUpperComposite);
        this.setControl((Control)this.fUpperComposite);
        Dialog.applyDialogFont((Control)this.fUpperComposite);
        WorkbenchHelp.setHelp((Control)this.fUpperComposite, (String)"org.eclipse.jdt.ui.javadoc_standard_page_context");
    }

    private void createBasicOptionsGroup(Composite composite) {
        this.fTitleButton = this.createButton(composite, 32, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.titlebutton.label"), this.createGridData(1));
        this.fTitleText = this.createText(composite, 2052, null, this.createGridData(768, 3, 0));
        String text = this.fStore.getTitle();
        if (!text.equals("")) {
            this.fTitleText.setText(text);
            this.fTitleButton.setSelection(true);
        } else {
            this.fTitleText.setEnabled(false);
        }
        this.fBasicOptionsGroup = new Group(composite, 16);
        this.fBasicOptionsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fBasicOptionsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fBasicOptionsGroup.setText(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.basicgroup.label"));
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.usebutton.label"), new GridData(768), this.fStore.USE, true);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.hierarchybutton.label"), new GridData(768), this.fStore.NOTREE, false);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.navigartorbutton.label"), new GridData(768), this.fStore.NONAVBAR, false);
        this.fIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.indexbutton.label"), new GridData(768), this.fStore.NOINDEX, false);
        this.fSeperatedIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.seperateindexbutton.label"), this.createGridData(512, 1, this.convertWidthInCharsToPixels(3)), this.fStore.SPLITINDEX, true);
        this.fSeperatedIndexCheck.getButton().setEnabled(this.fIndexCheck.getButton().getSelection());
        this.fIndexCheck.getButton().addSelectionListener((SelectionListener)new AJdocWizardPage.ToggleSelectionAdapter(new Control[]{this.fSeperatedIndexCheck.getButton()}));
        this.fTitleButton.addSelectionListener((SelectionListener)new AJdocWizardPage.ToggleSelectionAdapter(new Control[]{this.fTitleText}));
    }

    private void createTagOptionsGroup(Composite composite) {
        this.fTagsGroup = new Group(composite, 16);
        this.fTagsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fTagsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fTagsGroup.setText(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.tagsgroup.label"));
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.authorbutton.label"), new GridData(768), this.fStore.AUTHOR, true);
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.versionbutton.label"), new GridData(768), this.fStore.VERSION, true);
        this.fDeprecatedCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.deprecatedbutton.label"), new GridData(768), this.fStore.NODEPRECATED, false);
        this.fDeprecatedList = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.deprecatedlistbutton.label"), this.createGridData(768, 1, this.convertWidthInCharsToPixels(3)), this.fStore.NODEPRECATEDLIST, false);
        this.fDeprecatedList.getButton().setEnabled(this.fDeprecatedCheck.getButton().getSelection());
        this.fDeprecatedCheck.getButton().addSelectionListener((SelectionListener)new AJdocWizardPage.ToggleSelectionAdapter(new Control[]{this.fDeprecatedList.getButton()}));
    }

    private void createStyleSheetGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fStyleSheetButton = this.createButton(c, 32, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.stylesheettext.label"), this.createGridData(1));
        this.fStyleSheetText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fStyleSheetText.getLayoutData()).widthHint = 200;
        this.fStyleSheetBrowseButton = this.createButton(c, 8, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.stylesheetbrowsebutton.label"), this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint((Button)this.fStyleSheetBrowseButton);
        String str = this.fStore.getStyleSheet();
        if (str.equals("")) {
            this.fStyleSheetText.setEnabled(false);
            this.fStyleSheetBrowseButton.setEnabled(false);
        } else {
            this.fStyleSheetButton.setSelection(true);
            this.fStyleSheetText.setText(str);
        }
        this.fStyleSheetButton.addSelectionListener((SelectionListener)new AJdocWizardPage.ToggleSelectionAdapter(new Control[]{this.fStyleSheetText, this.fStyleSheetBrowseButton}){

            public void validate() {
                AJdocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AJdocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AJdocStandardWizardPage.this.handleFileBrowseButtonPressed(AJdocStandardWizardPage.this.fStyleSheetText, new String[]{"*.css"}, JavadocExportMessages.getString((String)"AJdocSpecificsWizardPage.stylesheetbrowsedialog.title"));
            }
        });
    }

    private void createListDialogField(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(1808, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        String[] buttonlabels = new String[]{JavadocExportMessages.getString((String)"JavadocStandardWizardPage.selectallbutton.label"), JavadocExportMessages.getString((String)"JavadocStandardWizardPage.clearallbutton.label"), JavadocExportMessages.getString((String)"JavadocStandardWizardPage.configurebutton.label")};
        JavadocLinkDialogLabelProvider labelProvider = new JavadocLinkDialogLabelProvider();
        ListAdapter adapter = new ListAdapter();
        this.fListDialogField = new CheckedListDialogField((IListAdapter)adapter, buttonlabels, (ILabelProvider)labelProvider);
        this.fListDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fListDialogField.setCheckAllButtonIndex(0);
        this.fListDialogField.setUncheckAllButtonIndex(1);
        this.fListDialogField.setViewerSorter(new ViewerSorter());
        this.createLabel(c, 0, JavadocExportMessages.getString((String)"JavadocStandardWizardPage.referencedclasses.label"), this.createGridData(32, 4, 0));
        this.fListDialogField.doFillIntoGrid(c, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fListDialogField.getListControl(null));
        this.fListDialogField.enableButton(2, false);
    }

    private List getCheckedReferences(JavadocLinkRef[] referencesClasses) {
        ArrayList<JavadocLinkRef> checkedElements = new ArrayList<JavadocLinkRef>();
        String[] hrefs = this.fStore.getHRefs();
        if (hrefs.length > 0) {
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < hrefs.length) {
                set.add(hrefs[i]);
                ++i;
            }
            i = 0;
            while (i < referencesClasses.length) {
                JavadocLinkRef curr = referencesClasses[i];
                URL url = curr.getURL();
                if (url != null && set.contains(url.toExternalForm())) {
                    checkedElements.add(curr);
                }
                ++i;
            }
        }
        return checkedElements;
    }

    private JavadocLinkRef[] getReferencedElements(IJavaProject[] checkedProjects) {
        HashSet result = new HashSet();
        int i = 0;
        while (i < checkedProjects.length) {
            IJavaProject project = checkedProjects[i];
            try {
                this.collectReferencedElements(project, result);
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                CoreException e = coreException2;
                JavaPlugin.log((Throwable)e);
            }
            ++i;
        }
        return result.toArray(new JavadocLinkRef[result.size()]);
    }

    private void collectReferencedElements(IJavaProject project, HashSet result) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry curr = unresolved[i];
            if (curr.getType() == 1) {
                result.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)curr.getResource()))));
            } else {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)curr, (IJavaProject)project);
                int k = 0;
                while (k < entries.length) {
                    IRuntimeClasspathEntry entry = entries[k];
                    if (entry.getType() == 1) {
                        result.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)entry.getResource()))));
                    } else if (entry.getType() == 2) {
                        result.add(new JavadocLinkRef(entry.getPath()));
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    final void doValidation(int VALIDATE) {
        File file = null;
        String ext = null;
        Path path = null;
        block0 : switch (VALIDATE) {
            case 1: {
                this.fStyleSheetStatus = new StatusInfo();
                if (!this.fStyleSheetButton.getSelection()) break;
                path = new Path(this.fStyleSheetText.getText());
                file = new File(this.fStyleSheetText.getText());
                ext = path.getFileExtension();
                if (file == null || !file.exists()) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.stylesheetnopath.error"));
                    break;
                }
                if (ext != null && ext.equalsIgnoreCase("css")) break;
                this.fStyleSheetStatus.setError(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.stylesheetnotcss.error"));
                break;
            }
            case 2: {
                this.fLinkRefStatus = new StatusInfo();
                List list = this.fListDialogField.getCheckedElements();
                int i = 0;
                while (i < list.size()) {
                    JavadocLinkRef curr = (JavadocLinkRef)list.get(i);
                    URL url = curr.getURL();
                    if (url == null) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.nolinkref.error"));
                        break block0;
                    }
                    if ("jar".equals(url.getProtocol())) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.nojarlinkref.error"));
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fStyleSheetStatus, this.fLinkRefStatus});
    }

    public void updateStore() {
        if (this.fTitleButton.getSelection()) {
            this.fStore.setTitle(this.fTitleText.getText());
        } else {
            this.fStore.setTitle("");
        }
        Object[] buttons = this.fButtonsList.toArray();
        int i = 0;
        while (i < buttons.length) {
            FlaggedButton button = (FlaggedButton)buttons[i];
            if (button.getButton().getEnabled()) {
                this.fStore.setBoolean(button.getFlag(), !(button.getButton().getSelection() ^ button.show()));
            } else {
                this.fStore.setBoolean(button.getFlag(), !button.show());
            }
            ++i;
        }
        if (this.fStyleSheetText.getEnabled()) {
            this.fStore.setStyleSheet(this.fStyleSheetText.getText());
        } else {
            this.fStore.setStyleSheet("");
        }
        this.fStore.setHRefs(this.getHRefs());
    }

    private String[] getHRefs() {
        HashSet<String> res = new HashSet<String>();
        List checked = this.fListDialogField.getCheckedElements();
        Iterator iterator = checked.iterator();
        while (iterator.hasNext()) {
            JavadocLinkRef element = (JavadocLinkRef)iterator.next();
            URL url = element.getURL();
            if (url == null) continue;
            res.add(url.toExternalForm());
        }
        return res.toArray(new String[res.size()]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(1);
            this.updateHRefList(this.fFirstPage.getCheckedProjects());
        } else {
            this.fStore.setHRefs(this.getHRefs());
        }
    }

    private void updateHRefList(IJavaProject[] checkedProjects) {
        JavadocLinkRef[] res = this.getReferencedElements(checkedProjects);
        this.fListDialogField.setElements(Arrays.asList(res));
        List checked = this.getCheckedReferences(res);
        this.fListDialogField.setCheckedElements((Collection)checked);
    }

    public void init() {
        this.updateStatus((IStatus)new StatusInfo());
    }

    private void doEditButtonPressed() {
        List selected = this.fListDialogField.getSelectedElements();
        if (selected.isEmpty()) {
            return;
        }
        JavadocLinkRef obj = (JavadocLinkRef)selected.get(0);
        if (obj != null) {
            JavadocPropertyDialog jdialog = new JavadocPropertyDialog(this.getShell(), obj);
            jdialog.open();
        }
    }

    static {
        Factory factory = new Factory("AJdocStandardWizardPage.java", Class.forName("org.eclipse.ajdt.ajdocexport.AJdocStandardWizardPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ajdocexport.AJdocStandardWizardPage-org.eclipse.core.runtime.CoreException-e-"), 287);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getReferencedElements-org.eclipse.ajdt.ajdocexport.AJdocStandardWizardPage-[Lorg.eclipse.jdt.core.IJavaProject;:-checkedProjects:--[Lorg.eclipse.jdt.internal.ui.javadocexport.JavadocLinkRef;-"), 282);
    }

    protected class FlaggedButton {
        private Button fButton;
        private String fFlag;
        private boolean fShowFlag;

        public FlaggedButton(Composite composite, String message, GridData gridData, String flag, boolean show) {
            this.fFlag = flag;
            this.fShowFlag = show;
            this.fButton = AJdocStandardWizardPage.this.createButton(composite, 32, message, gridData);
            AJdocStandardWizardPage.this.fButtonsList.add(this);
            this.setButtonSettings();
        }

        public Button getButton() {
            return this.fButton;
        }

        public String getFlag() {
            return this.fFlag;
        }

        public boolean show() {
            return this.fShowFlag;
        }

        private void setButtonSettings() {
            this.fButton.setSelection(!(AJdocStandardWizardPage.this.fStore.getBoolean(this.fFlag) ^ this.fShowFlag));
        }
    }

    private class ListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            if (index == 2) {
                AJdocStandardWizardPage.this.doEditButtonPressed();
            }
        }

        public void selectionChanged(ListDialogField field) {
            List selection = AJdocStandardWizardPage.this.fListDialogField.getSelectedElements();
            if (selection.size() != 1) {
                AJdocStandardWizardPage.this.fListDialogField.enableButton(2, false);
            } else {
                AJdocStandardWizardPage.this.fListDialogField.enableButton(2, true);
            }
        }

        public void doubleClicked(ListDialogField field) {
            AJdocStandardWizardPage.this.doEditButtonPressed();
        }

        public void dialogFieldChanged(DialogField field) {
            AJdocStandardWizardPage.this.doValidation(2);
        }
    }

    private class JavadocPropertyDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private JavadocConfigurationBlock fJavadocConfigurationBlock;
        private JavadocLinkRef fElement;

        public JavadocPropertyDialog(Shell parent, JavadocLinkRef selection) {
            super(parent);
            this.setTitle(JavadocExportMessages.getString((String)"JavadocStandardWizardPage.javadocpropertydialog.title"));
            this.fElement = selection;
            URL initialLocation = selection.getURL();
            this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(parent, (IStatusChangeListener)this, initialLocation, selection.isProjectRef());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control inner = this.fJavadocConfigurationBlock.createContents(composite);
            inner.setLayoutData((Object)new GridData(1808));
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        protected void okPressed() {
            URL javadocLocation = this.fJavadocConfigurationBlock.getJavadocLocation();
            this.fElement.setURL(javadocLocation);
            AJdocStandardWizardPage.this.fListDialogField.refresh();
            AJdocStandardWizardPage.this.doValidation(2);
            super.okPressed();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.javadoc_property_dialog_context");
        }
    }
}

