/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurationCreationException;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.Util;
import org.eclipse.ajdt.buildconfigurator.editor.BuildProperties;
import org.eclipse.ajdt.internal.core.CoreUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BuildConfiguration
implements Cloneable,
Util.Comparable {
    public static final String EXTENSION = "ajproperties";
    public static final String STANDARD_BUILD_CONFIGURATION_NAME;
    public static final String STANDARD_BUILD_CONFIGURATION_FILE;
    public static final int LST_FILE_LINK = 5;
    private String name;
    private BuildProperties propertiesFile;
    private HashSet fileList;
    private ProjectBuildConfigurator pbc;
    private boolean listenToFileChanges = true;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;

    static {
        Factory factory = new Factory("BuildConfiguration.java", Class.forName("org.eclipse.ajdt.buildconfigurator.BuildConfiguration"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.jdt.core.JavaModelException-<missing>-"), 130);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-java.lang.String:org.eclipse.jdt.core.IJavaProject:org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator:-name:jp:pbc:--"), 79);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.runtime.CoreException-<missing>-"), 364);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.ui.PartInitException-<missing>-"), 381);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.jdt.core.JavaModelException-<missing>-"), 427);
        ajc$tjp_13 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.resources.IFile:org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator:boolean:-fileToUse:pbc:makeActive:--"), 79);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.runtime.CoreException-e-"), 627);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-writeLstFile-org.eclipse.ajdt.buildconfigurator.BuildConfiguration----void-"), 594);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.ui.PartInitException-<missing>-"), 205);
        ajc$tjp_3 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.resources.IFile:org.eclipse.swt.widgets.Shell:org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator:-lstFile2:shell:pbc:--"), 79);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.runtime.CoreException-<missing>-"), 254);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-minimizeIncludes-org.eclipse.ajdt.buildconfigurator.BuildConfiguration-java.util.HashSet:-fileList:--java.util.List-"), 213);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-java.io.FileNotFoundException-<missing>-"), 279);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-addLStFileContentsToFileList-org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.resources.IFile:-lstFile:--void-"), 272);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.core.runtime.CoreException-<missing>-"), 357);
        ajc$tjp_9 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.buildconfigurator.BuildConfiguration-org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator:org.eclipse.swt.widgets.Shell:-pbc:parentShell:-org.eclipse.ajdt.buildconfigurator.BuildConfigurationCreationException:-"), 79);
        STANDARD_BUILD_CONFIGURATION_NAME = AspectJUIPlugin.getResourceString("buildConfig.standardFileName");
        STANDARD_BUILD_CONFIGURATION_FILE = String.valueOf(STANDARD_BUILD_CONFIGURATION_NAME) + "." + EXTENSION;
    }

    public BuildConfiguration(String name, IJavaProject jp, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.name = name;
        this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
        if (this.fileList != null) {
            this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
        } else {
            try {
                IClasspathEntry[] cpes2 = jp.getRawClasspath();
                if (BuildConfigurator.getBuildConfigurator().haveExclusionPatterns(cpes2)) {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getFileSetFromCPE(cpes2, jp);
                    this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
                } else {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
                    if (this.fileList != null) {
                        this.propertiesFile = new BuildProperties(this.getFileFromName(name), this.minimizeIncludes(this.fileList));
                    } else {
                        ArrayList<IPath> pathes = new ArrayList<IPath>();
                        int i = 0;
                        while (i < cpes2.length) {
                            if (cpes2[i].getEntryKind() == 3) {
                                IPath p = cpes2[i].getPath();
                                IResource res = jp.getProject().getParent().findMember(p);
                                if (res != null && res.exists()) {
                                    pathes.add(res.getProjectRelativePath());
                                }
                            }
                            ++i;
                        }
                        this.propertiesFile = new BuildProperties(this.getFileFromName(name), pathes);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
            }
        }
    }

    public IFile getFile() {
        return this.getFileFromName(this.name);
    }

    public BuildConfiguration(IFile existingFile, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.loadDataFromFile(existingFile);
    }

    private HashSet getFileList() {
        if (this.fileList == null) {
            HashSet newList = new HashSet(20);
            newList.addAll(this.propertiesFile.getFiles(false));
            this.fileList = newList;
            return newList;
        }
        return this.fileList;
    }

    public BuildConfiguration(IFile lstFile2, Shell shell, ProjectBuildConfigurator pbc) {
        this.pbc = pbc;
        this.name = lstFile2.getName();
        this.name = this.name.substring(0, this.name.length() - 4);
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveLstAsAJProp.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveLstAsAJProp.message").replaceAll("%src", this.name);
        InputDialogWithCheck md = new InputDialogWithCheck(shell, title, msg, String.valueOf(this.name) + "." + EXTENSION, null);
        md.setBlockOnOpen(true);
        if (md.open() == 0 && md.getValue() != null) {
            IWorkbenchWindow dwindow;
            IWorkbenchPage page;
            String fileName = md.getValue();
            if (!fileName.endsWith(".ajproperties")) {
                fileName = String.valueOf(fileName) + "." + EXTENSION;
            }
            IFile file = pbc.getJavaProject().getProject().getFile(fileName);
            this.name = BuildConfiguration.getNameFromFile(file);
            if (file.exists() && !this.askUserOverwrite(fileName)) {
                return;
            }
            this.fileList = new HashSet();
            this.addLStFileContentsToFileList(lstFile2);
            IFile newFile = this.getFileFromName(this.name);
            this.propertiesFile = new BuildProperties(newFile, this.minimizeIncludes(this.fileList));
            pbc.addBuildConfiguration(this);
            if (md.isActivateChecked()) {
                pbc.setActiveBuildConfiguration(this);
            }
            if (md.isOpenInEditorChecked() && (page = (dwindow = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow()).getActivePage()) != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    PartInitException partInitException2 = partInitException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException2, this, ajc$tjp_2, ajc$tjp_3);
                }
            }
        }
    }

    private List minimizeIncludes(HashSet fileList) {
        HashSet temp1 = (HashSet)fileList.clone();
        HashSet temp2 = new HashSet();
        boolean hasChanged = true;
        Iterator iter = temp1.iterator();
        while (hasChanged) {
            hasChanged = false;
            iter = temp1.iterator();
            while (iter.hasNext()) {
                IResource f = (IResource)iter.next();
                IContainer cont = f.getParent();
                if (cont.getType() != 4) {
                    try {
                        IResource[] mems = cont.members();
                        boolean containsAll = true;
                        int i = 0;
                        while (i < mems.length) {
                            if (!temp1.contains(mems[i]) && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(mems[i].getName())) {
                                containsAll = false;
                                break;
                            }
                            if (!temp1.contains(mems[i]) && mems[i].getType() == 2) {
                                containsAll = false;
                                break;
                            }
                            ++i;
                        }
                        if (!containsAll) {
                            i = 0;
                            while (i < mems.length) {
                                if (temp1.remove(mems[i])) {
                                    temp2.add(mems[i]);
                                }
                                ++i;
                            }
                        } else {
                            i = 0;
                            while (i < mems.length) {
                                temp1.remove(mems[i]);
                                ++i;
                            }
                            hasChanged = true;
                            temp2.add(cont);
                        }
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_4, ajc$tjp_5);
                    }
                } else {
                    temp1.remove(f);
                    temp2.add(f);
                }
                iter = temp1.iterator();
            }
            HashSet temp3 = temp2;
            temp2 = temp1;
            temp1 = temp3;
        }
        return new ArrayList(temp1);
    }

    private void addLStFileContentsToFileList(IFile lstFile) {
        IFile f;
        String filename;
        ArrayList files = new ArrayList();
        ArrayList options = new ArrayList();
        ArrayList links = new ArrayList();
        try {
            Util.getLstFileContents(lstFile.getLocation(), files, options, links);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException2, this, ajc$tjp_6, ajc$tjp_7);
            return;
        }
        IProject pro = this.pbc.getJavaProject().getProject();
        IPath lstFileFolder = lstFile.getFullPath().removeLastSegments(1);
        int segs = lstFileFolder.matchingFirstSegments(pro.getFullPath());
        IPath relPath = lstFileFolder.removeFirstSegments(segs);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            filename = (String)iter.next();
            f = pro.getFile(relPath.append(filename));
            if (!f.exists()) continue;
            this.getFileList().add(f);
        }
        iter = links.iterator();
        while (iter.hasNext()) {
            filename = ((String)iter.next()).substring(1);
            f = pro.getFile(relPath.append(filename));
            if (!f.exists()) continue;
            this.addLStFileContentsToFileList(f);
        }
    }

    public BuildConfiguration(final ProjectBuildConfigurator pbc, Shell parentShell) throws BuildConfigurationCreationException {
        this.pbc = pbc;
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveBuildConfigurationAs.message");
        String fileName = BuildConfigurator.getFreeFileName(pbc.getJavaProject().getProject());
        BuildConfiguration origBC = pbc.getActiveBuildConfiguration();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String input) {
                IFile[] files = pbc.getConfigurationFiles();
                int i = 0;
                while (i < files.length) {
                    IFile file = files[i];
                    files[i].getName();
                    if (file.getName().equals(input) || file.getName().equals(String.valueOf(input) + "." + BuildConfiguration.EXTENSION)) {
                        return AspectJUIPlugin.getResourceString("BCDialog.NameValidator.ExistsError");
                    }
                    ++i;
                }
                return null;
            }
        };
        InputDialogWithCheck md = new InputDialogWithCheck(parentShell, title, msg, fileName, validator);
        md.setBlockOnOpen(true);
        if (md.open() == 0) {
            if (md.getValue() != null) {
                IWorkbenchWindow dwindow;
                IWorkbenchPage page;
                String newName;
                this.name = newName = md.getValue();
                IFile origFile = origBC.getFile();
                IFile newFile = this.getFile();
                if (newFile.exists()) {
                    if (!this.askUserOverwrite(newFile.getName())) {
                        throw new BuildConfigurationCreationException();
                    }
                    try {
                        newFile.delete(true, null);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_8, ajc$tjp_9);
                    }
                }
                try {
                    origFile.copy(newFile.getFullPath(), true, null);
                    this.propertiesFile = new BuildProperties(newFile);
                }
                catch (CoreException coreException) {
                    CoreException coreException3 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, this, ajc$tjp_10, ajc$tjp_9);
                    this.propertiesFile = new BuildProperties(this.getFileFromName(this.name), new ArrayList(this.getFileList()));
                }
                this.fileList = new HashSet(this.propertiesFile.getFiles(false));
                pbc.addBuildConfiguration(this);
                if (md.isActivateChecked()) {
                    pbc.setActiveBuildConfiguration(this);
                }
                if (md.isOpenInEditorChecked() && (page = (dwindow = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow()).getActivePage()) != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)newFile, (boolean)true);
                    }
                    catch (PartInitException partInitException) {
                        PartInitException partInitException2 = partInitException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException2, this, ajc$tjp_11, ajc$tjp_9);
                    }
                }
            } else {
                throw new BuildConfigurationCreationException();
            }
        }
    }

    public BuildConfiguration(IFile fileToUse, ProjectBuildConfigurator pbc, boolean makeActive) {
        this.pbc = pbc;
        this.name = BuildConfiguration.getNameFromFile(fileToUse);
        IProject project = fileToUse.getProject();
        this.fileList = BuildConfigurator.getBuildConfigurator().getInitialFileList();
        if (this.fileList != null) {
            this.propertiesFile = new BuildProperties(fileToUse, new ArrayList(this.getFileList()));
        } else {
            try {
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] cpes2 = jp.getRawClasspath();
                if (BuildConfigurator.getBuildConfigurator().haveExclusionPatterns(cpes2)) {
                    this.fileList = BuildConfigurator.getBuildConfigurator().getFileSetFromCPE(cpes2, jp);
                    this.propertiesFile = new BuildProperties(fileToUse, this.minimizeIncludes(this.fileList));
                } else {
                    ArrayList<IPath> pathes = new ArrayList<IPath>();
                    int i = 0;
                    while (i < cpes2.length) {
                        if (cpes2[i].getEntryKind() == 3) {
                            IPath p = cpes2[i].getPath();
                            IResource res = jp.getProject().getParent().findMember(p);
                            if (res != null && res.exists()) {
                                pathes.add(res.getProjectRelativePath());
                            }
                        }
                        ++i;
                    }
                    this.propertiesFile = new BuildProperties(fileToUse, pathes);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_12, ajc$tjp_13);
            }
        }
        pbc.addBuildConfiguration(this);
        if (makeActive) {
            pbc.setActiveBuildConfiguration(this);
        }
    }

    IFile getFileFromName(String name) {
        return this.pbc.getJavaProject().getProject().getFile(String.valueOf(name) + "." + EXTENSION);
    }

    static String getNameFromFile(IFile file) {
        String n = file.getName();
        return n.substring(0, n.indexOf(".ajproperties"));
    }

    public void loadDataFromFile(IFile existingFile) {
        if (existingFile.exists()) {
            this.name = BuildConfiguration.getNameFromFile(existingFile);
            this.propertiesFile = new BuildProperties(existingFile);
        }
    }

    private String getLstContentFromData() {
        String files = "";
        Iterator iter = this.getFileList().iterator();
        while (iter.hasNext()) {
            files = files.concat(((IFile)iter.next()).getProjectRelativePath().toOSString().concat(System.getProperty("line.separator", "\n")));
        }
        return files;
    }

    public String getName() {
        return this.name;
    }

    private boolean excludeFile(IResource file) throws CoreException {
        this.listenToFileChanges = false;
        this.propertiesFile.exclude(file);
        this.listenToFileChanges = true;
        if (file.getType() == 1) {
            this.getFileList().remove(file);
            return true;
        }
        return false;
    }

    public void excludeFiles(List exFiles) throws CoreException {
        Iterator iter = exFiles.iterator();
        boolean needsupdate = false;
        IResource res = null;
        while (iter.hasNext()) {
            res = (IResource)iter.next();
            if (this.excludeFile(res)) continue;
            needsupdate = true;
        }
        if (needsupdate) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    private boolean includeFile(IResource file) {
        this.listenToFileChanges = false;
        this.propertiesFile.include(file);
        this.listenToFileChanges = true;
        if (file.getType() == 1) {
            this.getFileList().add(file);
            return true;
        }
        return false;
    }

    public void includeFiles(List exFiles) {
        Iterator iter = exFiles.iterator();
        boolean needsupdate = false;
        IResource res = null;
        while (iter.hasNext()) {
            res = (IResource)iter.next();
            if (this.includeFile(res)) continue;
            needsupdate = true;
        }
        if (needsupdate) {
            this.update(false);
        }
        this.propertiesFile.writeFile();
    }

    public boolean isIncluded(IResource file) {
        boolean isIncl = this.getFileList().contains(file);
        return isIncl;
    }

    public int compareTo(Util.Comparable o) {
        if (o instanceof BuildConfiguration) {
            return this.getName().compareToIgnoreCase(((BuildConfiguration)o).getName());
        }
        return 0;
    }

    public void update(boolean forceReadingFile) {
        AspectJUIPlugin.getDefault().getAjdtProjectProperties().setProjectSourceFileListKnown(this.pbc.getJavaProject().getProject(), false);
        if (this.listenToFileChanges) {
            if (this.fileList == null) {
                this.fileList = new HashSet();
            } else {
                this.fileList.clear();
            }
            List l = this.propertiesFile.getFiles(forceReadingFile);
            this.fileList.addAll(l);
        }
    }

    public List getIncludedJavaFiles(CoreUtils.FilenameFilter filter) {
        Iterator iter = this.getFileList().iterator();
        ArrayList<File> list = new ArrayList<File>(this.getFileList().size());
        while (iter.hasNext()) {
            IResource res = (IResource)iter.next();
            if (!res.exists() || !filter.accept(res.getName())) continue;
            list.add(new File(res.getLocation().toOSString()));
        }
        return list;
    }

    public List getIncludedJavaFileNames(CoreUtils.FilenameFilter filter) {
        Iterator iter = this.getFileList().iterator();
        ArrayList<String> list = new ArrayList<String>(this.getFileList().size());
        while (iter.hasNext()) {
            IResource res = (IResource)iter.next();
            if (!res.exists() || !filter.accept(res.getName())) continue;
            list.add(res.getLocation().toOSString());
        }
        return list;
    }

    public void writeLstFile() {
        this.update(false);
        String lstFileContent = this.getLstContentFromData();
        String title = AspectJUIPlugin.getResourceString("BCDialog.SaveAJPropAsLst.title");
        String msg = AspectJUIPlugin.getResourceString("BCDialog.SaveAJPropAsLst.message").replaceAll("%name", this.name);
        InputDialog md = new InputDialog(null, title, msg, String.valueOf(this.name) + ".lst", null);
        md.setBlockOnOpen(true);
        if (md.open() == 0 && md.getValue() != null) {
            String fileName = md.getValue();
            if (!fileName.endsWith(".lst")) {
                fileName = String.valueOf(fileName) + ".lst";
            }
            try {
                IFile file = this.pbc.getJavaProject().getProject().getFile(fileName);
                if (file.exists()) {
                    if (this.askUserOverwrite(fileName)) {
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(lstFileContent.getBytes());
                        if (file.isReadOnly()) {
                            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
                        }
                        file.setContents((InputStream)inputStream, 1, null);
                    }
                } else {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(lstFileContent.getBytes());
                    file.create((InputStream)inputStream, 1, null);
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_14, ajc$tjp_15);
                CoreException e = coreException2;
                AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("buildConfig.exceptionWriting").replaceAll("%fileName", fileName), e);
            }
        }
    }

    private boolean askUserOverwrite(String fileName) {
        String msg;
        String[] options = new String[]{AspectJUIPlugin.getResourceString("BCDialog.Overwrite.yes"), AspectJUIPlugin.getResourceString("BCDialog.Overwrite.no")};
        String title = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.title");
        MessageDialog mdiag = new MessageDialog(null, title, null, msg = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.message").replaceAll("%fileName", fileName), 3, options, 1);
        return mdiag.open() == 0;
    }

    public boolean areFilesActive() {
        return this.getFileList().size() != 0;
    }

    public void updateSourceFolders(List sourcePathes) {
        this.propertiesFile.updateSourceFolders(sourcePathes);
        this.fileList = null;
    }

    private class InputDialogWithCheck
    extends InputDialog {
        private Button activateCheckbox;
        private Button openInEditorCheckbox;
        private boolean activateSelected;
        private boolean openInEditorSelected;

        public InputDialogWithCheck(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.openInEditorCheckbox = new Button(composite, 32);
            this.openInEditorCheckbox.setSelection(true);
            this.openInEditorCheckbox.setText(AspectJUIPlugin.getResourceString("BuildConfig.openForEdit"));
            this.activateCheckbox = new Button(composite, 32);
            this.activateCheckbox.setSelection(true);
            this.activateCheckbox.setText(AspectJUIPlugin.getResourceString("BuildConfig.activate"));
            return composite;
        }

        protected void okPressed() {
            this.activateSelected = this.activateCheckbox.getSelection();
            this.openInEditorSelected = this.openInEditorCheckbox.getSelection();
            super.okPressed();
        }

        public boolean isActivateChecked() {
            return this.activateSelected;
        }

        public boolean isOpenInEditorChecked() {
            return this.openInEditorSelected;
        }
    }
}

