/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.internal.core.AJLog;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;

public class MarkerUpdating {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    public static void deleteAllMarkers(final IProject project) {
        try {
            AspectJPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.StaticPart ajc$tjp_1;

                public void run(IProgressMonitor monitor) {
                    try {
                        project.deleteMarkers("org.eclipse.ajdt.ui.advicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.sourceadvicemarker", true, 2);
                        project.deleteMarkers("org.eclipse.ajdt.ui.declarationmarker", true, 2);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                    }
                }

                static {
                    Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.builder.MarkerUpdating$1"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating$1-org.eclipse.core.runtime.CoreException-<missing>-"), 63);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.builder.MarkerUpdating$1-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 56);
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static void addNewMarkers(IProject project) {
        AJLog.logStart((String)"Add markers");
        int numMarkers = 0;
        AJModel ajModel = AJModel.getInstance();
        List allRelationships = ajModel.getAllRelationships(project, new AJRelationshipType[]{AJRelationshipManager.ADVISED_BY, AJRelationshipManager.ADVISES, AJRelationshipManager.ANNOTATED_BY, AJRelationshipManager.ANNOTATES, AJRelationshipManager.DECLARED_ON, AJRelationshipManager.ASPECT_DECLARATIONS, AJRelationshipManager.SOFTENS, AJRelationshipManager.SOFTENED_BY});
        HashMap cUsToListsOfRelationships = new HashMap();
        Iterator iter = allRelationships.iterator();
        while (iter.hasNext()) {
            AJRelationship relationship = (AJRelationship)iter.next();
            IJavaElement source = relationship.getSource();
            ICompilationUnit parentCU = (ICompilationUnit)source.getAncestor(5);
            if (parentCU == null) continue;
            if (cUsToListsOfRelationships.get(parentCU) instanceof List) {
                ((List)cUsToListsOfRelationships.get(parentCU)).add(relationship);
                continue;
            }
            ArrayList<AJRelationship> relationshipsForCU = new ArrayList<AJRelationship>();
            relationshipsForCU.add(relationship);
            cUsToListsOfRelationships.put(parentCU, relationshipsForCU);
        }
        Set affectedCompilationUnits = cUsToListsOfRelationships.keySet();
        Iterator iter2 = affectedCompilationUnits.iterator();
        while (iter2.hasNext()) {
            ICompilationUnit cu = (ICompilationUnit)iter2.next();
            List relationships = (List)cUsToListsOfRelationships.get(cu);
            HashMap lineNumberToRelationships = new HashMap();
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                AJRelationship relationship = (AJRelationship)iterator.next();
                IJavaElement source = relationship.getSource();
                Integer lineNumber = new Integer(ajModel.getJavaElementLineNumber(source));
                if (lineNumberToRelationships.get(lineNumber) instanceof List) {
                    ((List)lineNumberToRelationships.get(lineNumber)).add(relationship);
                    continue;
                }
                ArrayList<AJRelationship> relationshipsForLine = new ArrayList<AJRelationship>();
                relationshipsForLine.add(relationship);
                lineNumberToRelationships.put(lineNumber, relationshipsForLine);
            }
            Set lineNumbers = lineNumberToRelationships.keySet();
            Iterator iterator2 = lineNumbers.iterator();
            while (iterator2.hasNext()) {
                ++numMarkers;
                Integer lineNum = (Integer)iterator2.next();
                List relationshipsForLine = (List)lineNumberToRelationships.get(lineNum);
                MarkerUpdating.createMarker(lineNum, cu.getResource(), relationshipsForLine);
            }
        }
        AJLog.logEnd((String)"Add markers", (String)(String.valueOf(numMarkers) + " markers"));
    }

    private static void createMarker(int lineNumber, IResource resource, List relationships) {
        AJRelationship relationship;
        String markerType = null;
        boolean runtimeTest = false;
        Iterator iter = relationships.iterator();
        while (iter.hasNext()) {
            relationship = (AJRelationship)iter.next();
            boolean bl = runtimeTest = runtimeTest || relationship.hasRuntimeTest();
        }
        iter = relationships.iterator();
        while (iter.hasNext()) {
            relationship = (AJRelationship)iter.next();
            String markerTypeForRelationship = MarkerUpdating.getMarkerTypeForRelationship(relationship, runtimeTest);
            if (markerType == null) {
                markerType = markerTypeForRelationship;
                continue;
            }
            if (markerType.equals(markerTypeForRelationship)) continue;
            markerType = MarkerUpdating.getCombinedMarkerType(markerType, markerTypeForRelationship, runtimeTest);
        }
        try {
            IMarker marker = resource.createMarker(markerType);
            marker.setAttribute("lineNumber", lineNumber);
            String label = relationships.size() == 1 ? MarkerUpdating.getMarkerLabel((AJRelationship)relationships.get(0)) : MarkerUpdating.getMultipleMarkersLabel(relationships.size());
            marker.setAttribute("message", (Object)label);
            marker.setAttribute("priority", 2);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_2, ajc$tjp_3);
        }
    }

    private static String getMultipleMarkersLabel(int number) {
        return String.valueOf(number) + " " + AspectJUIPlugin.getResourceString("AspectJMarkersAtLine");
    }

    private static String getMarkerLabel(AJRelationship relationship) {
        return String.valueOf(relationship.getRelationship().getDisplayName()) + " " + AJModel.getInstance().getJavaElementLinkName(relationship.getTarget()) + (relationship.hasRuntimeTest() ? " " + AspectJUIPlugin.getResourceString("AspectJEditor.runtimetest") : "");
    }

    private static String getMarkerTypeForRelationship(AJRelationship relationship, boolean runtimeTest) {
        IJavaElement source = relationship.getSource();
        IJavaElement target = relationship.getTarget();
        AJRelationshipType type = relationship.getRelationship();
        if (type.equals(AJRelationshipManager.ADVISED_BY) && target instanceof AdviceElement) {
            try {
                IProgramElement.ExtraInformation extraInfo = ((AdviceElement)target).getAJExtraInformation();
                if (extraInfo.getExtraAdviceInformation() != null) {
                    if (extraInfo.getExtraAdviceInformation().equals("before")) {
                        if (runtimeTest) {
                            return "org.eclipse.ajdt.ui.dynamicbeforeadvicemarker";
                        }
                        return "org.eclipse.ajdt.ui.beforeadvicemarker";
                    }
                    if (extraInfo.getExtraAdviceInformation().equals("around")) {
                        if (runtimeTest) {
                            return "org.eclipse.ajdt.ui.dynamicaroundadvicemarker";
                        }
                        return "org.eclipse.ajdt.ui.aroundadvicemarker";
                    }
                    if (runtimeTest) {
                        return "org.eclipse.ajdt.ui.dynamicafteradvicemarker";
                    }
                    return "org.eclipse.ajdt.ui.afteradvicemarker";
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException2, ajc$tjp_4, ajc$tjp_5);
            }
            if (runtimeTest) {
                return "org.eclipse.ajdt.ui.dynamicadvicemarker";
            }
            return "org.eclipse.ajdt.ui.advicemarker";
        }
        if (type.equals(AJRelationshipManager.ADVISES) && source instanceof AdviceElement) {
            try {
                IProgramElement.ExtraInformation extraInfo = ((AdviceElement)source).getAJExtraInformation();
                if (extraInfo.getExtraAdviceInformation() != null) {
                    if (extraInfo.getExtraAdviceInformation().equals("before")) {
                        if (runtimeTest) {
                            return "org.eclipse.ajdt.ui.sourcedynamicbeforeadvicemarker";
                        }
                        return "org.eclipse.ajdt.ui.sourcebeforeadvicemarker";
                    }
                    if (extraInfo.getExtraAdviceInformation().equals("around")) {
                        if (runtimeTest) {
                            return "org.eclipse.ajdt.ui.sourcedynamicaroundadvicemarker";
                        }
                        return "org.eclipse.ajdt.ui.sourcearoundadvicemarker";
                    }
                    if (runtimeTest) {
                        return "org.eclipse.ajdt.ui.sourcedynamicafteradvicemarker";
                    }
                    return "org.eclipse.ajdt.ui.sourceafteradvicemarker";
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException3 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException3, ajc$tjp_6, ajc$tjp_5);
            }
            if (runtimeTest) {
                return "org.eclipse.ajdt.ui.sourcedynamicadvicemarker";
            }
            return "org.eclipse.ajdt.ui.sourceadvicemarker";
        }
        if (type.equals(AJRelationshipManager.ASPECT_DECLARATIONS) || type.equals(AJRelationshipManager.ANNOTATED_BY) || type.equals(AJRelationshipManager.SOFTENED_BY)) {
            return "org.eclipse.ajdt.ui.itdmarker";
        }
        if (type.equals(AJRelationshipManager.DECLARED_ON) || type.equals(AJRelationshipManager.ANNOTATES) || type.equals(AJRelationshipManager.SOFTENS)) {
            return "org.eclipse.ajdt.ui.sourceitdmarker";
        }
        return "org.eclipse.ajdt.ui.advicemarker";
    }

    private static String getCombinedMarkerType(String firstMarkerType, String secondMarkerType, boolean runtimeTest) {
        if (firstMarkerType.indexOf("source") != -1 && secondMarkerType.indexOf("source") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.sourcedynamicadvicemarker" : "org.eclipse.ajdt.ui.sourceadvicemarker";
        }
        if (firstMarkerType.indexOf("source") != -1 || secondMarkerType.indexOf("source") != -1) {
            return runtimeTest ? "org.eclipse.ajdt.ui.dynamicsourceandtargetmarker" : "org.eclipse.ajdt.ui.sourceandtargetmarker";
        }
        return runtimeTest ? "org.eclipse.ajdt.ui.dynamicadvicemarker" : "org.eclipse.ajdt.ui.advicemarker";
    }

    static {
        Factory factory = new Factory("MarkerUpdating.java", Class.forName("org.eclipse.ajdt.internal.builder.MarkerUpdating"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 66);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-deleteAllMarkers-org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.resources.IProject:-project:--void-"), 52);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.core.runtime.CoreException-<missing>-"), 172);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-createMarker-org.eclipse.ajdt.internal.builder.MarkerUpdating-int:org.eclipse.core.resources.IResource:java.util.List:-lineNumber:resource:relationships:--void-"), 142);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 241);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getMarkerTypeForRelationship-org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.ajdt.core.model.AJRelationship:boolean:-relationship:runtimeTest:--java.lang.String-"), 214);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.MarkerUpdating-org.eclipse.jdt.core.JavaModelException-<missing>-"), 271);
    }
}

