/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class AspectJEditorTitleImageUpdater {
    private AppearanceAwareLabelProvider labelProvider;
    private AspectJEditor editor;

    public AspectJEditorTitleImageUpdater(AspectJEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
        this.labelProvider = new AppearanceAwareLabelProvider(0, 2);
    }

    public void updateEditorImage(IJavaElement jelement) {
        Image titleImage = this.editor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.labelProvider.getImage((Object)jelement);
        if (titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.editor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    AspectJEditorTitleImageUpdater.this.editor.updatedTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        this.labelProvider.dispose();
    }
}

