/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.migration;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.wizards.migration.AJProjectListLabelProvider;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PluginDependencyMigrationPage
extends WizardPage {
    private CheckedListDialogField checkedListDialogField;
    private List ajPluginProjects;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    private PluginDependencyMigrationPage() {
        super(AspectJUIPlugin.getResourceString("PluginDependencyMigrationPage.name"));
        this.setTitle(AspectJUIPlugin.getResourceString("PluginDependencyMigrationPage.title"));
        this.setDescription(AspectJUIPlugin.getResourceString("PluginDependencyMigrationPage.description"));
    }

    protected PluginDependencyMigrationPage(List projects) {
        this();
        this.ajPluginProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        String[] buttonLabels = new String[]{NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.checkall.button"), NewWizardMessages.getString((String)"ProjectsWorkbookPage.projects.uncheckall.button")};
        this.checkedListDialogField = new CheckedListDialogField(null, buttonLabels, (ILabelProvider)new AJProjectListLabelProvider());
        this.checkedListDialogField.setLabelText(AspectJUIPlugin.getResourceString("PluginDependencyMigrationPage.updatePluginDependencyButton.message"));
        this.checkedListDialogField.setCheckAllButtonIndex(0);
        this.checkedListDialogField.setUncheckAllButtonIndex(1);
        this.checkedListDialogField.setElements((Collection)this.ajPluginProjects);
        this.checkedListDialogField.setCheckedElements((Collection)this.ajPluginProjects);
        this.checkedListDialogField.setViewerSorter(new ViewerSorter());
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.checkedListDialogField}, (boolean)true, (int)-1, (int)-1);
        LayoutUtil.setHorizontalGrabbing((Control)this.checkedListDialogField.getListControl(null));
        PixelConverter converter = new PixelConverter((Control)parent);
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.checkedListDialogField.setButtonsMinWidth(buttonBarWidth);
    }

    public void finishPressed(IProgressMonitor monitor) {
        List checkedProjects = this.checkedListDialogField.getCheckedElements();
        Iterator iter = checkedProjects.iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            this.updatePluginDependency(project);
            monitor.worked(2);
        }
        monitor.worked(2 * (this.ajPluginProjects.size() - checkedProjects.size()));
    }

    private void updatePluginDependency(IProject project) {
        boolean hasAJDEDependency = this.hasAJDEPluginDependency(project);
        boolean hasRuntimeDependency = AJDTUtils.hasAJPluginDependency(project);
        if (hasRuntimeDependency) {
            if (!hasAJDEDependency) {
                return;
            }
            this.removeAJDEPluginDependency(project);
        } else {
            AJDTUtils.importRuntimePlugin(project);
            if (hasAJDEDependency) {
                this.removeAJDEPluginDependency(project);
            }
        }
    }

    private boolean hasAJDEPluginDependency(IProject project) {
        ManifestEditor manEd = AJDTUtils.getAndPrepareToChangePDEModel(project);
        IPluginModel model = null;
        IPluginImport[] imports = null;
        if (manEd == null) {
            try {
                IPackageFragmentRoot[] dependencies = JavaCore.create((IProject)project).getPackageFragmentRoots();
                int i = 0;
                while (i < dependencies.length) {
                    if (dependencies[i].getElementName().equals("aspectjrt.jar")) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            }
            return false;
        }
        model = (IPluginModel)manEd.getAggregateModel();
        imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport importObj = imports[i];
            if (importObj.getId().equals("org.aspectj.ajde")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void removeAJDEPluginDependency(IProject project) {
        AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ManifestEditor manEd = AJDTUtils.getAndPrepareToChangePDEModel(project);
        if (manEd != null) {
            IPluginModel model = (IPluginModel)manEd.getAggregateModel();
            try {
                AJDTUtils.removeImportFromPDEModel(model, "org.aspectj.ajde");
                manEd.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
                CoreException e = coreException2;
                AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AutoPluginRemoveErrorDialog.title"), AspectJUIPlugin.getResourceString("AutoPluginRemoveErrorDialog.message"), e);
            }
        } else {
            MessageDialog.openError((Shell)AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AspectJUIPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.title"), (String)AspectJUIPlugin.getResourceString("AutoPluginRemoveDialog.noEditor.message"));
        }
    }

    static {
        Factory factory = new Factory("PluginDependencyMigrationPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 142);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-hasAJDEPluginDependency-org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage-org.eclipse.core.resources.IProject:-project:--boolean-"), 124);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage-org.eclipse.core.runtime.CoreException-e-"), 168);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-removeAJDEPluginDependency-org.eclipse.ajdt.internal.ui.wizards.migration.PluginDependencyMigrationPage-org.eclipse.core.resources.IProject:-project:--void-"), 157);
    }
}

