/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IClasspathContainer;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.core.Assert;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModel;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.XMLWriter;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;

public class ClasspathEntry
implements IClasspathEntry {
    public static final String TAG_CLASSPATH = "classpath";
    public static final String TAG_CLASSPATHENTRY = "classpathentry";
    public static final String TAG_OUTPUT = "output";
    public static final String TAG_KIND = "kind";
    public static final String TAG_PATH = "path";
    public static final String TAG_SOURCEPATH = "sourcepath";
    public static final String TAG_ROOTPATH = "rootpath";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_INCLUDING = "including";
    public static final String TAG_EXCLUDING = "excluding";
    public int entryKind;
    public int contentKind;
    public IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private String rootID;
    private AccessRestriction importRestriction;
    private static final AccessRestriction UNINIT_RESTRICTION = new AccessRestriction(null, null, null, null);
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public IPath sourceAttachmentPath;
    public IPath sourceAttachmentRootPath;
    public IPath specificOutputLocation;
    public static final int K_OUTPUT = 10;
    public boolean isExported;

    public ClasspathEntry(int contentKind, int entryKind, IPath path, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, IPath specificOutputLocation, boolean isExported) {
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        if (inclusionPatterns != INCLUDE_ALL && inclusionPatterns.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
            this.importRestriction = UNINIT_RESTRICTION;
        }
        if (exclusionPatterns.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
            this.importRestriction = UNINIT_RESTRICTION;
        }
        this.sourceAttachmentPath = sourceAttachmentPath;
        this.sourceAttachmentRootPath = sourceAttachmentRootPath;
        this.specificOutputLocation = specificOutputLocation;
        this.isExported = isExported;
    }

    public ClasspathEntry combineWith(IClasspathEntry referringEntry) {
        if (referringEntry == null) {
            return this;
        }
        if (referringEntry.isExported() || referringEntry.getInclusionPatterns().length > 0 || referringEntry.getExclusionPatterns().length > 0) {
            return new ClasspathEntry(this.getContentKind(), this.getEntryKind(), this.getPath(), ClasspathEntry.concatPatterns(referringEntry.getInclusionPatterns(), this.getInclusionPatterns()), ClasspathEntry.concatPatterns(referringEntry.getExclusionPatterns(), this.getExclusionPatterns()), this.getSourceAttachmentPath(), this.getSourceAttachmentRootPath(), this.getOutputLocation(), referringEntry.isExported() || this.isExported);
        }
        return this;
    }

    public static IPath[] concatPatterns(IPath[] patternList1, IPath[] patternList2) {
        int length1 = patternList1.length;
        if (length1 == 0) {
            return patternList2;
        }
        int length2 = patternList2.length;
        if (length2 == 0) {
            return patternList1;
        }
        IPath[] result = new IPath[length1 + length2];
        System.arraycopy(patternList1, 0, result, 0, length1);
        System.arraycopy(patternList2, 0, result, length1, length2);
        return result;
    }

    private static IPath[] decodePatterns(Element element, String tag) {
        char[][] patterns;
        int patternCount;
        String sequence = element.getAttribute(tag);
        if (!sequence.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', sequence.toCharArray())).length) > 0) {
            IPath[] paths = new IPath[patternCount];
            int j = 0;
            while (j < patterns.length) {
                paths[j] = new Path(new String(patterns[j]));
                ++j;
            }
            return paths;
        }
        return null;
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullExclusionPatternChars[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullInclusionPatternChars[i] = prefixPath.append(this.inclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_KIND, ClasspathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 4 && this.entryKind != 5 && xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
            if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            } else {
                xmlPath = xmlPath.makeAbsolute();
            }
        }
        parameters.put(TAG_PATH, String.valueOf(xmlPath));
        if (this.sourceAttachmentPath != null) {
            xmlPath = this.sourceAttachmentPath;
            if (this.entryKind != 4 && projectPath != null && projectPath.isPrefixOf(xmlPath) && xmlPath.segment(0).equals(projectPath.segment(0))) {
                xmlPath = xmlPath.removeFirstSegments(1);
                xmlPath = xmlPath.makeRelative();
            }
            parameters.put(TAG_SOURCEPATH, String.valueOf(xmlPath));
        }
        if (this.sourceAttachmentRootPath != null) {
            parameters.put(TAG_ROOTPATH, String.valueOf(this.sourceAttachmentRootPath));
        }
        if (this.isExported) {
            parameters.put(TAG_EXPORTED, "true");
        }
        ClasspathEntry.encodePatterns(this.inclusionPatterns, TAG_INCLUDING, parameters);
        ClasspathEntry.encodePatterns(this.exclusionPatterns, TAG_EXCLUDING, parameters);
        if (this.specificOutputLocation != null) {
            IPath outputLocation = this.specificOutputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            parameters.put(TAG_OUTPUT, String.valueOf(outputLocation));
        }
        writer.printTag(TAG_CLASSPATHENTRY, parameters, indent, newLine, true);
    }

    public static IClasspathEntry elementDecode(Element element, IJavaProject project) {
        IPath[] exclusionPatterns;
        Path sourceAttachmentPath;
        IPath projectPath = project.getProject().getFullPath();
        String kindAttr = element.getAttribute(TAG_KIND);
        String pathAttr = element.getAttribute(TAG_PATH);
        Path path = new Path(pathAttr);
        int kind = ClasspathEntry.kindFromString(kindAttr);
        if (kind != 4 && kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        Path path2 = sourceAttachmentPath = element.hasAttribute(TAG_SOURCEPATH) ? new Path(element.getAttribute(TAG_SOURCEPATH)) : null;
        if (kind != 4 && sourceAttachmentPath != null && !sourceAttachmentPath.isAbsolute()) {
            sourceAttachmentPath = projectPath.append((IPath)sourceAttachmentPath);
        }
        Path sourceAttachmentRootPath = element.hasAttribute(TAG_ROOTPATH) ? new Path(element.getAttribute(TAG_ROOTPATH)) : null;
        boolean isExported = element.getAttribute(TAG_EXPORTED).equals("true");
        IPath[] inclusionPatterns = ClasspathEntry.decodePatterns(element, TAG_INCLUDING);
        if (inclusionPatterns == null) {
            inclusionPatterns = INCLUDE_ALL;
        }
        if ((exclusionPatterns = ClasspathEntry.decodePatterns(element, TAG_EXCLUDING)) == null) {
            exclusionPatterns = EXCLUDE_NONE;
        }
        IPath outputLocation = element.hasAttribute(TAG_OUTPUT) ? projectPath.append(element.getAttribute(TAG_OUTPUT)) : null;
        switch (kind) {
            case 2: {
                return JavaCore.newProjectEntry((IPath)path, inclusionPatterns, exclusionPatterns, isExported);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, inclusionPatterns, exclusionPatterns, isExported);
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation);
                }
                if (path.segmentCount() == 1) {
                    return JavaCore.newProjectEntry((IPath)path, inclusionPatterns, exclusionPatterns, isExported);
                }
                return JavaCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, outputLocation);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttachmentPath, (IPath)sourceAttachmentRootPath, inclusionPatterns, exclusionPatterns, isExported);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path, inclusionPatterns, exclusionPatterns, isExported);
            }
            case 10: {
                if (!path.isAbsolute()) {
                    return null;
                }
                return new ClasspathEntry(10, 1, (IPath)path, INCLUDE_ALL, EXCLUDE_NONE, null, null, null, false);
            }
        }
        throw new Assert.AssertionFailedException(Util.bind("classpath.unknownKind", kindAttr));
    }

    private static void encodePatterns(IPath[] patterns, String tag, Map parameters) {
        if (patterns != null && patterns.length > 0) {
            StringBuffer rule = new StringBuffer(10);
            int i = 0;
            int max = patterns.length;
            while (i < max) {
                if (i > 0) {
                    rule.append('|');
                }
                rule.append(patterns[i]);
                ++i;
            }
            parameters.put(tag, String.valueOf(rule));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IClasspathEntry) {
            IClasspathEntry otherEntry = (IClasspathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            IPath otherPath = otherEntry.getSourceAttachmentPath();
            if (this.sourceAttachmentPath == null ? otherPath != null : !this.sourceAttachmentPath.equals((Object)otherPath)) {
                return false;
            }
            otherPath = otherEntry.getSourceAttachmentRootPath();
            if (this.sourceAttachmentRootPath == null ? otherPath != null : !this.sourceAttachmentRootPath.equals((Object)otherPath)) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.inclusionPatterns, otherEntry.getInclusionPatterns())) {
                return false;
            }
            if (!ClasspathEntry.equalPatterns(this.exclusionPatterns, otherEntry.getExclusionPatterns())) {
                return false;
            }
            otherPath = otherEntry.getOutputLocation();
            return !(this.specificOutputLocation == null ? otherPath != null : !this.specificOutputLocation.equals((Object)otherPath));
        }
        return false;
    }

    private static boolean equalPatterns(IPath[] firstPatterns, IPath[] secondPatterns) {
        if (firstPatterns != secondPatterns) {
            if (firstPatterns == null) {
                return false;
            }
            int length = firstPatterns.length;
            if (secondPatterns == null || secondPatterns.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstPatterns[i].toString().equals(secondPatterns[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public AccessRestriction getImportRestriction() {
        if (this.importRestriction == UNINIT_RESTRICTION) {
            char[][] importIncludes = ClasspathEntry.getAccessRestrictionPatterns(this.inclusionPatterns);
            char[][] importExcludes = ClasspathEntry.getAccessRestrictionPatterns(this.exclusionPatterns);
            this.importRestriction = importIncludes == null && importExcludes == null ? null : new AccessRestriction(this.entryKind == 2 || this.entryKind == 3 ? Util.bind("restrictedAccess.project", null, this.getPath().segment(0)) : Util.bind("restrictedAccess.library", null, this.getPath().makeRelative().toOSString()), importIncludes, importExcludes, null);
        }
        return this.importRestriction;
    }

    public static char[][] getAccessRestrictionPatterns(IPath[] patternSequence) {
        if (patternSequence == null) {
            return null;
        }
        int length = patternSequence.length;
        if (length == 0) {
            return null;
        }
        char[][] patternChars = new char[length][];
        int i = 0;
        while (i < length) {
            patternChars[i] = patternSequence[i].toString().toCharArray();
            ++i;
        }
        return patternChars;
    }

    public IPath getOutputLocation() {
        return this.specificOutputLocation;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getSourceAttachmentPath() {
        return this.sourceAttachmentPath;
    }

    public IPath getSourceAttachmentRootPath() {
        return this.sourceAttachmentRootPath;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean isExported() {
        return this.isExported;
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("var")) {
            return 4;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        if (kindStr.equalsIgnoreCase(TAG_OUTPUT)) {
            return 10;
        }
        return -1;
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "src";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 4: {
                return "var";
            }
            case 5: {
                return "con";
            }
            case 10: {
                return TAG_OUTPUT;
            }
        }
        return "unknown";
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("CPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("CPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("CPE_SOURCE");
                break;
            }
            case 4: {
                buffer.append("CPE_VARIABLE");
                break;
            }
            case 5: {
                buffer.append("CPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 2: {
                buffer.append("K_BINARY");
                break;
            }
            case 1: {
                buffer.append("K_SOURCE");
                break;
            }
            case 10: {
                buffer.append("K_OUTPUT");
            }
        }
        buffer.append(']');
        if (this.getSourceAttachmentPath() != null) {
            buffer.append("[sourcePath:");
            buffer.append(this.getSourceAttachmentPath());
            buffer.append(']');
        }
        if (this.getSourceAttachmentRootPath() != null) {
            buffer.append("[rootPath:");
            buffer.append(this.getSourceAttachmentRootPath());
            buffer.append(']');
        }
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.getInclusionPatterns();
        int length = patterns == null ? 0 : patterns.length;
        if (length > 0) {
            buffer.append("[including:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if ((length = (patterns = this.getExclusionPatterns()) == null ? 0 : patterns.length) > 0) {
            buffer.append("[excluding:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if (this.getOutputLocation() != null) {
            buffer.append("[output:");
            buffer.append(this.getOutputLocation());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 4: {
                    this.rootID = "[VAR]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public IClasspathEntry getResolvedEntry() {
        return JavaCore.getResolvedClasspathEntry(this);
    }

    public static IJavaModelStatus validateClasspath(IJavaProject javaProject, IClasspathEntry[] rawClasspath, IPath projectOutputLocation) {
        String entryPathMsg;
        boolean isProjectRelative;
        int kind;
        IClasspathEntry entry;
        IClasspathEntry resolvedEntry;
        IClasspathEntry[] classpath;
        IProject project = javaProject.getProject();
        IPath projectPath = project.getFullPath();
        String projectName = javaProject.getElementName();
        if (projectOutputLocation == null) {
            return new JavaModelStatus(970);
        }
        if (projectOutputLocation.isAbsolute()) {
            if (!projectPath.isPrefixOf(projectOutputLocation)) {
                return new JavaModelStatus(971, (IJavaElement)javaProject, projectOutputLocation.toString());
            }
        } else {
            return new JavaModelStatus(972, projectOutputLocation);
        }
        boolean hasSource = false;
        boolean hasLibFolder = false;
        if (rawClasspath == null) {
            return JavaModelStatus.VERIFIED_OK;
        }
        try {
            classpath = ((JavaProject)javaProject).getResolvedClasspath(rawClasspath, null, true, false, null);
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        int length = classpath.length;
        int outputCount = 1;
        IPath[] outputLocations = new IPath[length + 1];
        boolean[] allowNestingInOutputLocations = new boolean[length + 1];
        outputLocations[0] = projectOutputLocation;
        IPath potentialNestedOutput = null;
        int sourceEntryCount = 0;
        boolean disableExclusionPatterns = "disabled".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.classpath.exclusionPatterns", true));
        boolean disableCustomOutputLocations = "disabled".equals(javaProject.getOption("org.aspectj.org.eclipse.jdt.core.classpath.multipleOutputLocations", true));
        int i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            if (disableExclusionPatterns && (resolvedEntry.getInclusionPatterns() != null && resolvedEntry.getInclusionPatterns().length > 0 || resolvedEntry.getExclusionPatterns() != null && resolvedEntry.getExclusionPatterns().length > 0)) {
                return new JavaModelStatus(1002, (IJavaElement)javaProject, resolvedEntry.getPath());
            }
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    ++sourceEntryCount;
                    IPath customOutput = resolvedEntry.getOutputLocation();
                    if (customOutput == null) break;
                    if (disableCustomOutputLocations) {
                        return new JavaModelStatus(1003, (IJavaElement)javaProject, resolvedEntry.getPath());
                    }
                    if (customOutput.isAbsolute()) {
                        if (!javaProject.getPath().isPrefixOf(customOutput)) {
                            return new JavaModelStatus(971, (IJavaElement)javaProject, customOutput.toString());
                        }
                    } else {
                        return new JavaModelStatus(972, customOutput);
                    }
                    if (Util.indexOfMatchingPath(customOutput, outputLocations, outputCount) != -1) break;
                    outputLocations[outputCount++] = customOutput;
                }
            }
            ++i;
        }
        i = 1;
        while (i < outputCount) {
            IPath customOutput = outputLocations[i];
            int index = Util.indexOfEnclosingPath(customOutput, outputLocations, outputCount);
            if (index != -1 && index != i) {
                if (index == 0) {
                    if (potentialNestedOutput == null) {
                        potentialNestedOutput = customOutput;
                    }
                } else {
                    return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInOutput", customOutput.makeRelative().toString(), outputLocations[index].makeRelative().toString()));
                }
            }
            ++i;
        }
        if (sourceEntryCount <= outputCount - 1) {
            allowNestingInOutputLocations[0] = true;
        } else if (potentialNestedOutput != null) {
            return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInOutput", potentialNestedOutput.makeRelative().toString(), outputLocations[0].makeRelative().toString()));
        }
        i = 0;
        while (i < length) {
            resolvedEntry = classpath[i];
            IPath path = resolvedEntry.getPath();
            switch (resolvedEntry.getEntryKind()) {
                case 3: {
                    hasSource = true;
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                    break;
                }
                case 1: {
                    hasLibFolder |= !org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment());
                    int index = Util.indexOfMatchingPath(path, outputLocations, outputCount);
                    if (index == -1) break;
                    allowNestingInOutputLocations[index] = true;
                }
            }
            ++i;
        }
        if (!hasSource && !hasLibFolder) {
            i = 0;
            while (i < outputCount) {
                allowNestingInOutputLocations[i] = true;
                ++i;
            }
        }
        HashSet<IPath> pathes = new HashSet<IPath>(length);
        int i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                isProjectRelative = projectName.equals(entryPath.segment(0));
                String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
                if (!pathes.add(entryPath)) {
                    return new JavaModelStatus(977, Util.bind("classpath.duplicateEntryPath", entryPathMsg, projectName));
                }
                if (entryPath.equals((Object)projectPath)) {
                    if (kind == 2) {
                        return new JavaModelStatus(979, Util.bind("classpath.cannotReferToItself", entryPath.makeRelative().toString()));
                    }
                } else {
                    IPath currentOutput;
                    if (kind == 3 || kind == 1 && !org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                        int j = 0;
                        while (j < classpath.length) {
                            IClasspathEntry otherEntry = classpath[j];
                            if (otherEntry != null) {
                                int otherKind = otherEntry.getEntryKind();
                                IPath otherPath = otherEntry.getPath();
                                if (entry != otherEntry && (otherKind == 3 || otherKind == 1 && !org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(otherPath.lastSegment())) && otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath)) {
                                    char[][] inclusionPatterns = ((ClasspathEntry)otherEntry).fullInclusionPatternChars();
                                    char[][] exclusionPatterns = ((ClasspathEntry)otherEntry).fullExclusionPatternChars();
                                    if (!Util.isExcluded(entryPath.append("*"), inclusionPatterns, exclusionPatterns, false)) {
                                        String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                        if (Util.isExcluded(entryPath, inclusionPatterns, exclusionPatterns, false)) {
                                            return new JavaModelStatus(964, Util.bind("classpath.mustEndWithSlash", exclusionPattern, entryPath.makeRelative().toString()));
                                        }
                                        if (otherKind == 3) {
                                            exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                            return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInEntry", new String[]{entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString(), exclusionPattern}));
                                        }
                                        return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInLibrary", entryPath.makeRelative().toString(), otherEntry.getPath().makeRelative().toString()));
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
                    char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
                    int j = 0;
                    while (j < outputCount) {
                        currentOutput = outputLocations[j];
                        if (!(entryPath.equals((Object)currentOutput) || !entryPath.isPrefixOf(currentOutput) || kind == 3 && Util.isExcluded(currentOutput, inclusionPatterns, exclusionPatterns, true))) {
                            return new JavaModelStatus(964, Util.bind("classpath.cannotNestOutputInEntry", currentOutput.makeRelative().toString(), entryPath.makeRelative().toString()));
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < outputCount) {
                        if (!allowNestingInOutputLocations[j] && (currentOutput = outputLocations[j]).isPrefixOf(entryPath)) {
                            return new JavaModelStatus(964, Util.bind("classpath.cannotNestEntryInOutput", entryPath.makeRelative().toString(), currentOutput.makeRelative().toString()));
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < length) {
            entry = classpath[i2];
            if (entry != null) {
                IPath output;
                IPath entryPath = entry.getPath();
                kind = entry.getEntryKind();
                isProjectRelative = projectName.equals(entryPath.segment(0));
                String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : entryPath.makeRelative().toString();
                if (kind == 3 && (output = entry.getOutputLocation()) != null) {
                    int j = 0;
                    while (j < length) {
                        IClasspathEntry otherEntry = classpath[j];
                        if (otherEntry != entry) {
                            boolean opStartsWithProject = projectName.equals(otherEntry.getPath().segment(0));
                            String otherPathMsg = opStartsWithProject ? otherEntry.getPath().removeFirstSegments(1).toString() : otherEntry.getPath().makeRelative().toString();
                            switch (otherEntry.getEntryKind()) {
                                case 3: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, Util.bind("classpath.cannotUseDistinctSourceFolderAsOutput", new String[]{entryPathMsg, otherPathMsg, projectName}));
                                }
                                case 1: {
                                    if (!otherEntry.getPath().equals((Object)output)) break;
                                    return new JavaModelStatus(964, Util.bind("classpath.cannotUseLibraryAsOutput", new String[]{entryPathMsg, otherPathMsg, projectName}));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IJavaModelStatus validateClasspathEntry(IJavaProject project, IClasspathEntry entry, boolean checkSourceAttachment, boolean recurseInContainers) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        String projectName = project.getElementName();
        boolean pathStartsWithProject = projectName.equals(path.segment(0));
        String entryPathMsg = pathStartsWithProject ? path.removeFirstSegments(1).makeRelative().toString() : path.toString();
        switch (entry.getEntryKind()) {
            case 5: {
                if (path == null || path.segmentCount() < 1) return new JavaModelStatus(964, Util.bind("classpath.illegalContainerPath", entryPathMsg, projectName));
                try {
                    IClasspathContainer container = JavaModelManager.getJavaModelManager().getClasspathContainer(path, project);
                    if (container == null) {
                        return new JavaModelStatus(963, (IJavaElement)project, path);
                    }
                    if (container == JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                        return JavaModelStatus.VERIFIED_OK;
                    }
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    if (containerEntries == null) return JavaModelStatus.VERIFIED_OK;
                    int i = 0;
                    int length = containerEntries.length;
                    while (i < length) {
                        IJavaModelStatus containerEntryStatus;
                        int kind;
                        IClasspathEntry containerEntry = containerEntries[i];
                        int n = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                        if (containerEntry == null || kind == 3 || kind == 4 || kind == 5) {
                            String description = container.getDescription();
                            if (description != null) return new JavaModelStatus(962, (IJavaElement)project, path);
                            description = path.makeRelative().toString();
                            return new JavaModelStatus(962, (IJavaElement)project, path);
                        }
                        if (recurseInContainers && !(containerEntryStatus = ClasspathEntry.validateClasspathEntry(project, containerEntry, checkSourceAttachment, recurseInContainers)).isOK()) {
                            return containerEntryStatus;
                        }
                        ++i;
                    }
                    return JavaModelStatus.VERIFIED_OK;
                }
                catch (JavaModelException e) {
                    return new JavaModelStatus(e);
                }
            }
            case 4: {
                if (path == null || path.segmentCount() < 1) return new JavaModelStatus(964, Util.bind("classpath.illegalVariablePath", entryPathMsg, projectName));
                try {
                    entry = JavaCore.getResolvedClasspathEntry(entry);
                }
                catch (Assert.AssertionFailedException e) {
                    return new JavaModelStatus(979, e.getMessage());
                }
                if (entry != null) return ClasspathEntry.validateClasspathEntry(project, entry, checkSourceAttachment, recurseInContainers);
                return new JavaModelStatus(965, (IJavaElement)project, path);
            }
            case 1: {
                boolean isExternal;
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryPath", entryPathMsg, projectName));
                IPath sourceAttachment = entry.getSourceAttachmentPath();
                Object target = JavaModel.getTarget((IContainer)workspaceRoot, path, true);
                if (target != null && project.getOption("org.aspectj.org.eclipse.jdt.core.incompatibleJDKLevel", true) != "ignore") {
                    long projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                    long libraryJDK = Util.getJdkLevel(target);
                    if (libraryJDK != 0L && libraryJDK > projectTargetJDK) {
                        return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(libraryJDK));
                    }
                }
                if (target instanceof IResource) {
                    IResource resolvedResource = (IResource)target;
                    switch (resolvedResource.getType()) {
                        case 1: {
                            if (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(resolvedResource.getName())) return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryArchive", entryPathMsg, projectName));
                            if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                            return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.toString(), path.toString(), projectName}));
                        }
                        case 2: {
                            if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) break;
                            return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.toString(), path.toString(), projectName}));
                        }
                    }
                    return JavaModelStatus.VERIFIED_OK;
                }
                if (target instanceof File) {
                    File file = (File)target;
                    if (!file.isFile()) {
                        return new JavaModelStatus(964, Util.bind("classpath.illegalExternalFolder", path.toOSString(), projectName));
                    }
                    if (!org.aspectj.org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(file.getName())) {
                        return new JavaModelStatus(964, Util.bind("classpath.illegalLibraryArchive", path.toOSString(), projectName));
                    }
                    if (!checkSourceAttachment || sourceAttachment == null || sourceAttachment.isEmpty() || JavaModel.getTarget((IContainer)workspaceRoot, sourceAttachment, true) != null) return JavaModelStatus.VERIFIED_OK;
                    return new JavaModelStatus(964, Util.bind("classpath.unboundSourceAttachment", new String[]{sourceAttachment.toString(), path.toOSString(), projectName}));
                }
                boolean bl = isExternal = path.getDevice() != null || !workspaceRoot.getProject(path.segment(0)).exists();
                if (!isExternal) return new JavaModelStatus(964, Util.bind("classpath.unboundLibrary", entryPathMsg, projectName));
                return new JavaModelStatus(964, Util.bind("classpath.unboundLibrary", path.toOSString(), projectName));
            }
            case 2: {
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, Util.bind("classpath.illegalProjectPath", path.segment(0), projectName));
                IProject prereqProjectRsc = workspaceRoot.getProject(path.segment(0));
                IJavaProject prereqProject = JavaCore.create(prereqProjectRsc);
                try {
                    if (!prereqProjectRsc.exists() || !prereqProjectRsc.hasNature("org.aspectj.org.eclipse.jdt.core.javanature")) {
                        return new JavaModelStatus(964, Util.bind("classpath.unboundProject", path.segment(0), projectName));
                    }
                    if (!prereqProjectRsc.isOpen()) {
                        return new JavaModelStatus(964, Util.bind("classpath.closedProject", path.segment(0)));
                    }
                    if (project.getOption("org.aspectj.org.eclipse.jdt.core.incompatibleJDKLevel", true) == "ignore") return JavaModelStatus.VERIFIED_OK;
                    long projectTargetJDK = CompilerOptions.versionToJdkLevel(project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                    long prereqProjectTargetJDK = CompilerOptions.versionToJdkLevel(prereqProject.getOption("org.aspectj.org.eclipse.jdt.core.compiler.codegen.targetPlatform", true));
                    if (prereqProjectTargetJDK <= projectTargetJDK) return JavaModelStatus.VERIFIED_OK;
                    return new JavaModelStatus(1004, project, path, CompilerOptions.versionFromJdkLevel(prereqProjectTargetJDK));
                }
                catch (CoreException e) {
                    return new JavaModelStatus(964, Util.bind("classpath.unboundProject", path.segment(0), projectName));
                }
            }
            case 3: {
                if ((entry.getInclusionPatterns() != null && entry.getInclusionPatterns().length > 0 || entry.getExclusionPatterns() != null && entry.getExclusionPatterns().length > 0) && "disabled".equals(project.getOption("org.aspectj.org.eclipse.jdt.core.classpath.exclusionPatterns", true))) {
                    return new JavaModelStatus(1002, (IJavaElement)project, path);
                }
                if (entry.getOutputLocation() != null && "disabled".equals(project.getOption("org.aspectj.org.eclipse.jdt.core.classpath.multipleOutputLocations", true))) {
                    return new JavaModelStatus(1003, (IJavaElement)project, path);
                }
                if (path == null || !path.isAbsolute() || path.isEmpty()) return new JavaModelStatus(964, Util.bind("classpath.illegalSourceFolderPath", entryPathMsg, projectName));
                IPath projectPath = project.getProject().getFullPath();
                if (projectPath.isPrefixOf(path) && JavaModel.getTarget((IContainer)workspaceRoot, path, true) != null) return JavaModelStatus.VERIFIED_OK;
                return new JavaModelStatus(964, Util.bind("classpath.unboundSourceFolder", entryPathMsg, projectName));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

