/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.aspectj.org.eclipse.jdt.core.Flags;
import org.aspectj.org.eclipse.jdt.core.IClassFile;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IMember;
import org.aspectj.org.eclipse.jdt.core.IMethod;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.ISourceRange;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.InvalidInputException;
import org.aspectj.org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.LocalVariableDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.aspectj.org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.aspectj.org.eclipse.jdt.core.search.PackageDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.PackageReferenceMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchDocument;
import org.aspectj.org.eclipse.jdt.core.search.SearchMatch;
import org.aspectj.org.eclipse.jdt.core.search.SearchParticipant;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.core.search.SearchRequestor;
import org.aspectj.org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.aspectj.org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfIntValues;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.core.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElement;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.Openable;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.SourceMapper;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.aspectj.org.eclipse.jdt.internal.core.index.Index;
import org.aspectj.org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.search.IndexSelector;
import org.aspectj.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.aspectj.org.eclipse.jdt.internal.core.search.SearchBasicEngine;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.ClassFileMatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.InternalSearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocatorParser;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.PossibleMatchSet;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.aspectj.org.eclipse.jdt.internal.core.util.HandleFactory;
import org.aspectj.org.eclipse.jdt.internal.core.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MatchLocator
implements ITypeRequestor {
    public static final int MAX_AT_ONCE = 400;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IJavaSearchScope scope;
    public IProgressMonitor progressMonitor;
    public org.aspectj.org.eclipse.jdt.core.ICompilationUnit[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public MatchLocatorParser parser;
    private Parser basicParser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HierarchyResolver hierarchyResolver;
    public CompilerOptions options;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;
    int progressStep;
    int progressWorked;
    CompilationUnitScope unitScope;
    SimpleLookupTable bindings;

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, org.aspectj.org.eclipse.jdt.core.ICompilationUnit[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IJavaElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(org.aspectj.org.eclipse.jdt.core.ICompilationUnit[] copies, IJavaElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaProject) && !(focus instanceof JarPackageFragmentRoot)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            org.aspectj.org.eclipse.jdt.core.ICompilationUnit workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
            }
            ++i;
        }
        return result;
    }

    public static ClassFileReader classFileReader(IType type) {
        IClassFile classFile = type.getClassFile();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (classFile.isOpen()) {
            return (ClassFileReader)manager.getInfo(type);
        }
        PackageFragment pkg = (PackageFragment)type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            IPath zipPath;
            if (!root.isArchive()) {
                return ClassFileReader.read(type.getPath().toOSString());
            }
            IPath iPath = zipPath = root.isExternal() ? root.getPath() : root.getResource().getLocation();
            if (zipPath == null) {
                return null;
            }
            ZipFile zipFile = null;
            try {
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [MatchLocator.classFileReader()] Creating ZipFile on " + zipPath);
                }
                zipFile = manager.getZipFile(zipPath);
                String classFileName = classFile.getElementName();
                String path = Util.concatWith(pkg.names, classFileName, '/');
                ClassFileReader classFileReader = ClassFileReader.read(zipFile, path);
                Object var9_13 = null;
                manager.closeZipFile(zipFile);
                return classFileReader;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                manager.closeZipFile(zipFile);
                throw throwable;
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static SearchPattern createAndPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = searchPattern;
            }

            public SearchPattern currentPattern() {
                return this.current;
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IJavaElement getProjectOrJar(IJavaElement element) {
        while (!(element instanceof IJavaProject) && !(element instanceof JarPackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    public static boolean isPolymorphicSearch(InternalSearchPattern pattern) {
        return pattern.isPolymorphicSearch();
    }

    public static IJavaElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        block2: {
            CompilationResult unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit = this.basicParser().dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block2;
                throw e;
            }
        }
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getCompilationUnit());
            this.accept(sourceUnit, accessRestriction);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseAndBuildBindings(PossibleMatch possibleMatch, boolean mustResolve) {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (SearchBasicEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.nodeSet = possibleMatch.nodeSet;
            CompilationResult unitResult = new CompilationResult(possibleMatch, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(possibleMatch, unitResult);
            if (parsedUnit != null) {
                if (mustResolve && !parsedUnit.isEmpty()) {
                    this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                }
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.parser.nodeSet = null;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.parser.nodeSet = null;
            return;
        }
    }

    protected BinaryTypeBinding cacheBinaryType(IType type, IBinaryType binaryType) throws JavaModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType, null);
        }
        if (binaryType == null) {
            ClassFile classFile = (ClassFile)type.getClassFile();
            try {
                binaryType = this.getBinaryInfo(classFile, classFile.getResource());
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        if ((binding = this.lookupEnvironment.cacheBinaryType(binaryType, null)) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator(this.pattern, this.requestor, this.scope, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return this.allSuperTypeNames;
    }

    protected IJavaElement createHandle(AbstractMethodDeclaration method, IJavaElement parent) {
        int argCount;
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        Argument[] arguments = method.arguments;
        int n = argCount = arguments == null ? 0 : arguments.length;
        if (type.isBinary()) {
            IBinaryMethod[] methods;
            ClassFileReader reader = MatchLocator.classFileReader(type);
            if (reader != null && (methods = reader.getMethods()) != null) {
                boolean firstIsSynthetic = false;
                if (reader.isMember() && method.isConstructor() && !Flags.isStatic(reader.getModifiers())) {
                    firstIsSynthetic = true;
                    ++argCount;
                }
                int i = 0;
                int methodsLength = methods.length;
                while (i < methodsLength) {
                    block12: {
                        char[][] parameterTypes;
                        char[] selector;
                        IBinaryMethod binaryMethod = methods[i];
                        char[] cArray = selector = binaryMethod.isConstructor() ? type.getElementName().toCharArray() : binaryMethod.getSelector();
                        if (CharOperation.equals(selector, method.selector) && argCount == (parameterTypes = Signature.getParameterTypes(binaryMethod.getMethodDescriptor())).length) {
                            int j = 0;
                            while (j < argCount) {
                                char[] typeName;
                                if (j == 0 && firstIsSynthetic) {
                                    typeName = type.getDeclaringType().getFullyQualifiedName().toCharArray();
                                } else {
                                    TypeReference typeRef = arguments[firstIsSynthetic ? j - 1 : j].type;
                                    typeName = CharOperation.concatWith(typeRef.getTypeName(), '.');
                                    int k = 0;
                                    int dim = typeRef.dimensions();
                                    while (k < dim) {
                                        typeName = CharOperation.concat(typeName, new char[]{'[', ']'});
                                        ++k;
                                    }
                                }
                                char[] parameterTypeName = ClassFileMatchLocator.convertClassFileFormat(parameterTypes[j]);
                                if (CharOperation.endsWith(Signature.toCharArray(parameterTypeName), typeName)) {
                                    parameterTypes[j] = parameterTypeName;
                                    ++j;
                                    continue;
                                }
                                break block12;
                            }
                            return type.getMethod(new String(selector), CharOperation.toStrings(parameterTypes));
                        }
                    }
                    ++i;
                }
            }
            return null;
        }
        String[] parameterTypeSignatures = new String[argCount];
        int i = 0;
        while (i < argCount) {
            TypeReference typeRef = arguments[i].type;
            char[] typeName = CharOperation.concatWith(typeRef.getParameterizedTypeName(), '.');
            parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
            ++i;
        }
        return type.getMethod(new String(method.selector), parameterTypeSignatures);
    }

    protected IJavaElement createHandle(FieldDeclaration fieldDeclaration, TypeDeclaration typeDeclaration, IJavaElement parent) {
        if (!(parent instanceof IType)) {
            return parent;
        }
        switch (fieldDeclaration.getKind()) {
            case 1: 
            case 3: {
                return ((IType)parent).getField(new String(fieldDeclaration.name));
            }
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            if (fields[i].getKind() == 2) {
                ++occurrenceCount;
                if (fields[i].equals(fieldDeclaration)) break;
            }
            ++i;
        }
        return ((IType)parent).getInitializer(occurrenceCount);
    }

    protected boolean createHierarchyResolver(IType focusType, PossibleMatch[] possibleMatches) {
        char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
        boolean isPossibleMatch = false;
        int i = 0;
        int length = possibleMatches.length;
        while (i < length) {
            if (CharOperation.equals(possibleMatches[i].compoundName, compoundName)) {
                isPossibleMatch = true;
                break;
            }
            ++i;
        }
        if (!isPossibleMatch) {
            if (focusType.isBinary()) {
                try {
                    this.cacheBinaryType(focusType, null);
                }
                catch (JavaModelException e) {
                    return false;
                }
            } else {
                this.accept((ICompilationUnit)((Object)focusType.getCompilationUnit()), null);
            }
        }
        this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
        ReferenceBinding binding = this.hierarchyResolver.setFocusType(compoundName);
        return binding != null && binding.isValidBinding() && (binding.tagBits & 0x8000L) == 0L;
    }

    protected IJavaElement createImportHandle(ImportReference importRef) {
        Openable openable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if (importRef.onDemand) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((openable = this.currentPossibleMatch.openable) instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getImport(new String(importName));
        }
        IType binaryType = ((ClassFile)openable).getType();
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDollar == -1) {
            return binaryType;
        }
        return this.createTypeHandle(typeName.substring(0, lastDollar));
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getType(simpleTypeName);
        }
        IType binaryType = ((ClassFile)openable).getType();
        if (simpleTypeName.equals(binaryType.getTypeQualifiedName())) {
            return binaryType;
        }
        try {
            IClassFile classFile = binaryType.getPackageFragment().getClassFile(String.valueOf(simpleTypeName) + ".class");
            return classFile.getType();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected boolean encloses(IJavaElement element) {
        return element != null && this.scope.encloses(element);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        try {
            ClassFileReader info;
            block9: {
                PackageFragment pkg = (PackageFragment)classFile.getParent();
                PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
                if (root.isArchive()) {
                    String classFileName = classFile.getElementName();
                    String classFilePath = Util.concatWith(pkg.names, classFileName, '/');
                    ZipFile zipFile = null;
                    try {
                        zipFile = ((JarPackageFragmentRoot)root).getJar();
                        info = ClassFileReader.read(zipFile, classFilePath);
                    }
                    catch (Throwable throwable) {
                        Object var10_14 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                        throw throwable;
                    }
                    {
                        Object var10_15 = null;
                        JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                        break block9;
                    }
                }
                String osPath = resource.getLocation().toOSString();
                info = ClassFileReader.read(osPath);
            }
            if (info == null) {
                throw binaryType.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException e) {
            return null;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getMethodBodies(CompilationUnitDeclaration unit) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        int[] oldLineEnds = this.parser.scanner.lineEnds;
        int oldLinePtr = this.parser.scanner.linePtr;
        try {
            CompilationResult compilationResult = unit.compilationResult;
            this.parser.scanner.setSource(compilationResult);
            if (this.parser.javadocParser.checkDocComment) {
                char[] contents = compilationResult.compilationUnit.getContents();
                this.parser.javadocParser.scanner.setSource(contents);
            }
            this.parser.nodeSet = this.currentPossibleMatch.nodeSet;
            this.parser.parseBodies(unit);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            return;
        }
    }

    protected TypeBinding getType(Object typeKey, char[] typeName) {
        if (this.unitScope == null || typeName == null || typeName.length == 0) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(typeKey);
        if (binding != null) {
            if (binding instanceof TypeBinding && binding.isValidBinding()) {
                return (TypeBinding)binding;
            }
            return null;
        }
        char[][] compoundName = CharOperation.splitOn('.', typeName);
        TypeBinding typeBinding = this.unitScope.getType(compoundName, compoundName.length);
        this.bindings.put(typeKey, typeBinding);
        return typeBinding.isValidBinding() ? typeBinding : null;
    }

    public MethodBinding getMethodBinding(IMethod method) {
        if (this.unitScope == null) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(method);
        if (binding != null) {
            if (binding instanceof MethodBinding && binding.isValidBinding()) {
                return (MethodBinding)binding;
            }
            return null;
        }
        MethodBinding methodBinding = null;
        String typeName = method.getDeclaringType().getElementName();
        TypeBinding declaringTypeBinding = this.getType(typeName, typeName.toCharArray());
        if (declaringTypeBinding != null) {
            if (declaringTypeBinding.isArrayType()) {
                declaringTypeBinding = declaringTypeBinding.leafComponentType();
            }
            if (!declaringTypeBinding.isBaseType()) {
                String[] parameterTypes = method.getParameterTypes();
                int length = parameterTypes.length;
                TypeBinding[] parameters = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    parameters[i] = this.unitScope.getType(Signature.toCharArray(parameterTypes[i].toCharArray()));
                    ++i;
                }
                ReferenceBinding referenceBinding = (ReferenceBinding)declaringTypeBinding;
                methodBinding = referenceBinding.getExactMethod(method.getElementName().toCharArray(), parameters);
                this.bindings.put(method, methodBinding);
                return methodBinding;
            }
        }
        this.bindings.put(method, new ProblemMethodBinding(method.getElementName().toCharArray(), null, 1));
        return null;
    }

    protected boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            if (result.problems[i].getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize(JavaProject project, int possibleMatchSize) throws JavaModelException {
        if (this.nameEnvironment != null && possibleMatchSize != 1) {
            this.nameEnvironment.cleanup();
        }
        SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.workingCopies);
        this.nameEnvironment = possibleMatchSize == 1 ? searchableEnvironment : new JavaSearchNameEnvironment(project, this.workingCopies);
        this.options = new CompilerOptions(project.getOptions(true));
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = MatchLocatorParser.createParser(problemReporter, this);
        this.nameLookup = searchableEnvironment.nameLookup;
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(JavaProject javaProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        Object var10_16;
        boolean bindingsWereCreated;
        boolean mustResolve;
        block28: {
            this.initialize(javaProject, length);
            bindingsWereCreated = mustResolve = this.pattern.mustResolve;
            try {
                IType focusType;
                int i = start;
                int maxUnits = start + length;
                while (true) {
                    if (i >= maxUnits) {
                        if (mustResolve) {
                            this.lookupEnvironment.completeTypeBindings();
                        }
                        if ((focusType = this.getFocusType()) != null) break;
                        this.hierarchyResolver = null;
                        break block28;
                    }
                    PossibleMatch possibleMatch = possibleMatches[i];
                    try {
                        this.parseAndBuildBindings(possibleMatch, mustResolve);
                        if (!mustResolve) {
                            if (this.progressMonitor != null) {
                                ++this.progressWorked;
                                if (this.progressWorked % this.progressStep == 0) {
                                    this.progressMonitor.worked(this.progressStep);
                                }
                            }
                            this.process(possibleMatch, bindingsWereCreated);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_16 = null;
                        if (!mustResolve) {
                            possibleMatch.cleanUp();
                        }
                        throw throwable;
                    }
                    {
                        var10_16 = null;
                        if (!mustResolve) {
                            possibleMatch.cleanUp();
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
                if (!this.createHierarchyResolver(focusType, possibleMatches) && this.computeSuperTypeNames(focusType) == null) {
                    return;
                }
            }
            catch (AbortCompilation e) {
                bindingsWereCreated = false;
            }
        }
        if (!mustResolve) {
            return;
        }
        int i = 0;
        while (true) {
            PossibleMatch possibleMatch;
            block29: {
                if (i >= this.numberOfMatches) {
                    return;
                }
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                possibleMatch = this.matchesToProcess[i];
                this.matchesToProcess[i] = null;
                try {
                    try {
                        this.process(possibleMatch, bindingsWereCreated);
                    }
                    catch (AbortCompilation e) {
                        bindingsWereCreated = false;
                    }
                    catch (JavaModelException e) {
                        bindingsWereCreated = false;
                    }
                }
                catch (Throwable throwable) {
                    var10_16 = null;
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    if (this.options.verbose) {
                        System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                    }
                    possibleMatch.cleanUp();
                    throw throwable;
                }
                {
                    var10_16 = null;
                    if (this.progressMonitor == null) break block29;
                    ++this.progressWorked;
                    if (this.progressWorked % this.progressStep != 0) break block29;
                }
                this.progressMonitor.worked(this.progressStep);
            }
            if (this.options.verbose) {
                System.out.println(Util.bind("compilation.done", new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
            }
            possibleMatch.cleanUp();
            ++i;
        }
    }

    protected void locateMatches(JavaProject javaProject, PossibleMatchSet matchSet, int expected) throws CoreException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getPackageFragmentRoots());
        int length = possibleMatches.length;
        if (this.progressMonitor != null && expected > length) {
            this.progressWorked += expected - length;
            this.progressMonitor.worked(expected - length);
        }
        int index = 0;
        while (index < length) {
            int max = Math.min(400, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            index += max;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        docsLength = searchDocuments.length;
        if (SearchBasicEngine.VERBOSE) {
            System.out.println("Locating matches in documents [");
            i = 0;
            while (true) {
                if (i >= docsLength) {
                    System.out.println("]");
                    break;
                }
                System.out.println("\t" + searchDocuments[i]);
                ++i;
            }
        }
        n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
        this.progressStep = docsLength < n ? 1 : docsLength / n;
        this.progressWorked = 0;
        copies = new ArrayList<org.aspectj.org.eclipse.jdt.core.ICompilationUnit>();
        i = 0;
        while (true) {
            if (i >= docsLength) {
                copiesLength = copies.size();
                this.workingCopies = new org.aspectj.org.eclipse.jdt.core.ICompilationUnit[copiesLength];
                copies.toArray(this.workingCopies);
                manager = JavaModelManager.getJavaModelManager();
                this.bindings = new SimpleLookupTable();
                ** try [egrp 0[TRYBLOCK] [2 : 213->669)] { 
lbl26:
                // 1 sources

                break;
            }
            document = searchDocuments[i];
            if (document instanceof WorkingCopyDocument) {
                copies.add(((WorkingCopyDocument)document).workingCopy);
            }
            ++i;
        }
        {
            block31: {
                manager.cacheZipFiles();
                if (this.handleFactory == null) {
                    this.handleFactory = new HandleFactory();
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.beginTask("", searchDocuments.length);
                }
                this.patternLocator.initializePolymorphicSearch(this);
                previousJavaProject = null;
                matchSet = new PossibleMatchSet();
                Util.sort((Object[])searchDocuments, new Util.Comparer(){

                    public int compare(Object a, Object b) {
                        return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                    }
                });
                displayed = 0;
                i = 0;
                while (true) {
                    block33: {
                        block34: {
                            block32: {
                                if (i >= docsLength) {
                                    if (previousJavaProject != null) {
                                        ** try [egrp 2[TRYBLOCK] [1 : 633->648)] { 
lbl48:
                                        // 1 sources

                                        break;
                                    }
                                    break block31;
                                }
                                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                searchDocument = searchDocuments[i];
                                pathString = searchDocument.getPath();
                                if (i <= 0 || !pathString.equals(searchDocuments[i - 1].getPath())) break block32;
                                if (this.progressMonitor != null) {
                                    ++this.progressWorked;
                                    if (this.progressWorked % this.progressStep == 0) {
                                        this.progressMonitor.worked(this.progressStep);
                                    }
                                }
                                ++displayed;
                                break block33;
                            }
                            workingCopy = null;
                            if (!(searchDocument instanceof WorkingCopyDocument)) break block34;
                            workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                            openable = (Openable)workingCopy;
                            ** GOTO lbl-1000
                        }
                        openable = this.handleFactory.createOpenable(pathString, this.scope);
                        if (openable == null) {
                            if (this.progressMonitor != null) {
                                ++this.progressWorked;
                                if (this.progressWorked % this.progressStep == 0) {
                                    this.progressMonitor.worked(this.progressStep);
                                }
                            }
                            ++displayed;
                        } else lbl-1000:
                        // 2 sources

                        {
                            resource = null;
                            javaProject = (JavaProject)openable.getJavaProject();
                            v0 = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            if (!javaProject.equals(previousJavaProject)) {
                                if (previousJavaProject != null) {
                                    try {
                                        this.locateMatches(previousJavaProject, matchSet, i - displayed);
                                        displayed = i;
                                    }
                                    catch (JavaModelException var17_18) {
                                        // empty catch block
                                    }
                                    matchSet.reset();
                                }
                                previousJavaProject = javaProject;
                            }
                            matchSet.add(new PossibleMatch(this, resource, openable, searchDocument));
                        }
                    }
                    ++i;
                }
                {
                    this.locateMatches(previousJavaProject, matchSet, docsLength - displayed);
                }
lbl97:
                // 1 sources

                catch (JavaModelException var10_11) {
                    // empty catch block
                }
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.done();
            }
        }
lbl103:
        // 1 sources

        catch (Throwable var19_19) {
            var18_20 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            throw var19_19;
        }
        {
            var18_21 = null;
            if (this.nameEnvironment != null) {
                this.nameEnvironment.cleanup();
            }
            manager.flushZipFiles();
            this.bindings = null;
            return;
        }
    }

    public void locatePackageDeclarations(SearchParticipant participant) throws CoreException {
        this.locatePackageDeclarations(this.pattern, participant);
    }

    protected void locatePackageDeclarations(SearchPattern searchPattern, SearchParticipant participant) throws CoreException {
        block22: {
            block21: {
                if (!(searchPattern instanceof OrPattern)) break block21;
                SearchPattern[] patterns = ((OrPattern)searchPattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    this.locatePackageDeclarations(patterns[i], participant);
                    ++i;
                }
                break block22;
            }
            if (!(searchPattern instanceof PackageDeclarationPattern)) break block22;
            IJavaElement focus = searchPattern.focus;
            if (focus != null) {
                SearchDocument document = participant.getDocument(focus.getPath().toString());
                this.currentPossibleMatch = new PossibleMatch(this, focus.getResource(), null, document);
                if (this.encloses(focus)) {
                    SearchMatch match = this.newDeclarationMatch(focus, 0, -1, -1);
                    this.report(match);
                }
                return;
            }
            PackageDeclarationPattern pkgPattern = (PackageDeclarationPattern)searchPattern;
            IJavaProject[] projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int i = 0;
            int length = projects.length;
            while (i < length) {
                block18: {
                    IJavaProject javaProject = projects[i];
                    IPackageFragmentRoot[] roots = null;
                    try {
                        roots = javaProject.getPackageFragmentRoots();
                    }
                    catch (JavaModelException e) {
                        break block18;
                    }
                    int j = 0;
                    int rootsLength = roots.length;
                    while (j < rootsLength) {
                        block19: {
                            IJavaElement[] pkgs = null;
                            try {
                                pkgs = roots[j].getChildren();
                            }
                            catch (JavaModelException e) {
                                break block19;
                            }
                            int k = 0;
                            int pksLength = pkgs.length;
                            while (k < pksLength) {
                                block20: {
                                    IPackageFragment pkg = (IPackageFragment)pkgs[k];
                                    IJavaElement[] children = null;
                                    try {
                                        children = pkg.getChildren();
                                    }
                                    catch (JavaModelException e) {
                                        break block20;
                                    }
                                    if (children.length > 0 && pkgPattern.matchesName(pkgPattern.pkgName, pkg.getElementName().toCharArray())) {
                                        IResource resource = pkg.getResource();
                                        if (resource == null) {
                                            resource = javaProject.getProject();
                                        }
                                        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
                                        this.currentPossibleMatch = new PossibleMatch(this, resource, null, document);
                                        try {
                                            if (this.encloses(pkg)) {
                                                SearchMatch match = this.newDeclarationMatch(pkg, 0, -1, -1);
                                                this.report(match);
                                            }
                                        }
                                        catch (JavaModelException e) {
                                            throw e;
                                        }
                                        catch (CoreException e) {
                                            throw new JavaModelException(e);
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected IType lookupType(ReferenceBinding typeBinding) {
        IType type;
        if (typeBinding == null) {
            return null;
        }
        char[] packageName = typeBinding.qualifiedPackageName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        char[] sourceName = typeBinding.qualifiedSourceName();
        String typeName = new String(sourceName);
        int i = 0;
        int length = pkgs == null ? 0 : pkgs.length;
        while (i < length) {
            type = this.nameLookup.findType(typeName, pkgs[i], false, typeBinding.isClass() ? 2 : 4);
            if (type != null) {
                return type;
            }
            ++i;
        }
        char[][] qualifiedName = CharOperation.splitOn('.', sourceName);
        length = qualifiedName.length;
        if (length == 0) {
            return null;
        }
        type = this.createTypeHandle(new String(qualifiedName[0]));
        if (type == null) {
            return null;
        }
        int i2 = 1;
        while (i2 < length) {
            if ((type = type.getType(new String(qualifiedName[i2]))) == null) {
                return null;
            }
            ++i2;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newDeclarationMatch(IJavaElement element, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 4: {
                return new PackageDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 7: {
                return new TypeDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 8: {
                return new FieldDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 9: {
                return new MethodDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 14: {
                return new LocalVariableDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
            case 11: {
                return new PackageDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newFieldReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new FieldReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newLocalVariableReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new LocalVariableReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newMethodReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, boolean isConstructor, boolean isSynthetic, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new MethodReferenceMatch(enclosingElement, accuracy, offset, length, isConstructor, isSynthetic, insideDocComment, participant, resource);
    }

    public SearchMatch newPackageReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new PackageReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public SearchMatch newTypeReferenceMatch(IJavaElement enclosingElement, int accuracy, int offset, int length, int rule, ASTNode reference) {
        SearchMatch match = this.newTypeReferenceMatch(enclosingElement, accuracy, offset, length, reference);
        match.setMatchRule(rule);
        return match;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(PossibleMatch possibleMatch, boolean bindingsWereCreated) throws CoreException {
        block14: {
            block13: {
                this.currentPossibleMatch = possibleMatch;
                CompilationUnitDeclaration unit = possibleMatch.parsedUnit;
                try {
                    try {
                        if (unit.isEmpty()) {
                            ClassFile classFile;
                            IBinaryType info;
                            if (this.currentPossibleMatch.openable instanceof ClassFile && (info = this.getBinaryInfo(classFile = (ClassFile)this.currentPossibleMatch.openable, this.currentPossibleMatch.resource)) != null) {
                                new ClassFileMatchLocator().locateMatches(this, classFile, info);
                            }
                            Object var6_7 = null;
                            this.currentPossibleMatch = null;
                            return;
                        }
                        if (this.hasAlreadyDefinedType(unit)) {
                            break block13;
                        }
                        this.getMethodBodies(unit);
                        if (bindingsWereCreated && this.pattern.mustResolve && unit.types != null) {
                            if (SearchBasicEngine.VERBOSE) {
                                System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                            }
                            this.reduceParseTree(unit);
                            if (unit.scope != null) {
                                unit.scope.faultInTypes();
                                unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                            }
                            unit.resolve();
                            this.reportMatching(unit, true);
                            break block14;
                        } else {
                            this.reportMatching(unit, this.pattern.mustResolve);
                        }
                        break block14;
                    }
                    catch (AbortCompilation e) {
                        this.reportMatching(unit, true);
                        if (!(e instanceof AbortCompilationUnit)) {
                            throw e;
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    this.currentPossibleMatch = null;
                    throw throwable;
                }
            }
            Object var6_8 = null;
            this.currentPossibleMatch = null;
            return;
        }
        Object var6_10 = null;
        this.currentPossibleMatch = null;
    }

    protected void purgeMethodStatements(TypeDeclaration type, boolean checkEachMethod) {
        TypeDeclaration[] memberTypes;
        checkEachMethod = checkEachMethod && this.currentPossibleMatch.nodeSet.hasPossibleNodes(type.declarationSourceStart, type.declarationSourceEnd);
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int length;
            int j;
            if (checkEachMethod) {
                j = 0;
                length = methods.length;
                while (j < length) {
                    AbstractMethodDeclaration method = methods[j];
                    if (!this.currentPossibleMatch.nodeSet.hasPossibleNodes(method.declarationSourceStart, method.declarationSourceEnd)) {
                        method.statements = null;
                        method.javadoc = null;
                    }
                    ++j;
                }
            } else {
                j = 0;
                length = methods.length;
                while (j < length) {
                    methods[j].statements = null;
                    methods[j].javadoc = null;
                    ++j;
                }
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                this.purgeMethodStatements(memberTypes[i], checkEachMethod);
                ++i;
            }
        }
    }

    protected void reduceParseTree(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        int i = 0;
        int l = types.length;
        while (i < l) {
            this.purgeMethodStatements(types[i], true);
            ++i;
        }
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(SearchMatch match) throws CoreException {
        long start = -1L;
        if (SearchBasicEngine.VERBOSE) {
            start = System.currentTimeMillis();
            System.out.println("Reporting match");
            System.out.println("\tResource: " + match.getResource());
            System.out.println("\tPositions: [offset=" + match.getOffset() + ", length=" + match.getLength() + "]");
            System.out.println("\tJava element: " + ((JavaElement)match.getElement()).toStringWithAncestors());
            System.out.println(match.getAccuracy() == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
            System.out.print("\tMatch rule: ");
            if ((match.getMatchRule() & 0x20) != 0) {
                if ((match.getMatchRule() & 0x10) != 0) {
                    System.out.println("EQUIVALENT + ERASURE");
                } else {
                    System.out.println("EQUIVALENT");
                }
            } else if ((match.getMatchRule() & 0x10) != 0) {
                System.out.println("ERASURE");
            } else {
                System.out.println("PERFECT");
            }
        }
        this.requestor.acceptSearchMatch(match);
        if (SearchBasicEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void reportAccurateTypeReference(ASTNode typeRef, char[] name, IJavaElement element, int accuracy) throws CoreException {
        this.reportAccurateTypeReference(typeRef, name, element, accuracy, 0);
    }

    protected void reportAccurateTypeReference(ASTNode typeRef, char[] name, IJavaElement element, int accuracy, int rule) throws CoreException {
        if (accuracy == -1) {
            return;
        }
        if (!this.encloses(element)) {
            return;
        }
        int sourceStart = typeRef.sourceStart;
        int sourceEnd = typeRef.sourceEnd;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int token = -1;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 22 || !this.pattern.matchesName(name, scanner.getCurrentTokenSource())) continue;
            int length = scanner.currentPosition - currentPosition;
            SearchMatch match = this.newTypeReferenceMatch(element, accuracy, currentPosition, length, rule, typeRef);
            this.report(match);
            return;
        } while (token != 75);
        SearchMatch match = this.newTypeReferenceMatch(element, accuracy, sourceStart, sourceEnd - sourceStart + 1, rule, typeRef);
        this.report(match);
    }

    /*
     * Unable to fully structure code
     */
    protected void reportAccurateParameterizedTypeReference(TypeReference typeRef, int start, int index, TypeReference[] typeArguments, IJavaElement element, int accuracy, int rule) throws CoreException {
        block7: {
            block6: {
                block8: {
                    block9: {
                        if (accuracy == -1) {
                            return;
                        }
                        if (!this.encloses(element)) {
                            return;
                        }
                        end = typeRef.sourceEnd;
                        if (typeArguments == null) break block7;
                        scanner = this.parser.scanner;
                        source = this.currentPossibleMatch.getContents();
                        scanner.setSource(source);
                        javaSearchPattern = (JavaSearchPattern)this.pattern;
                        if (!javaSearchPattern.isErasureMatch && javaSearchPattern.typeSignatures != null) break block8;
                        if (!(typeRef instanceof QualifiedTypeReference) || index < 0) break block9;
                        positions = ((QualifiedTypeReference)typeRef).sourcePositions;
                        end = (int)positions[index];
                        break block7;
                    }
                    if (!(typeRef instanceof ArrayTypeReference)) break block7;
                    end = ((ArrayTypeReference)typeRef).originalSourceEnd;
                    break block7;
                }
                scanner.resetTo(end, source.length - 1);
                depth = 0;
                i = typeArguments.length - 1;
                while (i >= 0) {
                    if (typeArguments[i] != null) {
                        depth = this.resetScannerAfterLastTypeArgumentEnd(typeArguments[i], scanner, depth) + 1;
                        break block6;
                    }
                    --i;
                }
                break block6;
                while (true) {
                    if (scanner.getNextChar() != 62) continue;
                    end = scanner.currentPosition - 1;
                    break;
                }
            }
            while (depth-- > 0) {
                if (!scanner.atEnd()) ** continue;
            }
        }
        match = this.newTypeReferenceMatch(element, accuracy, start, end - start + 1, rule, typeRef);
        this.report(match);
    }

    private int resetScannerAfterLastTypeArgumentEnd(TypeReference typeRef, Scanner scanner, int depth) {
        int end = typeRef.sourceEnd;
        TypeReference[] typeArguments = null;
        if (typeRef instanceof ParameterizedQualifiedTypeReference) {
            ParameterizedQualifiedTypeReference pqtRef = (ParameterizedQualifiedTypeReference)typeRef;
            TypeReference[] last = null;
            int i = pqtRef.typeArguments.length - 1;
            while (i >= 0 && last == null) {
                last = pqtRef.typeArguments[i];
                --i;
            }
            if (last == null) {
                scanner.resetTo(end + 1, scanner.eofPosition - 1);
                return depth;
            }
            typeArguments = last;
        }
        if (typeRef instanceof ParameterizedSingleTypeReference || typeArguments != null) {
            if (typeArguments == null) {
                typeArguments = ((ParameterizedSingleTypeReference)typeRef).typeArguments;
            }
            TypeReference last = null;
            int i = typeArguments.length - 1;
            while (i >= 0 && last == null) {
                last = typeArguments[i];
                ++i;
            }
            if (last == null) {
                scanner.resetTo(end + 1, scanner.eofPosition - 1);
                return depth;
            }
            return this.resetScannerAfterLastTypeArgumentEnd(last, scanner, depth + 1);
        }
        scanner.resetTo(end + 1, scanner.eofPosition - 1);
        return depth;
    }

    protected void reportAccurateFieldReference(QualifiedNameReference qNameRef, IJavaElement element, int[] accuracies) throws CoreException {
        if (!this.encloses(element)) {
            return;
        }
        int sourceStart = qNameRef.sourceStart;
        int sourceEnd = qNameRef.sourceEnd;
        char[][] tokens = qNameRef.tokens;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int accuracyIndex = 0;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (token != 75) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
            if (accuracies[accuracyIndex] != -1) {
                SearchMatch match;
                if (refSourceStart != -1) {
                    match = this.newFieldReferenceMatch(element, accuracies[accuracyIndex], refSourceStart, refSourceEnd - refSourceStart + 1, qNameRef);
                    this.report(match);
                } else {
                    match = this.newFieldReferenceMatch(element, accuracies[accuracyIndex], sourceStart, sourceEnd - sourceStart + 1, qNameRef);
                    this.report(match);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (accuracyIndex >= accuracies.length - 1) continue;
            ++accuracyIndex;
        } while (token != 75);
    }

    protected void reportBinaryMemberDeclaration(IResource resource, IMember binaryMember, IBinaryType info, int accuracy) throws CoreException {
        char[] contents;
        SourceMapper mapper;
        BinaryType type;
        String sourceFileName;
        ISourceRange range;
        ClassFile classFile = (ClassFile)binaryMember.getClassFile();
        ISourceRange iSourceRange = range = classFile.isOpen() ? binaryMember.getNameRange() : SourceMapper.fgUnknownRange;
        if (range.getOffset() == -1 && (sourceFileName = (type = (BinaryType)classFile.getType()).sourceFileName(info)) != null && (mapper = classFile.getSourceMapper()) != null && (contents = mapper.findSource(type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, binaryMember);
        }
        if (resource == null) {
            resource = this.currentPossibleMatch.resource;
        }
        SearchMatch match = this.newDeclarationMatch(binaryMember, accuracy, range.getOffset(), range.getLength(), this.getParticipant(), resource);
        this.report(match);
    }

    protected void reportMatching(AbstractMethodDeclaration method, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IJavaElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            Scanner scanner = this.parser.scanner;
            int nameSourceStart = method.sourceStart;
            scanner.setSource(this.currentPossibleMatch.getContents());
            scanner.resetTo(nameSourceStart, method.sourceEnd);
            try {
                scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (this.encloses(enclosingElement)) {
                int length = scanner.currentPosition - nameSourceStart;
                SearchMatch match = this.patternLocator.newDeclarationMatch(method, enclosingElement, accuracy, length, this);
                this.report(match);
            }
        }
        if ((method.bits & 2) != 0) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
            try {
                method.traverse((ASTVisitor)localDeclarationVisitor, (ClassScope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (method.annotations != null) {
            int i = 0;
            int al = method.annotations.length;
            while (i < al) {
                TypeReference typeRef = method.annotations[i].type;
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(typeRef);
                if (level != null) {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(method, parent);
                    }
                    this.patternLocator.matchReportReference(typeRef, enclosingElement, level, this);
                }
                ++i;
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd)) != null) {
            int i;
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    i = 0;
                    int l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                        ++i;
                    }
                    return;
                }
            }
            i = 0;
            int l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(CompilationUnitDeclaration unit, boolean mustResolve) throws CoreException {
        TypeDeclaration[] types;
        Integer level;
        int i;
        ImportReference[] imports;
        boolean matchedUnitContainer;
        ImportReference importRef;
        MatchingNodeSet nodeSet;
        block14: {
            block11: {
                nodeSet = this.currentPossibleMatch.nodeSet;
                if (!mustResolve) break block11;
                this.unitScope = unit.scope.compilationUnitScope();
                Object[] nodes = nodeSet.possibleMatchingNodesSet.values;
                int i2 = 0;
                int l = nodes.length;
                while (i2 < l) {
                    block12: {
                        ASTNode node;
                        block13: {
                            node = (ASTNode)nodes[i2];
                            if (node == null) break block12;
                            if (!(node instanceof ImportReference)) break block13;
                            if (this.hierarchyResolver != null) break block12;
                            importRef = (ImportReference)node;
                            Binding binding = importRef.onDemand ? this.unitScope.getImport(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length), true, importRef.isStatic()) : this.unitScope.getImport(importRef.tokens, false, importRef.isStatic());
                            this.patternLocator.matchLevelAndReportImportRef(importRef, binding, this);
                        }
                        nodeSet.addMatch(node, this.patternLocator.resolveLevel(node));
                    }
                    ++i2;
                }
                nodeSet.possibleMatchingNodesSet = new SimpleSet(3);
                break block14;
            }
            this.unitScope = null;
        }
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        boolean bl = matchedUnitContainer = (this.matchContainer & 1) != 0;
        if (matchedUnitContainer && (imports = unit.imports) != null) {
            i = 0;
            int l = imports.length;
            while (i < l) {
                importRef = imports[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(importRef);
                if (level != null) {
                    this.patternLocator.matchReportImportRef(importRef, null, this.createImportHandle(importRef), level, this);
                }
                ++i;
            }
        }
        if ((types = unit.types) != null) {
            i = 0;
            int l = types.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
                ++i;
            }
        }
    }

    protected void reportMatching(FieldDeclaration field, TypeDeclaration type, IJavaElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block12: {
            ASTNode[] nodes;
            IJavaElement enclosingElement;
            block13: {
                int end;
                enclosingElement = null;
                if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, type, parent))) {
                    int offset = field.sourceStart;
                    SearchMatch match = this.newDeclarationMatch(enclosingElement, accuracy, offset, field.sourceEnd - offset + 1);
                    this.report(match);
                }
                if ((field.bits & 2) != 0) {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, nodeSet);
                    try {
                        field.traverse((ASTVisitor)localDeclarationVisitor, null);
                    }
                    catch (WrappedCoreException e) {
                        throw e.coreException;
                    }
                }
                if (field.annotations != null) {
                    int i = 0;
                    int al = field.annotations.length;
                    while (i < al) {
                        TypeReference typeRef = field.annotations[i].type;
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(typeRef);
                        if (level != null) {
                            if (enclosingElement == null) {
                                enclosingElement = this.createHandle(field, type, parent);
                            }
                            this.patternLocator.matchReportReference(typeRef, enclosingElement, level, this);
                        }
                        ++i;
                    }
                }
                if (!typeInHierarchy || (nodes = nodeSet.matchingNodes(field.declarationSourceStart, end = field.endPart2Position == 0 ? field.declarationSourceEnd : field.endPart2Position)) == null) break block12;
                if ((this.matchContainer & 8) != 0) break block13;
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
                break block12;
            }
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(field, type, parent);
            }
            if (!this.encloses(enclosingElement)) break block12;
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                ASTNode node = nodes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IJavaElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        ASTNode[] nodes;
        Integer level;
        Integer level2;
        boolean matchedClassContainer;
        IJavaElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.name));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.name));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? parent : member.getType(new String(type.name), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        if (accuracy > -1 && this.encloses(enclosingElement)) {
            int offset = type.sourceStart;
            SearchMatch match = this.patternLocator.newDeclarationMatch(type, enclosingElement, accuracy, type.sourceEnd - offset + 1, this);
            this.report(match);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (type.typeParameters != null) {
            int i = 0;
            int l = type.typeParameters.length;
            while (i < l) {
                TypeParameter typeParameter = type.typeParameters[i];
                if (typeParameter != null) {
                    if (typeParameter.type != null && (level2 = (Integer)nodeSet.matchingNodes.removeKey(typeParameter.type)) != null && matchedClassContainer) {
                        this.patternLocator.matchReportReference(typeParameter.type, enclosingElement, level2, this);
                    }
                    if (typeParameter.bounds != null) {
                        int j = 0;
                        int b = typeParameter.bounds.length;
                        while (j < b) {
                            level = (Integer)nodeSet.matchingNodes.removeKey(typeParameter.bounds[j]);
                            if (level != null && matchedClassContainer) {
                                this.patternLocator.matchReportReference(typeParameter.bounds[j], enclosingElement, level, this);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (type.annotations != null) {
            int i = 0;
            int al = type.annotations.length;
            while (i < al) {
                TypeReference typeRef = type.annotations[i].type;
                level2 = (Integer)nodeSet.matchingNodes.removeKey(typeRef);
                if (level2 != null && matchedClassContainer) {
                    this.patternLocator.matchReportReference(typeRef, enclosingElement, level2, this);
                }
                ++i;
            }
        }
        if (type.javadoc != null && (nodes = nodeSet.matchingNodes(type.declarationSourceStart, type.sourceStart)) != null) {
            int i;
            if (!matchedClassContainer) {
                i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level3 = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (this.encloses(enclosingElement)) {
                        this.patternLocator.matchReportReference(node, enclosingElement, level3, this);
                    }
                    ++i;
                }
            }
        }
        if ((type.bits & 0x200) != 0) {
            Integer level4;
            TypeReference superType = type.allocation.type;
            if (superType != null && (level4 = (Integer)nodeSet.matchingNodes.removeKey(superType)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superType, enclosingElement, level4, this);
            }
        } else {
            TypeReference[] superInterfaces;
            TypeReference superClass = type.superclass;
            if (superClass != null) {
                this.reportMatchingSuper(superClass, enclosingElement, nodeSet, matchedClassContainer);
            }
            if ((superInterfaces = type.superInterfaces) != null) {
                int i = 0;
                int l = superInterfaces.length;
                while (i < l) {
                    this.reportMatchingSuper(superInterfaces[i], enclosingElement, nodeSet, matchedClassContainer);
                    ++i;
                }
            }
        }
        boolean typeInHierarchy = type.binding == null || this.typeInHierarchy(type.binding);
        matchedClassContainer = matchedClassContainer && typeInHierarchy;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = fields.length;
            while (i < l) {
                FieldDeclaration field = fields[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(field);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(field, type, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = methods.length;
            while (i < l) {
                AbstractMethodDeclaration method = methods[i];
                Integer level5 = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level5 != null && matchedClassContainer ? level5 : -1;
                this.reportMatching(method, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i];
                Integer level6 = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level6 != null && matchedClassContainer ? level6 : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
                ++i;
            }
        }
    }

    protected void reportMatchingSuper(TypeReference superReference, IJavaElement enclosingElement, MatchingNodeSet nodeSet, boolean matchedClassContainer) throws CoreException {
        TypeReference[] typeArguments;
        ASTNode[] nodes = null;
        if (superReference instanceof ParameterizedSingleTypeReference) {
            typeArguments = ((ParameterizedSingleTypeReference)superReference).typeArguments;
            if (typeArguments != null && typeArguments.length > 0) {
                nodes = nodeSet.matchingNodes(superReference.sourceStart, typeArguments[typeArguments.length - 1].sourceEnd);
            }
        } else if (superReference instanceof ParameterizedQualifiedTypeReference && (typeArguments = ((ParameterizedQualifiedTypeReference)superReference).typeArguments) != null && typeArguments.length > 0) {
            TypeReference lastTypeArgs = typeArguments[typeArguments.length - 1];
            int end = superReference.sourceEnd;
            if (lastTypeArgs != null && ((TypeReference)lastTypeArgs).length > 0 && lastTypeArgs[((TypeReference)lastTypeArgs).length - 1].sourceEnd > end) {
                end = lastTypeArgs[((TypeReference)lastTypeArgs).length - 1].sourceEnd;
            }
            nodes = nodeSet.matchingNodes(superReference.sourceStart, end);
        }
        if (nodes != null) {
            if ((this.matchContainer & 2) == 0) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else if (this.encloses(enclosingElement)) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    this.patternLocator.matchReportReference(node, enclosingElement, level, this);
                    ++i;
                }
            }
        } else {
            Integer level = (Integer)nodeSet.matchingNodes.removeKey(superReference);
            if (level != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superReference, enclosingElement, level, this);
            }
        }
    }

    protected boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int i = 0;
            int length = this.allSuperTypeNames.length;
            while (i < length) {
                if (CharOperation.equals(compoundName, this.allSuperTypeNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IJavaElement enclosingElement;
        MatchingNodeSet nodeSet;
        HashtableOfIntValues occurrencesCounts = new HashtableOfIntValues();

        public LocalDeclarationVisitor(IJavaElement enclosingElement, MatchingNodeSet nodeSet) {
            this.enclosingElement = enclosingElement;
            this.nodeSet = nodeSet;
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope unused) {
            try {
                char[] simpleName = (typeDeclaration.bits & 0x200) != 0 ? CharOperation.NO_CHAR : typeDeclaration.name;
                int occurrenceCount = this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == Integer.MIN_VALUE ? 1 : ++occurrenceCount;
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                if (typeDeclaration.allocation == null || typeDeclaration.allocation.enumConstant == null) {
                    if ((typeDeclaration.bits & 0x200) != 0) {
                        MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, -1, this.nodeSet, occurrenceCount);
                    } else {
                        Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                        MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, level != null ? level : -1, this.nodeSet, occurrenceCount);
                    }
                } else {
                    Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                    if (level != null) {
                        FieldDeclaration enumConstant = typeDeclaration.allocation.enumConstant;
                        int offset = enumConstant.sourceStart;
                        SearchMatch match = MatchLocator.this.newDeclarationMatch(this.enclosingElement, level, offset, enumConstant.sourceEnd - offset + 1);
                        MatchLocator.this.report(match);
                    }
                }
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }

    public static class WorkingCopyDocument
    extends JavaSearchDocument {
        public org.aspectj.org.eclipse.jdt.core.ICompilationUnit workingCopy;

        WorkingCopyDocument(org.aspectj.org.eclipse.jdt.core.ICompilationUnit workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }

    public class WrappedCoreException
    extends RuntimeException {
        private static final long serialVersionUID = 8354329870126121212L;
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

