/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class Member
implements Comparable,
AnnotatedElement {
    private final Kind kind;
    private final TypeX declaringType;
    protected final int modifiers;
    private final TypeX returnType;
    private final String name;
    private final TypeX[] parameterTypes;
    private final String signature;
    private String paramSignature;
    private static final String[] ZERO_STRINGS = new String[0];
    private volatile int hashCode = 0;
    public static final Member[] NONE = new Member[0];
    public static final Kind METHOD = new Kind("METHOD", 1);
    public static final Kind FIELD = new Kind("FIELD", 2);
    public static final Kind CONSTRUCTOR = new Kind("CONSTRUCTOR", 3);
    public static final Kind STATIC_INITIALIZATION = new Kind("STATIC_INITIALIZATION", 4);
    public static final Kind POINTCUT = new Kind("POINTCUT", 5);
    public static final Kind ADVICE = new Kind("ADVICE", 6);
    public static final Kind HANDLER = new Kind("HANDLER", 7);

    public Member(Kind kind, TypeX declaringType, int modifiers, String name, String signature) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.name = name;
        this.signature = signature;
        if (kind == FIELD) {
            this.returnType = TypeX.forSignature(signature);
            this.parameterTypes = TypeX.NONE;
        } else {
            Object[] returnAndParams = Member.signatureToTypes(signature);
            this.returnType = (TypeX)returnAndParams[0];
            this.parameterTypes = (TypeX[])returnAndParams[1];
        }
    }

    public Member(Kind kind, TypeX declaringType, int modifiers, TypeX returnType, String name, TypeX[] parameterTypes) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.signature = kind == FIELD ? returnType.getSignature() : Member.typesToSignature(returnType, parameterTypes);
    }

    public ResolvedMember resolve(World world) {
        return world.resolve(this);
    }

    public static String typesToSignature(TypeX returnType, TypeX[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        buf.append(returnType.getSignature());
        return buf.toString();
    }

    public static String typesToSignature(TypeX[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        return buf.toString();
    }

    private static Object[] signatureToTypes(String sig) {
        char c;
        ArrayList<TypeX> l = new ArrayList<TypeX>();
        int i = 1;
        while ((c = sig.charAt(i)) != ')') {
            int start = i;
            while (c == '[') {
                c = sig.charAt(++i);
            }
            if (c == 'L') {
                i = sig.indexOf(59, start) + 1;
                l.add(TypeX.forSignature(sig.substring(start, i)));
                continue;
            }
            l.add(TypeX.forSignature(sig.substring(start, ++i)));
        }
        TypeX[] paramTypes = l.toArray(new TypeX[l.size()]);
        TypeX returnType = TypeX.forSignature(sig.substring(i + 1, sig.length()));
        return new Object[]{returnType, paramTypes};
    }

    public static Member field(String declaring, int mods, String name, String signature) {
        return Member.field(declaring, mods, TypeX.forSignature(signature), name);
    }

    public static Member field(TypeX declaring, int mods, String name, TypeX type) {
        return new Member(FIELD, declaring, mods, type, name, TypeX.NONE);
    }

    public static Member method(TypeX declaring, int mods, String name, String signature) {
        Object[] pair = Member.signatureToTypes(signature);
        return Member.method(declaring, mods, (TypeX)pair[0], name, (TypeX[])pair[1]);
    }

    public static Member pointcut(TypeX declaring, String name, String signature) {
        Object[] pair = Member.signatureToTypes(signature);
        return Member.pointcut(declaring, 0, (TypeX)pair[0], name, (TypeX[])pair[1]);
    }

    private static Member field(String declaring, int mods, TypeX ty, String name) {
        return new Member(FIELD, TypeX.forName(declaring), mods, ty, name, TypeX.NONE);
    }

    public static Member method(TypeX declTy, int mods, TypeX rTy, String name, TypeX[] paramTys) {
        return new Member(name.equals("<init>") ? CONSTRUCTOR : METHOD, declTy, mods, rTy, name, paramTys);
    }

    private static Member pointcut(TypeX declTy, int mods, TypeX rTy, String name, TypeX[] paramTys) {
        return new Member(POINTCUT, declTy, mods, rTy, name, paramTys);
    }

    public static ResolvedMember makeExceptionHandlerSignature(TypeX inType, TypeX catchType) {
        return new ResolvedMember(HANDLER, inType, 8, "<catch>", "(" + catchType.getSignature() + ")V");
    }

    public static Member fieldFromString(String str) {
        str = str.trim();
        int len = str.length();
        int i = 0;
        int mods = 0;
        if (str.startsWith("static", i)) {
            mods = 8;
            i += 6;
            while (Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
        }
        int start = i;
        while (!Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        TypeX retTy = TypeX.forName(str.substring(start, i));
        start = i;
        i = str.lastIndexOf(46);
        TypeX declaringTy = TypeX.forName(str.substring(start, i).trim());
        start = ++i;
        String name = str.substring(start, len).trim();
        return new Member(FIELD, declaringTy, mods, retTy, name, TypeX.NONE);
    }

    public static Member methodFromString(String str) {
        str = str.trim();
        int i = 0;
        int mods = 0;
        if (str.startsWith("static", i)) {
            mods = 8;
            i += 6;
        } else if (str.startsWith("interface", i)) {
            mods = 512;
            i += 9;
        } else if (str.startsWith("private", i)) {
            mods = 2;
            i += 7;
        }
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        int start = i;
        while (!Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        TypeX returnTy = TypeX.forName(str.substring(start, i));
        start = i;
        i = str.indexOf(40, i);
        i = str.lastIndexOf(46, i);
        TypeX declaringTy = TypeX.forName(str.substring(start, i).trim());
        start = ++i;
        i = str.indexOf(40, i);
        String name = str.substring(start, i).trim();
        start = ++i;
        i = str.indexOf(41, i);
        String[] paramTypeNames = Member.parseIds(str.substring(start, i).trim());
        return Member.method(declaringTy, mods, returnTy, name, TypeX.forNames(paramTypeNames));
    }

    private static String[] parseIds(String str) {
        if (str.length() == 0) {
            return ZERO_STRINGS;
        }
        ArrayList<String> l = new ArrayList<String>();
        int start = 0;
        while (true) {
            int i;
            if ((i = str.indexOf(44, start)) == -1) break;
            l.add(str.substring(start, i).trim());
            start = i + 1;
        }
        l.add(str.substring(start).trim());
        return l.toArray(new String[l.size()]);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Member)) {
            return false;
        }
        Member o = (Member)other;
        return this.kind == o.kind && this.name.equals(o.name) && this.signature.equals(o.signature) && this.declaringType.equals(o.declaringType);
    }

    public int compareTo(Object other) {
        Member o = (Member)other;
        int i = this.getName().compareTo(o.getName());
        if (i != 0) {
            return i;
        }
        return this.getSignature().compareTo(o.getSignature());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.kind.hashCode();
            result = 37 * result + this.name.hashCode();
            result = 37 * result + this.signature.hashCode();
            this.hashCode = result = 37 * result + this.declaringType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnType);
        buf.append(' ');
        buf.append(this.declaringType);
        buf.append('.');
        buf.append(this.name);
        if (this.kind != FIELD) {
            buf.append("(");
            if (this.parameterTypes.length != 0) {
                buf.append(this.parameterTypes[0]);
                int len = this.parameterTypes.length;
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    buf.append(this.parameterTypes[i]);
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String toLongString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.kind);
        buf.append(' ');
        if (this.modifiers != 0) {
            buf.append(Modifier.toString(this.modifiers));
            buf.append(' ');
        }
        buf.append(this.toString());
        buf.append(" <");
        buf.append(this.signature);
        buf.append(" >");
        return buf.toString();
    }

    public Kind getKind() {
        return this.kind;
    }

    public TypeX getDeclaringType() {
        return this.declaringType;
    }

    public TypeX getReturnType() {
        return this.returnType;
    }

    public TypeX getType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public TypeX[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public String getParameterSignature() {
        if (this.paramSignature != null) {
            return this.paramSignature;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            TypeX tx = this.parameterTypes[i];
            sb.append(tx.getSignature());
        }
        sb.append(")");
        this.paramSignature = sb.toString();
        return this.paramSignature;
    }

    public boolean isCompatibleWith(Member am) {
        if (this.kind != METHOD || am.getKind() != METHOD) {
            return true;
        }
        if (!this.name.equals(am.getName())) {
            return true;
        }
        if (!Member.equalTypes(this.getParameterTypes(), am.getParameterTypes())) {
            return true;
        }
        return this.getReturnType().equals(am.getReturnType());
    }

    private static boolean equalTypes(TypeX[] a, TypeX[] b) {
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public int getModifiers(World world) {
        return world.getModifiers(this);
    }

    public TypeX[] getExceptions(World world) {
        return world.getExceptions(this);
    }

    public final boolean isProtected(World world) {
        return Modifier.isProtected(world.getModifiers(this));
    }

    public final boolean isStatic(World world) {
        return Modifier.isStatic(world.getModifiers(this));
    }

    public final boolean isStrict(World world) {
        return Modifier.isStrict(world.getModifiers(this));
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public final int getCallsiteModifiers() {
        return this.modifiers & 0xFFFFFDFF;
    }

    public final String getExtractableName() {
        if (this.name.equals("<init>")) {
            return "init$";
        }
        if (this.name.equals("<clinit>")) {
            return "clinit$";
        }
        return this.name;
    }

    public boolean hasAnnotation(TypeX ofType) {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    public AnnotationX[] getAnnotations() {
        throw new UnsupportedOperationException("You should resolve this member and call getAnnotations() on the result...");
    }

    public Collection getDeclaringTypes(World world) {
        ResolvedTypeX myType = this.getDeclaringType().resolve(world);
        HashSet<ResolvedTypeX> ret = new HashSet<ResolvedTypeX>();
        if (this.kind == CONSTRUCTOR) {
            ret.add(myType);
        } else if (this.isStatic() || this.kind == FIELD) {
            this.walkUpStatic(ret, myType);
        } else {
            this.walkUp(ret, myType);
        }
        return ret;
    }

    private boolean walkUp(Collection acc, ResolvedTypeX curr) {
        if (acc.contains(curr)) {
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUp(acc, (ResolvedTypeX)i.next());
        }
        if (!b) {
            boolean bl = b = curr.lookupMemberNoSupers(this) != null;
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    private boolean walkUpStatic(Collection acc, ResolvedTypeX curr) {
        if (curr.lookupMemberNoSupers(this) != null) {
            acc.add(curr);
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUpStatic(acc, (ResolvedTypeX)i.next());
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    public String getSignatureMakerName() {
        if (this.getName().equals("<clinit>")) {
            return "makeInitializerSig";
        }
        Kind kind = this.getKind();
        if (kind == METHOD) {
            return "makeMethodSig";
        }
        if (kind == CONSTRUCTOR) {
            return "makeConstructorSig";
        }
        if (kind == FIELD) {
            return "makeFieldSig";
        }
        if (kind == HANDLER) {
            return "makeCatchClauseSig";
        }
        if (kind == STATIC_INITIALIZATION) {
            return "makeInitializerSig";
        }
        if (kind == ADVICE) {
            return "makeAdviceSig";
        }
        throw new RuntimeException("unimplemented");
    }

    public String getSignatureType() {
        Kind kind = this.getKind();
        if (this.getName().equals("<clinit>")) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == METHOD) {
            return "org.aspectj.lang.reflect.MethodSignature";
        }
        if (kind == CONSTRUCTOR) {
            return "org.aspectj.lang.reflect.ConstructorSignature";
        }
        if (kind == FIELD) {
            return "org.aspectj.lang.reflect.FieldSignature";
        }
        if (kind == HANDLER) {
            return "org.aspectj.lang.reflect.CatchClauseSignature";
        }
        if (kind == STATIC_INITIALIZATION) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == ADVICE) {
            return "org.aspectj.lang.reflect.AdviceSignature";
        }
        throw new RuntimeException("unimplemented");
    }

    public String getSignatureString(World world) {
        if (this.getName().equals("<clinit>")) {
            return this.getStaticInitializationSignatureString(world);
        }
        Kind kind = this.getKind();
        if (kind == METHOD) {
            return this.getMethodSignatureString(world);
        }
        if (kind == CONSTRUCTOR) {
            return this.getConstructorSignatureString(world);
        }
        if (kind == FIELD) {
            return this.getFieldSignatureString(world);
        }
        if (kind == HANDLER) {
            return this.getHandlerSignatureString(world);
        }
        if (kind == STATIC_INITIALIZATION) {
            return this.getStaticInitializationSignatureString(world);
        }
        if (kind == ADVICE) {
            return this.getAdviceSignatureString(world);
        }
        throw new RuntimeException("unimplemented");
    }

    private String getHandlerSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(0));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()[0]));
        buf.append('-');
        String pName = "<missing>";
        String[] names = this.getParameterNames(world);
        if (names != null) {
            pName = names[0];
        }
        buf.append(pName);
        buf.append('-');
        return buf.toString();
    }

    private String getStaticInitializationSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getAdviceSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getMethodSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getConstructorSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        return buf.toString();
    }

    protected String getFieldSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String makeString(int i) {
        return Integer.toString(i, 16);
    }

    protected String makeString(TypeX t) {
        if (t.isArray()) {
            return t.getSignature().replace('/', '.');
        }
        return t.getName();
    }

    protected String makeString(TypeX[] types) {
        if (types == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            buf.append(this.makeString(types[i]));
            buf.append(':');
        }
        return buf.toString();
    }

    protected String makeString(String[] names) {
        if (names == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            buf.append(names[i]);
            buf.append(':');
        }
        return buf.toString();
    }

    public String[] getParameterNames(World world) {
        return world.getParameterNames(this);
    }

    public static class Kind
    extends TypeSafeEnum {
        public Kind(String name, int key) {
            super(name, key);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return METHOD;
                }
                case 2: {
                    return FIELD;
                }
                case 3: {
                    return CONSTRUCTOR;
                }
                case 4: {
                    return STATIC_INITIALIZATION;
                }
                case 5: {
                    return POINTCUT;
                }
                case 6: {
                    return ADVICE;
                }
                case 7: {
                    return HANDLER;
                }
            }
            throw new BCException("weird kind " + key);
        }
    }
}

