/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.preference;

import java.util.List;
import org.eclipse.contribution.xref.core.XReferenceProviderDefinition;
import org.eclipse.contribution.xref.core.XReferenceProviderManager;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class XReferencePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text descriptionText;
    private CheckboxTableViewer checkboxViewer;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(768));
        mainComposite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        mainComposite.setLayout((Layout)layout);
        Label topLabel = new Label(mainComposite, 0);
        topLabel.setText(XReferenceUIPlugin.getResourceString("XReferencePreferencePage.explanation"));
        topLabel.setFont(font);
        this.createProvidersArea(mainComposite);
        this.createDescriptionArea(mainComposite);
        this.populateProviders();
        return mainComposite;
    }

    private void createDescriptionArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite textComposite = new Composite(mainComposite, 0);
        textComposite.setLayoutData((Object)new GridData(1808));
        GridLayout textLayout = new GridLayout();
        textLayout.marginWidth = 0;
        textLayout.marginHeight = 0;
        textComposite.setLayout((Layout)textLayout);
        textComposite.setFont(mainFont);
        Label descriptionLabel = new Label(textComposite, 0);
        descriptionLabel.setText(XReferenceUIPlugin.getResourceString("XReferencePreferencePage.description"));
        descriptionLabel.setFont(mainFont);
        this.descriptionText = new Text(textComposite, 2378);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setFont(mainFont);
    }

    private void createProvidersArea(Composite mainComposite) {
        Font mainFont = mainComposite.getFont();
        Composite providersComposite = new Composite(mainComposite, 0);
        providersComposite.setLayoutData((Object)new GridData(1808));
        GridLayout providersLayout = new GridLayout();
        providersLayout.marginWidth = 0;
        providersLayout.marginHeight = 0;
        providersComposite.setLayout((Layout)providersLayout);
        providersComposite.setFont(mainFont);
        Label providersLabel = new Label(providersComposite, 0);
        providersLabel.setText(XReferenceUIPlugin.getResourceString("XReferencePreferencePage.providersLabel"));
        providersLabel.setFont(mainFont);
        this.checkboxViewer = CheckboxTableViewer.newCheckList((Composite)providersComposite, (int)2180);
        this.checkboxViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.checkboxViewer.getTable().setFont(providersComposite.getFont());
        this.checkboxViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((XReferenceProviderDefinition)element).getLabel();
            }
        });
        this.checkboxViewer.getTable().setFont(mainFont);
        this.checkboxViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.checkboxViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    XReferenceProviderDefinition definition = (XReferenceProviderDefinition)sel.getFirstElement();
                    if (definition == null) {
                        XReferencePreferencePage.this.clearDescription();
                    } else {
                        XReferencePreferencePage.this.showDescription(definition);
                    }
                }
            }
        });
        this.checkboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                XReferencePreferencePage.this.checkboxViewer.setSelection((ISelection)new StructuredSelection(event.getElement()));
            }
        });
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        XReferenceProviderManager manager = XReferenceProviderManager.getManager();
        List providers = manager.getRegisteredProviders();
        int i = 0;
        while (i < providers.size()) {
            XReferenceProviderDefinition definition = (XReferenceProviderDefinition)providers.get(i);
            this.checkboxViewer.setChecked((Object)definition, definition.getDefaultEnablementValue());
            ++i;
        }
    }

    public boolean performOk() {
        if (super.performOk()) {
            List providers = this.getAllRegisteredProviders();
            int i = 0;
            while (i < providers.size()) {
                XReferenceProviderDefinition definition = (XReferenceProviderDefinition)providers.get(i);
                boolean checked = this.checkboxViewer.getChecked((Object)definition);
                definition.setEnabled(checked);
                ++i;
            }
            this.reset();
            return true;
        }
        return false;
    }

    private void populateProviders() {
        List providers = this.getAllRegisteredProviders();
        this.checkboxViewer.setInput((Object)providers.toArray());
        int i = 0;
        while (i < providers.size()) {
            XReferenceProviderDefinition definition = (XReferenceProviderDefinition)providers.get(i);
            this.checkboxViewer.setChecked((Object)definition, definition.isEnabled());
            ++i;
        }
    }

    private List getAllRegisteredProviders() {
        XReferenceProviderManager manager = XReferenceProviderManager.getManager();
        return manager.getRegisteredProviders();
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    private void showDescription(XReferenceProviderDefinition definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = definition.getDescription();
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(XReferenceUIPlugin.getResourceString("PreferencePage.noDescription"));
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void reset() {
        IPreferenceStore store = XReferenceUIPlugin.getDefault().getPreferenceStore();
        if (store.needsSaving()) {
            XReferenceUIPlugin.getDefault().savePluginPreferences();
        }
    }
}

