/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class EclipseAdapterUtils {
    public static String makeLocationContext(ICompilationUnit compilationUnit, IProblem problem) {
        int i;
        char c;
        int endPosition;
        int startPosition = problem.getSourceStart();
        if (startPosition > (endPosition = problem.getSourceEnd()) || startPosition <= 0 && endPosition <= 0 || compilationUnit == null) {
            return "(no source information available)";
        }
        int SPACE = 32;
        int MARK = 94;
        int TAB = 9;
        char[] source = compilationUnit.getContents();
        int begin = startPosition >= source.length ? source.length - 1 : startPosition;
        int relativeStart = 0;
        int end = endPosition >= source.length ? source.length - 1 : endPosition;
        int relativeEnd = 0;
        relativeStart = 0;
        while (begin != 0 && source[begin - 1] != '\n' && source[begin - 1] != '\r') {
            --begin;
            ++relativeStart;
        }
        relativeEnd = 0;
        while (end + 1 < source.length && source[end + 1] != '\r' && source[end + 1] != '\n') {
            ++end;
            ++relativeEnd;
        }
        char[] extract = new char[end - begin + 1];
        System.arraycopy(source, begin, extract, 0, extract.length);
        int trimLeftIndex = 0;
        while (((c = extract[trimLeftIndex++]) == '\t' || c == ' ') && trimLeftIndex < extract.length) {
        }
        if (trimLeftIndex >= extract.length) {
            return new String(extract) + "\n";
        }
        char[] cArray = extract;
        extract = new char[extract.length - trimLeftIndex + 1];
        System.arraycopy(cArray, trimLeftIndex - 1, extract, 0, extract.length);
        relativeStart -= trimLeftIndex;
        int pos = 0;
        char[] underneath = new char[extract.length];
        for (i = 0; i <= relativeStart; ++i) {
            underneath[pos++] = extract[i] == '\t' ? 9 : 32;
        }
        for (i = startPosition + trimLeftIndex; i <= (endPosition >= source.length ? source.length - 1 : endPosition); ++i) {
            underneath[pos++] = 94;
        }
        char[] cArray2 = underneath;
        underneath = new char[pos];
        System.arraycopy(cArray2, 0, underneath, 0, pos);
        return new String(extract) + "\n" + new String(underneath);
    }

    public static ISourceLocation makeSourceLocation(ICompilationUnit unit, IProblem problem) {
        int line = problem.getSourceLineNumber();
        File file = new File(new String(problem.getOriginatingFileName()));
        String context = EclipseAdapterUtils.makeLocationContext(unit, problem);
        return new SourceLocation(file, line, line, 0, context);
    }

    public static IMessage makeMessage(ICompilationUnit unit, IProblem problem) {
        ISourceLocation sourceLocation = EclipseAdapterUtils.makeSourceLocation(unit, problem);
        IProblem[] seeAlso = problem.seeAlso();
        ISourceLocation[] seeAlsoLocations = new ISourceLocation[seeAlso.length];
        for (int i = 0; i < seeAlso.length; ++i) {
            seeAlsoLocations[i] = new SourceLocation(new File(new String(seeAlso[i].getOriginatingFileName())), seeAlso[i].getSourceLineNumber());
        }
        String extraDetails = problem.getSupplementaryMessageInfo();
        boolean declared = false;
        if (extraDetails != null && extraDetails.endsWith("[deow=true]")) {
            declared = true;
            extraDetails = extraDetails.substring(0, extraDetails.length() - "[deow=true]".length());
        }
        IMessage.Kind kind = problem.getID() == 536871362 ? IMessage.TASKTAG : (problem.isError() ? IMessage.ERROR : IMessage.WARNING);
        Message msg = new Message(problem.getMessage(), extraDetails, kind, sourceLocation, null, seeAlsoLocations, declared, problem.getID(), problem.getSourceStart(), problem.getSourceEnd());
        return msg;
    }

    public static IMessage makeErrorMessage(ICompilationUnit unit, String text, Exception ex) {
        SourceLocation loc = new SourceLocation(new File(new String(unit.getFileName())), 0, 0, 0, "");
        Message msg = new Message(text, IMessage.ERROR, (Throwable)ex, (ISourceLocation)loc);
        return msg;
    }

    public static IMessage makeErrorMessage(String srcFile, String text, Exception ex) {
        SourceLocation loc = new SourceLocation(new File(srcFile), 0, 0, 0, "");
        Message msg = new Message(text, IMessage.ERROR, (Throwable)ex, (ISourceLocation)loc);
        return msg;
    }

    private EclipseAdapterUtils() {
    }
}

