/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.TypePattern;

public class MethodDelegateTypeMunger
extends ResolvedTypeMunger {
    private final ResolvedMember aspectFieldDelegate;
    private final TypePattern typePattern;

    public MethodDelegateTypeMunger(ResolvedMember signature, ResolvedType aspect, String fieldName, TypePattern typePattern) {
        super(ResolvedTypeMunger.MethodDelegate, signature);
        this.typePattern = typePattern;
        ResolvedMember[] fields = aspect.getDeclaredFields();
        ResolvedMember field = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!fieldName.equals(fields[i].getName())) continue;
            field = fields[i];
            break;
        }
        if (field == null) {
            throw new RuntimeException("Should not happen: aspect field not found for @DeclareParents delegate");
        }
        this.aspectFieldDelegate = field;
    }

    private MethodDelegateTypeMunger(ResolvedMember signature, ResolvedMember fieldDelegate, TypePattern typePattern) {
        super(ResolvedTypeMunger.MethodDelegate, signature);
        this.aspectFieldDelegate = fieldDelegate;
        this.typePattern = typePattern;
    }

    public ResolvedMember getDelegate() {
        return this.aspectFieldDelegate;
    }

    public void write(DataOutputStream s) throws IOException {
        this.kind.write(s);
        this.signature.write(s);
        this.aspectFieldDelegate.write(s);
        this.typePattern.write(s);
    }

    public static ResolvedTypeMunger readMethod(VersionedDataInputStream s, ISourceContext context) throws IOException {
        ResolvedMemberImpl signature = ResolvedMemberImpl.readResolvedMember(s, context);
        ResolvedMemberImpl field = ResolvedMemberImpl.readResolvedMember(s, context);
        TypePattern tp = TypePattern.read(s, context);
        return new MethodDelegateTypeMunger(signature, field, tp);
    }

    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        if (matchType.isEnum() || matchType.isInterface() || matchType.isAnnotation()) {
            return false;
        }
        return this.typePattern.matchesStatically(matchType);
    }

    public boolean changesPublicSignature() {
        return true;
    }
}

