/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.bcel.Tag;

public final class LocalVariableTag
extends Tag {
    private final UnresolvedType type;
    private final String name;
    private int slot;
    private final int startPos;
    boolean remapped = false;
    private volatile int hashCode = 0;

    public LocalVariableTag(UnresolvedType type, String name, int slot, int startPosition) {
        this.type = type;
        this.name = name;
        this.slot = slot;
        this.startPos = startPosition;
    }

    public String getName() {
        return this.name;
    }

    public int getSlot() {
        return this.slot;
    }

    public UnresolvedType getType() {
        return this.type;
    }

    public void updateSlot(int newSlot) {
        this.slot = newSlot;
        this.remapped = true;
    }

    public boolean isRemapped() {
        return this.remapped;
    }

    public String toString() {
        return "local " + this.slot + ": " + this.type + " " + this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LocalVariableTag)) {
            return false;
        }
        LocalVariableTag o = (LocalVariableTag)other;
        return o.type.equals(this.type) && o.name.equals(this.name) && o.slot == this.slot && o.startPos == this.startPos;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int ret = 17;
            ret = 37 * ret + this.type.hashCode();
            ret = 37 * ret + this.name.hashCode();
            ret = 37 * ret + this.slot;
            this.hashCode = ret = 37 * ret + this.startPos;
        }
        return this.hashCode;
    }
}

