/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.util.ClassLoaderRepository;
import org.aspectj.apache.bcel.util.Repository;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.reflect.AnnotationFinder;

public class Java15AnnotationFinder
implements AnnotationFinder {
    private Repository bcelRepository;
    private ClassLoader classLoader;
    private World world;

    public void setClassLoader(ClassLoader aLoader) {
        this.bcelRepository = new ClassLoaderRepository(aLoader);
        this.classLoader = aLoader;
    }

    public void setWorld(World aWorld) {
        this.world = aWorld;
    }

    public Object getAnnotation(ResolvedType annotationType, Object onObject) {
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.classLoader);
            if (onObject.getClass().isAnnotationPresent(annotationClass)) {
                return onObject.getClass().getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Object getAnnotationFromClass(ResolvedType annotationType, Class aClass) {
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.classLoader);
            if (aClass.isAnnotationPresent(annotationClass)) {
                return aClass.getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public Object getAnnotationFromMember(ResolvedType annotationType, Member aMember) {
        if (!(aMember instanceof AccessibleObject)) {
            return null;
        }
        AccessibleObject ao = (AccessibleObject)((Object)aMember);
        try {
            Class<?> annotationClass = Class.forName(annotationType.getName(), false, this.classLoader);
            if (ao.isAnnotationPresent(annotationClass)) {
                return ao.getAnnotation(annotationClass);
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        return null;
    }

    public Set getAnnotations(Member onMember) {
        if (!(onMember instanceof AccessibleObject)) {
            return Collections.EMPTY_SET;
        }
        try {
            JavaClass jc = this.bcelRepository.loadClass(onMember.getDeclaringClass());
            Annotation[] anns = new Annotation[]{};
            if (onMember instanceof java.lang.reflect.Method) {
                Method bcelMethod = jc.getMethod((java.lang.reflect.Method)onMember);
                anns = bcelMethod.getAnnotations();
            } else if (onMember instanceof Constructor) {
                Method bcelCons = jc.getMethod((Constructor)onMember);
                anns = bcelCons.getAnnotations();
            } else if (onMember instanceof java.lang.reflect.Field) {
                Field bcelField = jc.getField((java.lang.reflect.Field)onMember);
                anns = bcelField.getAnnotations();
            }
            this.bcelRepository.clear();
            if (anns == null) {
                anns = new Annotation[]{};
            }
            HashSet<ResolvedType> annSet = new HashSet<ResolvedType>();
            for (int i = 0; i < anns.length; ++i) {
                annSet.add(UnresolvedType.forName(anns[i].getTypeName()).resolve(this.world));
            }
            return annSet;
        }
        catch (ClassNotFoundException cnfEx) {
            AccessibleObject ao = (AccessibleObject)((Object)onMember);
            java.lang.annotation.Annotation[] anns = ao.getDeclaredAnnotations();
            HashSet<ResolvedType> annSet = new HashSet<ResolvedType>();
            for (int i = 0; i < anns.length; ++i) {
                annSet.add(UnresolvedType.forName(anns[i].annotationType().getName()).resolve(this.world));
            }
            return annSet;
        }
    }

    public ResolvedType[] getAnnotations(Class forClass, World inWorld) {
        try {
            JavaClass jc = this.bcelRepository.loadClass(forClass);
            Annotation[] anns = jc.getAnnotations();
            this.bcelRepository.clear();
            if (anns == null) {
                return new ResolvedType[0];
            }
            ResolvedType[] ret = new ResolvedType[anns.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = inWorld.resolve(anns[i].getTypeName());
            }
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            java.lang.annotation.Annotation[] classAnnotations = forClass.getAnnotations();
            ResolvedType[] ret = new ResolvedType[classAnnotations.length];
            for (int i = 0; i < classAnnotations.length; ++i) {
                ret[i] = inWorld.resolve(classAnnotations[i].annotationType().getName());
            }
            return ret;
        }
    }
}

