/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.renderers;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.interfaces.IVisualiserRenderer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ClassicVisualiserRenderer
implements IVisualiserRenderer {
    private int spacing = 4;
    private int columnTitleHeight = -1;
    private int margin = 6;
    private Font sysFont;

    public int getSpacing() {
        return this.spacing;
    }

    public int getColumnHeaderHeight() {
        if (this.columnTitleHeight < 0) {
            this.sysFont = Display.getCurrent().getSystemFont();
            Image tmpImg = new Image((Device)Display.getCurrent(), 1, 1);
            GC gc = new GC((Drawable)tmpImg);
            gc.setFont(this.sysFont);
            String s = VisualiserPlugin.getResourceString("Visualiser.testString");
            this.columnTitleHeight = gc.stringExtent((String)s).y * 11 / 10 + 4;
            gc.dispose();
            tmpImg.dispose();
        }
        return this.columnTitleHeight;
    }

    public int getMarginSize() {
        return this.margin;
    }

    public void paintColumnHeader(GC gc, IMember m, int x, int colWidth) {
        int title_y_start = this.getMarginSize();
        int title_y_height = this.getColumnHeaderHeight();
        gc.setBackground(ColorConstants.buttonDarker);
        gc.fillRectangle(x, title_y_start, colWidth, title_y_height);
        String name = this.getConstrainedString(gc, m.getName(), colWidth - 4);
        int xoff = (colWidth - gc.stringExtent((String)name).x) / 2;
        if (this.sysFont == null) {
            this.sysFont = Display.getCurrent().getSystemFont();
        }
        gc.setFont(this.sysFont);
        gc.drawString(name, x + xoff, title_y_start + 4, true);
        gc.setForeground(ColorConstants.white);
        gc.drawLine(x, title_y_start, x, title_y_start + title_y_height);
        gc.drawLine(x, title_y_start, x + colWidth, title_y_start);
        gc.setForeground(ColorConstants.black);
        gc.drawLine(x + colWidth, title_y_start, x + colWidth, title_y_start + title_y_height);
    }

    public void paintColumn(GC gc, IMember m, int x, int yoff, int colWidth, int colHeight, boolean affected) {
        if (affected) {
            gc.setBackground(ColorConstants.white);
        } else {
            gc.setBackground(ColorConstants.buttonDarkest);
        }
        gc.fillRectangle(x, yoff, colWidth, colHeight);
        gc.drawRectangle(x, yoff, colWidth, colHeight);
    }

    protected String getConstrainedString(GC gc, String name, int width) {
        String elip = "...";
        if (width <= gc.stringExtent((String)elip).x) {
            return elip;
        }
        int sw = gc.stringExtent((String)name).x;
        boolean needElipsis = false;
        int targetWidth = width;
        while (sw > targetWidth) {
            if (!needElipsis) {
                needElipsis = true;
                targetWidth -= gc.stringExtent((String)elip).x;
            }
            if ((name = name.substring(0, name.length() - 1)).length() <= 1) {
                return elip;
            }
            sw = gc.stringExtent((String)name).x;
        }
        if (needElipsis) {
            name = String.valueOf(name) + elip;
        }
        return name;
    }
}

