/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.launching.AJClasspathModel;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchConfigurationClasspathUtils {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public static IRuntimeClasspathEntry[] getCurrentClasspath(AJClasspathModel fModel) {
        IRuntimeClasspathEntry entry;
        IClasspathEntry[] boot = fModel.getEntries(0);
        IClasspathEntry[] user = fModel.getEntries(1);
        IClasspathEntry[] aspectPath = fModel.getEntries(2);
        IClasspathEntry[] outJar = fModel.getEntries(3);
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(boot.length + user.length + aspectPath.length);
        int i = 0;
        while (i < boot.length) {
            IClasspathEntry bootEntry = boot[i];
            entry = null;
            if (bootEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)bootEntry).getDelegate();
            } else if (bootEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)boot[i];
            }
            if (entry != null) {
                if (entry.getClasspathProperty() == 3) {
                    entry.setClasspathProperty(2);
                }
                entries.add(entry);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < user.length) {
            IClasspathEntry userEntry = user[i2];
            entry = null;
            if (userEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)userEntry).getDelegate();
            } else if (userEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)user[i2];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < aspectPath.length) {
            IClasspathEntry aspectEntry = aspectPath[i3];
            entry = null;
            if (aspectEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)aspectEntry).getDelegate();
            } else if (aspectEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)aspectPath[i3];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < outJar.length) {
            IClasspathEntry outJarEntry = outJar[i4];
            entry = null;
            if (outJarEntry instanceof ClasspathEntry) {
                entry = ((ClasspathEntry)outJarEntry).getDelegate();
            } else if (outJarEntry instanceof IRuntimeClasspathEntry) {
                entry = (IRuntimeClasspathEntry)aspectPath[i4];
            }
            if (entry != null) {
                entry.setClasspathProperty(3);
                entries.add(entry);
            }
            ++i4;
        }
        return entries.toArray(new IRuntimeClasspathEntry[entries.size()]);
    }

    public static AJClasspathModel createClasspathModel(ILaunchConfiguration configuration) throws CoreException {
        AJClasspathModel fModel = new AJClasspathModel();
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        IRuntimeClasspathEntry[] aspectEntries = null;
        IRuntimeClasspathEntry outJar = null;
        if (projectName != null && !projectName.trim().equals("")) {
            IProject project = AspectJPlugin.getWorkspace().getRoot().getProject(projectName);
            aspectEntries = LaunchConfigurationClasspathUtils.getAspectpath(project);
            outJar = LaunchConfigurationClasspathUtils.getOutJar(project);
        }
        if (aspectEntries != null) {
            int i = 0;
            while (i < aspectEntries.length) {
                fModel.addEntry(2, aspectEntries[i]);
                ++i;
            }
        } else {
            aspectEntries = new IRuntimeClasspathEntry[]{};
        }
        if (outJar != null) {
            fModel.addEntry(3, outJar);
        }
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    boolean isAspectPathEntry = false;
                    boolean isOutJarEntry = false;
                    int j = 0;
                    while (j < aspectEntries.length) {
                        if (aspectEntries[j].equals(entry)) {
                            isAspectPathEntry = true;
                            break;
                        }
                        ++j;
                    }
                    if (outJar != null && outJar.equals(entry)) {
                        isOutJarEntry = true;
                    }
                    if (isAspectPathEntry || isOutJarEntry) break;
                    fModel.addEntry(1, entry);
                    break;
                }
                default: {
                    fModel.addEntry(0, entry);
                }
            }
            ++i;
        }
        return fModel;
    }

    private static IRuntimeClasspathEntry getOutJar(IProject project) {
        String outjar = AspectJCorePreferences.getProjectOutJar((IProject)project);
        if (outjar == null || outjar.equals("")) {
            return null;
        }
        org.eclipse.jdt.internal.core.ClasspathEntry entry = new org.eclipse.jdt.internal.core.ClasspathEntry(2, 1, new Path(String.valueOf(project.getName()) + '/' + outjar).makeAbsolute(), new IPath[0], new IPath[0], null, null, null, false);
        return new RuntimeClasspathEntry((org.eclipse.jdt.core.IClasspathEntry)entry);
    }

    public static IRuntimeClasspathEntry[] getAspectpath(IProject project) {
        ArrayList<RuntimeClasspathEntry> result = new ArrayList<RuntimeClasspathEntry>();
        String[] v = AspectJCorePreferences.getProjectAspectPath((IProject)project);
        if (v == null) {
            return null;
        }
        String paths = v[0];
        String cKinds = v[1];
        String eKinds = v[2];
        if (paths != null && paths.length() > 0 && cKinds != null && cKinds.length() > 0 && eKinds != null && eKinds.length() > 0) {
            StringTokenizer sTokPaths = new StringTokenizer(paths, File.pathSeparator);
            StringTokenizer sTokCKinds = new StringTokenizer(cKinds, File.pathSeparator);
            StringTokenizer sTokEKinds = new StringTokenizer(eKinds, File.pathSeparator);
            if (sTokPaths.countTokens() == sTokCKinds.countTokens() && sTokPaths.countTokens() == sTokEKinds.countTokens()) {
                while (sTokPaths.hasMoreTokens()) {
                    org.eclipse.jdt.internal.core.ClasspathEntry entry = new org.eclipse.jdt.internal.core.ClasspathEntry(Integer.parseInt(sTokCKinds.nextToken()), Integer.parseInt(sTokEKinds.nextToken()), (IPath)new Path(sTokPaths.nextToken()), new IPath[0], new IPath[0], null, null, null, false);
                    result.add(new RuntimeClasspathEntry((org.eclipse.jdt.core.IClasspathEntry)entry));
                }
            }
        }
        if (result.size() > 0) {
            return result.toArray(new IRuntimeClasspathEntry[0]);
        }
        return null;
    }

    public static boolean isDefaultClasspath(IRuntimeClasspathEntry[] classpath, ILaunchConfiguration configuration) {
        try {
            ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            if (classpath.length == entries.length) {
                int i = 0;
                while (i < entries.length) {
                    IRuntimeClasspathEntry entry = entries[i];
                    if (!entry.equals(classpath[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            return false;
        }
    }

    public static void addAspectPathAndOutJarToClasspath(ILaunchConfiguration configuration) {
        block6: {
            try {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                AJClasspathModel model = LaunchConfigurationClasspathUtils.createClasspathModel(configuration);
                IRuntimeClasspathEntry[] classpath = LaunchConfigurationClasspathUtils.getCurrentClasspath(model);
                boolean def = LaunchConfigurationClasspathUtils.isDefaultClasspath(classpath, (ILaunchConfiguration)wc);
                if (def) {
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                    break block6;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                }
                wc.doSave();
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        }
    }

    static {
        Factory factory = new Factory("LaunchConfigurationClasspathUtils.java", Class.forName("org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 277);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "isDefaultClasspath", "org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils", "[Lorg.eclipse.jdt.launching.IRuntimeClasspathEntry;:org.eclipse.debug.core.ILaunchConfiguration:", "classpath:configuration:", "", "boolean"), 257);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 315);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "addAspectPathAndOutJarToClasspath", "org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils", "org.eclipse.debug.core.ILaunchConfiguration:", "configuration:", "", "void"), 287);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 319);
    }
}

