/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.builder.CoreProjectProperties;
import org.eclipse.ajdt.exports.AJModelBuildScriptGenerator;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.ui.build.BaseBuildAction;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;

public class BuildPluginAction
extends BaseBuildAction {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    protected void makeScripts(IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        BuildConfiguration bc;
        AJModelBuildScriptGenerator generator = new AJModelBuildScriptGenerator();
        AJModelBuildScriptGenerator.setOutputFormat((String)AbstractScriptGenerator.getDefaultOutputFormat());
        AJModelBuildScriptGenerator.setEmbeddedSource((boolean)AbstractScriptGenerator.getDefaultEmbeddedSource());
        AJModelBuildScriptGenerator.setForceUpdateJar((boolean)AbstractScriptGenerator.getForceUpdateJarFormat());
        AJModelBuildScriptGenerator.setConfigInfo((String)AbstractScriptGenerator.getDefaultConfigInfos());
        IProject project = this.fManifestFile.getProject();
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null && (bc = pbc.getActiveBuildConfiguration()) != null) {
            IFile configFile = bc.getFile();
            generator.setBuildConfig(configFile.getName());
        }
        List inpath = this.getInpath(project);
        List aspectpath = this.getAspectpath(project);
        generator.setInpath(inpath);
        generator.setAspectpath(aspectpath);
        generator.setWorkingDirectory(project.getLocation().toOSString());
        String url = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(project.getLocation().addTrailingSeparator().toString()) + "dev.properties"), (boolean)false);
        generator.setDevEntries(new DevClassPathHelper(url));
        generator.setPluginPath(TargetPlatform.createPluginPath());
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        try {
            IPluginModelBase model = PDECore.getDefault().getModelManager().findModel(project);
            if (model != null) {
                generator.setModelId(model.getPluginBase().getId());
                generator.generate();
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            throw new InvocationTargetException(e);
        }
    }

    private List getAspectpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectAspectPath((IProject)project);
        ProjectPropertiesAdapter adapter = Ajde.getDefault().getProjectProperties();
        if (adapter instanceof CoreProjectProperties) {
            String aspectPath = ((CoreProjectProperties)adapter).expandVariables(v[0], v[2]);
            if ((aspectPath = ((CoreProjectProperties)adapter).fullyQualifyPathEntries(aspectPath)).length() > 0) {
                String[] entries = aspectPath.split(File.pathSeparator);
                ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
                return entryList;
            }
        }
        return null;
    }

    private List getInpath(IProject project) {
        String[] v = AspectJCorePreferences.getProjectInPath((IProject)project);
        ProjectPropertiesAdapter adapter = Ajde.getDefault().getProjectProperties();
        if (adapter instanceof CoreProjectProperties) {
            String inPath = ((CoreProjectProperties)adapter).expandVariables(v[0], v[2]);
            if ((inPath = ((CoreProjectProperties)adapter).fullyQualifyPathEntries(inPath)).length() > 0) {
                String[] entries = inPath.split(File.pathSeparator);
                ArrayList<String> entryList = new ArrayList<String>(Arrays.asList(entries));
                return entryList;
            }
        }
        return null;
    }

    static {
        Factory factory = new Factory("BuildPluginAction.java", Class.forName("org.eclipse.ajdt.internal.ui.actions.BuildPluginAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.actions.BuildPluginAction", "org.eclipse.core.runtime.CoreException:", "e:"), 77);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "makeScripts", "org.eclipse.ajdt.internal.ui.actions.BuildPluginAction", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "java.lang.reflect.InvocationTargetException:org.eclipse.core.runtime.CoreException:", "void"), 43);
    }
}

