/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.weaver.WeaverMetrics;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CompilerMonitor
implements IAJCompilerMonitor {
    private boolean reportedCompiledMessages;
    private boolean reportedWovenMessages;
    private IProgressMonitor monitor = null;
    private boolean compilationInProgress = false;
    private float ajdeMonitorMaxRatio = 1.0f;
    private int currentAjdeProgress;
    private boolean linked;
    public static boolean isLocalBuild;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("CompilerMonitor.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 95);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "prepare", "org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor", "org.eclipse.core.resources.IProject:java.util.List:org.eclipse.core.runtime.IProgressMonitor:", "project:buildList:eclipseMonitor:", "", "void"), 86);
        isLocalBuild = false;
    }

    public void prepare(IProject project, List buildList, IProgressMonitor eclipseMonitor) {
        this.linked = false;
        IResource[] res = null;
        try {
            res = project.members();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        int i = 0;
        while (!this.linked && i < res.length) {
            if (res[i].getType() == 2) {
                this.linked = res[i].isLinked();
            }
            ++i;
        }
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.out.println("CompilerMonitor.prepare called: IPM is " + (eclipseMonitor == null ? "Null" : "Not-Null"));
        }
        this.monitor = eclipseMonitor;
        if (this.monitor != null) {
            this.monitor.beginTask(AspectJUIPlugin.getResourceString("ajCompilation"), 100);
        }
        AJLog.logStart((String)"Time to first compiled message");
        AJLog.logStart((String)"Time to first woven message");
        this.reportedCompiledMessages = false;
        this.reportedWovenMessages = false;
        this.compilationInProgress = true;
    }

    public void start(String configFile) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: CompileProgressMonitor.start() called");
        }
        this.currentAjdeProgress = 0;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProjectBuildConfigurator pbc;
                    if (CompilerMonitor.this.monitor != null && isLocalBuild && (pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator()) != null) {
                        String configName = pbc.getActiveBuildConfiguration().getName();
                        CompilerMonitor.this.monitor.setTaskName(AspectJUIPlugin.getFormattedResourceString("CompilerMonitor.building.Project", configName));
                    }
                }
            });
        }
    }

    public void setProgressText(String text) {
        if (!this.reportedCompiledMessages && text.startsWith("compiled: ")) {
            this.reportedCompiledMessages = true;
            AJLog.logEnd((String)"Time to first compiled message");
        }
        if (!this.reportedWovenMessages && text.startsWith("woven ")) {
            this.reportedWovenMessages = true;
            AJLog.logEnd((String)"Time to first woven message");
        }
        if (text.startsWith("compiled: ") || text.startsWith("woven ")) {
            Path resourcePath = null;
            if (text.startsWith("compiled: ")) {
                resourcePath = new Path(text.substring(10));
            } else {
                int fromLoc = text.indexOf("from ");
                int endLoc = text.lastIndexOf(")");
                if (fromLoc != -1 && endLoc > fromLoc) {
                    resourcePath = new Path(text.substring(fromLoc + 5, endLoc));
                }
            }
            IWorkspaceRoot workspaceRoot = AspectJPlugin.getWorkspace().getRoot();
            if (this.linked) {
                IFile[] files = workspaceRoot.findFilesForLocation((IPath)resourcePath);
                int i = 0;
                while (i < files.length) {
                    CompilerTaskListManager.getInstance().addAffectedResource((IResource)files[i]);
                    ++i;
                }
            } else {
                IFile file = workspaceRoot.getFileForLocation((IPath)resourcePath);
                if (file == null) {
                    AJLog.log((String)("Processing progress message: Can't find eclipse resource for file with path " + text));
                } else {
                    CompilerTaskListManager.getInstance().addAffectedResource((IResource)file);
                }
            }
        }
        final String amendedText = this.removePrefix(text);
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressText(" + text + ")");
        }
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.subTask(amendedText);
                    }
                }
            });
        }
    }

    public void setProgressBarVal(int newVal) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarVal(" + newVal + ")");
        }
        if (newVal >= this.currentAjdeProgress) {
            this.incrementProgressBarVal("setProgressBarVal() delegating to ");
        }
    }

    public void setProgressBarMax(int maxVal) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarMax(" + maxVal + ")");
        }
        this.ajdeMonitorMaxRatio = (float)maxVal / 100.0f;
    }

    public void incrementProgressBarVal() {
        this.incrementProgressBarVal("AJDE Callback:");
    }

    public void incrementProgressBarVal(String caller) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println(String.valueOf(caller) + " incrementProgressBarVal():" + this.currentAjdeProgress);
        }
        ++this.currentAjdeProgress;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.worked(1);
                    }
                }
            });
        }
    }

    public int getProgressBarMax() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: getProgressBarMax()");
        }
        return 100;
    }

    public synchronized void finish() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: finish()");
        }
        this.compilationInProgress = false;
        WeaverMetrics.reset();
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            System.err.println("Not finishing with bpm, display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.worked(100);
                        }
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.done();
                        }
                        CompilerMonitor.this.monitor = null;
                    }
                }
            });
        }
    }

    public boolean finished() {
        return !this.compilationInProgress;
    }

    private String removePrefix(String msg) {
        int loc;
        String ret = msg;
        IProject p = AspectJPlugin.getDefault().getCurrentProject();
        String projectLocation = String.valueOf(p.getLocation().toOSString()) + "\\";
        if (msg.indexOf(projectLocation) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        } else if (msg.indexOf(projectLocation = projectLocation.replace('\\', '/')) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        }
        if (ret.startsWith("might need to weave")) {
            ret = AspectJUIPlugin.getResourceString("CompilerMonitor.weaving");
        }
        if (ret.startsWith("directory classpath entry does not exist: null")) {
            ret = "";
        }
        if (ret.startsWith("woven") && ret.indexOf("(from") != -1 && (loc = ret.indexOf("(from")) != -1) {
            String fromPiece = ret.substring(loc);
            int lastSlash = fromPiece.lastIndexOf("/");
            if (lastSlash == -1) {
                lastSlash = fromPiece.lastIndexOf("\\");
            }
            if (lastSlash != -1) {
                fromPiece = fromPiece.substring(lastSlash + 1);
                ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece;
            } else {
                int space = fromPiece.indexOf(" ");
                if (space != -1) {
                    ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece.substring(space + 1);
                }
            }
        }
        return ret;
    }
}

