/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class SaveCrosscuttingMap
implements IWorkbenchWindowActionDelegate {
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        String mapName;
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (pbc == null) {
            return;
        }
        BuildConfiguration bc = pbc.getActiveBuildConfiguration();
        if (bc == null) {
            return;
        }
        IJavaProject jp = pbc.getJavaProject();
        IProject proj = jp.getProject();
        String buildConfName = bc.getName();
        String title = AspectJUIPlugin.getResourceString("savemap.dialog.title");
        String msg = AspectJUIPlugin.getResourceString("savemap.dialog.message");
        String initial = String.valueOf(buildConfName) + ".ajmap";
        InputDialog input = new InputDialog(null, title, msg, initial, null);
        input.setBlockOnOpen(true);
        if (input.open() == 0 && (mapName = input.getValue()) != null && mapName.length() > 0) {
            IPath file;
            if (!mapName.endsWith(".ajmap")) {
                mapName = String.valueOf(mapName) + ".ajmap";
            }
            if ((file = proj.getFile(mapName).getLocation()).toFile().exists() && !this.askUserOverwrite(mapName)) {
                return;
            }
            AJProjectModel pm = AJModel.getInstance().getModelForProject(proj);
            pm.saveModel(file);
            try {
                proj.getFile(mapName).refreshLocal(0, null);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    private boolean askUserOverwrite(String fileName) {
        String msg;
        String[] options = new String[]{AspectJUIPlugin.getResourceString("BCDialog.Overwrite.yes"), AspectJUIPlugin.getResourceString("BCDialog.Overwrite.no")};
        String title = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.title");
        MessageDialog mdiag = new MessageDialog(null, title, null, msg = AspectJUIPlugin.getResourceString("BCDialog.Overwrite.message").replaceAll("%fileName", fileName), 3, options, 1);
        return mdiag.open() == 0;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    static {
        Factory factory = new Factory("SaveCrosscuttingMap.java", Class.forName("org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 86);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.diff.SaveCrosscuttingMap", "org.eclipse.jface.action.IAction:", "action:", "", "void"), 52);
    }
}

