/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.eclipse.ajdt.internal.ui.editor.AJFormattingStrategy;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.contentassist.AJCompletionProcessor;
import org.eclipse.ajdt.internal.ui.editor.outline.AJOutlineInformationControl;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.CompoundContentAssistProcessor;
import org.eclipse.jdt.internal.ui.text.JavaElementProvider;
import org.eclipse.jdt.internal.ui.text.spelling.WordCompletionProcessor;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;

public class AJSourceViewerConfiguration
extends JavaSourceViewerConfiguration {
    AspectJTextTools ajtt = null;
    private IPreferenceStore prefs;

    public AJSourceViewerConfiguration(AspectJTextTools textTools, AspectJEditor editor) {
        super(textTools.getColorManager(), textTools.getPreferenceStore(), (ITextEditor)editor, "___java_partitioning");
        this.ajtt = textTools;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.ajtt.getCodeScanner();
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IContentAssistant assistant = super.getContentAssistant(sourceViewer);
        if (assistant != null && assistant instanceof ContentAssistant) {
            ContentAssistant cAssi = (ContentAssistant)assistant;
            AJCompletionProcessor ajProcessor = new AJCompletionProcessor((IEditorPart)this.getEditor());
            cAssi.setContentAssistProcessor((IContentAssistProcessor)ajProcessor, "__dftl_partition_content_type");
            WordCompletionProcessor wordProcessor = new WordCompletionProcessor();
            CompoundContentAssistProcessor compoundProcessor = new CompoundContentAssistProcessor();
            compoundProcessor.add((IContentAssistProcessor)ajProcessor);
            compoundProcessor.add((IContentAssistProcessor)wordProcessor);
            cAssi.setContentAssistProcessor((IContentAssistProcessor)compoundProcessor, "__java_singleline_comment");
            if (this.prefs == null) {
                this.prefs = this.createPreferenceStore();
            }
            this.configureAJProcessor(this.prefs, ajProcessor);
        }
        return assistant;
    }

    private IPreferenceStore createPreferenceStore() {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.ajtt.getPreferenceStore(), generalTextStore});
    }

    private void configureAJProcessor(IPreferenceStore store, AJCompletionProcessor jcp) {
        String triggers = store.getString("content_assist_autoactivation_triggers_java");
        if (triggers != null) {
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        }
        boolean enabled = store.getBoolean("content_assist_show_visible_proposals");
        jcp.restrictProposalsToVisibility(enabled);
        enabled = store.getBoolean("content_assist_case_sensitivity");
        jcp.restrictProposalsToMatchingCases(enabled);
        enabled = store.getBoolean("content_assist_order_proposals");
        jcp.orderProposalsAlphabetically(enabled);
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.ajtt.getAspectjCodeScanner().affectsBehavior(event) || super.affectsTextPresentation(event);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        IContentFormatter formatter = super.getContentFormatter(sourceViewer);
        if (formatter instanceof MultiPassContentFormatter) {
            ((MultiPassContentFormatter)formatter).setMasterStrategy((IFormattingStrategy)new AJFormattingStrategy());
        }
        return formatter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new AJOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator("org.eclipse.jdt.ui.navigate.java.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator("org.eclipse.jdt.ui.edit.text.java.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        JavaElementProvider provider = new JavaElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_javadoc");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__java_character");
        presenter.setSizeConstraints(20, 20, true, false);
        presenter.setRestoreInformationControlBounds(this.getSettings("outline_presenter_bounds"), true, true);
        return presenter;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = JavaPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }
}

