/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class ProblemsLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private static final int ERRORTICK_WARNING = 32;
    private static final int ERRORTICK_ERROR = 64;
    private ImageDescriptorRegistry registry;
    private boolean fUseNewRegistry = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public ProblemsLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public ProblemsLabelDecorator(ImageDescriptorRegistry registry) {
        this.registry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.registry == null) {
            this.registry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : JavaPlugin.getImageDescriptorRegistry();
        }
        return this.registry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object obj) {
        int adornmentFlags = this.computeAdornmentFlags(obj);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor((ImageDescriptor)baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    private int computeAdornmentFlags(Object obj) {
        try {
            ICompilationUnit cu;
            if (obj instanceof ICompilationUnit && (cu = (ICompilationUnit)obj) != null) {
                return this.getErrorTicksFromMarkers(cu.getResource(), 1);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        return 0;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return 0;
        }
        int info = 0;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 64) {
                IMarker curr = markers[i];
                int priority = curr.getAttribute("severity", -1);
                if (priority == 1) {
                    info = 32;
                } else if (priority == 2) {
                    info = 64;
                }
                ++i;
            }
        }
        return info;
    }

    public void dispose() {
        if (this.registry != null && this.fUseNewRegistry) {
            this.registry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags == 64) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_ERROR);
        } else if (adornmentFlags == 32) {
            decoration.addOverlay(JavaPluginImages.DESC_OVR_WARNING);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    static {
        Factory factory = new Factory("ProblemsLabelDecorator.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.ProblemsLabelDecorator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.ProblemsLabelDecorator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 107);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "computeAdornmentFlags", "org.eclipse.ajdt.internal.ui.editor.ProblemsLabelDecorator", "java.lang.Object:", "obj:", "", "int"), 99);
    }
}

