/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AJCompletionProcessor
extends JavaCompletionProcessor {
    boolean isInAspectJContext = false;
    protected static final String intertypeMemberTag = "ajc$";

    public AJCompletionProcessor(IEditorPart editor) {
        super(editor);
        IEditorInput input;
        IDocumentProvider provider = null;
        if (editor instanceof ITextEditor) {
            provider = ((ITextEditor)editor).getDocumentProvider();
        }
        if ((input = editor.getEditorInput()) instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)input).getFile();
            ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(file.getProject());
            boolean bl = this.isInAspectJContext = pbc != null;
        }
        if (this.isInAspectJContext) {
            this.fManager = new WorkingCopyManagerForCompletionProcessor(this.fManager, provider);
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        IContextInformation[] result = super.computeContextInformation(viewer, offset);
        if (this.isInAspectJContext) {
            ((WorkingCopyManagerForCompletionProcessor)this.fManager).discardWorkingCopy();
        }
        return result;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] props = super.computeCompletionProposals(viewer, offset);
        if (this.isInAspectJContext) {
            ((WorkingCopyManagerForCompletionProcessor)this.fManager).discardWorkingCopy();
            ICompletionProposal[] propsnew = new ICompletionProposal[props.length + 1];
            System.arraycopy(props, 0, propsnew, 0, props.length);
            propsnew[propsnew.length - 1] = new CompletionProposal("", offset, 0, 0, null, AspectJUIPlugin.getResourceString("codeAssist.limited.title"), null, AspectJUIPlugin.getResourceString("codeAssist.limited.message"));
            props = propsnew;
        }
        return this.filterAjcElements(props);
    }

    private ICompletionProposal[] filterAjcElements(ICompletionProposal[] props) {
        int toRemove = 0;
        int i = 0;
        while (i < props.length) {
            if (this.shouldBeRemoved(props[i])) {
                ++toRemove;
            }
            ++i;
        }
        if (toRemove > 0) {
            ICompletionProposal[] newProps = new ICompletionProposal[props.length - toRemove];
            int i2 = 0;
            int j = 0;
            while (i2 < newProps.length) {
                while (this.shouldBeRemoved(props[j++])) {
                }
                newProps[i2] = props[j - 1];
                ++i2;
            }
            props = newProps;
        }
        return props;
    }

    protected boolean shouldBeRemoved(ICompletionProposal proposal) {
        return proposal.getDisplayString().startsWith(intertypeMemberTag);
    }
}

