/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.IImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportsStructure;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.SuperInterfaceSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonStatusDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewContainerWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class NewTypeWizardPage
extends NewContainerWizardPage {
    public int F_PUBLIC = 1;
    public int F_PRIVATE = 2;
    public int F_PROTECTED = 4;
    public int F_STATIC = 8;
    public int F_FINAL = 16;
    public int F_ABSTRACT = 1024;
    public int F_PRIVILEGED = 32768;
    private static final String PAGE_NAME = "NewTypeWizardPage";
    protected static final String PACKAGE = "NewTypeWizardPage.package";
    protected static final String ENCLOSING = "NewTypeWizardPage.enclosing";
    protected static final String ENCLOSINGSELECTION = "NewTypeWizardPage.enclosing.selection";
    protected static final String TYPENAME = "NewTypeWizardPage.typename";
    protected static final String SUPER = "NewTypeWizardPage.superclass";
    protected static final String INTERFACES = "NewTypeWizardPage.interfaces";
    protected static final String MODIFIERS = "NewTypeWizardPage.modifiers";
    protected static final String METHODS = "NewTypeWizardPage.methods";
    private StringButtonStatusDialogField fPackageDialogField;
    private SelectionButtonDialogField fEnclosingTypeSelection;
    private StringButtonDialogField fEnclosingTypeDialogField;
    private boolean fCanModifyPackage;
    private boolean fCanModifyEnclosingType;
    private IPackageFragment fCurrPackage;
    private IFile fCreatedFile;
    private IType fCurrEnclosingType;
    private StringDialogField fTypeNameDialogField;
    private StringButtonDialogField fSuperClassDialogField;
    private ListDialogField fSuperInterfacesDialogField;
    private IType fSuperClass;
    private SelectionButtonDialogFieldGroup fAccMdfButtons;
    private SelectionButtonDialogFieldGroup fOtherMdfButtons;
    private IType fCreatedType = null;
    private JavaPackageCompletionProcessor fCurrPackageCompletionProcessor;
    private JavaTypeCompletionProcessor fEnclosingTypeCompletionProcessor;
    private JavaTypeCompletionProcessor fSuperClassCompletionProcessor;
    protected IStatus fEnclosingTypeStatus;
    protected IStatus fPackageStatus;
    protected IStatus fTypeNameStatus;
    protected IStatus fSuperClassStatus;
    protected IStatus fModifierStatus;
    protected IStatus fSuperInterfacesStatus;
    private boolean fIsClass;
    private boolean fIsAspect;
    private final int PUBLIC_INDEX = 0;
    private final int DEFAULT_INDEX = 1;
    private final int PRIVATE_INDEX = 2;
    private final int PROTECTED_INDEX = 3;
    private final int ABSTRACT_INDEX = 0;
    private final int FINAL_INDEX = 1;
    private final int STATIC_INDEX = 2;
    private final int PRIVILEGED_INDEX = 3;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_17;
    private static final JoinPoint.StaticPart ajc$tjp_18;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_19;
    private static final JoinPoint.StaticPart ajc$tjp_20;
    private static final JoinPoint.StaticPart ajc$tjp_21;

    public NewTypeWizardPage(boolean isClass, boolean isAspect, String pageName) {
        super(pageName);
        this.fIsClass = isClass;
        this.fIsAspect = isAspect;
        TypeFieldsAdapter adapter = new TypeFieldsAdapter();
        this.fPackageDialogField = new StringButtonStatusDialogField((IStringButtonAdapter)adapter);
        this.fPackageDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fPackageDialogField.setLabelText(NewWizardMessages.getString((String)"NewTypeWizardPage.package.label"));
        this.fPackageDialogField.setButtonLabel(NewWizardMessages.getString((String)"NewTypeWizardPage.package.button"));
        this.fPackageDialogField.setStatusWidthHint(NewWizardMessages.getString((String)"NewTypeWizardPage.default"));
        this.fEnclosingTypeSelection = new SelectionButtonDialogField(32);
        this.fEnclosingTypeSelection.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fEnclosingTypeSelection.setLabelText(NewWizardMessages.getString((String)"NewTypeWizardPage.enclosing.selection.label"));
        this.fEnclosingTypeDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fEnclosingTypeDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fEnclosingTypeDialogField.setButtonLabel(NewWizardMessages.getString((String)"NewTypeWizardPage.enclosing.button"));
        this.fTypeNameDialogField = new StringDialogField();
        this.fTypeNameDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fTypeNameDialogField.setLabelText(NewWizardMessages.getString((String)"NewTypeWizardPage.typename.label"));
        this.fSuperClassDialogField = new StringButtonDialogField((IStringButtonAdapter)adapter);
        this.fSuperClassDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        if (isAspect) {
            this.fSuperClassDialogField.setLabelText(AspectJUIPlugin.getResourceString("NewAspectCreationWizardPage.supertype.label"));
        } else {
            this.fSuperClassDialogField.setLabelText(NewWizardMessages.getString((String)"NewTypeWizardPage.superclass.label"));
        }
        this.fSuperClassDialogField.setButtonLabel(NewWizardMessages.getString((String)"NewTypeWizardPage.superclass.button"));
        String[] stringArray = new String[3];
        stringArray[0] = NewWizardMessages.getString((String)"NewTypeWizardPage.interfaces.add");
        stringArray[2] = NewWizardMessages.getString((String)"NewTypeWizardPage.interfaces.remove");
        String[] addButtons = stringArray;
        this.fSuperInterfacesDialogField = new ListDialogField((IListAdapter)adapter, addButtons, (ILabelProvider)new InterfacesListLabelProvider());
        this.fSuperInterfacesDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        String interfaceLabel = this.fIsClass || this.fIsAspect ? NewWizardMessages.getString((String)"NewTypeWizardPage.interfaces.class.label") : NewWizardMessages.getString((String)"NewTypeWizardPage.interfaces.ifc.label");
        this.fSuperInterfacesDialogField.setLabelText(interfaceLabel);
        this.fSuperInterfacesDialogField.setRemoveButtonIndex(2);
        String[] buttonNames1 = new String[]{NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.public"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.default"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.private"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.protected")};
        this.fAccMdfButtons = new SelectionButtonDialogFieldGroup(16, buttonNames1, 4);
        this.fAccMdfButtons.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fAccMdfButtons.setLabelText(NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.acc.label"));
        this.fAccMdfButtons.setSelection(0, true);
        String[] buttonNames2 = this.fIsClass ? new String[]{NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.abstract"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.final"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.static")} : (this.fIsAspect ? new String[]{NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.abstract"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.final"), NewWizardMessages.getString((String)"NewTypeWizardPage.modifiers.static"), "privileged"} : new String[]{});
        this.fOtherMdfButtons = new SelectionButtonDialogFieldGroup(32, buttonNames2, 4);
        this.fOtherMdfButtons.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fAccMdfButtons.enableSelectionButton(2, false);
        this.fAccMdfButtons.enableSelectionButton(3, false);
        this.fOtherMdfButtons.enableSelectionButton(2, false);
        this.fCurrPackageCompletionProcessor = new JavaPackageCompletionProcessor();
        this.fEnclosingTypeCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fSuperClassCompletionProcessor = new JavaTypeCompletionProcessor(false, false);
        this.fPackageStatus = new StatusInfo();
        this.fEnclosingTypeStatus = new StatusInfo();
        this.fCanModifyPackage = true;
        this.fCanModifyEnclosingType = true;
        this.updateEnableState();
        this.fTypeNameStatus = new StatusInfo();
        this.fSuperClassStatus = new StatusInfo();
        this.fSuperInterfacesStatus = new StatusInfo();
        this.fModifierStatus = new StatusInfo();
    }

    protected void initTypePage(IJavaElement elem) {
        String text;
        String initSuperclass = "java.lang.Object";
        ArrayList<String> initSuperinterfaces = new ArrayList<String>(5);
        IPackageFragment pack = null;
        IType enclosingType = null;
        if (elem != null) {
            pack = (IPackageFragment)elem.getAncestor(4);
            IType typeInCU = (IType)elem.getAncestor(7);
            if (typeInCU != null) {
                if (typeInCU.getCompilationUnit() != null) {
                    enclosingType = typeInCU;
                }
            } else {
                ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
                if (cu != null) {
                    enclosingType = cu.findPrimaryType();
                }
            }
            try {
                IType type = null;
                if (elem.getElementType() == 7 && (type = (IType)elem).exists()) {
                    String superName = JavaModelUtil.getFullyQualifiedName((IType)type);
                    if (type.isInterface()) {
                        initSuperinterfaces.add(superName);
                    } else {
                        initSuperclass = superName;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                JavaModelException e = javaModelException;
                JavaPlugin.log((Throwable)e);
            }
        }
        String typeName = "";
        ITextSelection selection = this.getCurrentTextSelection();
        if (selection != null && JavaConventions.validateJavaTypeName((String)(text = selection.getText())).isOK()) {
            typeName = text;
        }
        this.setPackageFragment(pack, true);
        this.setEnclosingType(enclosingType, true);
        this.setEnclosingTypeSelection(false, true);
        this.setTypeName(typeName, true);
        this.setSuperClass(initSuperclass, true);
        this.setSuperInterfaces(initSuperinterfaces, true);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createPackageControls(Composite composite, int nColumns) {
        this.fPackageDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fPackageDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.fCurrPackageCompletionProcessor);
    }

    protected void createEnclosingTypeControls(Composite composite, int nColumns) {
        Composite tabGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tabGroup.setLayout((Layout)layout);
        this.fEnclosingTypeSelection.doFillIntoGrid(tabGroup, 1);
        Text text = this.fEnclosingTypeDialogField.getTextControl(composite);
        GridData gd = new GridData(768);
        gd.widthHint = this.getMaxFieldWidth();
        gd.horizontalSpan = 2;
        text.setLayoutData((Object)gd);
        Button button = this.fEnclosingTypeDialogField.getChangeControl(composite);
        gd = new GridData(256);
        gd.heightHint = SWTUtil.getButtonHeightHint((Button)button);
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        button.setLayoutData((Object)gd);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.fEnclosingTypeCompletionProcessor);
    }

    protected void createTypeNameControls(Composite composite, int nColumns) {
        this.fTypeNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        LayoutUtil.setWidthHint((Control)this.fTypeNameDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
    }

    protected void createModifierControls(Composite composite, int nColumns) {
        LayoutUtil.setHorizontalSpan((Control)this.fAccMdfButtons.getLabelControl(composite), (int)1);
        Composite control = this.fAccMdfButtons.getSelectionButtonsGroup(composite);
        GridData gd = new GridData(256);
        gd.horizontalSpan = nColumns - 2;
        control.setLayoutData((Object)gd);
        DialogField.createEmptySpace((Composite)composite);
        if (this.fIsClass || this.fIsAspect) {
            DialogField.createEmptySpace((Composite)composite);
            control = this.fOtherMdfButtons.getSelectionButtonsGroup(composite);
            gd = new GridData(256);
            gd.horizontalSpan = nColumns - 2;
            control.setLayoutData((Object)gd);
            DialogField.createEmptySpace((Composite)composite);
        }
    }

    protected void createSuperClassControls(Composite composite, int nColumns) {
        this.fSuperClassDialogField.doFillIntoGrid(composite, nColumns);
        Text text = this.fSuperClassDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.fSuperClassCompletionProcessor);
    }

    protected void createSuperInterfacesControls(Composite composite, int nColumns) {
        this.fSuperInterfacesDialogField.doFillIntoGrid(composite, nColumns);
        GridData gd = (GridData)this.fSuperInterfacesDialogField.getListControl(null).getLayoutData();
        gd.heightHint = this.fIsClass ? this.convertHeightInCharsToPixels(3) : this.convertHeightInCharsToPixels(6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
    }

    protected void setFocus() {
        this.fTypeNameDialogField.setFocus();
    }

    private void typePageChangeControlPressed(DialogField field) {
        IType type;
        if (field == this.fPackageDialogField) {
            IPackageFragment pack = this.choosePackage();
            if (pack != null) {
                this.fPackageDialogField.setText(pack.getElementName());
            }
        } else if (field == this.fEnclosingTypeDialogField) {
            IType type2 = this.chooseEnclosingType();
            if (type2 != null) {
                this.fEnclosingTypeDialogField.setText(JavaModelUtil.getFullyQualifiedName((IType)type2));
            }
        } else if (field == this.fSuperClassDialogField && (type = this.chooseSuperType()) != null) {
            this.fSuperClassDialogField.setText(JavaModelUtil.getFullyQualifiedName((IType)type));
        }
    }

    private void typePageCustomButtonPressed(DialogField field, int index) {
        if (field == this.fSuperInterfacesDialogField) {
            this.chooseSuperInterfaces();
        }
    }

    private void typePageDialogFieldChanged(DialogField field) {
        String fieldName = null;
        if (field == this.fPackageDialogField) {
            this.fPackageStatus = this.packageChanged();
            this.updatePackageStatusLabel();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = PACKAGE;
        } else if (field == this.fEnclosingTypeDialogField) {
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSING;
        } else if (field == this.fEnclosingTypeSelection) {
            this.updateEnableState();
            boolean isEnclosedType = this.isEnclosingTypeSelected();
            if (!isEnclosedType) {
                if (this.fAccMdfButtons.isSelected(2) || this.fAccMdfButtons.isSelected(3)) {
                    this.fAccMdfButtons.setSelection(2, false);
                    this.fAccMdfButtons.setSelection(3, false);
                    this.fAccMdfButtons.setSelection(0, true);
                }
                if (this.fOtherMdfButtons.isSelected(2)) {
                    this.fOtherMdfButtons.setSelection(2, false);
                }
            } else if (this.fIsAspect) {
                this.fOtherMdfButtons.setSelection(2, true);
            }
            this.fAccMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fAccMdfButtons.enableSelectionButton(3, isEnclosedType);
            this.fOtherMdfButtons.enableSelectionButton(2, isEnclosedType);
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = ENCLOSINGSELECTION;
        } else if (field == this.fTypeNameDialogField) {
            this.fTypeNameStatus = this.typeNameChanged();
            fieldName = TYPENAME;
        } else if (field == this.fSuperClassDialogField) {
            this.fSuperClassStatus = this.superClassChanged();
            fieldName = SUPER;
        } else if (field == this.fSuperInterfacesDialogField) {
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
            fieldName = INTERFACES;
        } else if (field == this.fOtherMdfButtons || field == this.fAccMdfButtons) {
            this.fModifierStatus = this.modifiersChanged();
            fieldName = MODIFIERS;
        } else {
            fieldName = METHODS;
        }
        this.handleFieldChanged(fieldName);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == "NewContainerWizardPage.container") {
            this.fPackageStatus = this.packageChanged();
            this.fEnclosingTypeStatus = this.enclosingTypeChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.fSuperClassStatus = this.superClassChanged();
            this.fSuperInterfacesStatus = this.superInterfacesChanged();
        }
    }

    public String getPackageText() {
        return this.fPackageDialogField.getText();
    }

    public String getEnclosingTypeText() {
        return this.fEnclosingTypeDialogField.getText();
    }

    public IPackageFragment getPackageFragment() {
        if (!this.isEnclosingTypeSelected()) {
            return this.fCurrPackage;
        }
        if (this.fCurrEnclosingType != null) {
            return this.fCurrEnclosingType.getPackageFragment();
        }
        return null;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        this.fCanModifyPackage = canBeModified;
        String str = pack == null ? "" : pack.getElementName();
        this.fPackageDialogField.setText(str);
        this.updateEnableState();
    }

    public IType getEnclosingType() {
        if (this.isEnclosingTypeSelected()) {
            return this.fCurrEnclosingType;
        }
        return null;
    }

    public void setEnclosingType(IType type, boolean canBeModified) {
        this.fCurrEnclosingType = type;
        this.fCanModifyEnclosingType = canBeModified;
        String str = type == null ? "" : JavaModelUtil.getFullyQualifiedName((IType)type);
        this.fEnclosingTypeDialogField.setText(str);
        this.updateEnableState();
    }

    public boolean isEnclosingTypeSelected() {
        return this.fEnclosingTypeSelection.isSelected();
    }

    public void setEnclosingTypeSelection(boolean isSelected, boolean canBeModified) {
        this.fEnclosingTypeSelection.setSelection(isSelected);
        this.fEnclosingTypeSelection.setEnabled(canBeModified);
        this.updateEnableState();
    }

    public String getTypeName() {
        return this.fTypeNameDialogField.getText();
    }

    public void setTypeName(String name, boolean canBeModified) {
        this.fTypeNameDialogField.setText(name);
        this.fTypeNameDialogField.setEnabled(canBeModified);
    }

    public int getModifiers() {
        int mdf = 0;
        if (this.fAccMdfButtons.isSelected(0)) {
            mdf += this.F_PUBLIC;
        } else if (this.fAccMdfButtons.isSelected(2)) {
            mdf += this.F_PRIVATE;
        } else if (this.fAccMdfButtons.isSelected(3)) {
            mdf += this.F_PROTECTED;
        }
        if (this.fOtherMdfButtons.isSelected(0)) {
            mdf += this.F_ABSTRACT;
        }
        if (this.fOtherMdfButtons.isSelected(1)) {
            mdf += this.F_FINAL;
        }
        if (this.fOtherMdfButtons.isSelected(2)) {
            mdf += this.F_STATIC;
        }
        if (this.fOtherMdfButtons.isSelected(3)) {
            mdf += this.F_PRIVILEGED;
        }
        return mdf;
    }

    public void setModifiers(int modifiers, boolean canBeModified) {
        if (Flags.isPublic((int)modifiers)) {
            this.fAccMdfButtons.setSelection(0, true);
        } else if (Flags.isPrivate((int)modifiers)) {
            this.fAccMdfButtons.setSelection(2, true);
        } else if (Flags.isProtected((int)modifiers)) {
            this.fAccMdfButtons.setSelection(3, true);
        } else {
            this.fAccMdfButtons.setSelection(1, true);
        }
        if (Flags.isAbstract((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(0, true);
        }
        if (Flags.isFinal((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(1, true);
        }
        if (Flags.isStatic((int)modifiers)) {
            this.fOtherMdfButtons.setSelection(2, true);
        }
        if ((modifiers & this.F_PRIVILEGED) != 0) {
            this.fOtherMdfButtons.setSelection(3, true);
        }
        this.fAccMdfButtons.setEnabled(canBeModified);
        this.fOtherMdfButtons.setEnabled(canBeModified);
    }

    public String getSuperClass() {
        return this.fSuperClassDialogField.getText();
    }

    public void setSuperClass(String name, boolean canBeModified) {
        this.fSuperClassDialogField.setText(name);
        this.fSuperClassDialogField.setEnabled(canBeModified);
    }

    public List getSuperInterfaces() {
        return this.fSuperInterfacesDialogField.getElements();
    }

    public void setSuperInterfaces(List interfacesNames, boolean canBeModified) {
        this.fSuperInterfacesDialogField.setElements((Collection)interfacesNames);
        this.fSuperInterfacesDialogField.setEnabled(canBeModified);
    }

    public IResource getModifiedResource() {
        IType enclosing = this.getEnclosingType();
        if (enclosing != null) {
            return enclosing.getResource();
        }
        if (this.fCreatedFile != null) {
            return this.fCreatedFile;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            return pack.getCompilationUnit(String.valueOf(this.getTypeName()) + ".java").getResource();
        }
        return null;
    }

    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        this.fCurrPackageCompletionProcessor.setPackageFragmentRoot(this.getPackageFragmentRoot());
        if (this.getPackageFragmentRoot() != null) {
            this.fEnclosingTypeCompletionProcessor.setPackageFragment(this.getPackageFragmentRoot().getPackageFragment(""));
        }
        return status;
    }

    protected IStatus packageChanged() {
        IPackageFragmentRoot root;
        StatusInfo status = new StatusInfo();
        this.fPackageDialogField.enableButton(this.getPackageFragmentRoot() != null);
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidPackageName", (Object)val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.DiscouragedPackageName", (Object)val.getMessage()));
            }
        } else {
            status.setWarning(NewWizardMessages.getString((String)"NewTypeWizardPage.warning.DefaultPackageDiscouraged"));
        }
        if ((root = this.getPackageFragmentRoot()) != null) {
            if (root.getJavaProject().exists() && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.ClashOutputLocation"));
                        return status;
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                    JavaModelException e = javaModelException;
                    JavaPlugin.log((Throwable)e);
                }
            }
            this.fCurrPackage = root.getPackageFragment(packName);
            this.fSuperClassCompletionProcessor.setExtendsCompletionContext(this.fCurrPackage);
        } else {
            status.setError("");
        }
        return status;
    }

    private void updatePackageStatusLabel() {
        String packName = this.getPackageText();
        if (packName.length() == 0) {
            this.fPackageDialogField.setStatus(NewWizardMessages.getString((String)"NewTypeWizardPage.default"));
        } else {
            this.fPackageDialogField.setStatus("");
        }
    }

    private void updateEnableState() {
        boolean enclosing = this.isEnclosingTypeSelected();
        this.fPackageDialogField.setEnabled(this.fCanModifyPackage && !enclosing);
        this.fEnclosingTypeDialogField.setEnabled(this.fCanModifyEnclosingType && enclosing);
    }

    protected IStatus enclosingTypeChanged() {
        StatusInfo status = new StatusInfo();
        this.fCurrEnclosingType = null;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fEnclosingTypeDialogField.enableButton(root != null);
        if (root == null) {
            status.setError("");
            return status;
        }
        String enclName = this.getEnclosingTypeText();
        if (enclName.length() == 0) {
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnclosingTypeEnterName"));
            return status;
        }
        try {
            IType type = this.findType(root.getJavaProject(), enclName);
            if (type == null) {
                status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnclosingTypeNotExists"));
                return status;
            }
            if (type.getCompilationUnit() == null) {
                status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnclosingNotInCU"));
                return status;
            }
            if (!JavaModelUtil.isEditable((ICompilationUnit)type.getCompilationUnit())) {
                status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnclosingNotEditable"));
                return status;
            }
            this.fCurrEnclosingType = type;
            IPackageFragmentRoot enclosingRoot = JavaModelUtil.getPackageFragmentRoot((IJavaElement)type);
            if (!enclosingRoot.equals(root)) {
                status.setWarning(NewWizardMessages.getString((String)"NewTypeWizardPage.warning.EnclosingNotInSourceFolder"));
            }
            return status;
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            JavaModelException e = javaModelException;
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnclosingTypeNotExists"));
            JavaPlugin.log((Throwable)e);
            return status;
        }
    }

    protected IStatus typeNameChanged() {
        StatusInfo status = new StatusInfo();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.EnterTypeName"));
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.QualifiedName"));
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)typeName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.error.InvalidTypeName", (Object)val.getMessage()));
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.TypeNameDiscouraged", (Object)val.getMessage()));
        }
        if (!this.isEnclosingTypeSelected()) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack != null) {
                ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
                IResource resource = cu.getResource();
                if (resource.exists()) {
                    status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.TypeNameExists"));
                    return status;
                }
                IPath location = resource.getLocation();
                if (location != null && location.toFile().exists()) {
                    status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.TypeNameExistsDifferentCase"));
                    return status;
                }
            }
        } else {
            IType member;
            IType type = this.getEnclosingType();
            if (type != null && (member = type.getType(typeName)).exists()) {
                status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.TypeNameExists"));
                return status;
            }
        }
        return status;
    }

    protected IStatus superClassChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperClassDialogField.enableButton(root != null);
        this.fSuperClass = null;
        String sclassName = this.getSuperClass();
        if (sclassName.length() == 0) {
            return status;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)sclassName);
        if (val.getSeverity() == 4) {
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.InvalidSuperClassName"));
            return status;
        }
        if (root != null) {
            try {
                IType type = this.resolveSuperTypeName(root.getJavaProject(), sclassName);
                if (type == null) {
                    status.setWarning(NewWizardMessages.getString((String)"NewTypeWizardPage.warning.SuperClassNotExists"));
                    return status;
                }
                if (type.isInterface()) {
                    status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.SuperClassIsNotClass", (Object)sclassName));
                    return status;
                }
                int flags = type.getFlags();
                if (Flags.isFinal((int)flags)) {
                    status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.SuperClassIsFinal", (Object)sclassName));
                    return status;
                }
                if (!JavaModelUtil.isVisible((IMember)type, (IPackageFragment)this.getPackageFragment())) {
                    status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.SuperClassIsNotVisible", (Object)sclassName));
                    return status;
                }
                this.fSuperClass = type;
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
                JavaModelException e = javaModelException;
                status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.InvalidSuperClassName"));
                JavaPlugin.log((Throwable)e);
            }
        } else {
            status.setError("");
        }
        return status;
    }

    private IType resolveSuperTypeName(IJavaProject jproject, String sclassName) throws JavaModelException {
        if (!jproject.exists()) {
            return null;
        }
        IType type = null;
        if (this.isEnclosingTypeSelected()) {
            String[][] res;
            IType enclosingType = this.getEnclosingType();
            if (enclosingType != null && (res = enclosingType.resolveType(sclassName)) != null && res.length > 0) {
                type = jproject.findType(res[0][0], res[0][1]);
            }
        } else {
            IPackageFragment currPack = this.getPackageFragment();
            if (type == null && currPack != null) {
                String packName = currPack.getElementName();
                if (!currPack.isDefaultPackage()) {
                    type = jproject.findType(packName, sclassName);
                }
                if (type == null && !"java.lang".equals(packName)) {
                    type = jproject.findType("java.lang", sclassName);
                }
            }
            if (type == null) {
                type = jproject.findType(sclassName);
            }
        }
        return type;
    }

    private IType findType(IJavaProject project, String typeName) throws JavaModelException {
        if (project.exists()) {
            return project.findType(typeName);
        }
        return null;
    }

    protected IStatus superInterfacesChanged() {
        StatusInfo status = new StatusInfo();
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        this.fSuperInterfacesDialogField.enableButton(0, root != null);
        if (root != null) {
            List elements = this.fSuperInterfacesDialogField.getElements();
            int nElements = elements.size();
            int i = 0;
            while (i < nElements) {
                String intfname = (String)elements.get(i);
                try {
                    IType type = this.findType(root.getJavaProject(), intfname);
                    if (type == null) {
                        status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.InterfaceNotExists", (Object)intfname));
                        return status;
                    }
                    if (type.isClass()) {
                        status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.InterfaceIsNotInterface", (Object)intfname));
                        return status;
                    }
                    if (!JavaModelUtil.isVisible((IMember)type, (IPackageFragment)this.getPackageFragment())) {
                        status.setWarning(NewWizardMessages.getFormattedString((String)"NewTypeWizardPage.warning.InterfaceIsNotVisible", (Object)intfname));
                        return status;
                    }
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
                    JavaModelException e = javaModelException;
                    JavaPlugin.log((Throwable)e);
                }
                ++i;
            }
        }
        return status;
    }

    protected IStatus modifiersChanged() {
        StatusInfo status = new StatusInfo();
        int modifiers = this.getModifiers();
        if (Flags.isFinal((int)modifiers) && Flags.isAbstract((int)modifiers)) {
            status.setError(NewWizardMessages.getString((String)"NewTypeWizardPage.error.ModifiersFinalAndAbstract"));
        }
        return status;
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
            JavaModelException e = javaModelException;
            JavaPlugin.log((Throwable)e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.description"));
        dialog.setEmptyListMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.ChoosePackageDialog.empty"));
        dialog.setElements(packages);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseEnclosingType() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root});
        org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog dialog = new org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 0, scope);
        dialog.setTitle(NewWizardMessages.getString((String)"NewTypeWizardPage.ChooseEnclosingTypeDialog.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.ChooseEnclosingTypeDialog.description"));
        dialog.setFilter(org.eclipse.jdt.core.Signature.getSimpleName((String)this.getEnclosingTypeText()));
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseSuperType() {
        TypeSelectionDialog dialog;
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        if (this.fIsAspect) {
            dialog = new TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
            dialog.setTitle(AspectJUIPlugin.getResourceString("NewTypeWizardPage.SuperClassDialog.title"));
            dialog.setMessage(AspectJUIPlugin.getResourceString("NewTypeWizardPage.SuperClassDialog.message"));
        } else {
            dialog = new org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), 5, scope);
            dialog.setTitle(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.title"));
            dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.SuperClassDialog.message"));
            ((org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog)dialog).setFilter(this.getSuperClass());
        }
        if (dialog.open() == 0) {
            return (IType)dialog.getFirstResult();
        }
        return null;
    }

    private void chooseSuperInterfaces() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaProject project = root.getJavaProject();
        SuperInterfaceSelectionDialog dialog = new SuperInterfaceSelectionDialog(this.getShell(), (IRunnableContext)this.getWizard().getContainer(), this.fSuperInterfacesDialogField, project);
        dialog.setTitle(this.fIsClass ? NewWizardMessages.getString((String)"NewTypeWizardPage.InterfacesDialog.class.title") : NewWizardMessages.getString((String)"NewTypeWizardPage.InterfacesDialog.interface.title"));
        dialog.setMessage(NewWizardMessages.getString((String)"NewTypeWizardPage.InterfacesDialog.message"));
        dialog.open();
    }

    private IFile createNewFile(String sourceFolder, String packName) {
        Path path = new Path(sourceFolder);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = workspaceRoot.findMember((IPath)path);
        IProject proj = res.getProject();
        IResource pack = null;
        if (res.getType() == 2) {
            IFolder folder = (IFolder)res;
            pack = folder.findMember(packName);
        } else if (res.getType() == 4) {
            pack = ((IProject)res).findMember(packName);
        } else {
            return null;
        }
        if (pack == null) {
            IJavaProject jproject = JavaCore.create((IProject)proj);
            IPackageFragmentRoot root = jproject.getPackageFragmentRoot(res);
            try {
                IPackageFragment frag = root.createPackageFragment(packName, true, null);
                pack = frag.getResource();
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
            }
        }
        String aspectName = this.getTypeName();
        String extName = AspectJPreferences.getFileExt();
        IPath newpath = pack.getFullPath().append(String.valueOf(aspectName) + extName);
        IFile newfile = workspaceRoot.getFile(newpath);
        return newfile;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        block28: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(NewWizardMessages.getString((String)"NewTypeWizardPage.operationdesc"), 10);
            this.fCreatedFile = null;
            ICompilationUnit createdWorkingCopy = null;
            try {
                String originalContent;
                boolean needsSave;
                int ind;
                IType createdType;
                ImportsManager imports;
                Object parentCU;
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                IPackageFragment pack = this.getPackageFragment();
                if (pack == null) {
                    pack = root.getPackageFragment("");
                }
                if (!pack.exists()) {
                    String packName = pack.getElementName();
                    pack = root.createPackageFragment(packName, true, null);
                }
                monitor.worked(1);
                String clName = this.getTypeName();
                boolean isInnerClass = this.isEnclosingTypeSelected();
                int indent = 0;
                String lineDelimiter = null;
                if (!isInnerClass) {
                    lineDelimiter = System.getProperty("line.separator", "\n");
                    this.fCreatedFile = this.createNewFile(this.getPackageFragmentRootText(), pack.getElementName());
                    ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
                    this.fCreatedFile.create((InputStream)is, false, monitor);
                    parentCU = this.fIsAspect ? AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(this.fCreatedFile) : pack.createCompilationUnit(String.valueOf(clName) + ".java", "", false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    createdWorkingCopy = parentCU.getWorkingCopy(null);
                    String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)createdWorkingCopy, null, (String)"", (String)lineDelimiter);
                    if (content != null) {
                        createdWorkingCopy.getBuffer().setContents(content);
                    }
                    imports = new ImportsManager(createdWorkingCopy);
                    imports.addImport(JavaModelUtil.concatenateName((String)pack.getElementName(), (String)this.getTypeName()));
                    String typeContent = this.constructTypeStub(imports, lineDelimiter);
                    String cuContent = this.constructCUContent((ICompilationUnit)parentCU, typeContent, lineDelimiter);
                    createdWorkingCopy.getBuffer().setContents(cuContent);
                    createdType = createdWorkingCopy.getType(clName);
                } else {
                    IJavaElement[] elems;
                    StringBuffer content;
                    IType enclosingType = this.getEnclosingType();
                    parentCU = enclosingType.getCompilationUnit();
                    imports = new ImportsManager((ICompilationUnit)parentCU);
                    IType[] topLevelTypes = parentCU.getTypes();
                    int i = 0;
                    while (true) {
                        if (i >= topLevelTypes.length) {
                            String comment;
                            lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaElement)enclosingType);
                            content = new StringBuffer();
                            if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc") && (comment = this.getTypeComment((ICompilationUnit)parentCU, lineDelimiter)) != null) {
                                content.append(comment);
                                content.append(lineDelimiter);
                            }
                            content.append(this.constructTypeStub(imports, lineDelimiter));
                            elems = enclosingType.getChildren();
                        }
                        imports.addImport(topLevelTypes[i].getFullyQualifiedName('.'));
                        ++i;
                    }
                    IJavaElement sibling = elems.length > 0 ? elems[0] : null;
                    ind = content.indexOf("aspect");
                    if (ind != -1) {
                        content.replace(ind, ind + "aspect".length(), "class");
                    }
                    createdType = enclosingType.createType(content.toString(), sibling, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    indent = StubUtility.getIndentUsed((IJavaElement)enclosingType) + 1;
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ICompilationUnit cu = createdType.getCompilationUnit();
                boolean bl = needsSave = !cu.isWorkingCopy();
                if (cu instanceof AJCompilationUnit) {
                    ((AJCompilationUnit)cu).requestOriginalContentMode();
                }
                if (!isInnerClass || !this.fIsAspect) {
                    imports.create(needsSave, new SubProgressMonitor(monitor, 1));
                }
                JavaModelUtil.reconcile((ICompilationUnit)cu);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                imports = new ImportsManager(imports.getCompilationUnit(), imports.getAddedTypes());
                if (cu instanceof AJCompilationUnit) {
                    ((AJCompilationUnit)cu).discardOriginalContentMode();
                }
                this.createTypeMembers(createdType, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (cu instanceof AJCompilationUnit) {
                    ((AJCompilationUnit)cu).requestOriginalContentMode();
                }
                if (!isInnerClass || !this.fIsAspect) {
                    imports.create(needsSave, new SubProgressMonitor(monitor, 1));
                }
                this.removeUnusedImports(cu, imports.getAddedTypes(), needsSave);
                JavaModelUtil.reconcile((ICompilationUnit)cu);
                ISourceRange range = createdType.getSourceRange();
                IBuffer buf = cu.getBuffer();
                String repl = originalContent = buf.getText(range.getOffset(), range.getLength());
                ind = originalContent.indexOf("aspect");
                if (ind != -1) {
                    repl = String.valueOf(originalContent.substring(0, ind)) + "class" + originalContent.substring(ind + "aspect".length());
                }
                String formattedContent = CodeFormatterUtil.format((int)4, (String)repl, (int)indent, null, (String)lineDelimiter, (IJavaProject)pack.getJavaProject());
                ind = (formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent)).indexOf("class");
                if (ind != -1) {
                    formattedContent = String.valueOf(formattedContent.substring(0, ind)) + "aspect" + formattedContent.substring(ind + "class".length());
                }
                buf.replace(range.getOffset(), range.getLength(), formattedContent);
                if (!isInnerClass) {
                    String fileComment = this.getFileComment(cu);
                    if (fileComment != null && fileComment.length() > 0) {
                        buf.replace(0, 0, String.valueOf(fileComment) + lineDelimiter);
                    }
                    cu.commitWorkingCopy(false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    if (needsSave) {
                        buf.save(null, false);
                    }
                    monitor.worked(1);
                }
                this.fCreatedType = createdWorkingCopy != null ? (IType)createdType.getPrimaryElement() : createdType;
                if (cu instanceof AJCompilationUnit) {
                    ((AJCompilationUnit)cu).discardOriginalContentMode();
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                if (createdWorkingCopy != null) {
                    createdWorkingCopy.discardWorkingCopy();
                }
                monitor.done();
                throw throwable;
            }
            {
                Object var20_24 = null;
                if (createdWorkingCopy == null) break block28;
            }
            createdWorkingCopy.discardWorkingCopy();
        }
        monitor.done();
    }

    private void removeUnusedImports(ICompilationUnit cu, Set addedTypes, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        IProblem[] problems = root.getProblems();
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < problems.length) {
            int id = problems[i].getID();
            if (id == 268435844 || id == 268435847) {
                String imp = problems[i].getArguments()[0];
                res.add(imp);
            }
            ++i;
        }
        if (!res.isEmpty()) {
            ImportsManager imports = new ImportsManager(cu, addedTypes);
            int i2 = 0;
            while (i2 < res.size()) {
                String curr = (String)res.get(i2);
                imports.removeImport(curr);
                ++i2;
            }
            imports.create(needsSave, null);
        }
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        String typeComment = this.getTypeComment(cu, lineDelimiter);
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, (String)typeComment, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if (!(!pack.isDefaultPackage() && unit.getPackage() == null || unit.types().isEmpty() && !this.fIsAspect)) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        if (typeComment != null) {
            buf.append(typeComment).append(lineDelimiter);
        }
        buf.append(typeContent);
        return buf.toString();
    }

    public IType getCreatedType() {
        return this.fCreatedType;
    }

    private void writeSuperClass(StringBuffer buf, ImportsManager imports) {
        String typename = this.getSuperClass();
        if ((this.fIsClass || this.fIsAspect) && typename.length() > 0 && !"java.lang.Object".equals(typename)) {
            buf.append(" extends ");
            String qualifiedName = this.fSuperClass != null ? JavaModelUtil.getFullyQualifiedName((IType)this.fSuperClass) : typename;
            buf.append(imports.addImport(qualifiedName));
        }
    }

    private void writeSuperInterfaces(StringBuffer buf, ImportsManager imports) {
        List interfaces = this.getSuperInterfaces();
        int last = interfaces.size() - 1;
        if (last >= 0) {
            if (this.fIsClass || this.fIsAspect) {
                buf.append(" implements ");
            } else {
                buf.append(" extends ");
            }
            int i = 0;
            while (i <= last) {
                String typename = (String)interfaces.get(i);
                buf.append(imports.addImport(typename));
                if (i < last) {
                    buf.append(',');
                }
                ++i;
            }
        }
    }

    protected void writePerClause(StringBuffer buf) {
    }

    private String constructTypeStub(ImportsManager imports, String lineDelimiter) {
        StringBuffer buf = new StringBuffer();
        int modifiers = this.getModifiers();
        String modStr = Flags.toString((int)modifiers);
        buf.append(modStr);
        if ((modifiers & this.F_PRIVILEGED) != 0) {
            if (modStr.length() > 0) {
                buf.append(' ');
            }
            buf.append("privileged");
        }
        if (modifiers != 0) {
            buf.append(' ');
        }
        String type = "";
        type = this.fIsClass ? "class " : (this.fIsAspect ? "aspect " : "interface ");
        buf.append(type);
        buf.append(this.getTypeName());
        this.writeSuperClass(buf, imports);
        this.writeSuperInterfaces(buf, imports);
        if (this.fIsAspect) {
            this.writePerClause(buf);
        }
        buf.append('{');
        buf.append(lineDelimiter);
        buf.append(lineDelimiter);
        buf.append('}');
        buf.append(lineDelimiter);
        return buf.toString();
    }

    protected void createTypeMembers(IType newType, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createTypeMembers(newType, (IImportsStructure)imports, monitor);
    }

    protected void createTypeMembers(IType newType, IImportsStructure imports, IProgressMonitor monitor) throws CoreException {
    }

    protected String getFileComment(ICompilationUnit parentCU) {
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment((int)next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invalidInputException, (Object)this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_15);
            return false;
        }
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) {
        try {
            StringBuffer typeName = new StringBuffer();
            if (this.isEnclosingTypeSelected()) {
                typeName.append(JavaModelUtil.getTypeQualifiedName((IType)this.getEnclosingType())).append('.');
            }
            typeName.append(this.getTypeName());
            String comment = CodeGeneration.getTypeComment((ICompilationUnit)parentCU, (String)typeName.toString(), (String)lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_16, (JoinPoint.StaticPart)ajc$tjp_17);
            CoreException e = coreException;
            JavaPlugin.log((Throwable)e);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
            return this.getTypeComment(parentCU, String.valueOf('\n'));
        }
        return null;
    }

    protected String getTemplate(String name, ICompilationUnit parentCU) {
        return this.getTemplate(name, parentCU, 0);
    }

    protected String getTemplate(String name, ICompilationUnit parentCU, int pos) {
        try {
            Template template = JavaPlugin.getDefault().getTemplateStore().findTemplate(name);
            if (template != null) {
                return JavaContext.evaluateTemplate((Template)template, (ICompilationUnit)parentCU, (int)pos);
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_18, (JoinPoint.StaticPart)ajc$tjp_19);
            CoreException e = coreException;
            JavaPlugin.log((Throwable)e);
        }
        catch (BadLocationException badLocationException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException, (Object)this, ajc$tjp_20, (JoinPoint.StaticPart)ajc$tjp_19);
            BadLocationException e = badLocationException;
            JavaPlugin.log((Throwable)e);
        }
        catch (TemplateException templateException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(templateException, (Object)this, ajc$tjp_21, (JoinPoint.StaticPart)ajc$tjp_19);
            TemplateException e = templateException;
            JavaPlugin.log((Throwable)e);
        }
        return null;
    }

    protected IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        String[] constructors;
        IType superclass;
        ArrayList<String> newMethods = new ArrayList<String>();
        ITypeHierarchy hierarchy = null;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
        if (doConstructors && (superclass = (hierarchy = type.newSupertypeHierarchy(monitor)).getSuperclass(type)) != null && (constructors = StubUtility.evalConstructors((IType)type, (IType)superclass, (CodeGenerationSettings)settings, (IImportsStructure)imports)) != null) {
            int i = 0;
            while (i < constructors.length) {
                newMethods.add(constructors[i]);
                ++i;
            }
        }
        if (doUnimplementedMethods) {
            String[] unimplemented;
            if (hierarchy == null) {
                hierarchy = type.newSupertypeHierarchy(monitor);
            }
            if ((unimplemented = StubUtility.evalUnimplementedMethods((IType)type, (ITypeHierarchy)hierarchy, (boolean)false, (CodeGenerationSettings)settings, (IImportsStructure)imports)) != null) {
                int i = 0;
                while (i < unimplemented.length) {
                    newMethods.add(unimplemented[i]);
                    ++i;
                }
            }
        }
        IMethod[] createdMethods = new IMethod[newMethods.size()];
        int i = 0;
        while (i < newMethods.size()) {
            String content = String.valueOf((String)newMethods.get(i)) + '\n';
            createdMethods[i] = type.createMethod(content, null, false, null);
            ++i;
        }
        return createdMethods;
    }

    protected IMethod[] createInheritedMethods(IType type, boolean doConstructors, boolean doUnimplementedMethods, IImportsStructure imports, IProgressMonitor monitor) throws CoreException {
        return this.createInheritedMethods(type, doConstructors, doUnimplementedMethods, new ImportsManager(imports), monitor);
    }

    public IRunnableWithProgress getRunnable() {
        return new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    NewTypeWizardPage.this.createType(monitor);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException e = coreException;
                    throw new InvocationTargetException(e);
                }
            }

            static {
                Factory factory = new Factory("NewTypeWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage$1", "org.eclipse.core.runtime.CoreException:", "e:"), 2094);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage$1", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "java.lang.reflect.InvocationTargetException:java.lang.InterruptedException:", "void"), 2088);
            }
        };
    }

    static {
        Factory factory = new Factory("NewTypeWizardPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 447);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "initTypePage", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.IJavaElement:", "elem:", "", "void"), 412);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 1388);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "choosePackage", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "", "", "", "org.eclipse.jdt.core.IPackageFragment"), 1381);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 1503);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createNewFile", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "java.lang.String:java.lang.String:", "sourceFolder:packName:", "", "org.eclipse.core.resources.IFile"), 1480);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.compiler.InvalidInputException:", "<missing>:"), 1940);
        ajc$tjp_15 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "isValidComment", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "java.lang.String:", "template:", "", "boolean"), 1931);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.core.runtime.CoreException:", "e:"), 1968);
        ajc$tjp_17 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "getTypeComment", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.ICompilationUnit:java.lang.String:", "parentCU:lineDelimiter:", "", "java.lang.String"), 1957);
        ajc$tjp_18 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.core.runtime.CoreException:", "e:"), 2010);
        ajc$tjp_19 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "getTemplate", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "java.lang.String:org.eclipse.jdt.core.ICompilationUnit:int:", "name:parentCU:pos:", "", "java.lang.String"), 2004);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 1064);
        ajc$tjp_20 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jface.text.BadLocationException:", "e:"), 2012);
        ajc$tjp_21 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jface.text.templates.TemplateException:", "e:"), 2014);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "packageChanged", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "", "", "", "org.eclipse.core.runtime.IStatus"), 1031);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 1149);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "enclosingTypeChanged", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "", "", "", "org.eclipse.core.runtime.IStatus"), 1110);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 1263);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "superClassChanged", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "", "", "", "org.eclipse.core.runtime.IStatus"), 1225);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "org.eclipse.jdt.core.JavaModelException:", "e:"), 1352);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "superInterfacesChanged", "org.eclipse.ajdt.internal.ui.wizards.NewTypeWizardPage", "", "", "", "org.eclipse.core.runtime.IStatus"), 1326);
    }

    public static class ImportsManager
    implements IImportsStructure {
        private ImportsStructure fImportsStructure;
        private Set fAddedTypes;

        ImportsManager(IImportsStructure importsStructure) {
            this.fImportsStructure = (ImportsStructure)importsStructure;
        }

        ImportsManager(ICompilationUnit createdWorkingCopy) throws CoreException {
            this(createdWorkingCopy, new HashSet());
        }

        ImportsManager(ICompilationUnit createdWorkingCopy, Set addedTypes) throws CoreException {
            IPreferenceStore store = PreferenceConstants.getPreferenceStore();
            String[] prefOrder = JavaPreferencesSettings.getImportOrderPreference((IPreferenceStore)store);
            int threshold = JavaPreferencesSettings.getImportNumberThreshold((IPreferenceStore)store);
            this.fAddedTypes = addedTypes;
            this.fImportsStructure = new ImportsStructure(createdWorkingCopy, prefOrder, threshold, true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsStructure.getCompilationUnit();
        }

        public String addImport(String qualifiedTypeName) {
            this.fAddedTypes.add(qualifiedTypeName);
            return this.fImportsStructure.addImport(qualifiedTypeName);
        }

        void create(boolean needsSave, SubProgressMonitor monitor) throws CoreException {
            this.fImportsStructure.create(needsSave, (IProgressMonitor)monitor);
        }

        void removeImport(String qualifiedName) {
            if (this.fAddedTypes.contains(qualifiedName)) {
                this.fImportsStructure.removeImport(qualifiedName);
            }
        }

        Set getAddedTypes() {
            return this.fAddedTypes;
        }
    }

    private class InterfacesListLabelProvider
    extends LabelProvider {
        private Image fInterfaceImage = JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");

        public Image getImage(Object element) {
            return this.fInterfaceImage;
        }
    }

    private class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        TypeFieldsAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            NewTypeWizardPage.this.typePageChangeControlPressed(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            NewTypeWizardPage.this.typePageCustomButtonPressed((DialogField)field, index);
        }

        public void selectionChanged(ListDialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeWizardPage.this.typePageDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
        }
    }
}

