/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.ajdt.exports.AJBuildScriptGenerator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.build.ClasspathHelper;
import org.eclipse.pde.internal.ui.wizards.exports.PluginExportJob;

public class AJPluginExportJob
extends PluginExportJob {
    private String fDevProperties;

    public AJPluginExportJob(int exportType, boolean exportSource, String destination, String zipFileName, Object[] items) {
        super(exportType, exportSource, destination, zipFileName, items);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExport(String featureID, String version, String featureLocation, String os, String ws, String arch, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        monitor.beginTask("", 5);
        monitor.setTaskName(PDEPlugin.getResourceString((String)"FeatureExportJob.taskName"));
        try {
            HashMap properties = this.createBuildProperties(os, ws, arch);
            this.makeScript(featureID, version, os, ws, arch, featureLocation);
            monitor.worked(1);
            this.runScript(this.getBuildScriptName(featureLocation), this.getBuildExecutionTargets(), properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            this.runScript(this.getAssemblyScriptName(featureID, os, ws, arch, featureLocation), new String[]{"main"}, properties, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        monitor.done();
    }

    private String getBuildScriptName(String featureLocation) {
        return String.valueOf(featureLocation) + '/' + "build.xml";
    }

    private String[] getBuildExecutionTargets() {
        if (this.fExportSource && this.fExportType != 2) {
            return new String[]{"build.jars", "build.sources", "gather.logs"};
        }
        return new String[]{"build.jars", "gather.logs"};
    }

    private String getDevProperties() {
        if (this.fDevProperties == null) {
            this.fDevProperties = ClasspathHelper.getDevEntriesProperties((String)(String.valueOf(this.fBuildTempLocation) + "/dev.properties"), (boolean)false);
        }
        return this.fDevProperties;
    }

    private void makeScript(String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        AJBuildScriptGenerator generator = new AJBuildScriptGenerator();
        generator.setBuildingOSGi(PDECore.getDefault().getModelManager().isOSGiRuntime());
        generator.setChildren(true);
        generator.setWorkingDirectory(featureLocation);
        generator.setDevEntries(this.getDevProperties());
        generator.setElements(new String[]{"feature@" + featureID + (versionId == null ? "" : ":" + versionId)});
        generator.setPluginPath(this.getPaths());
        String format = this.fExportType == 0 ? (Platform.getOS().equals("macosx") ? "tarGz" : "antZip") : "folder";
        BuildScriptGenerator.setOutputFormat((String)format);
        BuildScriptGenerator.setForceUpdateJar((this.fExportType == 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setEmbeddedSource((this.fExportSource && this.fExportType != 2 ? 1 : 0) != 0);
        BuildScriptGenerator.setConfigInfo((String)(String.valueOf(os) + "," + ws + "," + arch));
        generator.generate();
    }
}

