/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.exports;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.exports.AJModelBuildScriptGenerator;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.SourceFeatureWriter;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;

public class AJFeatureBuildScriptGenerator
extends FeatureBuildScriptGenerator {
    protected boolean analyseIncludedFeatures = false;
    protected boolean analysePlugins = true;
    protected boolean sourceFeatureGeneration = false;
    protected boolean binaryFeature = true;
    private boolean scriptGeneration = true;
    protected String featureIdentifier;
    protected String searchedVersion;
    protected IFeature feature;
    protected String featureFullName;
    protected String featureFolderName;
    protected String featureRootLocation;
    protected String featureTempFolder;
    protected Feature sourceFeature;
    protected PluginEntry sourcePlugin;
    protected String sourceFeatureFullName;
    protected String sourceFeatureFullNameVersionned;
    protected SourceFeatureInformation sourceToGather;
    protected boolean sourcePluginOnly = false;
    private String[] extraPlugins = new String[0];
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;

    public AJFeatureBuildScriptGenerator() {
    }

    public AJFeatureBuildScriptGenerator(String featureId, String versionId, AssemblyInformation informationGathering) throws CoreException {
        if (featureId == null) {
            String message = Policy.bind((String)"error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        this.featureIdentifier = featureId;
        this.searchedVersion = versionId;
        this.assemblyData = informationGathering;
    }

    protected List computeElements() throws CoreException {
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(5);
        IPluginEntry[] pluginList = this.feature.getPluginEntries();
        int i = 0;
        while (i < pluginList.length) {
            IPluginEntry entry = pluginList[i];
            VersionedIdentifier identifier = entry.getVersionedIdentifier();
            String versionRequested = identifier.getVersion().toString();
            BundleDescription model = this.getSite(false).getRegistry().getResolvedBundle(identifier.getIdentifier(), versionRequested);
            if (model == null && this.getBuildProperties().containsKey("generate.plugin@" + identifier.getIdentifier())) {
                this.generateEmbeddedSource(identifier.getIdentifier());
                model = this.getSite(false).getRegistry().getResolvedBundle(identifier.getIdentifier(), versionRequested);
            }
            if (model == null) {
                String message = Policy.bind((String)"exception.missingPlugin", (String)entry.getVersionedIdentifier().toString());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
            }
            result.add(model);
            this.collectElementToAssemble(pluginList[i]);
            this.collectSourcePlugins(pluginList[i], model);
            ++i;
        }
        return result;
    }

    private void generateEmbeddedSource(String pluginId) throws CoreException {
        AJFeatureBuildScriptGenerator featureGenerator = new AJFeatureBuildScriptGenerator(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.plugin@" + pluginId))[0], null, this.assemblyData);
        featureGenerator.setGenerateIncludedFeatures(false);
        featureGenerator.setAnalyseChildren(this.analysePlugins);
        featureGenerator.setSourceFeatureGeneration(true);
        featureGenerator.setExtraPlugins(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.plugin@" + pluginId)));
        featureGenerator.setBinaryFeatureGeneration(false);
        featureGenerator.setScriptGeneration(false);
        featureGenerator.setPluginPath(this.pluginPath);
        featureGenerator.setBuildSiteFactory(this.siteFactory);
        featureGenerator.setDevEntries(this.devEntries);
        featureGenerator.setCompiledElements(this.getCompiledElements());
        featureGenerator.setSourceToGather(this.sourceToGather);
        featureGenerator.setSourcePluginOnly(true);
        featureGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
        featureGenerator.generate();
    }

    public void setSourcePluginOnly(boolean b) {
        this.sourcePluginOnly = b;
    }

    private void collectSourcePlugins(IPluginEntry pluginEntry, BundleDescription model) {
        if (!this.sourceFeatureGeneration) {
            return;
        }
        if (pluginEntry.getOS() == null && pluginEntry.getWS() == null && pluginEntry.getOSArch() == null) {
            this.sourceToGather.addElementEntry(Config.genericConfig(), model);
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)pluginEntry);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            this.sourceToGather.addElementEntry((Config)iter.next(), model);
        }
    }

    public void setAnalyseChildren(boolean generate) {
        this.analysePlugins = generate;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generate() throws CoreException {
        if (AbstractScriptGenerator.workingDirectory == null) {
            String message = Policy.bind((String)"error.missingInstallLocation");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 2, message, null));
        }
        this.initializeVariables();
        String custom = (String)this.getBuildProperties().get("custom");
        if ("true".equalsIgnoreCase(custom)) {
            File buildFile = new File(this.featureRootLocation, "build.xml");
            try {
                this.updateVersion(buildFile, "feature.version.suffix", this.feature.getVersionedIdentifier().getVersion().toString());
                return;
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                IOException e = iOException;
                String message = Policy.bind((String)"exception.writeScript", (String)buildFile.toString());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, message, (Throwable)e));
            }
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeature();
        }
        if (this.analysePlugins) {
            this.generateChildrenScripts();
        }
        if (this.sourceFeatureGeneration) {
            this.addSourceFragmentsToFeature();
            this.writeSourceFeature();
        }
        if (!this.sourcePluginOnly) {
            this.collectElementToAssemble(this.feature);
        }
        if (this.analyseIncludedFeatures) {
            this.generateIncludedFeatureBuildFile();
        }
        if (this.sourceFeatureGeneration) {
            this.generateSourceFeatureScripts();
        }
        if (!this.scriptGeneration) return;
        this.openScript(this.featureRootLocation, "build.xml");
        try {
            this.generateBuildScript();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.closeScript();
            throw throwable;
        }
        {
            Object var3_6 = null;
        }
        this.closeScript();
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < referencedFeatures.length) {
            String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
            boolean doSourceFeatureGeneration = this.getBuildProperties().containsKey("generate.feature@" + featureId);
            AJFeatureBuildScriptGenerator generator = new AJFeatureBuildScriptGenerator(doSourceFeatureGeneration ? Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.feature@" + featureId))[0] : featureId, null, this.assemblyData);
            generator.setGenerateIncludedFeatures(!doSourceFeatureGeneration);
            generator.setAnalyseChildren(this.analysePlugins);
            generator.setSourceFeatureGeneration(doSourceFeatureGeneration);
            generator.setBinaryFeatureGeneration(!doSourceFeatureGeneration);
            generator.setScriptGeneration(!doSourceFeatureGeneration);
            if (doSourceFeatureGeneration) {
                generator.setExtraPlugins(Utils.getArrayFromString((String)this.getBuildProperties().getProperty("generate.feature@" + featureId)));
            }
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setDevEntries(this.devEntries);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setSourceToGather(new SourceFeatureInformation());
            generator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
            generator.generate();
            ++i;
        }
    }

    protected void setExtraPlugins(String[] plugins) {
        this.extraPlugins = plugins;
    }

    private void generateBuildScript() throws CoreException {
        if (BundleHelper.getDefault().isDebugging()) {
            System.out.println("Generating feature " + this.featureFullName);
        }
        this.generatePrologue();
        this.generateAllPluginsTarget();
        this.generateAllFeaturesTarget();
        this.generateUpdateFeatureFile();
        this.generateAllChildrenTarget();
        this.generateChildrenTarget();
        this.generateBuildJarsTarget();
        this.generateBuildZipsTarget();
        this.generateBuildUpdateJarTarget();
        this.generateGatherBinPartsTarget();
        this.generateZipDistributionWholeTarget();
        this.generateZipSourcesTarget();
        this.generateZipLogsTarget();
        this.generateCleanTarget();
        this.generateRefreshTarget();
        this.generateGatherSourcesTarget();
        this.generateGatherLogsTarget();
        this.generateEpilogue();
    }

    private void generateGatherSourcesTarget() {
        this.script.printTargetDeclaration("gather.sources", null, null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("destination.temp.folder", String.valueOf(this.getPropertyFormat("feature.temp.folder")) + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        params.put("target", "gather.sources");
        this.script.printAntCallTask("children", null, params);
        this.script.printTargetEnd();
    }

    private void generateGatherLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("gather.logs", "init", null, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", params);
        this.script.printTargetEnd();
    }

    private void generateUpdateFeatureFile() {
        this.script.printTargetDeclaration("update.feature", "init", null, null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildZipsTarget() throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties();
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(zipName, (String)entry.getValue());
        }
        this.script.println();
        this.script.printTargetDeclaration("build.zips", "init" + zips.toString(), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "build.zips");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateZipIndividualTarget(String zipName, String source) {
        this.script.println();
        this.script.printTargetDeclaration(zipName, "init", null, null, null);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("basedir")) + '/' + zipName, String.valueOf(this.getPropertyFormat("basedir")) + '/' + source, false, false, null);
        this.script.printTargetEnd();
    }

    private void generateCleanTarget() {
        this.script.println();
        this.script.printTargetDeclaration("clean", "init", null, null, Policy.bind((String)"build.feature.clean", (String)this.featureIdentifier));
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".jar", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".bin.dist.zip", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".log.zip", null);
        this.script.printDeleteTask(null, String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".src.zip", null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "clean");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateZipLogsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.logs", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(this.featureTempFolder).append("plugins").toString());
        this.script.printAntCallTask("all.children", "false", params);
        IPath destination = new Path(this.getPropertyFormat("feature.destination")).append(String.valueOf(this.featureFullName) + ".log.zip");
        this.script.printZipTask(destination.toString(), this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipSourcesTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.sources", "init", null, null, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("include.children", "true");
        params.put("target", "gather.sources");
        params.put("destination.temp.folder", String.valueOf(this.featureTempFolder) + '/' + "plugins" + '/' + this.sourceFeatureFullNameVersionned + '/' + "src");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".src.zip", this.featureTempFolder, true, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateGatherBinPartsTarget() throws CoreException {
        this.script.println();
        this.script.printTargetDeclaration("gather.bin.parts", "init", "feature.base", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.bin.parts");
        params.put("destination.temp.folder", new Path(this.getPropertyFormat("feature.base")).append("plugins").toString());
        this.script.printAntCallTask("children", null, params);
        String include = (String)this.getBuildProperties().get("bin.includes");
        String exclude = (String)this.getBuildProperties().get("bin.excludes");
        String root = String.valueOf(this.getPropertyFormat("feature.base")) + '/' + this.featureFolderName;
        if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase("folder") && include != null) {
            this.script.printMkdirTask(root);
        }
        if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase("antzip") && AbstractScriptGenerator.outputFormat.equalsIgnoreCase("zip") && include != null) {
            this.script.printMkdirTask(root);
        }
        if (include != null) {
            if (include != null || exclude != null) {
                FileSet fileSet = new FileSet(this.getPropertyFormat("basedir"), null, include, null, exclude, null, null);
                this.script.printCopyTask(null, root, new FileSet[]{fileSet}, true);
            }
            String featureVersionInfo = "";
            IIncludedFeatureReference[] includedFeatures = this.feature.getRawIncludedFeatureReferences();
            int i = 0;
            while (i < includedFeatures.length) {
                String versionId = includedFeatures[i].getVersionedIdentifier().getVersion().toString();
                IFeature includedFeature = this.getSite(false).findFeature(includedFeatures[i].getVersionedIdentifier().getIdentifier(), versionId, true);
                VersionedIdentifier includedFeatureVersionId = includedFeature.getVersionedIdentifier();
                featureVersionInfo = String.valueOf(featureVersionInfo) + includedFeatureVersionId.getIdentifier() + ',' + includedFeatureVersionId.getVersion().toString() + ',';
                ++i;
            }
            String pluginVersionInfo = "";
            IPluginEntry[] pluginsIncluded = this.feature.getRawPluginEntries();
            int i2 = 0;
            while (i2 < pluginsIncluded.length) {
                VersionedIdentifier identifier = pluginsIncluded[i2].getVersionedIdentifier();
                String versionRequested = identifier.getVersion().toString();
                String entryIdentifier = identifier.getIdentifier();
                BundleDescription model = this.getSite(false).getRegistry().getResolvedBundle(entryIdentifier, versionRequested);
                if (model != null) {
                    pluginVersionInfo = String.valueOf(pluginVersionInfo) + entryIdentifier + ',' + model.getVersion() + ',';
                }
                ++i2;
            }
            this.script.println("<eclipse.idReplacer featureFilePath=\"" + root + '/' + "feature.xml" + "\"  selfVersion=\"" + this.feature.getVersionedIdentifier().getVersion() + "\" featureIds=\"" + featureVersionInfo + "\" pluginIds=\"" + pluginVersionInfo + "\"/>");
        }
        this.generateRootFilesAndPermissionsCalls();
        this.script.printTargetEnd();
        this.generateRootFilesAndPermissions();
    }

    private void generateRootFilesAndPermissionsCalls() {
        this.script.printAntCallTask("rootFiles" + this.getPropertyFormat("os") + '_' + this.getPropertyFormat("ws") + '_' + this.getPropertyFormat("arch"), null, null);
    }

    private void generateRootFilesAndPermissions() throws CoreException {
        Iterator iter = AJFeatureBuildScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            Config aConfig = (Config)iter.next();
            this.script.printTargetDeclaration("rootFiles" + aConfig.toString("_"), null, null, null, null);
            this.generateCopyRootFiles(aConfig);
            this.generatePermissions(aConfig);
            this.script.printTargetEnd();
        }
    }

    private void generateCopyRootFiles(Config aConfig) throws CoreException {
        String baseList = this.getBuildProperties().getProperty("root", "");
        String fileList = this.getBuildProperties().getProperty("root." + aConfig.toString("."), "");
        fileList = String.valueOf(fileList.length() == 0 ? "" : String.valueOf(fileList) + ',') + baseList;
        if (fileList.equals("")) {
            return;
        }
        this.assemblyData.addRootFileProvider(aConfig, this.feature);
        String configName = aConfig.toStringReplacingAny(".", "ANY");
        this.script.printMkdirTask(String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configName + '/' + this.getPropertyFormat("collectingFolder"));
        String[] files = Utils.getArrayFromString((String)fileList, (String)",");
        FileSet[] fileSet = new FileSet[files.length];
        int i = 0;
        while (i < files.length) {
            String fromDir = String.valueOf(this.getPropertyFormat("basedir")) + '/';
            String file = files[i];
            if (file.startsWith("absolute:")) {
                file = file.substring(9);
                fromDir = "";
            }
            if (file.startsWith("file:")) {
                Path target = new Path(file.substring(5));
                fileSet[i] = new FileSet(String.valueOf(fromDir) + target.removeLastSegments(1), null, target.lastSegment(), null, null, null, null);
            } else {
                fileSet[i] = new FileSet(String.valueOf(fromDir) + file, null, "**", null, null, null, null);
            }
            ++i;
        }
        this.script.printCopyTask(null, String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configName + '/' + this.getPropertyFormat("collectingFolder"), fileSet, true);
    }

    private void generatePermissions(Config aConfig) throws CoreException {
        String configInfix = aConfig.toString(".");
        Properties featureProperties = this.getBuildProperties();
        String prefixPermissions = "root." + configInfix + '.' + "permissions" + '.';
        String prefixLinks = "root." + configInfix + '.' + "link";
        String commonPermissions = "root.permissions.";
        String commonLinks = "root.link";
        Iterator<Map.Entry<Object, Object>> iter = featureProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> permission = iter.next();
            String instruction = (String)permission.getKey();
            String parameters = (String)permission.getValue();
            if (instruction.startsWith(prefixPermissions)) {
                this.generateChmodInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configInfix + '/' + this.getPropertyFormat("collectingFolder"), instruction.substring(prefixPermissions.length()), parameters);
                continue;
            }
            if (instruction.startsWith(prefixLinks)) {
                this.generateLinkInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configInfix + '/' + this.getPropertyFormat("collectingFolder"), parameters);
                continue;
            }
            if (instruction.startsWith(commonPermissions)) {
                this.generateChmodInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configInfix + '/' + this.getPropertyFormat("collectingFolder"), instruction.substring(commonPermissions.length()), parameters);
                continue;
            }
            if (!instruction.startsWith(commonLinks)) continue;
            this.generateLinkInstruction(String.valueOf(this.getPropertyFormat("feature.base")) + '/' + configInfix + '/' + this.getPropertyFormat("collectingFolder"), parameters);
        }
    }

    private void generateChmodInstruction(String dir, String rights, String files) {
        if (rights.equals("executable")) {
            rights = "755";
        }
        this.script.printChmod(dir, rights, files);
    }

    private void generateLinkInstruction(String dir, String files) {
        String[] links = Utils.getArrayFromString((String)files, (String)",");
        ArrayList<String> arguments = new ArrayList<String>(2);
        int i = 0;
        while (i < links.length) {
            arguments.add("-s");
            arguments.add(links[i]);
            arguments.add(links[i + 1]);
            this.script.printExecTask("ln", dir, arguments, "Linux");
            arguments.clear();
            i += 2;
        }
    }

    private void generateBuildUpdateJarTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.update.jar", "init", null, null, Policy.bind((String)"build.feature.buildUpdateJar", (String)this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.update.jar");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printProperty("feature.base", this.featureTempFolder);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        params.clear();
        params.put("feature.base", this.featureTempFolder);
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", "false", params);
        this.script.printJarTask(String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".jar", String.valueOf(this.featureTempFolder) + '/' + this.featureFolderName);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    protected void generateZipDistributionWholeTarget() {
        this.script.println();
        this.script.printTargetDeclaration("zip.distribution", "init", null, null, Policy.bind((String)"build.feature.zips", (String)this.featureIdentifier));
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printMkdirTask(this.featureTempFolder);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("feature.base", this.featureTempFolder);
        params.put("include.children", "true");
        params.put("os", this.feature.getOS() == null ? Config.ANY : this.feature.getOS());
        params.put("ws", this.feature.getWS() == null ? Config.ANY : this.feature.getWS());
        params.put("arch", this.feature.getOSArch() == null ? Config.ANY : this.feature.getOSArch());
        params.put("nl", this.feature.getNL() == null ? Config.ANY : this.feature.getNL());
        this.script.printAntCallTask("gather.bin.parts", null, params);
        this.script.printZipTask(String.valueOf(this.getPropertyFormat("feature.destination")) + '/' + this.featureFullName + ".bin.dist.zip", this.featureTempFolder, false, false, null);
        this.script.printDeleteTask(this.featureTempFolder, null, null);
        this.script.printTargetEnd();
    }

    private void generateAllChildrenTarget() {
        StringBuffer depends = new StringBuffer();
        depends.append("init");
        depends.append(',');
        depends.append("all.features");
        depends.append(',');
        depends.append("all.plugins");
        depends.append(',');
        depends.append("update.feature");
        this.script.println();
        this.script.printTargetDeclaration("all.children", depends.toString(), null, null, null);
        this.script.printTargetEnd();
    }

    protected void generateAllPluginsTarget() throws CoreException {
        List plugins = this.computeElements();
        plugins = Utils.extractPlugins((List)this.getSite(false).getRegistry().getSortedBundles(), (List)plugins);
        this.script.println();
        this.script.printTargetDeclaration("all.plugins", "init", null, null, null);
        HashSet<BundleDescription> writtenCalls = new HashSet<BundleDescription>(plugins.size());
        Iterator iter = plugins.iterator();
        while (iter.hasNext()) {
            BundleDescription current = (BundleDescription)iter.next();
            if (writtenCalls.contains(current)) continue;
            writtenCalls.add(current);
            IPluginEntry[] entries = Utils.getPluginEntry((IFeature)this.feature, (String)current.getSymbolicName(), (boolean)false);
            int j = 0;
            while (j < entries.length) {
                List list = this.selectConfigs((IPlatformEnvironment)entries[j]);
                if (list.size() != 0) {
                    HashMap<String, String> params = null;
                    Config aMatchingConfig = (Config)list.get(0);
                    params = new HashMap<String, String>(3);
                    if (!aMatchingConfig.getOs().equals(Config.ANY)) {
                        params.put("os", aMatchingConfig.getOs());
                    }
                    if (!aMatchingConfig.getWs().equals(Config.ANY)) {
                        params.put("ws", aMatchingConfig.getWs());
                    }
                    if (!aMatchingConfig.getArch().equals(Config.ANY)) {
                        params.put("arch", aMatchingConfig.getArch());
                    }
                    IPath location = Utils.makeRelative((IPath)new Path(this.getLocation(current)), (IPath)new Path(this.featureRootLocation));
                    this.script.printAntTask("build.xml", location.toString(), this.getPropertyFormat("target"), null, null, params);
                }
                ++j;
            }
        }
        this.script.printTargetEnd();
    }

    private void generateAllFeaturesTarget() throws CoreException {
        this.script.printTargetDeclaration("all.features", "init", null, null, null);
        if (this.analyseIncludedFeatures) {
            IIncludedFeatureReference[] features = this.feature.getIncludedFeatureReferences();
            int i = 0;
            while (i < features.length) {
                String featureId = features[i].getVersionedIdentifier().getIdentifier();
                String versionId = features[i].getVersionedIdentifier().getVersion().toString();
                IFeature includedFeature = this.getSite(false).findFeature(featureId, versionId, false);
                String includedFeatureDirectory = includedFeature.getURL().getPath();
                int j = includedFeatureDirectory.lastIndexOf("feature.xml");
                if (j != -1) {
                    includedFeatureDirectory = includedFeatureDirectory.substring(0, j);
                }
                IPath location = Utils.makeRelative((IPath)new Path(includedFeatureDirectory), (IPath)new Path(this.featureRootLocation));
                this.script.printAntTask("build.xml", location.toString(), this.getPropertyFormat("target"), null, null, null);
                ++i;
            }
        }
        this.script.printTargetEnd();
    }

    private void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration(this.feature.getVersionedIdentifier().getIdentifier(), "build.update.jar", ".");
        this.script.println();
        this.script.printTargetDeclaration("init", null, null, null, null);
        this.script.printProperty("feature.temp.folder", String.valueOf(this.getPropertyFormat("basedir")) + '/' + "feature.temp.folder");
        this.script.printProperty("feature.destination", this.getPropertyFormat("basedir"));
        this.script.printTargetEnd();
    }

    private void generateChildrenScripts() throws CoreException {
        List plugins = this.computeElements();
        this.generateModels(Utils.extractPlugins((List)this.getSite(false).getRegistry().getSortedBundles(), (List)plugins));
    }

    private void generateModels(List models) throws CoreException {
        if (!this.scriptGeneration) {
            return;
        }
        if (!this.binaryFeature || models.isEmpty()) {
            return;
        }
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            BundleDescription model = (BundleDescription)iterator.next();
            AJModelBuildScriptGenerator generator = new AJModelBuildScriptGenerator();
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setModel(model);
            generator.setFeatureGenerator(this);
            generator.setPluginPath(this.getPluginPath());
            generator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
            generator.setDevEntries(this.devEntries);
            generator.generate();
        }
    }

    public void setFeature(String featureID) throws CoreException {
        if (featureID == null) {
            String message = Policy.bind((String)"error.missingFeatureId");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, message, null));
        }
        this.featureIdentifier = featureID;
    }

    private void initializeVariables() throws CoreException {
        this.feature = this.getSite(false).findFeature(this.featureIdentifier, this.searchedVersion, true);
        if (this.featureRootLocation == null) {
            this.featureRootLocation = this.feature.getURL().getPath();
            int i = this.featureRootLocation.lastIndexOf("feature.xml");
            if (i != -1) {
                this.featureRootLocation = this.featureRootLocation.substring(0, i);
            }
        }
        this.featureFullName = this.feature.getVersionedIdentifier().toString();
        this.featureFolderName = "features/" + this.featureFullName;
        this.sourceFeatureFullName = this.computeSourceFeatureName(this.feature, false);
        this.sourceFeatureFullNameVersionned = this.computeSourceFeatureName(this.feature, true);
        this.featureTempFolder = this.getPropertyFormat("feature.temp.folder");
    }

    private String computeSourceFeatureName(IFeature featureForName, boolean withNumber) throws CoreException {
        String sourceFeatureName = this.getBuildProperties().getProperty("sourceFeature.name");
        if (sourceFeatureName == null) {
            sourceFeatureName = String.valueOf(featureForName.getVersionedIdentifier().getIdentifier()) + ".source";
        }
        return String.valueOf(sourceFeatureName) + (withNumber ? "_" + featureForName.getVersionedIdentifier().getVersion().toString() : "");
    }

    protected Properties getBuildProperties() throws CoreException {
        if (this.buildProperties == null) {
            this.buildProperties = AJFeatureBuildScriptGenerator.readProperties((String)this.featureRootLocation, (String)"build.properties", (int)2);
        }
        return this.buildProperties;
    }

    private void generateChildrenTarget() {
        this.script.println();
        this.script.printTargetDeclaration("children", null, "include.children", null, null);
        this.script.printAntCallTask("all.children", null, null);
        this.script.printTargetEnd();
    }

    private void generateBuildJarsTarget() {
        this.script.println();
        this.script.printTargetDeclaration("build.jars", "init", null, null, Policy.bind((String)"build.feature.buildJars", (String)this.featureIdentifier));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.jars");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
        this.script.println();
        this.script.printTargetDeclaration("build.sources", "init", null, null, null);
        params.clear();
        params.put("target", "build.sources");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    private void generateRefreshTarget() {
        this.script.println();
        this.script.printTargetDeclaration("refresh", "init", "eclipse.running", null, Policy.bind((String)"build.feature.refresh", (String)this.featureIdentifier));
        this.script.printConvertPathTask(new Path(this.featureRootLocation).removeLastSegments(0).toOSString().replace('\\', '/'), "resourcePath", false);
        this.script.printRefreshLocalTask(this.getPropertyFormat("resourcePath"), "infinite");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "refresh");
        this.script.printAntCallTask("all.children", null, params);
        this.script.printTargetEnd();
    }

    public void setGenerateIncludedFeatures(boolean recursiveGeneration) {
        this.analyseIncludedFeatures = recursiveGeneration;
    }

    protected void collectElementToAssemble(IFeature featureToCollect) throws CoreException {
        if (this.assemblyData == null || this.getBuildProperties().get("bin.includes") == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)featureToCollect);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }

    private void generateSourceFeature() throws CoreException {
        Feature featureExample = (Feature)this.feature;
        this.sourceFeature = this.createSourceFeature(featureExample);
        this.associateExtraPlugins();
        this.sourcePlugin = this.createSourcePlugin();
        this.generateSourceFragment();
    }

    private void generateSourceFragment() throws CoreException {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals((Object)Config.genericConfig())) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = String.valueOf(this.sourceFeature.getFeatureIdentifier()) + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            this.createSourceFragment(sourceFragment, this.sourcePlugin);
        }
    }

    private void addSourceFragmentsToFeature() {
        Map fragments = this.sourceToGather.getElementEntries();
        Iterator iter = fragments.entrySet().iterator();
        while (iter.hasNext()) {
            Set sourceList;
            Map.Entry fragmentInfo = iter.next();
            Config configInfo = (Config)fragmentInfo.getKey();
            if (configInfo.equals((Object)Config.genericConfig()) || (sourceList = (Set)fragmentInfo.getValue()).size() == 0) continue;
            PluginEntry sourceFragment = new PluginEntry();
            String sourceFragmentId = String.valueOf(this.sourceFeature.getFeatureIdentifier()) + "." + configInfo.toString(".");
            sourceFragment.setPluginIdentifier(sourceFragmentId);
            sourceFragment.setPluginVersion(this.sourceFeature.getFeatureVersion());
            sourceFragment.setOS(configInfo.getOs());
            sourceFragment.setWS(configInfo.getWs());
            sourceFragment.setArch(configInfo.getArch());
            sourceFragment.isFragment(true);
            this.sourceFeature.addPluginEntryModel((PluginEntryModel)sourceFragment);
        }
    }

    private void generateSourceFeatureScripts() throws CoreException {
        AJFeatureBuildScriptGenerator sourceScriptGenerator = new AJFeatureBuildScriptGenerator(this.sourceFeatureFullName, null, this.assemblyData);
        sourceScriptGenerator.setGenerateIncludedFeatures(false);
        sourceScriptGenerator.setAnalyseChildren(true);
        sourceScriptGenerator.setSourceToGather(this.sourceToGather);
        sourceScriptGenerator.setBinaryFeatureGeneration(true);
        sourceScriptGenerator.setSourceFeatureGeneration(false);
        sourceScriptGenerator.setScriptGeneration(true);
        sourceScriptGenerator.setPluginPath(this.pluginPath);
        sourceScriptGenerator.setBuildSiteFactory(this.siteFactory);
        sourceScriptGenerator.setDevEntries(this.devEntries);
        sourceScriptGenerator.setCompiledElements(this.getCompiledElements());
        sourceScriptGenerator.setSourcePluginOnly(this.sourcePluginOnly);
        sourceScriptGenerator.setBuildingOSGi(AJFeatureBuildScriptGenerator.isBuildingOSGi());
        sourceScriptGenerator.generate();
    }

    private void associateExtraPlugins() throws CoreException {
        int i = 1;
        while (i < this.extraPlugins.length) {
            BundleDescription model = this.getSite(false).getRegistry().getResolvedBundle(this.extraPlugins[i].startsWith("plugin@") ? this.extraPlugins[i].substring(7) : this.extraPlugins[i].substring(8));
            if (model == null) {
                String message = Policy.bind((String)"exception.missingPlugin", (String)this.extraPlugins[i]);
                BundleHelper.getDefault().getLog().log((IStatus)new Status(2, this.extraPlugins[i], 5, message, null));
            } else {
                PluginEntry entry = new PluginEntry();
                entry.setPluginIdentifier(model.getSymbolicName());
                entry.setPluginVersion(model.getVersion().toString());
                this.sourceFeature.addPluginEntryModel((PluginEntryModel)entry);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginEntry createSourcePlugin() throws CoreException {
        StringBuffer buffer;
        PluginEntry result = new PluginEntry();
        String sourcePluginId = this.sourceFeature.getFeatureIdentifier();
        result.setPluginIdentifier(sourcePluginId);
        result.setPluginVersion(this.sourceFeature.getFeatureVersion());
        this.sourceFeature.addPluginEntryModel((PluginEntryModel)result);
        Path sourcePluginDirURL = new Path(String.valueOf(AbstractScriptGenerator.workingDirectory) + '/' + "plugins" + '/' + this.getSourcePluginName(result, false));
        File sourcePluginDir = sourcePluginDirURL.toFile();
        sourcePluginDir.mkdir();
        Path templatePluginXML = new Path("templates/plugin/plugin.xml");
        URL templatePluginURL = BundleHelper.getDefault().find((IPath)templatePluginXML);
        if (templatePluginURL == null) {
            Status status = new Status(2, "org.eclipse.pde.build", 10, Policy.bind((String)"error.readingDirectory", (String)templatePluginURL.toExternalForm()), null);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
        try {
            buffer = this.readFile(templatePluginURL.openStream());
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            IOException e1 = iOException;
            String message = Policy.bind((String)"exception.readingFile", (String)templatePluginURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        int beginId = this.scan(buffer, 0, "PLUGIN_ID");
        buffer.replace(beginId, beginId + "PLUGIN_ID".length(), result.getPluginIdentifier());
        beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
        buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), result.getPluginVersion());
        try {
            Utils.transferStreams((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), (OutputStream)new FileOutputStream(sourcePluginDirURL.append("plugin.xml").toOSString()));
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
            IOException e1 = iOException;
            String message = Policy.bind((String)"exception.readingFile", (String)templatePluginURL.toExternalForm());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, message, (Throwable)e1));
        }
        Collection copiedFiles = Utils.copyFiles((String)(String.valueOf(this.featureRootLocation) + '/' + "sourceTemplatePlugin"), (String)sourcePluginDir.getAbsolutePath());
        File buildProperty = sourcePluginDirURL.append("build.properties").toFile();
        if (!buildProperty.exists()) {
            copiedFiles.add("plugin.xml");
            copiedFiles.add("src/**/*.zip");
            Properties sourceBuildProperties = new Properties();
            sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection((Collection)copiedFiles, (String)","));
            sourceBuildProperties.put("sourcePlugin", "true");
            try {
                BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                try {
                    sourceBuildProperties.store(buildFile, null);
                }
                catch (Throwable throwable) {
                    Object var13_23 = null;
                    ((OutputStream)buildFile).close();
                    throw throwable;
                }
                {
                    Object var13_24 = null;
                    ((OutputStream)buildFile).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
                FileNotFoundException e = fileNotFoundException;
                String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_3);
                IOException e = iOException;
                String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
            }
        }
        this.getSite(false).getRegistry().addBundle(sourcePluginDir);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSourceFragment(PluginEntry fragment, PluginEntry plugin) throws CoreException {
        File sourceFragmentDir;
        block9: {
            Path sourceFragmentDirURL = new Path(String.valueOf(AbstractScriptGenerator.workingDirectory) + '/' + "plugins" + '/' + this.getSourcePluginName(fragment, false));
            sourceFragmentDir = new File(sourceFragmentDirURL.toOSString());
            sourceFragmentDir.mkdir();
            try {
                Path fragmentPath = new Path("templates/fragment/fragment.xml");
                URL templateLocation = BundleHelper.getDefault().find((IPath)fragmentPath);
                if (templateLocation == null) {
                    Status status = new Status(2, "org.eclipse.pde.build", 10, Policy.bind((String)"error.readingDirectory", (String)fragmentPath.toString()), null);
                    BundleHelper.getDefault().getLog().log((IStatus)status);
                    return;
                }
                StringBuffer buffer = this.readFile(templateLocation.openStream());
                int beginId = this.scan(buffer, 0, "FRAGMENT_ID");
                buffer.replace(beginId, beginId + "FRAGMENT_ID".length(), fragment.getPluginIdentifier());
                beginId = this.scan(buffer, beginId, "FRAGMENT_VERSION");
                buffer.replace(beginId, beginId + "FRAGMENT_VERSION".length(), fragment.getPluginVersion());
                beginId = this.scan(buffer, beginId, "PLUGIN_ID");
                buffer.replace(beginId, beginId + "PLUGIN_ID".length(), plugin.getPluginIdentifier());
                beginId = this.scan(buffer, beginId, "PLUGIN_VERSION");
                buffer.replace(beginId, beginId + "PLUGIN_VERSION".length(), plugin.getPluginVersion());
                Utils.transferStreams((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), (OutputStream)new FileOutputStream(sourceFragmentDirURL.append("fragment.xml").toOSString()));
                Collection copiedFiles = Utils.copyFiles((String)(String.valueOf(this.featureRootLocation) + '/' + "sourceTemplateFragment"), (String)sourceFragmentDir.getAbsolutePath());
                File buildProperty = sourceFragmentDirURL.append("build.properties").toFile();
                if (buildProperty.exists()) break block9;
                copiedFiles.add("fragment.xml");
                copiedFiles.add("src/**");
                Properties sourceBuildProperties = new Properties();
                sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection((Collection)copiedFiles, (String)","));
                sourceBuildProperties.put("sourcePlugin", "true");
                try {
                    BufferedOutputStream buildFile = new BufferedOutputStream(new FileOutputStream(buildProperty));
                    try {
                        sourceBuildProperties.store(buildFile, null);
                    }
                    catch (Throwable throwable) {
                        Object var13_18 = null;
                        ((OutputStream)buildFile).close();
                        throw throwable;
                    }
                    {
                        Object var13_19 = null;
                        ((OutputStream)buildFile).close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException, (Object)this, ajc$tjp_7, (JoinPoint.StaticPart)ajc$tjp_8);
                    FileNotFoundException e = fileNotFoundException;
                    String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
                catch (IOException iOException) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_8);
                    IOException e = iOException;
                    String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
                }
            }
            catch (IOException iOException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_8);
                String message = Policy.bind((String)"exception.writingFile", (String)sourceFragmentDir.getName());
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, null));
            }
        }
        this.getSite(false).getRegistry().addBundle(sourceFragmentDir);
    }

    public String getSourcePluginName(PluginEntry plugin, boolean versionSuffix) {
        return String.valueOf(plugin.getPluginIdentifier()) + (versionSuffix ? "_" + plugin.getPluginVersion() : "");
    }

    public void setFeatureRootLocation(String featureLocation) {
        this.featureRootLocation = featureLocation;
    }

    public void setSourceToGather(SourceFeatureInformation sourceToGather) {
        this.sourceToGather = sourceToGather;
    }

    public void setSourceFeatureGeneration(boolean sourceFeatureGeneration) {
        this.sourceFeatureGeneration = sourceFeatureGeneration;
    }

    public void setBinaryFeatureGeneration(boolean binaryFeatureGeneration) {
        this.binaryFeature = binaryFeatureGeneration;
    }

    public void setScriptGeneration(boolean scriptGeneration) {
        this.scriptGeneration = scriptGeneration;
    }

    public boolean isSourceFeatureGeneration() {
        return this.sourceFeatureGeneration;
    }

    protected void collectElementToAssemble(IPluginEntry entryToCollect) throws CoreException {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)entryToCollect);
        String versionRequested = entryToCollect.getVersionedIdentifier().getVersion().toString();
        BundleDescription effectivePlugin = null;
        effectivePlugin = this.getSite(false).getRegistry().getResolvedBundle(entryToCollect.getVersionedIdentifier().getIdentifier(), versionRequested);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            this.assemblyData.addPlugin((Config)iter.next(), effectivePlugin);
        }
    }

    private Feature createSourceFeature(Feature featureExample) throws CoreException {
        Feature result = new Feature();
        result.setFeatureIdentifier(this.computeSourceFeatureName((IFeature)featureExample, false));
        result.setFeatureVersion(featureExample.getVersionedIdentifier().getVersion().toString());
        result.setLabel(featureExample.getLabelNonLocalized());
        result.setProvider(featureExample.getProviderNonLocalized());
        result.setImageURLString(featureExample.getImageURLString());
        result.setInstallHandlerModel(featureExample.getInstallHandlerModel());
        result.setDescriptionModel(featureExample.getDescriptionModel());
        result.setCopyrightModel(featureExample.getCopyrightModel());
        result.setLicenseModel(featureExample.getLicenseModel());
        result.setUpdateSiteEntryModel(featureExample.getUpdateSiteEntryModel());
        URLEntryModel[] siteEntries = featureExample.getDiscoverySiteEntryModels();
        result.setDiscoverySiteEntryModels(siteEntries == null || siteEntries.length == 0 ? null : siteEntries);
        result.setOS(featureExample.getOS());
        result.setArch(featureExample.getOSArch());
        result.setWS(featureExample.getWS());
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceFeature() throws CoreException {
        String sourceFeatureDir = String.valueOf(AbstractScriptGenerator.workingDirectory) + '/' + "features" + '/' + this.sourceFeatureFullName;
        File sourceDir = new File(sourceFeatureDir);
        sourceDir.mkdir();
        File file = new File(String.valueOf(sourceFeatureDir) + '/' + "feature.xml");
        try {
            SourceFeatureWriter writer = new SourceFeatureWriter((OutputStream)new FileOutputStream(file), this.sourceFeature, (FeatureBuildScriptGenerator)this);
            try {
                writer.printFeature();
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                writer.close();
            }
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_12);
            IOException e = iOException;
            String message = Policy.bind((String)"error.creatingFeature", (String)this.sourceFeature.getFeatureIdentifier());
            throw new CoreException((IStatus)new Status(0, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        Collection copiedFiles = Utils.copyFiles((String)(String.valueOf(this.featureRootLocation) + '/' + "sourceTemplateFeature"), (String)sourceFeatureDir);
        File buildProperty = new File(String.valueOf(sourceFeatureDir) + '/' + "build.properties");
        if (buildProperty.exists()) {
            this.getSite(false).addFeatureReferenceModel(sourceDir);
            return;
        }
        copiedFiles.add("feature.xml");
        Properties sourceBuildProperties = new Properties();
        sourceBuildProperties.put("bin.includes", Utils.getStringFromCollection((Collection)copiedFiles, (String)","));
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(buildProperty);
            try {
                sourceBuildProperties.store(output, null);
            }
            catch (Throwable throwable) {
                Object var8_16 = null;
                ((OutputStream)output).close();
                throw throwable;
            }
            {
                Object var8_17 = null;
                ((OutputStream)output).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(fileNotFoundException, (Object)this, ajc$tjp_13, (JoinPoint.StaticPart)ajc$tjp_12);
            FileNotFoundException e = fileNotFoundException;
            String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        catch (IOException iOException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_12);
            IOException e = iOException;
            String message = Policy.bind((String)"exception.writingFile", (String)buildProperty.getAbsolutePath());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        this.getSite(false).addFeatureReferenceModel(sourceDir);
    }

    static {
        Factory factory = new Factory("AJFeatureBuildScriptGenerator.java", Class.forName("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e:"), 220);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "generate", "org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "", "", "org.eclipse.core.runtime.CoreException:", "void"), 206);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "<missing>:"), 1105);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e:"), 1214);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "writeSourceFeature", "org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "", "", "org.eclipse.core.runtime.CoreException:", "void"), 1201);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.FileNotFoundException:", "e:"), 1235);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e:"), 1238);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e1:"), 1010);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createSourcePlugin", "org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "", "", "org.eclipse.core.runtime.CoreException:", "org.eclipse.update.core.PluginEntry"), 987);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e1:"), 1021);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.FileNotFoundException:", "e:"), 1041);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e:"), 1044);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.FileNotFoundException:", "e:"), 1097);
        ajc$tjp_8 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "createSourceFragment", "org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "org.eclipse.update.core.PluginEntry:org.eclipse.update.core.PluginEntry:", "fragment:plugin:", "org.eclipse.core.runtime.CoreException:", "void"), 1053);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.exports.AJFeatureBuildScriptGenerator", "java.io.IOException:", "e:"), 1100);
    }
}

