/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.aspectj.ajdt.internal.compiler.AjCompilerAdapter;
import org.aspectj.ajdt.internal.compiler.CompilerAdapter;
import org.aspectj.ajdt.internal.compiler.IBinarySourceProvider;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapter;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapterFactory;
import org.aspectj.ajdt.internal.compiler.IIntermediateResultsRequestor;
import org.aspectj.ajdt.internal.compiler.IOutputClassFileNameProvider;
import org.aspectj.ajdt.internal.compiler.InterimCompilationResult;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.problem.AjProblemReporter;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.AsmHierarchyBuilder;
import org.aspectj.ajdt.internal.core.builder.EclipseAdapterUtils;
import org.aspectj.ajdt.internal.core.builder.StatefulNameEnvironment;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextFormatter;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.Dump;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.core.runtime.OperationCanceledException;

public class AjBuildManager
implements IOutputClassFileNameProvider,
IBinarySourceProvider,
ICompilerAdapterFactory {
    private static final String CROSSREFS_FILE_NAME = "build.lst";
    private static final String CANT_WRITE_RESULT = "unable to write compilation result";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final boolean COPY_INPATH_DIR_RESOURCES = false;
    static final boolean FAIL_IF_RUNTIME_NOT_FOUND = false;
    private static final FileFilter binarySourceFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.getName().endsWith(".class");
        }
    };
    private static AsmHierarchyBuilder asmHierarchyBuilder = new AsmHierarchyBuilder();
    private IProgressListener progressListener = null;
    private int compiledCount;
    private int sourceFileCount;
    private JarOutputStream zos;
    private boolean batchCompile = true;
    private INameEnvironment environment;
    private Map binarySourcesForTheNextCompile = new HashMap();
    private IHierarchy structureModel;
    public AjBuildConfig buildConfig;
    private List aspectNames = new LinkedList();
    AjState state = new AjState(this);
    public CountingMessageHandler handler;

    public BcelWeaver getWeaver() {
        return this.state.getWeaver();
    }

    public BcelWorld getBcelWorld() {
        return this.state.getBcelWorld();
    }

    public AjBuildManager(IMessageHandler holder) {
        this.handler = CountingMessageHandler.makeCountingMessageHandler((IMessageHandler)holder);
    }

    public boolean doGenerateModel() {
        return this.buildConfig.isGenerateModelMode();
    }

    public boolean batchBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.doBuild(buildConfig, baseHandler, true);
    }

    public boolean incrementalBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.doBuild(buildConfig, baseHandler, false);
    }

    /*
     * Exception decompiling
     */
    protected boolean doBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler, boolean batch) throws IOException, AbortException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 8[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean openOutputStream(File outJar) {
        try {
            BufferedOutputStream os = FileUtil.makeOutputStream((File)this.buildConfig.getOutputJar());
            this.zos = new JarOutputStream((OutputStream)os, this.getWeaver().getManifest(true));
        }
        catch (IOException ex) {
            Message message = new Message("Unable to open outjar " + outJar.getPath() + "(" + ex.getMessage() + ")", (ISourceLocation)new SourceLocation(outJar, 0), true);
            this.handler.handleMessage((IMessage)message);
            return false;
        }
        return true;
    }

    private void closeOutputStream(File outJar) {
        try {
            if (this.zos != null) {
                this.zos.close();
            }
            this.zos = null;
            if (this.handler.hasErrors()) {
                outJar.delete();
            }
        }
        catch (IOException ex) {
            Message message = new Message("Unable to write outjar " + outJar.getPath() + "(" + ex.getMessage() + ")", (ISourceLocation)new SourceLocation(outJar, 0), true);
            this.handler.handleMessage((IMessage)message);
        }
    }

    private void copyResourcesToDestination() throws IOException {
        Iterator<Object> i = this.buildConfig.getInJars().iterator();
        while (i.hasNext()) {
            File inJar = (File)i.next();
            this.copyResourcesFromJarFile(inJar);
        }
        i = this.buildConfig.getInpath().iterator();
        while (i.hasNext()) {
            File inPathElement = (File)i.next();
            if (inPathElement.isDirectory()) {
                this.copyResourcesFromDirectory(inPathElement);
                continue;
            }
            this.copyResourcesFromJarFile(inPathElement);
        }
        if (this.buildConfig.getSourcePathResources() != null) {
            i = this.buildConfig.getSourcePathResources().keySet().iterator();
            while (i.hasNext()) {
                String resource = (String)i.next();
                File from = (File)this.buildConfig.getSourcePathResources().get(resource);
                this.copyResourcesFromFile(from, resource, from);
            }
        }
        this.writeManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourcesFromJarFile(File jarFile) throws IOException {
        ZipInputStream inStream = null;
        try {
            ZipEntry entry;
            inStream = new JarInputStream(new FileInputStream(jarFile));
            while ((entry = ((JarInputStream)inStream).getNextEntry()) != null) {
                String filename = entry.getName();
                if (!entry.isDirectory() && this.acceptResource(filename)) {
                    byte[] bytes = FileUtil.readAsByteArray((InputStream)inStream);
                    this.writeResource(filename, bytes, jarFile);
                }
                inStream.closeEntry();
            }
        }
        finally {
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private void copyResourcesFromDirectory(File dir) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourcesFromFile(File f, String filename, File src) throws IOException {
        if (!this.acceptResource(filename)) {
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            byte[] bytes = FileUtil.readAsByteArray((InputStream)fis);
            this.writeResource(filename, bytes, src);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void writeResource(String filename, byte[] content, File srcLocation) throws IOException {
        if (this.state.resources.contains(filename)) {
            Message msg = new Message("duplicate resource: '" + filename + "'", IMessage.WARNING, null, (ISourceLocation)new SourceLocation(srcLocation, 0));
            this.handler.handleMessage((IMessage)msg);
            return;
        }
        if (this.zos != null) {
            ZipEntry newEntry = new ZipEntry(filename);
            this.zos.putNextEntry(newEntry);
            this.zos.write(content);
            this.zos.closeEntry();
        } else {
            BufferedOutputStream fos = FileUtil.makeOutputStream((File)new File(this.buildConfig.getOutputDir(), filename));
            ((OutputStream)fos).write(content);
            ((OutputStream)fos).close();
        }
        this.state.resources.add(filename);
    }

    private void writeManifest() throws IOException {
        Manifest manifest = this.getWeaver().getManifest(false);
        if (manifest != null && this.zos == null) {
            BufferedOutputStream fos = FileUtil.makeOutputStream((File)new File(this.buildConfig.getOutputDir(), MANIFEST_NAME));
            manifest.write(fos);
            ((OutputStream)fos).close();
        }
    }

    private boolean acceptResource(String resourceName) {
        return !resourceName.startsWith("CVS/") && resourceName.indexOf("/CVS/") == -1 && !resourceName.endsWith("/CVS") && !resourceName.endsWith(".class") && !resourceName.toUpperCase().equals(MANIFEST_NAME);
    }

    private void writeOutxmlFile() throws IOException {
        String filename = this.buildConfig.getOutxmlName();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println("<aspectj>");
        ps.println("<aspects>");
        Iterator i = this.aspectNames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            ps.println("<aspect name=\"" + name + "\"/>");
        }
        ps.println("</aspects>");
        ps.println("</aspectj>");
        ps.println();
        ps.close();
        if (this.zos != null) {
            ZipEntry newEntry = new ZipEntry(filename);
            this.zos.putNextEntry(newEntry);
            this.zos.write(baos.toByteArray());
            this.zos.closeEntry();
        } else {
            BufferedOutputStream fos = FileUtil.makeOutputStream((File)new File(this.buildConfig.getOutputDir(), filename));
            ((OutputStream)fos).write(baos.toByteArray());
            ((OutputStream)fos).close();
        }
    }

    private void setupModel(AjBuildConfig config) {
        AsmManager.setCreatingModel((config.isEmacsSymMode() || config.isGenerateModelMode() ? 1 : 0) != 0);
        if (!AsmManager.isCreatingModel()) {
            return;
        }
        AsmManager.getDefault().createNewASM();
        IHierarchy model = AsmManager.getDefault().getHierarchy();
        String rootLabel = "<root>";
        IProgramElement.Kind kind = IProgramElement.Kind.FILE_JAVA;
        if (this.buildConfig.getConfigFile() != null) {
            rootLabel = this.buildConfig.getConfigFile().getName();
            model.setConfigFile(this.buildConfig.getConfigFile().getAbsolutePath());
            kind = IProgramElement.Kind.FILE_LST;
        }
        model.setRoot((IProgramElement)new ProgramElement(rootLabel, kind, new ArrayList()));
        model.setFileMap(new HashMap());
        this.setStructureModel(model);
        this.state.setStructureModel(model);
        this.state.setRelationshipMap(AsmManager.getDefault().getRelationshipMap());
    }

    private void initBcelWorld(IMessageHandler handler) throws IOException {
        List unwovenClasses;
        List cp = this.buildConfig.getBootclasspath();
        cp.addAll(this.buildConfig.getClasspath());
        BcelWorld bcelWorld = new BcelWorld(cp, handler, null);
        bcelWorld.setBehaveInJava5Way(this.buildConfig.getBehaveInJava5Way());
        bcelWorld.setTargetAspectjRuntimeLevel(this.buildConfig.getTargetAspectjRuntimeLevel());
        bcelWorld.setXnoInline(this.buildConfig.isXnoInline());
        bcelWorld.setXlazyTjp(this.buildConfig.isXlazyTjp());
        bcelWorld.setXHasMemberSupportEnabled(this.buildConfig.isXHasMemberEnabled());
        bcelWorld.setPinpointMode(this.buildConfig.isXdevPinpoint());
        BcelWeaver bcelWeaver = new BcelWeaver(bcelWorld);
        this.state.setWorld(bcelWorld);
        this.state.setWeaver(bcelWeaver);
        this.state.binarySourceFiles = new HashMap();
        Iterator i = this.buildConfig.getAspectpath().iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            bcelWeaver.addLibraryJarFile(f);
        }
        if (this.buildConfig.getLintMode().equals("default")) {
            bcelWorld.getLint().loadDefaultProperties();
        } else {
            bcelWorld.getLint().setAll(this.buildConfig.getLintMode());
        }
        if (this.buildConfig.getLintSpecFile() != null) {
            bcelWorld.getLint().setFromProperties(this.buildConfig.getLintSpecFile());
        }
        i = this.buildConfig.getInJars().iterator();
        while (i.hasNext()) {
            File inJar = (File)i.next();
            unwovenClasses = bcelWeaver.addJarFile(inJar, this.buildConfig.getOutputDir(), false);
            this.state.binarySourceFiles.put(inJar.getPath(), unwovenClasses);
        }
        i = this.buildConfig.getInpath().iterator();
        while (i.hasNext()) {
            File inPathElement = (File)i.next();
            if (!inPathElement.isDirectory()) {
                unwovenClasses = bcelWeaver.addJarFile(inPathElement, this.buildConfig.getOutputDir(), true);
                this.state.binarySourceFiles.put(inPathElement.getPath(), unwovenClasses);
                continue;
            }
            File[] binSrcs = FileUtil.listFiles((File)inPathElement, (FileFilter)binarySourceFilter);
            for (int j = 0; j < binSrcs.length; ++j) {
                UnwovenClassFile ucf = bcelWeaver.addClassFile(binSrcs[j], inPathElement, this.buildConfig.getOutputDir());
                ArrayList<UnwovenClassFile> ucfl = new ArrayList<UnwovenClassFile>();
                ucfl.add(ucf);
                this.state.binarySourceFiles.put(binSrcs[j].getPath(), ucfl);
            }
        }
        bcelWeaver.setReweavableMode(this.buildConfig.isXNotReweavable());
        ResolvedType joinPoint = bcelWorld.resolve("org.aspectj.lang.JoinPoint");
        if (joinPoint.isMissing()) {
            Message message = new Message("classpath error: unable to find org.aspectj.lang.JoinPoint (check that aspectjrt.jar is in your classpath)", null, true);
            handler.handleMessage((IMessage)message);
        }
    }

    public World getWorld() {
        return this.getBcelWorld();
    }

    void addAspectClassFilesToWeaver(List addedClassFiles) throws IOException {
        Iterator i = addedClassFiles.iterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i.next();
            this.getWeaver().addClassFile(classFile);
        }
    }

    public FileSystem getLibraryAccess(String[] classpaths, String[] filenames) {
        String defaultEncoding = this.buildConfig.getOptions().defaultEncoding;
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int[] classpathModes = new int[classpaths.length];
        for (int i = 0; i < classpaths.length; ++i) {
            classpathModes[i] = 2;
        }
        return new FileSystem(classpaths, filenames, defaultEncoding, classpathModes);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public CompilationUnit[] getCompilationUnits(String[] filenames, String[] encodings) {
        int fileCount = filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        String defaultEncoding = this.buildConfig.getOptions().defaultEncoding;
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        for (int i = 0; i < fileCount; ++i) {
            String encoding = encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, filenames[i], encoding);
        }
        return units;
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(CharOperation.subarray(fileName, 0, lastIndex));
        }
        return System.getProperty("user.dir");
    }

    public void performCompilation(List files) {
        if (this.progressListener != null) {
            this.compiledCount = 0;
            this.sourceFileCount = files.size();
            this.progressListener.setText("compiling source files");
        }
        String[] filenames = new String[files.size()];
        String[] encodings = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            filenames[i] = ((File)files.get(i)).getPath();
        }
        List cps = this.buildConfig.getFullClasspath();
        Dump.saveFullClasspath((List)cps);
        String[] classpaths = new String[cps.size()];
        for (int i = 0; i < cps.size(); ++i) {
            classpaths[i] = (String)cps.get(i);
        }
        this.environment = this.getLibraryAccess(classpaths, filenames);
        if (!this.state.classesFromName.isEmpty()) {
            this.environment = new StatefulNameEnvironment(this.environment, this.state.classesFromName);
        }
        CompilerAdapter.setCompilerAdapterFactory(this);
        Compiler compiler = new Compiler(this.environment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.buildConfig.getOptions().getMap(), this.getBatchRequestor(), this.getProblemFactory());
        CompilerOptions options = compiler.options;
        options.produceReferenceInfo = true;
        try {
            compiler.compile(this.getCompilationUnits(filenames, encodings));
        }
        catch (OperationCanceledException oce) {
            this.handler.handleMessage((IMessage)new Message("build cancelled:" + oce.getMessage(), IMessage.WARNING, null, null));
        }
        this.environment.cleanup();
        this.environment = null;
    }

    public IIntermediateResultsRequestor getInterimResultRequestor() {
        return new IIntermediateResultsRequestor(){

            public void acceptResult(InterimCompilationResult result) {
                if (AjBuildManager.this.progressListener != null) {
                    AjBuildManager.this.compiledCount++;
                    AjBuildManager.this.progressListener.setProgress((double)AjBuildManager.this.compiledCount / 2.0 / (double)AjBuildManager.this.sourceFileCount);
                    AjBuildManager.this.progressListener.setText("compiled: " + result.fileName());
                }
                AjBuildManager.this.state.noteResult(result);
                if (AjBuildManager.this.progressListener != null && AjBuildManager.this.progressListener.isCancelledRequested()) {
                    throw new AbortCompilation(true, (RuntimeException)new OperationCanceledException("Compilation cancelled as requested"));
                }
            }
        };
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult unitResult) {
                if (!unitResult.hasErrors() || AjBuildManager.this.proceedOnError()) {
                    Collection classFiles = unitResult.compiledTypes.values();
                    boolean shouldAddAspectName = AjBuildManager.this.buildConfig.getOutxmlName() != null;
                    Iterator iter = classFiles.iterator();
                    while (iter.hasNext()) {
                        ClassFile classFile = (ClassFile)iter.next();
                        String filename = new String(classFile.fileName());
                        String classname = filename.replace('/', '.');
                        filename = filename.replace('/', File.separatorChar) + ".class";
                        try {
                            if (AjBuildManager.this.buildConfig.getOutputJar() == null) {
                                this.writeDirectoryEntry(unitResult, classFile, filename);
                            } else {
                                this.writeZipEntry(classFile, filename);
                            }
                            if (!shouldAddAspectName) continue;
                            this.addAspectName(classname);
                        }
                        catch (IOException ex) {
                            IMessage message = EclipseAdapterUtils.makeErrorMessage(new String(unitResult.fileName), AjBuildManager.CANT_WRITE_RESULT, (Exception)ex);
                            AjBuildManager.this.handler.handleMessage(message);
                        }
                    }
                }
                if (unitResult.hasProblems() || unitResult.hasTasks()) {
                    IProblem[] problems = unitResult.getAllProblems();
                    for (int i = 0; i < problems.length; ++i) {
                        IMessage message = EclipseAdapterUtils.makeMessage(unitResult.compilationUnit, problems[i]);
                        AjBuildManager.this.handler.handleMessage(message);
                    }
                }
            }

            private void writeDirectoryEntry(CompilationResult unitResult, ClassFile classFile, String filename) throws IOException {
                String outFile;
                File destinationPath = AjBuildManager.this.buildConfig.getOutputDir();
                if (destinationPath == null) {
                    outFile = new File(filename).getName();
                    outFile = new File(AjBuildManager.this.extractDestinationPathFromSourceFile(unitResult), outFile).getPath();
                } else {
                    outFile = new File(destinationPath, filename).getPath();
                }
                BufferedOutputStream os = FileUtil.makeOutputStream((File)new File(outFile));
                os.write(classFile.getBytes());
                os.close();
            }

            private void writeZipEntry(ClassFile classFile, String name) throws IOException {
                name = name.replace(File.separatorChar, '/');
                ZipEntry newEntry = new ZipEntry(name);
                AjBuildManager.this.zos.putNextEntry(newEntry);
                AjBuildManager.this.zos.write(classFile.getBytes());
                AjBuildManager.this.zos.closeEntry();
            }

            private void addAspectName(String name) {
                BcelWorld world = AjBuildManager.this.getBcelWorld();
                ResolvedType type = world.resolve(name);
                if (type.isAspect()) {
                    AjBuildManager.this.aspectNames.add(name);
                }
            }
        };
    }

    protected boolean proceedOnError() {
        return this.buildConfig.getProceedOnError();
    }

    private void setBuildConfig(AjBuildConfig buildConfig) {
        this.buildConfig = buildConfig;
        this.handler.reset();
    }

    String makeClasspathString(AjBuildConfig buildConfig) {
        if (buildConfig == null || buildConfig.getFullClasspath() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator it = buildConfig.getFullClasspath().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    public String checkRtJar(AjBuildConfig buildConfig) {
        if ("1.5.0".equals("DEVELOPMENT")) {
            return null;
        }
        if (buildConfig == null || buildConfig.getFullClasspath() == null) {
            return "no classpath specified";
        }
        String ret = null;
        Iterator it = buildConfig.getFullClasspath().iterator();
        while (it.hasNext()) {
            File p = new File((String)it.next());
            if (!p.isFile() || !p.getName().startsWith("aspectjrt") || !p.getName().endsWith(".jar")) continue;
            try {
                String version = null;
                Manifest manifest = new JarFile(p).getManifest();
                if (manifest == null) {
                    ret = "no manifest found in " + p.getAbsolutePath() + ", expected " + "1.5.0";
                    continue;
                }
                Attributes attr = manifest.getAttributes("org/aspectj/lang/");
                if (null != attr && null != (version = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION))) {
                    version = version.trim();
                }
                if ("DEVELOPMENT".equals(version)) {
                    return null;
                }
                if (!"1.5.0".equals(version)) {
                    ret = "bad version number found in " + p.getAbsolutePath() + " expected " + "1.5.0" + " found " + version;
                    continue;
                }
            }
            catch (IOException ioe) {
                ret = "bad jar file found in " + p.getAbsolutePath() + " error: " + ioe;
            }
            return null;
        }
        if (ret != null) {
            return ret;
        }
        return "couldn't find aspectjrt.jar on classpath, checked: " + this.makeClasspathString(buildConfig);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AjBuildManager(");
        buf.append(")");
        return buf.toString();
    }

    public void setStructureModel(IHierarchy structureModel) {
        this.structureModel = structureModel;
    }

    public IHierarchy getStructureModel() {
        return this.structureModel;
    }

    public IProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(IProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public String getOutputClassFileName(char[] eclipseClassFileName, CompilationResult result) {
        String outFile;
        String filename = new String(eclipseClassFileName);
        filename = filename.replace('/', File.separatorChar) + ".class";
        File destinationPath = this.buildConfig.getOutputDir();
        if (destinationPath == null) {
            outFile = new File(filename).getName();
            outFile = new File(this.extractDestinationPathFromSourceFile(result), outFile).getPath();
        } else {
            outFile = new File(destinationPath, filename).getPath();
        }
        return outFile;
    }

    public ICompilerAdapter getAdapter(Compiler forCompiler) {
        EclipseFactory factory;
        AjProblemReporter pr = new AjProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), forCompiler.options, this.getProblemFactory());
        forCompiler.problemReporter = pr;
        AjLookupEnvironment le = new AjLookupEnvironment(forCompiler, forCompiler.options, pr, this.environment);
        le.factory = factory = new EclipseFactory(le, this);
        pr.factory = factory;
        forCompiler.lookupEnvironment = le;
        forCompiler.parser = new Parser(pr, forCompiler.options.parseLiteralExpressionsAsConstants);
        return new AjCompilerAdapter(forCompiler, this.batchCompile, this.getBcelWorld(), this.getWeaver(), factory, this.getInterimResultRequestor(), this.progressListener, this, this, this.state.binarySourceFiles, this.state.resultsFromFile.values(), this.buildConfig.isNoWeave(), this.buildConfig.getProceedOnError(), this.buildConfig.isNoAtAspectJAnnotationProcessing());
    }

    public Map getBinarySourcesForThisWeave() {
        return this.binarySourcesForTheNextCompile;
    }

    public static AsmHierarchyBuilder getAsmHierarchyBuilder() {
        return asmHierarchyBuilder;
    }

    public static void setAsmHierarchyBuilder(AsmHierarchyBuilder newBuilder) {
        asmHierarchyBuilder = newBuilder;
    }

    public AjState getState() {
        return this.state;
    }

    public void setState(AjState buildState) {
        this.state = buildState;
    }

    static {
        CompilationAndWeavingContext.registerFormatter((int)0, (ContextFormatter)new AjBuildContexFormatter());
        CompilationAndWeavingContext.registerFormatter((int)1, (ContextFormatter)new AjBuildContexFormatter());
    }

    private static class AjBuildContexFormatter
    implements ContextFormatter {
        private AjBuildContexFormatter() {
        }

        public String formatEntry(int phaseId, Object data) {
            StringBuffer sb = new StringBuffer();
            if (phaseId == 0) {
                sb.append("batch building ");
            } else {
                sb.append("incrementally building ");
            }
            AjBuildConfig config = (AjBuildConfig)data;
            List classpath = config.getClasspath();
            sb.append("with classpath: ");
            Iterator iter = classpath.iterator();
            while (iter.hasNext()) {
                sb.append(iter.next().toString());
                sb.append(File.pathSeparator);
            }
            return sb.toString();
        }
    }
}

