/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildconfig;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;

public class ProjectBuildConfigurator {
    private HashMap buildconfigs;
    private IJavaProject javaProject;
    IFile activeBuildConfiguration;
    private BuildConfigurator buildConfigurator;
    private boolean initialized;
    private boolean fullbuildrequested;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;

    public ProjectBuildConfigurator(IJavaProject project) {
        this.javaProject = project;
        this.buildConfigurator = BuildConfigurator.getBuildConfigurator();
        this.buildconfigs = new HashMap();
    }

    public void reInit() {
        this.initialized = false;
    }

    private void init() {
        if (!this.initialized) {
            this.readBuildConfigurationsFromFileSystem();
            this.activeBuildConfiguration = this.getStoredBuildConfiguration();
            this.initialized = true;
        }
    }

    private IFile getStoredBuildConfiguration() {
        IProject project = this.javaProject.getProject();
        String configFile = AspectJPreferences.getActiveBuildConfigurationName(project);
        if (configFile == null || configFile.length() == 0) {
            return null;
        }
        return project.getFile(configFile);
    }

    private void storeActiveBuildConfigurationName(String configName) {
        IProject project = this.javaProject.getProject();
        AspectJPreferences.setActiveBuildConfigurationName(project, configName);
    }

    private void readBuildConfigurationsFromFileSystem() {
        try {
            IResource[] files = this.javaProject.getProject().members(1);
            int i = 0;
            while (i < files.length) {
                if (files[i].getType() != 2 && "ajproperties".equals(files[i].getFileExtension()) && files[i].exists()) {
                    BuildConfiguration bc = new BuildConfiguration((IFile)files[i], this);
                    this.buildconfigs.put(files[i], bc);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
    }

    public BuildConfiguration getActiveBuildConfiguration() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return (BuildConfiguration)this.buildconfigs.get(this.activeBuildConfiguration);
    }

    public void setActiveBuildConfiguration(BuildConfiguration bc) {
        if (this.buildconfigs.containsKey(bc.getFile())) {
            if (!bc.getFile().exists()) {
                this.buildconfigs.remove(bc.getFile());
                this.makeSureThereIsAtLeastOneActiveConfiguration();
            } else {
                IFile oldActive = this.activeBuildConfiguration;
                this.activeBuildConfiguration = bc.getFile();
                this.storeActiveBuildConfigurationName(bc.getFile().getName());
                bc.update(false);
                if (!this.activeBuildConfiguration.equals((Object)oldActive)) {
                    try {
                        this.requestFullBuild(true);
                        this.activeBuildConfiguration.touch(null);
                    }
                    catch (CoreException coreException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                    }
                }
            }
        }
    }

    public BuildConfiguration getBuildConfiguration(IFile bcFile) {
        return (BuildConfiguration)this.buildconfigs.get(bcFile);
    }

    public void requestFullBuild(boolean temp) {
        this.fullbuildrequested = temp;
    }

    public boolean fullBuildRequested() {
        return this.fullbuildrequested;
    }

    public void configurationChanged(BuildConfiguration bc) {
        if (this.initialized) {
            if (!this.buildconfigs.containsKey(bc.getFile())) {
                this.buildconfigs.put(bc.getFile(), bc);
            }
            if (bc.getFile().equals((Object)this.activeBuildConfiguration)) {
                this.requestFullBuild(true);
                AJDTUtils.refreshPackageExplorer();
            }
            this.buildConfigurator.notifyChangeListeners();
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setProject(IJavaProject project) {
        this.javaProject = project;
    }

    public IFile[] getConfigurationFiles() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        IFile[] z = new IFile[]{};
        return this.buildconfigs.keySet().toArray(z);
    }

    public Collection getBuildConfigurations() {
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        return this.buildconfigs.values();
    }

    public void addBuildConfiguration(BuildConfiguration bc) {
        this.buildconfigs.put(bc.getFile(), bc);
        this.buildConfigurator.notifyChangeListeners();
    }

    private void makeSureThereIsAtLeastOneActiveConfiguration() {
        if (!this.initialized) {
            this.init();
        }
        if (this.buildconfigs.size() == 0) {
            BuildConfiguration nbc = new BuildConfiguration(BuildConfiguration.STANDARD_BUILD_CONFIGURATION_NAME, this.javaProject, this);
            this.buildconfigs.put(nbc.getFile(), nbc);
        }
        if (this.activeBuildConfiguration == null || !this.buildconfigs.containsKey(this.activeBuildConfiguration)) {
            this.setActiveBuildConfiguration(this.getDefaultBuildConfiguration());
        }
    }

    private BuildConfiguration getDefaultBuildConfiguration() {
        if (this.buildconfigs.size() == 1) {
            return (BuildConfiguration)this.buildconfigs.values().iterator().next();
        }
        IFile first = null;
        Iterator iter = this.buildconfigs.keySet().iterator();
        while (iter.hasNext()) {
            IFile file = (IFile)iter.next();
            if (file.getName().equals(BuildConfiguration.STANDARD_BUILD_CONFIGURATION_FILE)) {
                return (BuildConfiguration)this.buildconfigs.get(file);
            }
            if (first != null && file.getName().compareTo(first.getName()) >= 0) continue;
            first = file;
        }
        return (BuildConfiguration)this.buildconfigs.get(first);
    }

    public void removeBuildConfiguration(BuildConfiguration bc) {
        if (bc.getFile().equals((Object)this.activeBuildConfiguration)) {
            this.activeBuildConfiguration = null;
        }
        this.buildconfigs.remove(bc.getFile());
        this.makeSureThereIsAtLeastOneActiveConfiguration();
        this.buildConfigurator.notifyChangeListeners();
    }

    public void setActiveBuildConfiguration(IFile buildFile) {
        BuildConfiguration bc = this.getBuildConfiguration(buildFile);
        if (bc == null) {
            bc = new BuildConfiguration(buildFile, this);
            this.addBuildConfiguration(bc);
        }
        this.setActiveBuildConfiguration(bc);
    }

    public void removeBuildConfiguration(IFile file) {
        BuildConfiguration bc = this.getBuildConfiguration(file);
        if (bc != null) {
            this.removeBuildConfiguration(bc);
        }
    }

    static {
        Factory factory = new Factory("ProjectBuildConfigurator.java", Class.forName("org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 83);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "readBuildConfigurationsFromFileSystem", "org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator", "", "", "", "void"), 70);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 106);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "setActiveBuildConfiguration", "org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator", "org.eclipse.ajdt.internal.buildconfig.BuildConfiguration:", "bc:", "", "void"), 92);
    }
}

