/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildconfig.editor;

import java.io.PrintWriter;
import java.util.Enumeration;

public class PropertiesUtil {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String createWritableName(String source) {
        if (source.indexOf(32) == -1) {
            return source;
        }
        StringBuffer writableName = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == ' ') {
                writableName.append("\\ ");
            } else {
                writableName.append(c);
            }
            ++i;
        }
        return writableName.toString();
    }

    public static String createEscapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
            } else if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
            } else {
                buf.append(character);
            }
            ++i;
        }
        return buf.toString();
    }

    public static void writeKeyValuePair(String name, String value, PrintWriter writer) {
        String writableName = PropertiesUtil.createWritableName(name);
        writer.print(String.valueOf(writableName) + " = ");
        writer.println(PropertiesUtil.createEscapedValue(value));
    }

    public static void writeKeyValuePair(String name, Enumeration tokens, PrintWriter writer) {
        String writableName = PropertiesUtil.createWritableName(name);
        writer.print(String.valueOf(writableName) + " = ");
        if (!tokens.hasMoreElements()) {
            writer.println();
            return;
        }
        int indentLength = name.length() + 3;
        while (tokens.hasMoreElements()) {
            String token = tokens.nextElement().toString();
            writer.print(PropertiesUtil.createEscapedValue(token));
            if (tokens.hasMoreElements()) {
                writer.println(",\\");
                int j = 0;
                while (j < indentLength) {
                    writer.print(" ");
                    ++j;
                }
                continue;
            }
            writer.println("");
        }
    }

    public static String writeKeyValuePair(String name, String[] tokens) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PropertiesUtil.createWritableName(name));
        buffer.append(" = ");
        int indentLength = name.length() + 3;
        int i = 0;
        while (i < tokens.length) {
            buffer.append(PropertiesUtil.createEscapedValue(tokens[i]));
            if (i < tokens.length - 1) {
                buffer.append(",\\" + System.getProperty("line.separator"));
                int j = 0;
                while (j < indentLength) {
                    buffer.append(" ");
                    ++j;
                }
            }
            ++i;
        }
        buffer.append(System.getProperty("line.separator"));
        return buffer.toString();
    }
}

