/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPrintHandler {
    public static final String XML_COMMENT_END_TAG = "-->";
    public static final String XML_COMMENT_BEGIN_TAG = "<!--";
    public static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"";
    public static final String XML_HEAD_END_TAG = "?>";
    public static final String XML_DBL_QUOTES = "\"";
    public static final String XML_SPACE = " ";
    public static final String XML_BEGIN_TAG = "<";
    public static final String XML_END_TAG = ">";
    public static final String XML_EQUAL = "=";
    public static final String XML_SLASH = "/";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public static void printBeginElement(Writer xmlWriter, String elementString, String indent, boolean terminate) throws IOException {
        StringBuffer temp = new StringBuffer(indent);
        temp.append(XML_BEGIN_TAG);
        temp.append(elementString);
        if (terminate) {
            temp.append(XML_SLASH);
        }
        temp.append(XML_END_TAG);
        temp.append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printEndElement(Writer xmlWriter, String elementString, String indent) throws IOException {
        StringBuffer temp = new StringBuffer(indent);
        temp.append(XML_BEGIN_TAG);
        temp.append(XML_SLASH).append(elementString).append(XML_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printText(Writer xmlWriter, String text) throws IOException {
        xmlWriter.write(XMLPrintHandler.encode(text).toString());
    }

    public static void printComment(Writer xmlWriter, String comment) throws IOException {
        StringBuffer temp = new StringBuffer(XML_COMMENT_BEGIN_TAG);
        temp.append(XMLPrintHandler.encode(comment).toString()).append(XML_COMMENT_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static void printHead(Writer xmlWriter, String encoding) throws IOException {
        StringBuffer temp = new StringBuffer(XML_HEAD);
        temp.append(encoding).append(XML_DBL_QUOTES).append(XML_HEAD_END_TAG).append("\n");
        xmlWriter.write(temp.toString());
    }

    public static String wrapAttributeForPrint(String attribute, String value) throws IOException {
        StringBuffer temp = new StringBuffer(XML_SPACE);
        temp.append(attribute).append(XML_EQUAL).append(XML_DBL_QUOTES).append(XMLPrintHandler.encode(value).toString()).append(XML_DBL_QUOTES);
        return temp.toString();
    }

    public static void printNode(Writer xmlWriter, Node node, String encoding, String indent) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 9: {
                XMLPrintHandler.printHead(xmlWriter, encoding);
                XMLPrintHandler.printNode(xmlWriter, ((Document)node).getDocumentElement(), encoding, indent);
                break;
            }
            case 1: {
                StringBuffer tempElementString = new StringBuffer(node.getNodeName());
                NamedNodeMap attributeList = node.getAttributes();
                if (attributeList != null) {
                    int i = 0;
                    while (i < attributeList.getLength()) {
                        Node attribute = attributeList.item(i);
                        tempElementString.append(XMLPrintHandler.wrapAttributeForPrint(attribute.getNodeName(), attribute.getNodeValue()));
                        ++i;
                    }
                }
                NodeList childNodes = node.getChildNodes();
                int length = childNodes.getLength();
                XMLPrintHandler.printBeginElement(xmlWriter, tempElementString.toString(), indent, length == 0);
                int i = 0;
                while (i < length) {
                    XMLPrintHandler.printNode(xmlWriter, childNodes.item(i), encoding, String.valueOf(indent) + "\t");
                    ++i;
                }
                if (length <= 0) break;
                XMLPrintHandler.printEndElement(xmlWriter, node.getNodeName(), indent);
                break;
            }
            case 3: {
                break;
            }
            case 8: {
                StringBuffer temp = new StringBuffer(XML_COMMENT_BEGIN_TAG);
                temp.append(XMLPrintHandler.encode(node.getNodeValue()).toString()).append(XML_COMMENT_END_TAG).append("\n");
                xmlWriter.write(temp.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported XML Node Type.");
            }
        }
    }

    public static StringBuffer encode(String value) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeFile(Document doc, File file) throws IOException {
        block12: {
            writer = null;
            out = null;
            try {
                out = new FileOutputStream(file);
                writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                XMLPrintHandler.printNode(writer, doc, "UTF-8", "");
            }
            catch (Throwable var5_4) {
                var4_5 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException var6_7) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(var6_7, XMLPrintHandler.ajc$tjp_0, (JoinPoint.StaticPart)XMLPrintHandler.ajc$tjp_1);
                }
                try {
                    if (out == null) throw var5_4;
                    out.close();
                    throw var5_4;
                }
                catch (IOException var7_9) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(var7_9, XMLPrintHandler.ajc$tjp_2, (JoinPoint.StaticPart)XMLPrintHandler.ajc$tjp_1);
                }
                throw var5_4;
            }
            {
                var4_6 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 46->57)] { 
lbl29:
            // 1 sources

            if (writer != null) {
                writer.close();
            }
            break block12;
lbl32:
            // 1 sources

            catch (IOException var6_8) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(var6_8, XMLPrintHandler.ajc$tjp_0, (JoinPoint.StaticPart)XMLPrintHandler.ajc$tjp_1);
            }
        }
        try {}
        catch (IOException var7_10) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(var7_10, XMLPrintHandler.ajc$tjp_2, (JoinPoint.StaticPart)XMLPrintHandler.ajc$tjp_1);
            return;
        }
        if (out == null) return;
        out.close();
    }

    static {
        Factory factory = new Factory("XMLPrintHandler.java", Class.forName("org.eclipse.ajdt.internal.launching.XMLPrintHandler"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException:", "<missing>:"), 177);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "writeFile", "org.eclipse.ajdt.internal.launching.XMLPrintHandler", "org.w3c.dom.Document:java.io.File:", "doc:file:", "java.io.IOException:", "void"), 166);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.launching.XMLPrintHandler", "java.io.IOException:", "<missing>:"), 182);
    }
}

