/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class PulldownBuildselectorMenu
implements IWorkbenchWindowPulldownDelegate,
SelectionListener,
IBuildConfigurationChangedListener {
    private IAction buildAction;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public PulldownBuildselectorMenu() {
        BuildConfigurator.getBuildConfigurator().addBuildConfigurationChangedListener(this);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public String getWorkspaceDirectory() {
        IProject currentProject = AspectJPlugin.getDefault().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        IPath trimPath = currentProject.getLocation();
        trimPath = trimPath.removeLastSegments(1);
        return new String(String.valueOf(trimPath.toOSString()) + File.separator);
    }

    public Menu getMenu(Control c) {
        Menu m = new Menu(c);
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (pbc == null) {
            MenuItem defaultLstItem = new MenuItem(m, 32);
            defaultLstItem.setText(AspectJUIPlugin.getResourceString("PulldownBuildselectorMenu.no.open.ajproject"));
            defaultLstItem.setData(null);
            return m;
        }
        Util.Comparable[] bcs = pbc.getBuildConfigurations().toArray(new BuildConfiguration[0]);
        Util.sort((Util.Comparable[])bcs);
        MenuItem mi = null;
        BuildConfiguration activeBC = pbc.getActiveBuildConfiguration();
        int i = 0;
        while (i < bcs.length) {
            Util.Comparable bc = bcs[i];
            mi = new MenuItem(m, 32);
            mi.setText(bc.getName());
            mi.addSelectionListener((SelectionListener)this);
            mi.setData((Object)bc);
            if (bc == activeBC) {
                mi.setSelection(true);
            }
            ++i;
        }
        return m;
    }

    public void run(IAction action) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (pbc != null) {
            this.build(pbc.getJavaProject().getProject());
        }
    }

    public void buildConfigurationChanged(ProjectBuildConfigurator pbc) {
        if (pbc == null) {
            this.buildAction.setEnabled(false);
        } else {
            this.buildAction.setEnabled(true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.buildAction == null) {
            this.buildAction = action;
        }
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.chooseBuild(se);
    }

    public void widgetSelected(SelectionEvent se) {
        this.chooseBuild(se);
    }

    public void chooseBuild(SelectionEvent se) {
        Object src = se.getSource();
        if (src instanceof MenuItem) {
            MenuItem w = (MenuItem)src;
            BuildConfiguration bc = (BuildConfiguration)w.getData();
            ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
            if (pbc != null) {
                pbc.setActiveBuildConfiguration(bc);
            }
        }
    }

    private void build(final IProject project) {
        Shell activeShell = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress op = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            void doLocalBuild(int buildType, IProgressMonitor pm) throws CoreException {
                CompilerMonitor.isLocalBuild = true;
                project.build(6, pm);
                CompilerMonitor.isLocalBuild = false;
            }

            public void run(IProgressMonitor pm) {
                try {
                    this.doLocalBuild(6, pm);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException cEx = coreException;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("PulldownBuildselectorMenu.build.error"), cEx);
                }
                catch (NullPointerException nullPointerException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(nullPointerException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    NullPointerException npe = nullPointerException;
                    AJLog.log((String)("Unexpected NullPointerException during build processing (eclipse bug?): Your task view will be temporarily out of step with compilation:" + npe));
                }
                catch (OperationCanceledException operationCanceledException) {
                    AJLog.log((String)"Build was cancelled.");
                }
            }

            static {
                Factory factory = new Factory("PulldownBuildselectorMenu.java", Class.forName("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1", "org.eclipse.core.runtime.CoreException:", "cEx:"), 208);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1", "org.eclipse.core.runtime.IProgressMonitor:", "pm:", "", "void"), 205);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1", "java.lang.NullPointerException:", "npe:"), 212);
            }
        };
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, op);
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            InvocationTargetException e = invocationTargetException;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("PulldownBuildselectorMenu.autobuild.failed"), e);
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            InterruptedException e = interruptedException;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("PulldownBuildselectorMenu.autobuild.failed"), e);
        }
    }

    static {
        Factory factory = new Factory("PulldownBuildselectorMenu.java", Class.forName("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu", "java.lang.reflect.InvocationTargetException:", "e:"), 224);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "build", "org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu", "org.eclipse.core.resources.IProject:", "project:", "", "void"), 191);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu", "java.lang.InterruptedException:", "e:"), 227);
    }
}

