/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CompilerTaskListManager
implements TaskListManager {
    private static CompilerTaskListManager instance;
    private static List problems;
    private static Set affectedResources;
    private static Map otherProjectMarkers;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("CompilerTaskListManager.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 134);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "clearOtherProjectMarkers", "org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "org.eclipse.core.resources.IProject:", "p:", "", "void"), 126);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "org.eclipse.core.runtime.CoreException:", "cEx:"), 320);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "showMessages", "org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "", "", "", "void"), 191);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "org.eclipse.jdt.core.JavaModelException:", "jmEx:"), 510);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "tryToFindResource", "org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "java.lang.String:", "fileName:", "", "org.eclipse.core.resources.IResource"), 480);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "java.lang.Exception:", "<missing>:"), 536);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "findFile", "org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager", "[Lorg.eclipse.core.resources.IResource;:java.lang.String:", "srcContainer:name:", "", "org.eclipse.core.resources.IResource"), 521);
        problems = new ArrayList();
        affectedResources = new HashSet();
        otherProjectMarkers = new HashMap();
    }

    private CompilerTaskListManager() {
    }

    public static CompilerTaskListManager getInstance() {
        if (instance == null) {
            instance = new CompilerTaskListManager();
        }
        return instance;
    }

    public void addSourcelineTask(String message, ISourceLocation location, IMessage.Kind kind) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("CompilerMessage received ]" + message + "[");
        }
        problems.add(new ProblemTracker(message, location, kind));
    }

    public void addProjectTask(String message, IMessage.Kind kind) {
        problems.add(new ProblemTracker(message, null, kind));
    }

    protected void addAffectedResource(IResource res) {
        affectedResources.add(res);
    }

    public static void clearOtherProjectMarkers(IProject p) {
        List l = (List)otherProjectMarkers.get(p.getName());
        if (l != null) {
            ListIterator li = l.listIterator();
            while (li.hasNext()) {
                IMarker m = (IMarker)li.next();
                try {
                    m.delete();
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            }
            l.clear();
        }
    }

    public void clearTasks() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("clearTasks() called");
        }
        affectedResources.clear();
        problems.clear();
    }

    public void addSourcelineTask(IMessage msg) {
        if (msg.getSourceLocation() == null) {
            this.addProjectTask(msg.getMessage(), msg.getKind());
        } else {
            problems.add(new ProblemTracker(msg.getMessage(), msg.getSourceLocation(), msg.getKind(), msg.getDeclared(), msg.getExtraSourceLocations(), msg.getID(), msg.getSourceStart(), msg.getSourceEnd()));
        }
    }

    public boolean hasWarning() {
        return false;
    }

    public static void showOutstandingProblems() {
        if (problems.size() > 0 || affectedResources.size() > 0) {
            CompilerTaskListManager.getInstance().showMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessages() {
        Set activeEditorList;
        IWorkspaceRunnable r = new IWorkspaceRunnable(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;
            private static final JoinPoint.StaticPart ajc$tjp_3;

            public void run(IProgressMonitor monitor) {
                try {
                    Iterator affectedResourceIterator = affectedResources.iterator();
                    AJLog.log((String)("Types affected during build = " + affectedResources.size()));
                    IResource ir = null;
                    while (affectedResourceIterator.hasNext()) {
                        ir = (IResource)affectedResourceIterator.next();
                        try {
                            if (!ir.exists()) continue;
                            ir.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                            ir.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, 2);
                            ir.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
                        }
                        catch (ResourceException resourceException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                            ResourceException re = resourceException;
                            AJLog.log((String)("Failed marker deletion: resource=" + ir.getLocation()));
                            throw re;
                        }
                    }
                    IProject project = AJBuilder.getLastBuildTarget();
                    Iterator problemIterator = problems.iterator();
                    ProblemTracker p = null;
                    while (problemIterator.hasNext()) {
                        p = (ProblemTracker)problemIterator.next();
                        ir = null;
                        IMarker marker = null;
                        try {
                            if (p.location != null) {
                                ir = CompilerTaskListManager.this.locationToResource(p.location, project);
                                int prio = CompilerTaskListManager.this.getTaskPriority(p);
                                if (prio != -1) {
                                    marker = ir.createMarker("org.eclipse.core.resources.taskmarker");
                                    marker.setAttribute("priority", prio);
                                } else if (p.declaredErrorOrWarning) {
                                    marker = ir.createMarker("org.eclipse.ajdt.ui.problemmarker");
                                } else {
                                    marker = ir.createMarker("org.eclipse.jdt.core.problem");
                                    marker.setAttribute("id", p.id);
                                    if (p.start >= 0 && p.end >= 0) {
                                        marker.setAttribute("charStart", (Object)new Integer(p.start));
                                        marker.setAttribute("charEnd", (Object)new Integer(p.end + 1));
                                    }
                                }
                                if (!ir.getProject().equals((Object)project)) {
                                    CompilerTaskListManager.this.addOtherProjectMarker(project, marker);
                                }
                                if (p.location.getLine() > 0) {
                                    marker.setAttribute("lineNumber", (Object)new Integer(p.location.getLine()));
                                }
                            } else {
                                marker = project.createMarker("org.eclipse.jdt.core.problem");
                            }
                            CompilerTaskListManager.this.setSeverity(marker, p.kind);
                            if (p.extraLocs != null && p.extraLocs.size() > 0) {
                                int relCount = 0;
                                Iterator iter = p.extraLocs.iterator();
                                while (iter.hasNext()) {
                                    ISourceLocation sLoc = (ISourceLocation)iter.next();
                                    StringBuffer attrData = new StringBuffer();
                                    attrData.append(sLoc.getSourceFile().getAbsolutePath());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getLine());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getEndLine());
                                    attrData.append(":::");
                                    attrData.append(sLoc.getColumn());
                                    marker.setAttribute("relatedLocations-" + relCount++, (Object)attrData.toString());
                                }
                            }
                            CompilerTaskListManager.this.setMessage(marker, p.message);
                        }
                        catch (ResourceException resourceException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(resourceException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                            ResourceException re = resourceException;
                            AJLog.log((String)("Failed marker creation: resource=" + p.location.getSourceFile().getPath() + " line=" + p.location.getLine() + " message=" + p.message));
                            throw re;
                        }
                    }
                    CompilerTaskListManager.this.clearTasks();
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
                    CoreException e = coreException;
                    ErrorHandler.handleAJDTError(AspectJUIPlugin.getResourceString("CompilerTaskListManager.markerError"), e);
                }
            }

            static {
                Factory factory = new Factory("CompilerTaskListManager.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager$1", "org.eclipse.core.internal.resources.ResourceException:", "re:"), 217);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager$1", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "void"), 197);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager$1", "org.eclipse.core.internal.resources.ResourceException:", "re:"), 300);
                ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager$1", "org.eclipse.core.runtime.CoreException:", "e:"), 311);
            }
        };
        try {
            AspectJPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            CoreException cEx = coreException;
            ErrorHandler.handleAJDTError(AspectJUIPlugin.getResourceString("CompilerTaskListManager.markerError"), cEx);
        }
        Set set = activeEditorList = AspectJEditor.getActiveEditorList();
        synchronized (set) {
            Iterator iter = activeEditorList.iterator();
            while (iter.hasNext()) {
                ((AspectJEditor)((Object)iter.next())).resetTitleImage();
            }
        }
    }

    private int getTaskPriority(ProblemTracker p) {
        if (p == null) {
            return -1;
        }
        String message = p.message;
        Preferences pref = JavaCore.getPlugin().getPluginPreferences();
        String tags = pref.getString("org.eclipse.jdt.core.compiler.taskTags");
        String caseSens = pref.getString("org.eclipse.jdt.core.compiler.taskCaseSensitive");
        String priorities = pref.getString("org.eclipse.jdt.core.compiler.taskPriorities");
        boolean caseSensitive = !caseSens.equals("disabled");
        StringTokenizer tagTokens = new StringTokenizer(tags, ",");
        StringTokenizer priorityTokens = new StringTokenizer(priorities, ",");
        while (tagTokens.hasMoreTokens()) {
            String temp;
            String prio = priorityTokens.nextToken();
            String token = tagTokens.nextToken();
            if (!(caseSensitive ? message.startsWith(token) : token.length() <= message.length() && token.compareToIgnoreCase(temp = message.substring(0, token.length())) == 0)) continue;
            return this.getPrioritiyFlag(prio);
        }
        return -1;
    }

    private int getPrioritiyFlag(String prio) {
        if (prio.equals("NORMAL")) {
            return 1;
        }
        if (prio.equals("HIGH")) {
            return 2;
        }
        return 0;
    }

    private void setMessage(IMarker marker, String message) throws CoreException {
        if (message.indexOf("\":") != -1 && message.indexOf(", at line") != -1) {
            String hackedMessage = message.substring(message.indexOf("\":") + 2);
            message = hackedMessage.substring(0, hackedMessage.indexOf(", at line"));
        }
        marker.setAttribute("message", (Object)message);
    }

    private void setSeverity(IMarker marker, IMessage.Kind kind) throws CoreException {
        if (kind == IMessage.ERROR) {
            marker.setAttribute("severity", (Object)new Integer(2));
        } else if (kind == IMessage.WARNING) {
            marker.setAttribute("severity", (Object)new Integer(1));
        } else {
            marker.setAttribute("severity", (Object)new Integer(0));
        }
    }

    private IResource locationToResource(ISourceLocation isl, IProject project) {
        IResource ir = null;
        String loc = isl.getSourceFile().getPath();
        ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(loc, project);
        if (ir == null) {
            ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(loc);
            if (ir == null) {
                ir = this.tryToFindResource(loc);
            }
            if (ir == null) {
                AJLog.log((String)("Whilst adding post compilation markers to resources, cannot locate valid eclipse resource for file " + loc));
            }
        }
        return ir;
    }

    private IResource tryToFindResource(String fileName) {
        IProject ret = null;
        String toFind = fileName.replace('\\', '/');
        IProject project = AspectJPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            int i = 0;
            while (i < classpathEntries.length) {
                IClasspathEntry cpEntry = classpathEntries[i];
                if (cpEntry.getEntryKind() == 3) {
                    IPath sourcePath = cpEntry.getPath();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath)};
                    ret = this.findFile(srcContainer, toFind);
                    if (ret != null) {
                        break;
                    }
                } else if (cpEntry.getEntryKind() == 2) {
                    IPath projPath = cpEntry.getPath();
                    IResource projResource = AspectJPlugin.getWorkspace().getRoot().findMember(projPath);
                    ret = this.findFile(new IResource[]{projResource}, toFind);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
            JavaModelException jmEx = javaModelException;
            ErrorHandler.handleAJDTError(AspectJUIPlugin.getResourceString("ajErrorDialogTitle"), AspectJUIPlugin.getResourceString("jmCoreException"), (CoreException)((Object)jmEx));
        }
        if (ret == null) {
            ret = project;
        }
        return ret;
    }

    private IResource findFile(IResource[] srcContainer, String name) {
        IResource ret = null;
        try {
            int i = 0;
            while (i < srcContainer.length) {
                IResource ir = srcContainer[i];
                if (ir.getFullPath().toString().endsWith(name)) {
                    ret = ir;
                } else if (!(ir instanceof IContainer) || (ret = this.findFile(((IContainer)ir).members(), name)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
        }
        return ret;
    }

    private void addOtherProjectMarker(IProject p, IMarker m) {
        if (!otherProjectMarkers.containsKey(p.getName())) {
            otherProjectMarkers.put(p.getName(), new ArrayList());
        }
        List l = (List)otherProjectMarkers.get(p.getName());
        l.add(m);
    }

    class ProblemTracker {
        public ISourceLocation location;
        public String message;
        public IMessage.Kind kind;
        public boolean declaredErrorOrWarning = false;
        public List extraLocs;
        public int id;
        public int start;
        public int end;

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k) {
            this(m, l, k, false, null, -1, -1, -1);
        }

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k, boolean deow, List extraLocs, int id, int start, int end) {
            this.location = l;
            this.message = m;
            this.kind = k;
            this.declaredErrorOrWarning = deow;
            this.extraLocs = extraLocs;
            this.id = id;
            this.start = start;
            this.end = end;
        }
    }
}

