/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.visualiser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.ui.visualiser.AJDTMarkupProvider;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTContentProvider;
import org.eclipse.contribution.visualiser.jdtImpl.JDTGroup;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMember;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AJDTContentProvider
extends JDTContentProvider {
    List currentGroups;
    List currentMembers;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;

    public List getAllGroups() {
        if (this.currentGroups != null) {
            return this.currentGroups;
        }
        this.updateData();
        return this.currentGroups;
    }

    public List getAllMembers() {
        if (this.currentMembers != null) {
            return this.currentMembers;
        }
        this.updateData();
        return this.currentMembers;
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        IStructuredSelection structuredSelection;
        Object o;
        if (!ProviderManager.getContentProvider().equals((Object)this)) {
            return;
        }
        boolean updateRequired = false;
        if (is instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)is).getFirstElement()) != null && o instanceof IJavaElement) {
            IJavaElement je = (IJavaElement)o;
            if (this.currentlySelectedJE == je) {
                return;
            }
            this.currentlySelectedJE = je;
            updateRequired = true;
            if (je.getJavaProject() != null) {
                this.setCurrentProject(je.getJavaProject());
            }
        }
        if (updateRequired) {
            AJLog.log((String)"AJDTContentProvider.selectionChanged(): Marking visualiser content as out of date");
            this.currentGroups = null;
            this.currentMembers = null;
            VisualiserPlugin.refresh();
        }
    }

    private void updateData() {
        if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
            ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetMarkupsAndKinds();
        }
        long stime = System.currentTimeMillis();
        this.currentGroups = new ArrayList();
        this.currentMembers = new ArrayList();
        try {
            if (this.currentlySelectedJE instanceof IJavaProject) {
                IPackageFragment[] packageFragments = ((IJavaProject)this.currentlySelectedJE).getPackageFragments();
                int i = 0;
                while (i < packageFragments.length) {
                    IPackageFragment packageFragment;
                    List classes;
                    if (!packageFragments[i].isReadOnly() && (classes = this.getMembersForPackage(packageFragment = packageFragments[i])).size() > 0) {
                        boolean defaultPackage = packageFragment.isDefaultPackage();
                        JDTGroup group = new JDTGroup(packageFragment.getElementName());
                        if (defaultPackage) {
                            group.setName("(default package)");
                            group.setTooltip("(default package)");
                        }
                        Iterator iter = classes.iterator();
                        while (iter.hasNext()) {
                            IMember member = (IMember)iter.next();
                            group.add(member);
                            this.currentMembers.add(member);
                            if (!defaultPackage) continue;
                            ((SimpleMember)member).setFullName(member.getName());
                        }
                        this.currentGroups.add(group);
                    }
                    ++i;
                }
            } else if (this.currentlySelectedJE instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)this.currentlySelectedJE;
                List classes = this.getMembersForPackage(packageFragment);
                if (classes.size() > 0) {
                    boolean defaultPackage = packageFragment.isDefaultPackage();
                    JDTGroup group = new JDTGroup(packageFragment.getElementName());
                    if (defaultPackage) {
                        group.setName("(default package)");
                        group.setTooltip("(default package)");
                    }
                    Iterator iter = classes.iterator();
                    while (iter.hasNext()) {
                        IMember member = (IMember)iter.next();
                        group.add(member);
                        this.currentMembers.add(member);
                        if (!defaultPackage) continue;
                        ((SimpleMember)member).setFullName(member.getName());
                    }
                    this.currentGroups.add(group);
                }
            } else if (this.currentlySelectedJE instanceof ICompilationUnit) {
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(this.currentProject);
                BuildConfiguration bc = null;
                if (pbc != null) {
                    bc = pbc.getActiveBuildConfiguration();
                }
                JDTMember member = null;
                if (bc != null && bc.isIncluded(this.currentlySelectedJE.getResource()) || bc == null) {
                    String memberName = this.currentlySelectedJE.getElementName();
                    if (memberName.endsWith(".java")) {
                        memberName = memberName.substring(0, memberName.length() - 5);
                    } else if (memberName.endsWith(".aj")) {
                        memberName = memberName.substring(0, memberName.length() - 3);
                    }
                    member = new JDTMember(memberName, this.currentlySelectedJE);
                    member.setSize(this.getLength((ICompilationUnit)this.currentlySelectedJE));
                    this.currentMembers.add(member);
                }
                if (member != null) {
                    IPackageFragment packageFrag = (IPackageFragment)((ICompilationUnit)this.currentlySelectedJE).getParent();
                    boolean defaultPackage = packageFrag.isDefaultPackage();
                    JDTGroup group = new JDTGroup(packageFrag.getElementName());
                    if (defaultPackage) {
                        group.setName("(default package)");
                        group.setTooltip("(default package)");
                    }
                    if (defaultPackage) {
                        member.setFullName(member.getName());
                    }
                    group.add((IMember)member);
                    this.currentGroups.add(group);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        long etime = System.currentTimeMillis();
        AJLog.log((String)("AJDTContentProvider.updateData() executed - took " + (etime - stime) + "ms"));
    }

    protected void setCurrentProject(IJavaProject newProject) {
        if (this.currentProject == null || !this.currentProject.equals(newProject)) {
            if (ProviderManager.getMarkupProvider() instanceof AJDTMarkupProvider) {
                ((AJDTMarkupProvider)ProviderManager.getMarkupProvider()).resetColours();
            }
            this.currentProject = newProject;
        }
    }

    public void reset() {
        this.currentGroups = null;
        this.currentMembers = null;
    }

    public boolean processMouseclick(IMember member, boolean markupWasClicked, int buttonClicked) {
        IJavaElement jEl;
        if (buttonClicked != 1) {
            return true;
        }
        if (markupWasClicked) {
            return false;
        }
        if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
            JDTUtils.openInEditor((IResource)jEl.getResource(), (int)JDTUtils.getClassDeclLineNum((IJavaElement)jEl));
        }
        return false;
    }

    public List getMembersForPackage(IPackageFragment PF) {
        ArrayList<JDTMember> returningClasses = new ArrayList<JDTMember>();
        try {
            if (this.containsUsefulStuff(PF)) {
                ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(this.currentProject);
                BuildConfiguration bc = null;
                if (pbc != null) {
                    bc = pbc.getActiveBuildConfiguration();
                }
                IJavaElement[] ijes = PF.getChildren();
                int j = 0;
                while (j < ijes.length) {
                    if (ijes[j].getElementType() == 5 && (bc != null && bc.isIncluded(ijes[j].getResource()) || bc == null)) {
                        String memberName = ijes[j].getElementName();
                        if (memberName.endsWith(".java")) {
                            memberName = memberName.substring(0, memberName.length() - 5);
                        } else if (memberName.endsWith(".aj")) {
                            memberName = memberName.substring(0, memberName.length() - 3);
                        }
                        JDTMember member = new JDTMember(memberName, ijes[j]);
                        member.setSize(this.getLength((ICompilationUnit)ijes[j]));
                        returningClasses.add(member);
                    }
                    ++j;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return returningClasses;
    }

    static {
        Factory factory = new Factory("AJDTContentProvider.java", Class.forName("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 203);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "updateData", "org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "", "", "", "void"), 116);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 293);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getMembersForPackage", "org.eclipse.ajdt.internal.ui.visualiser.AJDTContentProvider", "org.eclipse.jdt.core.IPackageFragment:", "PF:", "", "java.util.List"), 266);
    }
}

