/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.wizards.ResourceAddedPage;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ResourceAddedWizard
extends Wizard
implements INewWizard {
    IWorkbench workbench;
    IStructuredSelection selection;
    ResourceAddedPage mainPage;
    List newResourcesList;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(AspectJUIPlugin.getResourceString("newResourcesWizard.wizardTitle"));
        this.newResourcesList = null;
    }

    public void setNewResources(List newResources) {
        this.newResourcesList = newResources;
    }

    public void addPages() {
        this.mainPage = new ResourceAddedPage(this.newResourcesList);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        List resourcesToAdd = this.mainPage.getSelectedResources();
        List buildConfigFilesToUpdate = this.mainPage.getSelectedBuildConfigFiles();
        if (buildConfigFilesToUpdate.size() == 0 || resourcesToAdd.size() == 0) {
            return true;
        }
        IProject project = ((IResource)resourcesToAdd.get(0)).getProject();
        IPath workspacePath = project.getLocation();
        workspacePath = workspacePath.removeLastSegments(1);
        StringBuffer newLines = new StringBuffer();
        Iterator resourceIterator = resourcesToAdd.iterator();
        while (resourceIterator.hasNext()) {
            IResource resourceFile = (IResource)resourceIterator.next();
            String resourcePath = String.valueOf(workspacePath.toOSString()) + resourceFile.getFullPath().toOSString();
            if (resourcePath.endsWith(".lst")) {
                newLines.append("@");
            }
            newLines.append(resourcePath);
            newLines.append("\n");
        }
        Iterator configIterator = buildConfigFilesToUpdate.iterator();
        while (configIterator.hasNext()) {
            IResource configurationFile = (IResource)configIterator.next();
            IFile ifile = (IFile)configurationFile;
            try {
                boolean trailingReturnRequired = true;
                InputStream is = ifile.getContents();
                byte[] inputdata = new byte[is.available()];
                is.read(inputdata);
                if (inputdata[inputdata.length - 1] == new String("\n").getBytes()[0]) {
                    trailingReturnRequired = false;
                }
                ByteArrayInputStream bais = null;
                bais = trailingReturnRequired ? new ByteArrayInputStream(new String("\n" + newLines.toString()).getBytes()) : new ByteArrayInputStream(newLines.toString().getBytes());
                ifile.appendContents((InputStream)bais, true, false, null);
            }
            catch (Exception exception) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                Exception e = exception;
                AspectJUIPlugin.getDefault().getErrorHandler().handleError(String.valueOf(AspectJUIPlugin.getResourceString("newResourcesWizard.exceptionAppendingToBuildConfigFile")) + ifile.getFullPath().toOSString(), e);
            }
        }
        return true;
    }

    static {
        Factory factory = new Factory("ResourceAddedWizard.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.ResourceAddedWizard"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.wizards.ResourceAddedWizard", "java.lang.Exception:", "e:"), 139);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "performFinish", "org.eclipse.ajdt.internal.ui.wizards.ResourceAddedWizard", "", "", "", "boolean"), 76);
    }
}

