/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.pde.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class FormOutlinePage
extends ContentOutlinePage
implements IModelChangedListener {
    private boolean stale;
    protected TreeViewer treeViewer;
    protected PDEFormEditor editor;

    public FormOutlinePage(PDEFormEditor editor) {
        this.editor = editor;
    }

    protected ITreeContentProvider createContentProvider() {
        return new BasicContentProvider();
    }

    public void createControl(Composite parent) {
        Tree widget = new Tree(parent, 770);
        this.treeViewer = new TreeViewer(widget);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.editor);
        IBaseModel model = this.editor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    protected ILabelProvider createLabelProvider() {
        return new BasicLabelProvider();
    }

    public void dispose() {
        super.dispose();
        IBaseModel model = this.editor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public Control getControl() {
        return this.treeViewer != null ? this.treeViewer.getControl() : null;
    }

    private Object[] getPages() {
        ArrayList<IFormPage> formPages = new ArrayList<IFormPage>();
        IFormPage[] pages = this.editor.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isEditor()) {
                formPages.add(pages[i]);
            }
            ++i;
        }
        return formPages.toArray();
    }

    public void modelChanged(IModelChangedEvent event) {
        IFormPage page = this.editor.getActivePageInstance();
        this.stale = true;
        if (!page.isEditor()) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.stale) {
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
            this.stale = false;
        }
    }

    protected String getParentPageId(Object item) {
        if (item instanceof IFormPage) {
            return ((IFormPage)item).getId();
        }
        return null;
    }

    protected Object[] getChildren(Object parent) {
        return new Object[0];
    }

    public void selectionChanged(Object item) {
        IFormPage revealPage;
        IFormPage page = this.editor.getActivePageInstance();
        String id = this.getParentPageId(item);
        IFormPage newPage = null;
        if (!(id == null || page != null && page.getId().equals(id))) {
            newPage = this.editor.setActivePage(id);
        }
        IFormPage iFormPage = revealPage = newPage != null ? newPage : page;
        if (revealPage != null && !(item instanceof IFormPage)) {
            revealPage.selectReveal(item);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object item = ssel.getFirstElement();
            this.selectionChanged(item);
        }
        this.fireSelectionChanged(selection);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public class BasicContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object obj) {
            return FormOutlinePage.this.getPages();
        }

        public Object[] getChildren(Object obj) {
            return FormOutlinePage.this.getChildren(obj);
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length > 0;
        }

        public Object getParent(Object obj) {
            return null;
        }
    }

    public class BasicLabelProvider
    extends LabelProvider {
        public String getText(Object obj) {
            if (obj instanceof IFormPage) {
                return ((IFormPage)obj).getTitle();
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IFormPage) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PAGE_OBJ);
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(obj);
        }
    }
}

