/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.pde.internal.ui.editor;

import java.util.List;
import java.util.Vector;
import org.eclipse.ajdt.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class ModelUndoManager
implements IModelUndoManager,
IModelChangedListener {
    private static final String KEY_NO_UNDO = "UpdateManager.noUndo";
    private static final String KEY_NO_REDO = "UpdateManager.noRedo";
    private static final String KEY_UNDO = "UpdateManager.undo";
    private static final String KEY_REDO = "UpdateManager.redo";
    private static final String KEY_OP_ADD = "UpdateManager.op.add";
    private static final String KEY_OP_REMOVE = "UpdateManager.op.remove";
    private static final String KEY_OP_CHANGE = "UpdateManager.op.change";
    private boolean ignoreChanges;
    private List operations;
    private int undoLevelLimit = 10;
    private int cursor = -1;
    private IAction undoAction;
    private IAction redoAction;
    private PDEFormEditor editor;

    public ModelUndoManager(PDEFormEditor editor) {
        this.editor = editor;
        this.operations = new Vector();
    }

    public void connect(IModelChangeProvider provider) {
        provider.addModelChangedListener((IModelChangedListener)this);
        if (this.operations == null) {
            this.initialize();
        }
    }

    public void disconnect(IModelChangeProvider provider) {
        provider.removeModelChangedListener((IModelChangedListener)this);
    }

    private void initialize() {
        this.operations = new Vector();
        this.cursor = -1;
        this.updateActions();
    }

    public boolean isUndoable() {
        return this.cursor >= 0;
    }

    public boolean isRedoable() {
        if (this.operations == null) {
            this.initialize();
        }
        return this.cursor + 1 < this.operations.size();
    }

    public void undo() {
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return;
        }
        this.ignoreChanges = true;
        this.openRelatedPage(op);
        this.execute(op, true);
        --this.cursor;
        this.updateActions();
        this.ignoreChanges = false;
    }

    public void redo() {
        ++this.cursor;
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return;
        }
        this.ignoreChanges = true;
        this.openRelatedPage(op);
        this.execute(op, false);
        this.ignoreChanges = false;
        this.updateActions();
    }

    protected abstract String getPageId(Object var1);

    protected abstract void execute(IModelChangedEvent var1, boolean var2);

    private void openRelatedPage(IModelChangedEvent op) {
        IFormPage newPage;
        IFormPage cpage;
        Object obj = op.getChangedObjects()[0];
        String pageId = this.getPageId(obj);
        if (pageId != null && (cpage = this.editor.getActivePageInstance()) != (newPage = this.editor.findPage(pageId))) {
            this.editor.setActivePage(newPage.getId());
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        if (this.ignoreChanges) {
            return;
        }
        if (event.getChangeType() == 99) {
            this.initialize();
            return;
        }
        this.addOperation(event);
    }

    private IModelChangedEvent getCurrentOperation() {
        if (this.cursor == -1 || this.cursor == this.operations.size()) {
            return null;
        }
        return (IModelChangedEvent)this.operations.get(this.cursor);
    }

    private IModelChangedEvent getNextOperation() {
        int peekCursor = this.cursor + 1;
        if (peekCursor >= this.operations.size()) {
            return null;
        }
        return (IModelChangedEvent)this.operations.get(peekCursor);
    }

    private void addOperation(IModelChangedEvent operation) {
        this.operations.add(operation);
        int size = this.operations.size();
        if (size > this.undoLevelLimit) {
            int extra = size - this.undoLevelLimit;
            int i = 0;
            while (i < extra) {
                this.operations.remove(i);
                ++i;
            }
        }
        this.cursor = this.operations.size() - 1;
        this.updateActions();
    }

    public void setActions(IAction undoAction, IAction redoAction) {
        this.undoAction = undoAction;
        this.redoAction = redoAction;
        this.updateActions();
    }

    private void updateActions() {
        if (this.undoAction != null && this.redoAction != null) {
            this.undoAction.setEnabled(this.isUndoable());
            this.undoAction.setText(this.getUndoText());
            this.redoAction.setEnabled(this.isRedoable());
            this.redoAction.setText(this.getRedoText());
        }
    }

    private String getUndoText() {
        IModelChangedEvent op = this.getCurrentOperation();
        if (op == null) {
            return PDEPlugin.getResourceString((String)KEY_NO_UNDO);
        }
        String opText = this.getOperationText(op);
        return PDEPlugin.getFormattedMessage((String)KEY_UNDO, (String)opText);
    }

    private String getRedoText() {
        IModelChangedEvent op = this.getNextOperation();
        if (op == null) {
            return PDEPlugin.getResourceString((String)KEY_NO_REDO);
        }
        String opText = this.getOperationText(op);
        return PDEPlugin.getFormattedMessage((String)KEY_REDO, (String)opText);
    }

    private String getOperationText(IModelChangedEvent op) {
        String opText = "";
        switch (op.getChangeType()) {
            case 1: {
                opText = PDEPlugin.getResourceString((String)KEY_OP_ADD);
                break;
            }
            case 2: {
                opText = PDEPlugin.getResourceString((String)KEY_OP_REMOVE);
                break;
            }
            case 3: {
                opText = PDEPlugin.getResourceString((String)KEY_OP_CHANGE);
            }
        }
        return opText;
    }

    public void setUndoLevelLimit(int limit) {
        this.undoLevelLimit = limit;
    }

    public void setIgnoreChanges(boolean ignore) {
        this.ignoreChanges = ignore;
    }
}

