/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.IAJLogger;
import org.eclipse.ajdt.core.ICoreOperations;
import org.eclipse.ajdt.core.builder.AJBuilder;
import org.eclipse.ajdt.core.builder.IAJBuildListener;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.internal.buildconfig.BCResourceChangeListener;
import org.eclipse.ajdt.internal.buildconfig.BCWorkbenchWindowInitializer;
import org.eclipse.ajdt.internal.builder.BuilderUtils;
import org.eclipse.ajdt.internal.builder.UIBuildListener;
import org.eclipse.ajdt.internal.javamodel.FileFilter;
import org.eclipse.ajdt.internal.javamodel.ResourceChangeListener;
import org.eclipse.ajdt.internal.ui.EventTraceLogger;
import org.eclipse.ajdt.internal.ui.actions.UICoreOperations;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.CompilerTaskListManager;
import org.eclipse.ajdt.internal.ui.ajde.EditorAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.ajde.IdeUIAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.internal.utils.AJDTEventTrace;
import org.eclipse.ajdt.internal.utils.AJDTStructureViewNodeFactory;
import org.eclipse.ajdt.internal.utils.AJDTUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AspectJUIPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static String VERSION;
    public static final String PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_OUTLINE = "org.eclipse.ajdt.ui.ajoutlineview";
    private static final String AJDE_VERSION_KEY_CURRENT = "ajde.version";
    private static final String AJDE_VERSION_KEY_PREVIOUS = "ajde.version.at.previous.startup";
    public static boolean isDebugging;
    public static boolean DEBUG_BUILDER;
    public static boolean DEBUG_COMPILER;
    public static boolean DEBUG_OUTLINE;
    private static AspectJUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private ProjectProperties ajdtProjectProperties;
    private EditorAdapter ajdtEditorAdapter;
    private org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter ajdtBuildOptions;
    private AspectJImages ajdtImages;
    private AJDTStructureViewNodeFactory ajdtStructureFactory;
    private IdeUIAdapter ajdtUIAdapter;
    private ErrorHandler ajdtErrorHandler;
    private AspectJTextTools aspectJTextTools;
    private IResource currentResource;
    private Display display;
    IResourceChangeListener resourceChangeListener;
    public static final String SOURCE_LOCATION_ATTRIBUTE = "sourceLocationOfAdvice";
    public static final String RELATED_LOCATIONS_ATTRIBUTE_PREFIX = "relatedLocations-";
    public static final String ACCKIND_ATTRIBUTE = "acckind";
    private static final String defaultLstShouldBeUsed = "org.eclipse.ajdt.ui.buildConfig.useDefaultLst";
    public static final int PROGRESS_MONITOR_MAX = 100;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_15;

    static {
        Factory factory = new Factory("AspectJUIPlugin.java", Class.forName("org.eclipse.ajdt.ui.AspectJUIPlugin"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "java.util.MissingResourceException:", "<missing>:"), 285);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "getResourceString", "org.eclipse.ajdt.ui.AspectJUIPlugin", "java.lang.String:", "key:", "", "java.lang.String"), 280);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.core.runtime.CoreException:", "ce:"), 799);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getLstFiles", "org.eclipse.ajdt.ui.AspectJUIPlugin", "[Lorg.eclipse.core.resources.IResource;:java.util.List:", "resource_list:allLstFiles:", "", "void"), 788);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 853);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "addAjrtToBuildPath", "org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.core.resources.IProject:", "project:", "", "void"), 838);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 887);
        ajc$tjp_15 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("9", "removeAjrtFromBuildPath", "org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.core.resources.IProject:", "project:", "", "void"), 863);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "java.util.MissingResourceException:", "<missing>:"), 360);
        ajc$tjp_3 = factory.makeESJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "org.eclipse.ajdt.ui.AspectJUIPlugin", "", "", ""), 353);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "java.io.IOException:", "<missing>:"), 454);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkTemplatesInstalled", "org.eclipse.ajdt.ui.AspectJUIPlugin", "", "", "", "void"), 435);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.jdt.core.JavaModelException:", "jme:"), 750);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "selectionChanged", "org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.ui.IWorkbenchPart:org.eclipse.jface.viewers.ISelection:", "iwp:is:", "", "void"), 713);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.ui.AspectJUIPlugin", "org.eclipse.core.runtime.CoreException:", "ce:"), 771);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getListOfConfigFilesForCurrentProject", "org.eclipse.ajdt.ui.AspectJUIPlugin", "", "", "", "java.util.List"), 766);
        VERSION = "unset";
        isDebugging = false;
        DEBUG_BUILDER = false;
        DEBUG_COMPILER = false;
        DEBUG_OUTLINE = false;
    }

    public static AspectJUIPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AspectJUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(missingResourceException, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            return key;
        }
    }

    public static String getFormattedResourceString(String key, String arg) {
        return AspectJUIPlugin.getFormattedResourceString(key, new String[]{arg});
    }

    public static String getFormattedResourceString(String key, String[] args) {
        return MessageFormat.format(AspectJUIPlugin.getResourceString(key), args);
    }

    public static void setBuildConfigurationFile(IProject project, IFile buildfile) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String propertyName = "org.eclipse.ajdt.ui." + project.getName() + ".lst";
        if (buildfile == null) {
            store.setValue(propertyName, defaultLstShouldBeUsed);
        } else {
            store.setValue(propertyName, buildfile.getLocation().toOSString());
        }
        String cfg = AspectJPlugin.getBuildConfigurationFile((IProject)project);
        Ajde.getDefault().getConfigurationManager().setActiveConfigFile(cfg);
        AJLog.log((String)("Configuration file " + cfg + " selected for " + project.getName()));
    }

    public static void setBuildConfigurationFile(IProject project, IResource buildfile) {
        if (buildfile == null) {
            AspectJUIPlugin.setBuildConfigurationFile(project, null);
        } else if (buildfile instanceof IFile) {
            AspectJUIPlugin.setBuildConfigurationFile(project, (IFile)buildfile);
        }
    }

    public AspectJUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ajdt.internal.ui.resources.AspectJPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(missingResourceException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            this.resourceBundle = null;
        }
    }

    private void checkAspectJVersion() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String currentAjdeVersion = AspectJUIPlugin.getResourceString(AJDE_VERSION_KEY_CURRENT);
        String previousAjdeVersion = store.getString(AJDE_VERSION_KEY_PREVIOUS);
        if (previousAjdeVersion == null || !currentAjdeVersion.equals(previousAjdeVersion)) {
            AJLog.log((String)("New version of AJDE detected (now:" + currentAjdeVersion + ") - checking aspectjrt.jar for each project."));
            IProject[] projects = AspectJPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject current;
                if (projects[i].isOpen() && AspectJPlugin.isAJProject((IProject)(current = projects[i]))) {
                    AJDTUtils.verifyAjrtVersion(current);
                }
                ++i;
            }
            this.checkTemplatesInstalled();
            this.checkProblemMarkersVisible();
            store.putValue(AJDE_VERSION_KEY_PREVIOUS, currentAjdeVersion);
        }
    }

    private void checkProblemMarkersVisible() {
        String enabledMarkers;
        IDialogSettings filterSettings;
        String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
        String problemMarker = "org.eclipse.ajdt.ui.problemmarker:";
        UIPlugin plugin = UIPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null && (filterSettings = settings.getSection("filter")) != null && (enabledMarkers = filterSettings.get("selectedType")) != null && enabledMarkers.indexOf(problemMarker) == -1) {
            enabledMarkers = String.valueOf(enabledMarkers) + problemMarker;
            filterSettings.put("selectedType", enabledMarkers);
        }
    }

    private void checkTemplatesInstalled() {
        TemplateStore codeTemplates = JavaPlugin.getDefault().getTemplateStore();
        if (codeTemplates.findTemplate("adviceexecution") == null) {
            try {
                URL loc = this.getBundle().getEntry("/aspectj_code_templates.xml");
                TemplateReaderWriter trw = new TemplateReaderWriter();
                TemplatePersistenceData[] templates = trw.read(loc.openStream(), null);
                if (templates == null || templates.length == 0) {
                    AJLog.log((String)AspectJUIPlugin.getResourceString("codeTemplates.couldNotLoad"));
                } else {
                    int i = 0;
                    while (i < templates.length) {
                        codeTemplates.add(templates[i]);
                        ++i;
                    }
                    codeTemplates.save();
                }
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
                AJLog.log((String)AspectJUIPlugin.getResourceString("codeTemplates.couldNotLoad"));
            }
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.ajdtErrorHandler;
    }

    public ProjectProperties getAjdtProjectProperties() {
        return this.ajdtProjectProperties;
    }

    public org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter getAjdtBuildOptionsAdapter() {
        return this.ajdtBuildOptions;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        AJBuilder.addAJBuildListener((IAJBuildListener)new UIBuildListener());
        new BCWorkbenchWindowInitializer();
        this.display = Display.getDefault();
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new BCResourceChangeListener();
            this.enableBuildConfiguratorResourceChangeListener();
            AspectJPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 15);
        }
        Bundle bundle = AspectJUIPlugin.getDefault().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier pvi = new PluginVersionIdentifier(version);
        VERSION = String.valueOf(pvi.getMajorComponent()) + "." + pvi.getMinorComponent() + "." + pvi.getServiceComponent();
        this.initDebugging();
        AspectJPlugin.getDefault().setCoreOperations((ICoreOperations)new UICoreOperations());
        AspectJPlugin.getDefault().setAJLogger((IAJLogger)new EventTraceLogger());
        this.ajdtProjectProperties = new ProjectProperties();
        AspectJPlugin.getDefault().setCompilerMonitor((IAJCompilerMonitor)new CompilerMonitor());
        this.ajdtEditorAdapter = new EditorAdapter();
        this.ajdtErrorHandler = new ErrorHandler();
        this.ajdtBuildOptions = new org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter();
        this.ajdtImages = AspectJImages.instance();
        this.ajdtUIAdapter = new IdeUIAdapter();
        this.ajdtStructureFactory = new AJDTStructureViewNodeFactory(this.ajdtImages);
        Ajde.init((org.aspectj.ajde.EditorAdapter)this.ajdtEditorAdapter, (TaskListManager)CompilerTaskListManager.getInstance(), (BuildProgressMonitor)AspectJPlugin.getDefault().getCompilerMonitor(), (ProjectPropertiesAdapter)this.ajdtProjectProperties, (BuildOptionsAdapter)this.ajdtBuildOptions, (StructureViewNodeFactory)this.ajdtStructureFactory, (org.aspectj.ajde.ui.IdeUIAdapter)this.ajdtUIAdapter, (org.aspectj.ajde.ErrorHandler)this.ajdtErrorHandler);
        this.checkEclipseVersion();
        AJDTEventTrace.startup();
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String previousAJVersion = store.getString(AJDE_VERSION_KEY_PREVIOUS);
        this.checkAspectJVersion();
        FileFilter.checkIfFileFilterEnabledAndAsk();
        if (previousAJVersion.equals("")) {
            store.setValue("neverRunMigrationWizard", true);
            AspectJPreferences.setDontRunMigrationWizard(true);
        } else {
            IWorkspace currentWorkspace = ResourcesPlugin.getWorkspace();
            String workspaceLocation = currentWorkspace.getRoot().getLocation().toString();
            AspectJPreferences.setDontRunMigrationWizard(store.getBoolean(workspaceLocation) || this.workspaceIsEmpty(currentWorkspace.getRoot()) || store.getBoolean("neverRunMigrationWizard"));
        }
        AJCompilationUnitManager.INSTANCE.initCompilationUnits(AspectJPlugin.getWorkspace());
        BuilderUtils.initTypesCache();
        AJDTUtils.refreshPackageExplorer();
    }

    public boolean workspaceIsEmpty(IWorkspaceRoot root) {
        return !AspectJUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone") && root.getProjects().length == 0;
    }

    private void checkEclipseVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier pvi = new PluginVersionIdentifier(version);
        if (pvi.getMajorComponent() != 3 || pvi.getMinorComponent() != 0) {
            this.getErrorHandler().handleError(AspectJUIPlugin.getFormattedResourceString("wrong.eclipse.version", new String[]{"3.0", String.valueOf(pvi.getMajorComponent()) + "." + pvi.getMinorComponent()}));
        }
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return plugin.getWorkbench().getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        return this.display;
    }

    public AspectJTextTools getAspectJTextTools() {
        if (this.aspectJTextTools == null) {
            IPreferenceStore textToolPreferences = JavaPlugin.getDefault().getPreferenceStore();
            this.aspectJTextTools = new AspectJTextTools(textToolPreferences);
        }
        return this.aspectJTextTools;
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        AspectJPreferencePage.initDefaults(store);
        AJCompilerPreferencePage.initDefaults(store);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    private void initDebugging() {
        if (this.isDebugging()) {
            System.out.println("AJP START: org.eclipse.ajdt.ui " + VERSION);
            isDebugging = true;
            String option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/builderDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP builderDebug ON");
                DEBUG_BUILDER = true;
            } else {
                System.out.println("AJP builderDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/compilerDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP compilerDebug ON");
                DEBUG_COMPILER = true;
            } else {
                System.out.println("AJP compilerDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/outlineDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP outlineDebug ON");
                DEBUG_OUTLINE = true;
            } else {
                System.out.println("AJP outlineDebug OFF");
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        try {
            IStructuredSelection structuredSelection;
            Object o;
            if (is instanceof IStructuredSelection && (o = (structuredSelection = (IStructuredSelection)is).getFirstElement()) != null) {
                IJavaElement je;
                if (o instanceof IResource) {
                    this.currentResource = (IResource)o;
                    AspectJPlugin.getDefault().setCurrentProject(this.currentResource.getProject());
                } else if (o instanceof IJavaElement && (je = (IJavaElement)o).getJavaProject() != null) {
                    this.currentResource = je.getUnderlyingResource();
                    AspectJPlugin.getDefault().setCurrentProject(je.getJavaProject().getProject());
                }
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            JavaModelException jme = javaModelException;
            this.getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AspectJUIPlugin.exception.in.selection.changed"), jme);
        }
    }

    public List getListOfConfigFilesForCurrentProject() {
        ArrayList allLstFiles = new ArrayList();
        try {
            IResource[] files = AspectJPlugin.getDefault().getCurrentProject().members();
            this.getLstFiles(files, allLstFiles);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
            CoreException ce = coreException;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AspectJUIPlugin.exception.retrieving.lst.files"), ce);
        }
        return allLstFiles;
    }

    private void getLstFiles(IResource[] resource_list, List allLstFiles) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir.getName().endsWith(".lst") && !ir.getName().equals("default.lst")) {
                    allLstFiles.add(ir);
                }
                if (ir instanceof IContainer) {
                    this.getLstFiles(((IContainer)ir).members(), allLstFiles);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
            CoreException ce = coreException;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AspectJUIPlugin.exception.retrieving.lst.files"), ce);
        }
    }

    public void disableBuildConfiguratorResourceChangeListener() {
        AspectJPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    public void enableBuildConfiguratorResourceChangeListener() {
        AspectJPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 15);
    }

    public static void addAjrtToBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            IClasspathEntry ajrtLIB = JavaCore.newVariableEntry((IPath)new Path("ASPECTJRT_LIB"), null, null);
            int originalCPLength = originalCP.length;
            IClasspathEntry[] newCP = new IClasspathEntry[originalCPLength + 1];
            System.arraycopy(originalCP, 0, newCP, 0, originalCPLength);
            newCP[originalCPLength] = ajrtLIB;
            javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
        }
    }

    public static void removeAjrtFromBuildPath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] originalCP = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> tempCP = new ArrayList<IClasspathEntry>();
            int i = 0;
            while (i < originalCP.length) {
                IPath path = originalCP[i].getPath();
                if (!path.toOSString().endsWith("ASPECTJRT_LIB") && !path.toOSString().endsWith("aspectjrt.jar")) {
                    tempCP.add(originalCP[i]);
                }
                ++i;
            }
            if (originalCP.length != tempCP.size()) {
                IClasspathEntry[] newCP = tempCP.toArray(new IClasspathEntry[tempCP.size()]);
                javaProject.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(javaModelException, ajc$tjp_14, (JoinPoint.StaticPart)ajc$tjp_15);
        }
    }
}

