/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.asm;

import org.aspectj.org.objectweb.asm.Attribute;
import org.aspectj.org.objectweb.asm.ByteVector;
import org.aspectj.org.objectweb.asm.ClassReader;
import org.aspectj.org.objectweb.asm.ClassWriter;
import org.aspectj.org.objectweb.asm.Label;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.asm.AsmDelegate;

class AjASMAttribute
extends Attribute {
    private boolean unpacked = false;
    private byte[] data;

    protected AjASMAttribute(String type) {
        super(type);
    }

    protected AjASMAttribute(String type, byte[] data) {
        super(type);
        this.data = data;
    }

    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        byte[] data = new byte[len];
        System.arraycopy(cr.b, off, data, 0, len);
        return new AjASMAttribute(this.type, data);
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        throw new BCException("Attempt to write out the AjASMAttribute for " + this.type);
    }

    public boolean isUnknown() {
        return false;
    }

    public AjAttribute unpack(AsmDelegate relatedDelegate) {
        if (this.unpacked) {
            throw new BCException("Don't unpack an attribute twice!");
        }
        AjAttribute attr = AjAttribute.read(relatedDelegate.weaverVersion, this.type, this.data, relatedDelegate.getSourceContext(), relatedDelegate.getWorld().getMessageHandler());
        this.unpacked = true;
        return attr;
    }
}

