/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.core;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.aspectj.org.eclipse.jdt.internal.antadapter.AntAdapterMessages;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;

public class JDTCompilerAdapter
extends DefaultCompilerAdapter {
    private static String compilerClass = "org.aspectj.org.eclipse.jdt.internal.compiler.batch.Main";
    String logFileName;
    Map customDefaultOptions;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public boolean execute() throws BuildException {
        this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.usingJDTCompiler"), 3);
        Commandline cmd = this.setupJavacCommand();
        try {
            Class<?> c = Class.forName(compilerClass);
            Class[] classArray = new Class[4];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.io.PrintWriter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            classArray[2] = Boolean.TYPE;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.util.Map");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[3] = clazz3;
            Constructor<?> batchCompilerConstructor = c.getConstructor(classArray);
            Object batchCompilerInstance = batchCompilerConstructor.newInstance(new PrintWriter(System.out), new PrintWriter(System.err), Boolean.TRUE, this.customDefaultOptions);
            Class[] classArray2 = new Class[1];
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz4;
            Method compile = c.getMethod("compile", classArray2);
            Object result = compile.invoke(batchCompilerInstance, new Object[]{cmd.getArguments()});
            boolean resultValue = (Boolean)result;
            if (!resultValue && this.logFileName != null) {
                System.out.println(AntAdapterMessages.getString("ant.jdtadapter.error.compilationFailed", this.logFileName));
            }
            return resultValue;
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(AntAdapterMessages.getString("ant.jdtadapter.error.cannotFindJDTCompiler"));
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected Commandline setupJavacCommand() throws BuildException {
        String source;
        String memoryParameterPrefix;
        Commandline cmd = new Commandline();
        this.customDefaultOptions = new CompilerOptions().getMap();
        cmd.createArgument().setValue("-noExit");
        if (this.bootclasspath != null && this.bootclasspath.size() != 0) {
            cmd.createArgument().setValue("-bootclasspath");
            cmd.createArgument().setPath(this.bootclasspath);
        } else {
            this.includeJavaRuntime = true;
        }
        Path classpath = new Path(this.project);
        this.addExtdirs(this.extdirs, classpath);
        classpath.append(this.getCompileClasspath());
        Path sourcepath = null;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.apache.tools.ant.taskdefs.Javac");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> javacClass = clazz;
        Method getSourcepathMethod = null;
        try {
            getSourcepathMethod = javacClass.getMethod("getSourcepath", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        Path compileSourcePath = null;
        if (getSourcepathMethod != null) {
            try {
                compileSourcePath = (Path)getSourcepathMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        sourcepath = compileSourcePath != null ? compileSourcePath : this.src;
        classpath.append(sourcepath);
        cmd.createArgument().setValue("-classpath");
        cmd.createArgument().setPath(classpath);
        String string = memoryParameterPrefix = JavaEnvUtils.getJavaVersion().equals("1.1") ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryInitialSize"), 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.ignoringMemoryMaximumSize"), 1);
            } else {
                cmd.createArgument().setValue(String.valueOf(memoryParameterPrefix) + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.debug) {
            Method getDebugLevelMethod = null;
            try {
                getDebugLevelMethod = javacClass.getMethod("getDebugLevel", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            String debugLevel = null;
            if (getDebugLevelMethod != null) {
                try {
                    debugLevel = (String)getDebugLevelMethod.invoke((Object)this.attributes, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            if (debugLevel != null) {
                if (debugLevel.length() == 0) {
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                } else {
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                    if (debugLevel.indexOf("vars") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    }
                    if (debugLevel.indexOf("lines") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    }
                    if (debugLevel.indexOf("source") != -1) {
                        this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    }
                }
            } else {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
            }
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        }
        Method getCurrentCompilerArgsMethod = null;
        try {
            getCurrentCompilerArgsMethod = javacClass.getMethod("getCurrentCompilerArgs", null);
        }
        catch (NoSuchMethodException debugLevel) {
            // empty catch block
        }
        String[] compilerArgs = null;
        if (getCurrentCompilerArgsMethod != null) {
            try {
                compilerArgs = (String[])getCurrentCompilerArgsMethod.invoke((Object)this.attributes, null);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (this.attributes.getNowarn()) {
            Object[] entries = this.customDefaultOptions.entrySet().toArray();
            int i = 0;
            int max = entries.length;
            while (i < max) {
                Map.Entry entry = (Map.Entry)entries[i];
                if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                    this.customDefaultOptions.put(entry.getKey(), "ignore");
                }
                ++i;
            }
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.taskTags", "");
            if (this.deprecation) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
            }
        } else if (this.deprecation) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "enabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "enabled");
        } else {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
        }
        if (this.destDir != null) {
            cmd.createArgument().setValue("-d");
            cmd.createArgument().setFile(this.destDir.getAbsoluteFile());
        }
        if (this.target != null) {
            if (this.target.equals("1.1")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (this.target.equals("1.2")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            } else if (this.target.equals("1.3")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
            } else if (this.target.equals("1.4")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
            } else if (this.target.equals("1.5")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            } else {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.unknownTarget", this.target), 1);
            }
        }
        if (this.verbose && this.destDir != null) {
            cmd.createArgument().setValue("-log");
            this.logFileName = String.valueOf(this.destDir.getAbsolutePath()) + ".log";
            cmd.createArgument().setValue(this.logFileName);
        }
        if (!this.attributes.getFailonerror()) {
            cmd.createArgument().setValue("-proceedOnError");
        }
        if ((source = this.attributes.getSource()) != null) {
            if (source.equals("1.3")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.3");
            } else if (source.equals("1.4")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.4");
            } else if (source.equals("1.5")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.source", "1.5");
            } else {
                this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.unknownSource", source), 1);
            }
        }
        if (JavaEnvUtils.getJavaVersion().equals("1.0") || JavaEnvUtils.getJavaVersion().equals("1.1") || JavaEnvUtils.getJavaVersion().equals("1.2") || JavaEnvUtils.getJavaVersion().equals("1.3")) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
        } else if (JavaEnvUtils.getJavaVersion().equals("1.4")) {
            if (this.target != null && this.target.equals("1.1")) {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            } else {
                this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            }
        } else if (JavaEnvUtils.getJavaVersion().equals("1.5")) {
            this.customDefaultOptions.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
        } else {
            this.attributes.log(AntAdapterMessages.getString("ant.jdtadapter.info.unknownVmVersion", JavaEnvUtils.getJavaVersion()), 1);
        }
        if (this.encoding != null) {
            cmd.createArgument().setValue("-encoding");
            cmd.createArgument().setValue(this.encoding);
        }
        if (compilerArgs != null && compilerArgs.length != 0) {
            cmd.addArguments(compilerArgs);
        }
        this.logAndAddFilesToCompile(cmd);
        return cmd;
    }

    private void addExtdirs(Path extDirs, Path classpath) {
        if (extDirs == null) {
            String extProp = System.getProperty("java.ext.dirs");
            if (extProp != null) {
                extDirs = new Path(classpath.getProject(), extProp);
            } else {
                return;
            }
        }
        String[] dirs = extDirs.list();
        int i = 0;
        while (i < dirs.length) {
            File dir = classpath.getProject().resolveFile(dirs[i]);
            if (dir.exists() && dir.isDirectory()) {
                FileSet fs = new FileSet();
                fs.setDir(dir);
                fs.setIncludes("*");
                classpath.addFileset(fs);
            }
            ++i;
        }
    }
}

