/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ajdocexport;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.internal.ajdocexport.AJdocOptionsManager;
import org.eclipse.ajdt.internal.ajdocexport.AJdocSpecificsWizardPage;
import org.eclipse.ajdt.internal.ajdocexport.AJdocStandardWizardPage;
import org.eclipse.ajdt.internal.ajdocexport.AJdocTreeWizardPage;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.jarpackager.ConfirmSaveModifiedResourcesDialog;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AJdocWizard
extends Wizard
implements IExportWizard {
    private AJdocTreeWizardPage fJTWPage;
    private AJdocSpecificsWizardPage fJSWPage;
    private AJdocStandardWizardPage fJSpWPage;
    private IPath fDestination;
    private boolean fWriteCustom;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private AJdocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.jdt.ui.javadocProcess";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_14;

    public static void openJavadocWizard(AJdocWizard wizard, Shell shell, IStructuredSelection selection) {
        wizard.init(PlatformUI.getWorkbench(), selection);
        PixelConverter converter = new PixelConverter((Control)shell);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(100), converter.convertHeightInCharsToPixels(20));
        dialog.open();
    }

    public AJdocWizard() {
        this(null);
    }

    public AJdocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(AspectJImages.W_EXPORT_AJDOC.getImageDescriptor());
        this.setWindowTitle(AspectJUIPlugin.getResourceString("ajdocWizard.javadocwizard.title"));
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
        this.fWriteCustom = false;
    }

    public boolean performFinish() {
        IJavaProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        if (!this.checkPreconditions(this.fStore.getSourceElements())) {
            return false;
        }
        this.fDestination = new Path(this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURL();
                ArrayList<IJavaProject> projs = new ArrayList<IJavaProject>();
                int i = 0;
                while (i < checkedProjects.length) {
                    IJavaProject curr = checkedProjects[i];
                    URL currURL = JavaUI.getProjectJavadocLocation((IJavaProject)curr);
                    if (!newURL.equals(currURL)) {
                        projs.add(curr);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(malformedURLException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                MalformedURLException e = malformedURLException;
                JavaPlugin.log((Throwable)e);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore(IJavaProject[] checkedProjects) {
        this.fJTWPage.updateStore(checkedProjects);
        this.fJSpWPage.updateStore();
        this.fJSWPage.updateStore();
    }

    public boolean performCancel() {
        IJavaProject[] checkedProjects = this.fJTWPage.getCheckedProjects();
        this.updateStore(checkedProjects);
        if (this.fXmlJavadocFile == null) {
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] projects, URL newURL) {
        Shell shell = this.getShell();
        Image image = shell == null ? null : shell.getDisplay().getSystemImage(4);
        String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int j = 0;
        while (j < projects.length) {
            IJavaProject iJavaProject = projects[j];
            String message = JavadocExportMessages.getFormattedString((String)"JavadocWizard.updatejavadoclocation.message", (Object[])new String[]{iJavaProject.getElementName(), this.fDestination.toOSString()});
            MessageDialog dialog = new MessageDialog(shell, JavadocExportMessages.getString((String)"JavadocWizard.updatejavadocdialog.label"), image, message, 4, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaUI.setProjectJavadocLocation((IJavaProject)iJavaProject, (URL)newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    private boolean executeJavadocGeneration() {
        block19: {
            Process process = null;
            try {
                ArrayList userVmArgs = new ArrayList();
                ArrayList progArgs = new ArrayList();
                this.fStore.getArgumentArray(userVmArgs, progArgs);
                File file = File.createTempFile("javadoc-arguments", ".tmp");
                String jreDir = JavaRuntime.getDefaultVMInstall().getInstallLocation().getAbsolutePath();
                String aspectjrtDir = CoreUtils.getAspectjrtClasspath();
                String aspectjtoolsDir = "";
                URL ajdeURL = Platform.getBundle((String)"org.aspectj.ajde").getEntry("ajde.jar");
                URL weaverURL = Platform.getBundle((String)"org.aspectj.weaver").getEntry("aspectjweaver.jar");
                URL coreURL = Platform.getBundle((String)"org.eclipse.core.runtime").getEntry("runtime.jar");
                if (coreURL == null) {
                    coreURL = Platform.getBundle((String)"org.eclipse.core.runtime").getEntry("/");
                }
                try {
                    File coreFile;
                    File weaverFile;
                    File ajdeFile = new File(Platform.asLocalURL((URL)ajdeURL).getFile());
                    if (ajdeFile.exists()) {
                        aspectjtoolsDir = String.valueOf(aspectjtoolsDir) + ajdeFile.getAbsolutePath();
                    }
                    if ((weaverFile = new File(Platform.asLocalURL((URL)weaverURL).getFile())).exists()) {
                        aspectjtoolsDir = String.valueOf(aspectjtoolsDir) + File.pathSeparator + weaverFile.getAbsolutePath();
                    }
                    if ((coreFile = new File(Platform.asLocalURL((URL)coreURL).getFile())).exists()) {
                        aspectjtoolsDir = String.valueOf(aspectjtoolsDir) + File.pathSeparator + coreFile.getAbsolutePath();
                    }
                }
                catch (IOException iOException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
                }
                ArrayList<String> vmArgs = new ArrayList<String>();
                String[] contentsOfJREDir = JavaRuntime.getDefaultVMInstall().getInstallLocation().list();
                boolean foundJavaCmd = false;
                int i = 0;
                while (i < contentsOfJREDir.length) {
                    if (contentsOfJREDir[i].equals("bin")) {
                        vmArgs.add(String.valueOf(jreDir) + File.separator + "bin" + File.separator + "java");
                        foundJavaCmd = true;
                        break;
                    }
                    ++i;
                }
                if (!foundJavaCmd) {
                    vmArgs.add(String.valueOf(jreDir) + File.separator + "jre" + File.separator + "bin" + File.separator + "java");
                }
                String toolsDir = String.valueOf(jreDir) + File.separator + "lib" + File.separator + "tools.jar";
                boolean noXmx = true;
                Iterator iter = userVmArgs.iterator();
                while (iter.hasNext()) {
                    String element = (String)iter.next();
                    if (element.startsWith("-Xmx")) {
                        noXmx = false;
                    }
                    if (element.indexOf("tools.jar") != -1) {
                        toolsDir = element;
                        continue;
                    }
                    vmArgs.add(element);
                }
                if (noXmx) {
                    vmArgs.add("-Xmx64M");
                }
                vmArgs.add("-classpath");
                vmArgs.add(String.valueOf(aspectjtoolsDir) + File.pathSeparator + toolsDir + File.pathSeparator + aspectjrtDir);
                vmArgs.add("org.aspectj.tools.ajdoc.Main");
                int i2 = 0;
                while (i2 < progArgs.size()) {
                    String curr = (String)progArgs.get(i2);
                    vmArgs.add(this.checkForSpaces(curr));
                    ++i2;
                }
                String[] args = vmArgs.toArray(new String[vmArgs.size()]);
                process = Runtime.getRuntime().exec(args);
                if (process == null) break block19;
                StringBuffer buf = new StringBuffer();
                int i3 = 0;
                while (i3 < args.length) {
                    buf.append(args[i3]);
                    buf.append(' ');
                    ++i3;
                }
                JavadocDebugEventListener listener = new JavadocDebugEventListener(this.getShell().getDisplay(), file);
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)listener);
                ILaunchConfigurationWorkingCopy wc = null;
                try {
                    ILaunchConfigurationType lcType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                    String name = JavadocExportMessages.getString((String)"JavadocWizard.launchconfig.name");
                    wc = lcType.newInstance(null, name);
                    wc.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
                    Launch newLaunch = new Launch((ILaunchConfiguration)wc, "run", null);
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)newLaunch, (Process)process, (String)AspectJUIPlugin.getResourceString("ajdocWizard.ajdocprocess.label"));
                    iprocess.setAttribute(IProcess.ATTR_CMDLINE, buf.toString());
                    iprocess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                    DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)newLaunch);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
                    CoreException e = coreException;
                    String title = AspectJUIPlugin.getResourceString("ajdocWizard.error.title");
                    String message = AspectJUIPlugin.getResourceString("ajdocWizard.launch.error.message");
                    ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)title, (String)message);
                }
                return true;
            }
            catch (IOException iOException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_3);
                IOException e = iOException;
                String title = AspectJUIPlugin.getResourceString("ajdocWizard.error.title");
                String message = AspectJUIPlugin.getResourceString("ajdocWizard.exec.error.message");
                Status status = new Status(4, "org.eclipse.jdt.ui", 4, e.getMessage(), (Throwable)e);
                ExceptionHandler.handle((CoreException)new CoreException((IStatus)status), (Shell)this.getShell(), (String)title, (String)message);
                return false;
            }
        }
        return false;
    }

    private String checkForSpaces(String curr) {
        if (curr.indexOf(32) == -1) {
            return curr;
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < curr.length()) {
            char ch = curr.charAt(i);
            if (ch == '\\' || ch == '\'') {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    private boolean checkPreconditions(IJavaElement[] elements) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof ICompilationUnit) {
                resources.add(elements[i].getResource());
            }
            ++i;
        }
        IFile[] unSavedFiles = this.getUnsavedFiles(resources);
        return this.saveModifiedResourcesIfUserConfirms(unSavedFiles);
    }

    private IFile[] getUnsavedFiles(List resources) {
        IEditorPart[] dirtyEditors = JavaPlugin.getDirtyEditors();
        HashSet<IFile> unsavedFiles = new HashSet<IFile>(dirtyEditors.length);
        if (dirtyEditors.length > 0) {
            int i = 0;
            while (i < dirtyEditors.length) {
                IFile dirtyFile;
                if (dirtyEditors[i].getEditorInput() instanceof IFileEditorInput && resources.contains(dirtyFile = ((IFileEditorInput)dirtyEditors[i].getEditorInput()).getFile())) {
                    unsavedFiles.add(dirtyFile);
                }
                ++i;
            }
        }
        return unsavedFiles.toArray(new IFile[unsavedFiles.size()]);
    }

    private boolean saveModifiedResourcesIfUserConfirms(IFile[] dirtyFiles) {
        if (this.confirmSaveModifiedResources(dirtyFiles)) {
            try {
                if (this.saveModifiedResources(dirtyFiles)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
                CoreException e = coreException;
                ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)JavadocExportMessages.getString((String)"AJdocWizard.saveresourcedialogCE.title"), (String)JavadocExportMessages.getString((String)"AJdocWizard.saveresourcedialogCE.message"));
            }
            catch (InvocationTargetException invocationTargetException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_7);
                InvocationTargetException e = invocationTargetException;
                ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)JavadocExportMessages.getString((String)"AJdocWizard.saveresourcedialogITE.title"), (String)JavadocExportMessages.getString((String)"AJdocWizard.saveresourcedialogITE.message"));
            }
        }
        return false;
    }

    private boolean confirmSaveModifiedResources(IFile[] dirtyFiles) {
        if (dirtyFiles == null || dirtyFiles.length == 0) {
            return true;
        }
        Display display = this.getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final ConfirmSaveModifiedResourcesDialog dlg = new ConfirmSaveModifiedResourcesDialog(this.getShell(), dirtyFiles);
        final int[] intResult = new int[1];
        Runnable runnable = new Runnable(){

            public void run() {
                intResult[0] = dlg.open();
            }
        };
        display.syncExec(runnable);
        return intResult[0] == 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveModifiedResources(IFile[] dirtyFiles) throws CoreException, InvocationTargetException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        boolean autoBuild = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            workspace.setDescription(description);
            try {
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), this.createSaveModifiedResourcesRunnable(dirtyFiles), (ISchedulingRule)workspace.getRoot());
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                throw throwable;
            }
            {
                Object var5_7 = null;
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_9, (JoinPoint.StaticPart)ajc$tjp_10);
            return false;
        }
    }

    private IRunnableWithProgress createSaveModifiedResourcesRunnable(final IFile[] dirtyFiles) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pm) {
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                IEditorPart[] editorsToSave = JavaPlugin.getDirtyEditors();
                String name = JavadocExportMessages.getString((String)"AJdocWizard.savetask.name");
                pm.beginTask(name, editorsToSave.length);
                try {
                    List<IFile> dirtyFilesList = Arrays.asList(dirtyFiles);
                    int i = 0;
                    while (i < editorsToSave.length) {
                        IFile dirtyFile;
                        if (editorsToSave[i].getEditorInput() instanceof IFileEditorInput && dirtyFilesList.contains(dirtyFile = ((IFileEditorInput)editorsToSave[i].getEditorInput()).getFile())) {
                            editorsToSave[i].doSave((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                        pm.worked(1);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    pm.done();
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                }
                pm.done();
            }
        };
    }

    public void addPages() {
        this.fJTWPage = new AJdocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fJSWPage = new AJdocSpecificsWizardPage("JavadocSpecificsPage", this.fStore);
        this.fJSpWPage = new AJdocStandardWizardPage("JavadocStandardPage", this.fJTWPage, this.fStore);
        super.addPage((IWizardPage)this.fJTWPage);
        super.addPage((IWizardPage)this.fJSWPage);
        super.addPage((IWizardPage)this.fJSpWPage);
        this.fJTWPage.init();
        this.fJSWPage.init();
        this.fJSpWPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ArrayList<IJavaElement> selected = Collections.EMPTY_LIST;
        if (window != null) {
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                selected = ((IStructuredSelection)selection).toList();
            } else {
                IJavaElement element = EditorUtility.getActiveEditorJavaInput();
                if (element != null) {
                    selected = new ArrayList<IJavaElement>();
                    selected.add(element);
                }
            }
        }
        this.fStore = new AJdocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), selected);
    }

    private void refresh(IPath path) {
        if (this.fRoot.findContainersForLocation(path).length > 0) {
            try {
                this.fRoot.refreshLocal(2, null);
            }
            catch (CoreException coreException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_11, (JoinPoint.StaticPart)ajc$tjp_12);
                CoreException e = coreException;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURL();
                OpenBrowserUtil.open((URL)url, (Display)display, (String)this.getWindowTitle());
            }
            catch (MalformedURLException malformedURLException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(malformedURLException, (Object)this, ajc$tjp_13, (JoinPoint.StaticPart)ajc$tjp_14);
                MalformedURLException e = malformedURLException;
                JavaPlugin.log((Throwable)e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof AJdocTreeWizardPage) {
            return this.fJSWPage;
        }
        if (page instanceof AJdocSpecificsWizardPage) {
            return null;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof AJdocSpecificsWizardPage) {
            return this.fJSWPage;
        }
        if (page instanceof AJdocTreeWizardPage) {
            return null;
        }
        return null;
    }

    static {
        Factory factory = new Factory("AJdocWizard.java", Class.forName("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.net.MalformedURLException:", "e:"), 193);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "performFinish", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "", "", "", "boolean"), 151);
        ajc$tjp_10 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "saveModifiedResources", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "[Lorg.eclipse.core.resources.IFile;:", "dirtyFiles:", "org.eclipse.core.runtime.CoreException:java.lang.reflect.InvocationTargetException:", "boolean"), 571);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.CoreException:", "e:"), 668);
        ajc$tjp_12 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "refresh", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.IPath:", "path:", "", "void"), 664);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.net.MalformedURLException:", "e:"), 680);
        ajc$tjp_14 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "spawnInBrowser", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "org.eclipse.swt.widgets.Display:", "display:", "", "void"), 674);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.io.IOException:", "<missing>:"), 326);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "executeJavadocGeneration", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "", "", "", "boolean"), 291);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.CoreException:", "e:"), 413);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.io.IOException:", "e:"), 423);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "org.eclipse.core.runtime.CoreException:", "e:"), 512);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "saveModifiedResourcesIfUserConfirms", "org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "[Lorg.eclipse.core.resources.IFile;:", "dirtyFiles:", "", "boolean"), 507);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.lang.reflect.InvocationTargetException:", "e:"), 520);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ajdocexport.AJdocWizard", "java.lang.InterruptedException:", "<missing>:"), 589);
    }

    private class JavadocDebugEventListener
    implements IDebugEventSetListener {
        private Display fDisplay;
        private File fFile;

        public JavadocDebugEventListener(Display display, File file) {
            this.fDisplay = display;
            this.fFile = file;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                if (events[i].getKind() == 8) {
                    try {
                        if (!AJdocWizard.this.fWriteCustom) {
                            this.fFile.delete();
                            AJdocWizard.this.refresh(AJdocWizard.this.fDestination);
                            AJdocWizard.this.spawnInBrowser(this.fDisplay);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        throw throwable;
                    }
                    {
                        Object var3_5 = null;
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        return;
                    }
                }
                ++i;
            }
            return;
        }
    }
}

