/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildconfig;

import java.io.File;
import org.aspectj.ajdt.internal.core.builder.IncrementalStateManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.internal.buildconfig.BCResourceDeltaVisitor;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;

public class BCResourceChangeListener
implements IResourceChangeListener {
    private BCResourceDeltaVisitor myDeltaVisitor = new BCResourceDeltaVisitor();
    private BuildConfigurator myBCor = BuildConfigurator.getBuildConfigurator();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (event.getType() == 2 || event.getType() == 4) {
            IResource res = event.getResource();
            if (res.getType() == 4) {
                IProject project = (IProject)res;
                this.myBCor.closeProject(project);
                boolean delete = event.getType() == 4;
                String lstFileName = AspectJPlugin.getBuildConfigurationFile((IProject)project);
                File lstFile = new File(lstFileName);
                if (delete && lstFile.exists()) {
                    lstFile.delete();
                }
                AJModel.getInstance().clearMap(project, delete);
                IncrementalStateManager.removeIncrementalStateInformationFor((String)AspectJPlugin.getBuildConfigurationFile((IProject)project));
            }
        } else if (event.getType() == 1 && (delta = event.getDelta()) != null) {
            IResourceDelta[] cd = delta.getAffectedChildren();
            if (cd == null) {
                try {
                    delta.accept((IResourceDeltaVisitor)this.myDeltaVisitor);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            } else {
                int i = 0;
                while (i < cd.length) {
                    try {
                        IResource res = cd[i].getResource();
                        if (res == null) {
                            cd[i].accept((IResourceDeltaVisitor)this.myDeltaVisitor);
                        } else {
                            IProject proj = res.getProject();
                            if (proj == null || !proj.isAccessible() || AspectJPlugin.isAJProject((IProject)proj)) {
                                cd[i].accept((IResourceDeltaVisitor)this.myDeltaVisitor);
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                    }
                    ++i;
                }
            }
        }
    }

    static {
        Factory factory = new Factory("BCResourceChangeListener.java", Class.forName("org.eclipse.ajdt.internal.buildconfig.BCResourceChangeListener"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.BCResourceChangeListener", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 75);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "resourceChanged", "org.eclipse.ajdt.internal.buildconfig.BCResourceChangeListener", "org.eclipse.core.resources.IResourceChangeEvent:", "event:", "", "void"), 49);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.BCResourceChangeListener", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 94);
    }
}

