/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class AJMainTypeSelectionDialog
extends TwoPaneElementSelector {
    private Object[] types;

    public AJMainTypeSelectionDialog(Shell shell, Object[] types) {
        super(shell, (ILabelProvider)new AJElementLabelProvider(16), (ILabelProvider)new PackageRenderer());
        this.types = types;
        this.setMessage(LauncherMessages.getString((String)"MainTypeSelectionDialog.Choose_a_type"));
        this.setUpperListLabel(LauncherMessages.getString((String)"MainTypeSelectionDialog.Matching_types"));
        this.setLowerListLabel(LauncherMessages.getString((String)"MainTypeSelectionDialog.Qualifier"));
    }

    public Object[] getTypes() {
        return this.types;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    public int open() {
        if (this.types == null) {
            return 1;
        }
        this.setElements(this.types);
        return super.open();
    }

    public Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        AJMainTypeSelectionDialog.applyDialogFont((Control)control);
        return control;
    }

    private static class PackageRenderer
    extends JavaElementLabelProvider {
        public PackageRenderer() {
            super(2114);
        }

        public Image getImage(Object element) {
            if (element instanceof IType) {
                return super.getImage((Object)((IType)element).getPackageFragment());
            }
            return null;
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof IType) {
                text = super.getText((Object)((IType)element).getPackageFragment());
            }
            return text;
        }
    }

    private static class AJElementLabelProvider
    extends JavaElementLabelProvider {
        private ILabelProvider labelProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)new AppearanceAwareLabelProvider());

        public AJElementLabelProvider(int i) {
            super(i);
        }

        public Image getImage(Object element) {
            if (element instanceof AspectElement) {
                return this.labelProvider.getImage(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof AspectElement) {
                return this.labelProvider.getText(element);
            }
            return super.getText(element);
        }
    }
}

