/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnitManager;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractRulerActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class AdviceActionDelegate
extends AbstractRulerActionDelegate {
    IEditorPart editor = null;
    IVerticalRulerInfo rulerInfo = null;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public void setActiveEditor(IAction callerAction, IEditorPart targetEditor) {
        String id;
        if (!(targetEditor == null || (id = targetEditor.getSite().getId()).equals("org.eclipse.jdt.ui.CompilationUnitEditor") || id.equals("org.eclipse.jdt.ui.ClassFileEditor") || id.equals("org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor"))) {
            targetEditor = null;
        }
        this.editor = targetEditor;
        super.setActiveEditor(callerAction, targetEditor);
    }

    protected IAction createAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.rulerInfo = rulerInfo;
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        try {
            IFileEditorInput ifep = (IFileEditorInput)this.editor.getEditorInput();
            IFile ifile = ifep.getFile();
            int linenumber = this.rulerInfo.getLineOfLastMouseButtonActivity();
            Integer clickedLine = new Integer(linenumber + 1);
            Object cu = ifile.getFileExtension().equals("aj") ? AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(ifile) : (ICompilationUnit)JavaCore.create((IFile)ifile);
            List javaElementsForLine = this.getJavaElementsForLine((IJavaElement)cu, clickedLine);
            boolean addedSeparator = false;
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.ADVISES);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.ADVISED_BY);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.ANNOTATES);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.ANNOTATED_BY);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.DECLARED_ON);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.ASPECT_DECLARATIONS);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.SOFTENS);
            addedSeparator = this.createMenuForRelationshipType(javaElementsForLine, manager, addedSeparator, AJRelationshipManager.SOFTENED_BY);
            IMarker[] probMarkers = ifile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            MenuManager problemSubmenu = null;
            boolean problemSubmenuInitialized = false;
            if (probMarkers != null && probMarkers.length != 0) {
                int j = 0;
                while (j < probMarkers.length) {
                    IMarker m = probMarkers[j];
                    if (m.getAttribute("lineNumber").equals(clickedLine)) {
                        String loc;
                        int relCount = 0;
                        if ((loc = (String)m.getAttribute("relatedLocations-" + relCount++)) != null) {
                            while (loc != null) {
                                String[] s = loc.split(":::");
                                String resName = s[0].substring(s[0].lastIndexOf(File.separator) + 1);
                                String textLabel = AspectJUIPlugin.getFormattedResourceString("EditorRulerContextMenu.relatedLocation.message", new String[]{resName, s[1]});
                                RelatedLocationMenuAction ama = new RelatedLocationMenuAction(textLabel, loc);
                                if (!problemSubmenuInitialized) {
                                    problemSubmenu = new MenuManager(AspectJUIPlugin.getResourceString("EditorRulerContextMenu.relatedLocations"));
                                    if (!addedSeparator) {
                                        manager.add((IContributionItem)new Separator());
                                    }
                                    manager.add((IContributionItem)problemSubmenu);
                                    problemSubmenuInitialized = true;
                                }
                                problemSubmenu.add((IAction)ama);
                                loc = (String)m.getAttribute("relatedLocations-" + relCount++);
                            }
                        }
                    }
                    ++j;
                }
            }
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException ce = coreException;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AdviceActionDelegate.exception.adding.advice.to.context.menu"), ce);
        }
    }

    private boolean createMenuForRelationshipType(List javaElements, IMenuManager manager, boolean addedSeparator, AJRelationshipType relationshipType) {
        boolean menuInitialized = false;
        MenuManager menu = null;
        Iterator iter = javaElements.iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            List relationships = AJModel.getInstance().getRelatedElements(relationshipType, element);
            if (relationships == null) continue;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                IJavaElement el = (IJavaElement)iterator.next();
                if (!addedSeparator) {
                    manager.add((IContributionItem)new Separator());
                    addedSeparator = true;
                }
                if (!menuInitialized) {
                    menu = new MenuManager(AspectJPlugin.getResourceString((String)(String.valueOf(relationshipType.getInternalName()) + ".menuName")));
                    manager.add((IContributionItem)new Separator());
                    manager.add((IContributionItem)menu);
                    menuInitialized = true;
                }
                menu.add((IAction)new MenuAction(el));
            }
        }
        return addedSeparator;
    }

    private List getJavaElementsForLine(IJavaElement je, int clickedLine) {
        IJavaElement[] children;
        AJModel model = AJModel.getInstance();
        ArrayList<IJavaElement> toReturn = new ArrayList<IJavaElement>();
        List extraChildren = model.getExtraChildren(je);
        if (extraChildren != null) {
            Iterator iter = extraChildren.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                if (model.getJavaElementLineNumber(element) == clickedLine) {
                    toReturn.add(element);
                }
                toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
            }
        }
        if (je instanceof ICompilationUnit) {
            try {
                children = ((ICompilationUnit)je).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement element = children[i];
                    if (model.getJavaElementLineNumber(element) == clickedLine) {
                        toReturn.add(element);
                    }
                    toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        } else if (je instanceof IType) {
            try {
                children = ((IType)je).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement element = children[i];
                    if (model.getJavaElementLineNumber(element) == clickedLine) {
                        toReturn.add(element);
                    }
                    toReturn.addAll(this.getJavaElementsForLine(element, clickedLine));
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_3);
            }
        }
        return toReturn;
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

            public void run() {
                IEditorStatusLine fStatusLine;
                IEditorPart iEditorPart = AdviceActionDelegate.this.editor;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((fStatusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                    fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }

            static {
                Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1", "java.lang.ClassNotFoundException:", "<missing>:"), 439);
                ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$1", "", "", "", "void"), 438);
            }
        });
    }

    static {
        Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.core.runtime.CoreException:", "ce:"), 189);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "menuAboutToShow", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.jface.action.IMenuManager:", "manager:", "", "void"), 111);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 265);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "getJavaElementsForLine", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.jdt.core.IJavaElement:int:", "je:clickedLine:", "", "java.util.List"), 242);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 277);
    }

    private static class MenuAction
    extends Action {
        private static ILabelProvider labelProvider;
        private IJavaElement jumpLocation;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 318);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$MenuAction", "", "", "", "void"), 306);
            labelProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)new AppearanceAwareLabelProvider());
        }

        public MenuAction(IJavaElement el) {
            super(AJModel.getInstance().getJavaElementLinkName(el));
            Image image = labelProvider.getImage((Object)el);
            if (image != null) {
                this.setImageDescriptor((ImageDescriptor)new ImageImageDescriptor(image));
            }
            this.jumpLocation = el;
        }

        public void run() {
            IJavaElement parentCU = this.jumpLocation.getAncestor(5);
            if (parentCU != null) {
                IResource res = parentCU.getResource();
                try {
                    IMarker marker = res.createMarker("org.eclipse.core.resources.marker");
                    int lineNumber = AJModel.getInstance().getJavaElementLineNumber(this.jumpLocation);
                    if (lineNumber >= 0) {
                        marker.setAttribute("lineNumber", lineNumber);
                    }
                    IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker);
                }
                catch (CoreException coreException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                }
            }
        }
    }

    abstract class BaseAJDTMenuAction
    extends Action {
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        BaseAJDTMenuAction(String s) {
            super(s);
        }

        abstract String getJumpLocation();

        public void run() {
            block8: {
                try {
                    String[] s = this.getJumpLocation().split(":::");
                    String filepath = s[0];
                    String linenumber = s[1];
                    IResource r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath);
                    if (r == null) {
                        r = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(filepath, AspectJPlugin.getDefault().getCurrentProject());
                    }
                    IResource ir = r;
                    IMarker jumpMarker = null;
                    if (ir != null && ir.exists()) {
                        try {
                            jumpMarker = ir.createMarker("org.eclipse.core.resources.textmarker");
                            jumpMarker.setAttribute("lineNumber", new Integer(linenumber).intValue());
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                            CoreException ce = coreException;
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AdviceActionDelegate.unable.to.create.marker"), ce);
                        }
                        try {
                            IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IMarker)jumpMarker, (boolean)true);
                        }
                        catch (Exception exception) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
                            Exception e = exception;
                            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AdviceActionDelegate.exception.jumping"), e);
                        }
                        break block8;
                    }
                    AdviceActionDelegate.this.report(AspectJUIPlugin.getResourceString("AdviceActionDelegate.resource.not.found"));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(indexOutOfBoundsException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_1);
                    IndexOutOfBoundsException ioobe = indexOutOfBoundsException;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("AdviceActionDelegate.problem.finding.jump.location"), ioobe);
                }
            }
        }

        static {
            Factory factory = new Factory("AdviceActionDelegate.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "org.eclipse.core.runtime.CoreException:", "ce:"), 385);
            ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "", "", "", "void"), 351);
            ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.Exception:", "e:"), 398);
            ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.AdviceActionDelegate$BaseAJDTMenuAction", "java.lang.IndexOutOfBoundsException:", "ioobe:"), 410);
        }
    }

    class RelatedLocationMenuAction
    extends BaseAJDTMenuAction {
        private String jumpLocation;

        RelatedLocationMenuAction(String s, String jumpLocation) {
            super(s);
            this.jumpLocation = jumpLocation;
            this.setImageDescriptor(JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.jcu_obj.gif"));
        }

        String getJumpLocation() {
            return this.jumpLocation;
        }
    }
}

