/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.wizards.TabFolderLayout;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AJCompilerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    private static final String PREF_AJ_SHADOW_NOT_IN_STRUCTURE = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    private static final String PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    private static final String PREF_AJ_INVALID_WILDCARD_TYPE_NAME = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    private static final String PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    private static final String PREF_AJ_UNRESOLVABLE_MEMBER = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    private static final String PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    private static final String PREF_AJ_INCOMPATIBLE_SERIAL_VERSION = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    private static final String PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    private static final String PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    private static final String PREF_ENABLE_NO_WEAVE = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    private static final String PREF_ENABLE_SERIALIZABLE_ASPECTS = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    private static final String PREF_ENABLE_NO_INLINE = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    private static final String PREF_ENABLE_NOT_REWEAVABLE = "org.aspectj.ajdt.core.compiler.weaver.XNotReweavable";
    private static final String PREF_ENABLE_HAS_MEMBER = "org.aspectj.ajdt.core.compiler.weaver.XHasMember";
    private static final String PREF_ENABLE_INCREMENTAL = "org.aspectj.ajdt.core.compiler.BuildOptions.incrementalMode";
    private static final String PREF_ENABLE_BUILD_ASM = "org.aspectj.ajdt.core.compiler.BuildOptions.buildAsm";
    private static final String PREF_ENABLE_WEAVE_MESSAGES = "org.aspectj.ajdt.core.compiler.BuildOptions.showweavemessages";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private Button noweaveButton;
    private Button noinlineButton;
    private Button notReweaveableButton;
    private Button hasMemberButton;
    protected List fComboBoxes;
    protected List fCheckBoxes;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public AJCompilerPreferencePage() {
        this.setTitle(AspectJUIPlugin.getResourceString("AJCompilerPreferencePage.aspectj.compiler"));
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME, WARNING);
        store.setDefault(PREF_AJ_SHADOW_NOT_IN_STRUCTURE, IGNORE);
        store.setDefault(PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP, IGNORE);
        store.setDefault(PREF_AJ_INVALID_WILDCARD_TYPE_NAME, IGNORE);
        store.setDefault(PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER, WARNING);
        store.setDefault(PREF_AJ_UNRESOLVABLE_MEMBER, WARNING);
        store.setDefault(PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL, WARNING);
        store.setDefault(PREF_AJ_INCOMPATIBLE_SERIAL_VERSION, IGNORE);
        store.setDefault(PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD, IGNORE);
        store.setDefault(PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT, WARNING);
        store.setDefault(PREF_ENABLE_NO_WEAVE, false);
        store.setDefault(PREF_ENABLE_SERIALIZABLE_ASPECTS, false);
        store.setDefault(PREF_ENABLE_NO_INLINE, false);
        store.setDefault(PREF_ENABLE_NOT_REWEAVABLE, false);
        store.setDefault(PREF_ENABLE_HAS_MEMBER, false);
        store.setDefault(PREF_ENABLE_INCREMENTAL, true);
        store.setDefault(PREF_ENABLE_BUILD_ASM, true);
        store.setDefault(PREF_ENABLE_WEAVE_MESSAGES, false);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.runtimeExceptionNotSoftened", WARNING);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.multipleAdviceStoppingLazyTjp", IGNORE);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.noGuardForLazyTjp", IGNORE);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.noExplicitConstructorCall", WARNING);
        store.setDefault("org.aspectj.ajdt.core.complier.lint.aspectExcludedByConfiguration", IGNORE);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.unorderedAdviceAtShadow", IGNORE);
        store.setDefault("org.aspectj.ajdt.core.compiler.lint.swallowedExceptionInCatchBlock", IGNORE);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Composite aspectjComposite = this.createMessagesTabContent((Composite)folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.tabtitle"));
        item.setControl((Control)aspectjComposite);
        aspectjComposite = this.createAdvancedTabContent((Composite)folder);
        item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.tabtitle"));
        item.setControl((Control)aspectjComposite);
        aspectjComposite = this.createOtherTabContent((Composite)folder);
        item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_other.tabtitle"));
        item.setControl((Control)aspectjComposite);
        return folder;
    }

    private Composite createMessagesTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.error"), AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.warning"), AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.ignore")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_messages.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_absolute_type_name.label");
        this.addComboBox(composite, label, PREF_AJ_INVALID_ABSOLUTE_TYPE_NAME, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_invalid_wildcard_type_name.label");
        this.addComboBox(composite, label, PREF_AJ_INVALID_WILDCARD_TYPE_NAME, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_unresolvable_member.label");
        this.addComboBox(composite, label, PREF_AJ_UNRESOLVABLE_MEMBER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_type_not_exposed_to_weaver.label");
        this.addComboBox(composite, label, PREF_AJ_TYPE_NOT_EXPOSED_TO_WEAVER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_shadow_not_in_structure.label");
        this.addComboBox(composite, label, PREF_AJ_SHADOW_NOT_IN_STRUCTURE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_unmatched_super_type_in_call.label");
        this.addComboBox(composite, label, PREF_AJ_UNMATCHED_SUPER_TYPE_IN_CALL, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_cannot_implement_lazy_tjp.label");
        this.addComboBox(composite, label, PREF_AJ_CANNOT_IMPLEMENT_LAZY_TJP, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_need_serial_version_uid_field.label");
        this.addComboBox(composite, label, PREF_AJ_NEED_SERIAL_VERSION_UID_FIELD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_incompatible_serial_version.label");
        this.addComboBox(composite, label, PREF_AJ_INCOMPATIBLE_SERIAL_VERSION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_no_interface_ctor_joinpoint.label");
        this.addComboBox(composite, label, PREF_AJ_NO_INTERFACE_CTOR_JOINPOINT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.runtime_exception_not_softened");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.runtimeExceptionNotSoftened", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.multiple_advice_stopping_lazy_tjp");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.multipleAdviceStoppingLazyTjp", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.no_guard_for_lazy_tjp");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.noGuardForLazyTjp", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.no_explicit_constructor_call");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.noExplicitConstructorCall", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aspect_excluded_by_configuration");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.complier.lint.aspectExcludedByConfiguration", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.unordered_advice_at_shadow");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.unorderedAdviceAtShadow", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.swallowed_exception_in_catch_block");
        this.addComboBox(composite, label, "org.aspectj.ajdt.core.compiler.lint.swallowedExceptionInCatchBlock", errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return composite;
    }

    private Composite createAdvancedTabContent(Composite folder) {
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        CheckBoxListener checkBoxListener = new CheckBoxListener();
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_advanced.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_no_weave.label");
        this.noweaveButton = this.addCheckBox(composite, label, PREF_ENABLE_NO_WEAVE, enableDisableValues, 0);
        this.noweaveButton.addSelectionListener((SelectionListener)checkBoxListener);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_serializable_aspects.label");
        this.addCheckBox(composite, label, PREF_ENABLE_SERIALIZABLE_ASPECTS, enableDisableValues, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_no_inline.label");
        this.noinlineButton = this.addCheckBox(composite, label, PREF_ENABLE_NO_INLINE, enableDisableValues, 0);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_not_reweavable.label");
        this.notReweaveableButton = this.addCheckBox(composite, label, PREF_ENABLE_NOT_REWEAVABLE, enableDisableValues, 0);
        this.notReweaveableButton.addSelectionListener((SelectionListener)checkBoxListener);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_x_has_member.label");
        this.hasMemberButton = this.addCheckBox(composite, label, PREF_ENABLE_HAS_MEMBER, enableDisableValues, 0);
        this.hasMemberButton.addSelectionListener((SelectionListener)checkBoxListener);
        this.checkNoWeaveSelection();
        return composite;
    }

    private Composite createOtherTabContent(Composite folder) {
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_other.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_enable_incremental.label");
        this.addCheckBox(composite, label, PREF_ENABLE_INCREMENTAL, enableDisableValues, 0, false);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_enable_build_asm.label");
        this.addCheckBox(composite, label, PREF_ENABLE_BUILD_ASM, enableDisableValues, 0, false);
        label = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.aj_enable_weave_messages.label");
        this.addCheckBox(composite, label, PREF_ENABLE_WEAVE_MESSAGES, enableDisableValues, 0);
        this.checkNoWeaveSelection();
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return AspectJUIPlugin.getDefault().getPreferenceStore();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean lintChanges = false;
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            Combo curr = (Combo)this.fComboBoxes.get(i);
            ControlData data = (ControlData)curr.getData();
            String value = data.getValue(curr.getSelectionIndex());
            if (!value.equals(store.getString(data.getKey()))) {
                lintChanges = true;
                store.setValue(data.getKey(), value);
            }
            --i;
        }
        boolean advancedOrOtherChanges = false;
        int i2 = this.fCheckBoxes.size() - 1;
        while (i2 >= 0) {
            Button curr = (Button)this.fCheckBoxes.get(i2);
            ControlData data = (ControlData)curr.getData();
            boolean value = curr.getSelection();
            if (value != store.getBoolean(data.getKey())) {
                advancedOrOtherChanges = true;
                store.setValue(data.getKey(), value);
            }
            --i2;
        }
        AspectJUIPlugin.getDefault().savePluginPreferences();
        if (lintChanges || advancedOrOtherChanges) {
            boolean doBuild = false;
            String[] strings = this.getFullBuildDialogStrings();
            if (strings != null) {
                MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = dialog.open();
                if (res == 0) {
                    doBuild = true;
                } else if (res != 1) {
                    return false;
                }
            }
            if (doBuild) {
                this.doFullBuild();
            }
        }
        return true;
    }

    protected String[] getFullBuildDialogStrings() {
        String title = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.needsbuild.title");
        String message = AspectJUIPlugin.getResourceString("CompilerConfigurationBlock.needsfullbuild.message");
        return new String[]{title, message};
    }

    protected void doFullBuild() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    monitor.beginTask("", 2);
                    try {
                        try {
                            monitor.setTaskName(AspectJUIPlugin.getResourceString("OptionsConfigurationBlock.buildall.taskname"));
                            ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (CoreException coreException) {
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                            CoreException e = coreException;
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    monitor.done();
                }

                static {
                    Factory factory = new Factory("AJCompilerPreferencePage.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage$1"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage$1", "org.eclipse.core.runtime.CoreException:", "e:"), 490);
                    ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage$1", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "java.lang.reflect.InvocationTargetException:", "void"), 480);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        catch (InvocationTargetException invocationTargetException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            InvocationTargetException e = invocationTargetException;
            String message = AspectJUIPlugin.getResourceString("OptionsConfigurationBlock.builderror.message");
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(message, e);
        }
    }

    protected void performDefaults() {
        String defaultValue;
        ControlData data;
        Combo curr;
        super.performDefaults();
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            curr = (Combo)this.fComboBoxes.get(i);
            data = (ControlData)curr.getData();
            defaultValue = this.getPreferenceStore().getDefaultString(data.getKey());
            curr.select(data.getSelection(defaultValue));
            --i;
        }
        i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            curr = (Button)this.fCheckBoxes.get(i);
            curr.setEnabled(true);
            data = (ControlData)curr.getData();
            defaultValue = this.getPreferenceStore().getDefaultString(data.getKey());
            curr.setSelection(defaultValue.equals("true"));
            --i;
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        return this.addCheckBox(parent, label, key, values, indent, true);
    }

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent, boolean fillGridVertically) {
        ControlData data = new ControlData(key, values);
        int idx = label.indexOf("-");
        String optionname = label.substring(0, idx);
        String optiondesc = label.substring(idx + 1);
        optiondesc = optiondesc.trim();
        GridData gd = new GridData();
        if (fillGridVertically) {
            gd.verticalAlignment = 4;
        }
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        Button checkBox = new Button(parent, 32);
        checkBox.setText(optionname);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        Label l = new Label(parent, 64);
        l.setText(optiondesc);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 20;
        l.setLayoutData((Object)gridData);
        this.createLabel(parent, "");
        boolean currValue = this.getPreferenceStore().getBoolean(key);
        checkBox.setSelection(currValue);
        this.fCheckBoxes.add(checkBox);
        return checkBox;
    }

    protected void addComboBox(Composite parent, String label, String key, String[] values, String[] valueLabels, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16448);
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = new Combo(parent, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.setLayoutData((Object)new GridData(256));
        Label placeHolder = new Label(parent, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        String currValue = this.getPreferenceStore().getString(key);
        if (currValue != null && currValue.length() > 0) {
            comboBox.select(data.getSelection(currValue));
        }
        this.fComboBoxes.add(comboBox);
    }

    private void checkNoWeaveSelection() {
        boolean buttonSelected = this.noweaveButton.getSelection();
        if (buttonSelected) {
            this.noinlineButton.setEnabled(!buttonSelected);
            this.notReweaveableButton.setEnabled(!buttonSelected);
        }
    }

    static {
        Factory factory = new Factory("AJCompilerPreferencePage.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage", "java.lang.InterruptedException:", "<missing>:"), 497);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "doFullBuild", "org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage", "", "", "", "void"), 476);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage", "java.lang.reflect.InvocationTargetException:", "e:"), 499);
    }

    protected static class ControlData {
        private String fKey;
        private String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            int i = 0;
            while (i < this.fValues.length) {
                if (value.equals(this.fValues[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
    }

    private class CheckBoxListener
    implements SelectionListener {
        CheckBoxListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource().equals(AJCompilerPreferencePage.this.noweaveButton)) {
                boolean buttonSelected = AJCompilerPreferencePage.this.noweaveButton.getSelection();
                if (buttonSelected) {
                    AJCompilerPreferencePage.this.noinlineButton.setSelection(false);
                    AJCompilerPreferencePage.this.notReweaveableButton.setSelection(false);
                }
                AJCompilerPreferencePage.this.noinlineButton.setEnabled(!buttonSelected);
                AJCompilerPreferencePage.this.notReweaveableButton.setEnabled(!buttonSelected);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

