/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.internal.ui.wizards.InPathLibrariesWorkbookPage;
import org.eclipse.ajdt.internal.ui.wizards.TabFolderLayout;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class InPathBlock
implements PreferencePageBuilder.AJDTPathBlockPage {
    private IWorkspaceRoot fWorkspaceRoot = AspectJPlugin.getWorkspace().getRoot();
    private ListDialogField fInPathList;
    private StatusInfo fInPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private int fPageIndex;
    private InPathLibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;

    public InPathBlock(IStatusChangeListener context, int pageToShow) {
        this.fContext = context;
        this.fPageIndex = pageToShow;
        this.fLibrariesPage = null;
        this.fCurrPage = null;
        InPathAdapter adapter = new InPathAdapter();
        String[] buttonLabels = new String[]{AspectJUIPlugin.getResourceString("InPathBlock.order.up.button"), AspectJUIPlugin.getResourceString("InPathBlock.order.down.button")};
        this.fInPathList = new ListDialogField(null, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fInPathList.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fInPathList.setLabelText(AspectJUIPlugin.getResourceString("InPathBlock.inpath.label"));
        this.fInPathList.setUpButtonIndex(0);
        this.fInPathList.setDownButtonIndex(1);
        this.fBuildPathStatus = new StatusInfo();
        this.fInPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fInPathList) {
            this.updateInPathStatus();
        }
        this.doStatusLineUpdate();
    }

    public void init(IJavaProject jproject, IPath outputLocation, IClasspathEntry[] inpathEntries) {
        this.fCurrJProject = jproject;
        boolean projectExists = false;
        ArrayList newInPath = null;
        IProject project = this.fCurrJProject.getProject();
        boolean bl = projectExists = project.exists() && project.getFile(".ajpath").exists();
        if (projectExists) {
            // empty if block
        }
        if (outputLocation == null) {
            outputLocation = this.getDefaultBuildPath(jproject);
        }
        if (inpathEntries != null) {
            newInPath = this.getExistingEntries(inpathEntries);
        }
        if (newInPath == null) {
            newInPath = new ArrayList();
        }
        this.fOutputLocationPath = new Path(outputLocation.makeRelative().toString()).makeAbsolute();
        ArrayList arrayList = newInPath;
        ListDialogField listDialogField = this.fInPathList;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$7$5dca5dc3(listDialogField, arrayList, this);
        listDialogField.setElements(arrayList);
        if (this.fLibrariesPage != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.doStatusLineUpdate();
    }

    public void updateInPathStatus() {
        this.fInPathStatus.setOK();
        List elements = this.fInPathList.getElements();
        CPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fInPathStatus.setWarning(AspectJUIPlugin.getResourceString("InPathBlock.warning.EntryMissing"));
            } else {
                this.fInPathStatus.setWarning(AspectJUIPlugin.getResourceString("InPathBlock.warning.EntriesMissing"));
            }
        }
        this.updateBuildPathStatus();
    }

    private void doStatusLineUpdate() {
        IStatus res = this.findMostSevereStatus();
        this.fContext.statusChanged(res);
    }

    private IPath getDefaultBuildPath(IJavaProject jproj) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String outputLocationName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return jproj.getProject().getFullPath().append(outputLocationName);
        }
        return jproj.getProject().getFullPath();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] inpathEntries) {
        ArrayList<CPListElement> newInPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < inpathEntries.length) {
            IClasspathEntry curr = inpathEntries[i];
            newInPath.add(CPListElement.createFromExisting((IClasspathEntry)curr, (IJavaProject)this.fCurrJProject));
            ++i;
        }
        return newInPath;
    }

    private void updateBuildPathStatus() {
        List elements = this.fInPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere((IStatus[])new IStatus[]{this.fInPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(AspectJUIPlugin.getResourceString("InPathBlock.operationdesc_java"));
        monitor.beginTask("", 10);
        try {
            this.internalConfigureJavaProject(this.fInPathList.getElements(), monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    protected void internalConfigureJavaProject(List inPathEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        int nEntries = inPathEntries.size();
        IClasspathEntry[] inpath = new IClasspathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            CPListElement entry = (CPListElement)inPathEntries.get(i);
            inpath[i] = entry.getClasspathEntry();
            ++i;
        }
        monitor.worked(2);
        StringBuffer inpathBuffer = new StringBuffer();
        StringBuffer contentKindBuffer = new StringBuffer();
        StringBuffer entryKindBuffer = new StringBuffer();
        int i2 = 0;
        while (i2 < inpath.length) {
            inpathBuffer.append(inpath[i2].getPath());
            inpathBuffer.append(File.pathSeparator);
            contentKindBuffer.append(inpath[i2].getContentKind());
            contentKindBuffer.append(File.pathSeparator);
            entryKindBuffer.append(inpath[i2].getEntryKind());
            entryKindBuffer.append(File.pathSeparator);
            ++i2;
        }
        inpathBuffer = this.removeFinalPathSeparatorChar(inpathBuffer);
        contentKindBuffer = this.removeFinalPathSeparatorChar(contentKindBuffer);
        entryKindBuffer = this.removeFinalPathSeparatorChar(entryKindBuffer);
        AspectJCorePreferences.setProjectInPath((IProject)this.fCurrJProject.getProject(), (String)inpathBuffer.toString(), (String)contentKindBuffer.toString(), (String)entryKindBuffer.toString());
    }

    private StringBuffer removeFinalPathSeparatorChar(StringBuffer buffer) {
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == File.pathSeparatorChar) {
            buffer = buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        ImageRegistry imageRegistry = JavaPlugin.getDefault().getImageRegistry();
        IWorkbench workbench = AspectJUIPlugin.getDefault().getWorkbench();
        workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fLibrariesPage = new InPathLibrariesWorkbookPage(this.fWorkspaceRoot, this.fInPathList);
        TabItem item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("InPathBlock.tab.libraries"));
        item.setImage(imageRegistry.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fInPathList);
        item = new TabItem(folder, 0);
        item.setText(AspectJUIPlugin.getResourceString("InPathBlock.tab.inpath.order"));
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InPathBlock.this.tabChanged(e.item);
            }
        });
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.jdt.ui.build_paths_context");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private class InPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        InPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            InPathBlock.this.buildPathDialogFieldChanged(field);
        }
    }
}

