/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.pde.internal.ui.editor.context;

import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.StorageDocumentProvider;
import org.eclipse.pde.internal.ui.editor.SystemFileDocumentProvider;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.model.IEditingModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

public abstract class InputContext {
    private PDEFormEditor editor;
    private IEditorInput input;
    private IBaseModel model;
    private IModelChangedListener modelListener;
    private IDocumentProvider documentProvider;
    private IElementStateListener elementListener;
    private boolean validated;
    private boolean primary;
    protected ArrayList fEditOperations = new ArrayList();
    private boolean fIsSourceMode;
    private boolean mustSynchronize;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    public InputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        this.editor = editor;
        this.input = input;
        this.setPrimary(primary);
    }

    public abstract String getId();

    public IEditorInput getInput() {
        return this.input;
    }

    public PDEFormEditor getEditor() {
        return this.editor;
    }

    public IBaseModel getModel() {
        return this.model;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    protected IDocumentProvider createDocumentProvider(IEditorInput input) {
        FileDocumentProvider documentProvider = null;
        if (input instanceof IFileEditorInput) {
            documentProvider = new FileDocumentProvider(){

                public IDocument createDocument(Object element) throws CoreException {
                    IDocumentPartitioner partitioner;
                    IDocument document = super.createDocument(element);
                    if (document != null && (partitioner = InputContext.this.createDocumentPartitioner()) != null) {
                        partitioner.connect(document);
                        document.setDocumentPartitioner(partitioner);
                    }
                    return document;
                }
            };
        } else {
            if (input instanceof SystemFileEditorInput) {
                return new SystemFileDocumentProvider(this.createDocumentPartitioner(), this.getDefaultCharset());
            }
            if (input instanceof IStorageEditorInput) {
                documentProvider = new StorageDocumentProvider(this.createDocumentPartitioner(), this.getDefaultCharset());
            }
        }
        return documentProvider;
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        return null;
    }

    protected abstract String getDefaultCharset();

    protected abstract IBaseModel createModel(IEditorInput var1) throws CoreException;

    protected void create() {
        this.documentProvider = this.createDocumentProvider(this.input);
        if (this.documentProvider == null) {
            return;
        }
        try {
            IAnnotationModel amodel;
            this.documentProvider.connect((Object)this.input);
            this.model = this.createModel(this.input);
            if (this.model instanceof IModelChangeProvider) {
                this.modelListener = new IModelChangedListener(){

                    public void modelChanged(IModelChangedEvent e) {
                        if (e.getChangeType() != 99) {
                            IModelChangeProvider provider;
                            if (!InputContext.this.editor.getLastDirtyState()) {
                                InputContext.this.editor.fireSaveNeeded(InputContext.this.input, true);
                            }
                            if (!InputContext.this.fIsSourceMode && (provider = e.getChangeProvider()) instanceof IEditingModel && ((IEditingModel)provider).isDirty()) {
                                InputContext.this.addTextEditOperation(InputContext.this.fEditOperations, e);
                            }
                        }
                    }
                };
                ((IModelChangeProvider)this.model).addModelChangedListener(this.modelListener);
            }
            if ((amodel = this.documentProvider.getAnnotationModel((Object)this.input)) != null) {
                amodel.connect(this.documentProvider.getDocument((Object)this.input));
            }
            this.elementListener = new ElementListener();
            this.documentProvider.addElementStateListener(this.elementListener);
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            CoreException e = coreException;
            PDEPlugin.logException((Throwable)e);
        }
    }

    public synchronized boolean validateEdit() {
        IFile file;
        if (!this.validated && this.input instanceof IFileEditorInput && (file = ((IFileEditorInput)this.input).getFile()).isReadOnly()) {
            Shell shell = this.editor.getEditorSite().getShell();
            IStatus validateStatus = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)shell);
            this.validated = true;
            if (validateStatus.getSeverity() != 0) {
                ErrorDialog.openError((Shell)shell, (String)this.editor.getTitle(), null, (IStatus)validateStatus);
            }
            return validateStatus.getSeverity() == 0;
        }
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IDocument doc = this.documentProvider.getDocument((Object)this.input);
            this.documentProvider.aboutToChange((Object)this.input);
            this.flushModel(doc);
            this.documentProvider.saveDocument(monitor, (Object)this.input, doc, true);
            this.documentProvider.changed((Object)this.input);
            this.validated = false;
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
            CoreException e = coreException;
            PDEPlugin.logException((Throwable)e);
        }
    }

    protected abstract void addTextEditOperation(ArrayList var1, IModelChangedEvent var2);

    protected void flushModel(IDocument doc) {
        if (this.fEditOperations.size() > 0) {
            try {
                MultiTextEdit edit = new MultiTextEdit();
                int i = 0;
                while (i < this.fEditOperations.size()) {
                    InputContext.insert((TextEdit)edit, (TextEdit)this.fEditOperations.get(i));
                    ++i;
                }
                if (this.model instanceof IEditingModel) {
                    ((IEditingModel)this.model).setStale(true);
                }
                edit.apply(doc);
                this.fEditOperations.clear();
                if (this.model instanceof IEditable) {
                    ((IEditable)this.model).setDirty(false);
                }
            }
            catch (MalformedTreeException malformedTreeException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(malformedTreeException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
                MalformedTreeException e = malformedTreeException;
                PDEPlugin.logException((Throwable)e);
            }
            catch (BadLocationException badLocationException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_5);
                BadLocationException e = badLocationException;
                PDEPlugin.logException((Throwable)e);
            }
        }
    }

    protected static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            if (edit instanceof MoveSourceEdit) {
                parent.addChild((TextEdit)((MoveSourceEdit)edit).getTargetEdit());
            }
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            child = children[i];
            if (InputContext.covers(child, edit)) {
                InputContext.insert(child, edit);
                return;
            }
            ++i;
        }
        i = children.length - 1;
        while (i >= 0) {
            child = children[i];
            if (InputContext.covers(edit, child)) {
                parent.removeChild(i);
                edit.addChild(child);
            }
            --i;
        }
        parent.addChild(edit);
        if (edit instanceof MoveSourceEdit) {
            parent.addChild((TextEdit)((MoveSourceEdit)edit).getTargetEdit());
        }
    }

    protected static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset < otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }

    public boolean mustSave() {
        if (!this.fIsSourceMode && this.model instanceof IEditable && ((IEditable)this.model).isDirty()) {
            return true;
        }
        return this.documentProvider.canSaveDocument((Object)this.input);
    }

    public void dispose() {
        IAnnotationModel amodel = this.documentProvider.getAnnotationModel((Object)this.input);
        if (amodel != null) {
            amodel.disconnect(this.documentProvider.getDocument((Object)this.input));
        }
        this.documentProvider.removeElementStateListener(this.elementListener);
        this.documentProvider.disconnect((Object)this.input);
        if (this.modelListener != null && this.model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)this.model).removeModelChangedListener(this.modelListener);
        }
        if (this.model != null) {
            this.model.dispose();
        }
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean setSourceEditingMode(boolean sourceMode) {
        this.fIsSourceMode = sourceMode;
        if (sourceMode) {
            this.flushModel(this.documentProvider.getDocument((Object)this.input));
            this.mustSynchronize = true;
            return true;
        }
        return this.synchronizeModelIfNeeded();
    }

    private boolean synchronizeModelIfNeeded() {
        if (this.mustSynchronize) {
            boolean result = this.synchronizeModel(this.documentProvider.getDocument((Object)this.input));
            this.mustSynchronize = false;
            return result;
        }
        return true;
    }

    public void doRevert() {
        this.mustSynchronize = true;
        this.synchronizeModelIfNeeded();
    }

    public boolean isInSourceMode() {
        return this.fIsSourceMode;
    }

    public boolean isModelCorrect() {
        this.synchronizeModelIfNeeded();
        return this.model != null ? this.model.isValid() : false;
    }

    protected boolean synchronizeModel(IDocument doc) {
        return true;
    }

    public boolean matches(IResource resource) {
        IFileEditorInput finput;
        IFile file;
        return this.input instanceof IFileEditorInput && (file = (finput = (IFileEditorInput)this.input).getFile()).equals((Object)resource);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    static {
        Factory factory = new Factory("InputContext.java", Class.forName("org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.core.runtime.CoreException:", "e:"), 169);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "create", "org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "", "", "", "void"), 134);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.core.runtime.CoreException:", "e:"), 226);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "doSave", "org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "void"), 193);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.text.edits.MalformedTreeException:", "e:"), 246);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "flushModel", "org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.jface.text.IDocument:", "doc:", "", "void"), 233);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext", "org.eclipse.jface.text.BadLocationException:", "e:"), 248);
    }

    class ElementListener
    implements IElementStateListener {
        ElementListener() {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
            InputContext.this.doRevert();
        }

        public void elementDeleted(Object element) {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            InputContext.this.mustSynchronize = true;
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            InputContext.this.editor.close(true);
        }
    }
}

