/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.TransparentFigure;
import org.eclipse.draw2d.UpdateManager;

public class Layer
extends TransparentFigure {
    protected Layer nextLayer;
    protected Layer prevLayer;

    public Layer getNextLayer() {
        return this.nextLayer;
    }

    public Layer getPreviousLayer() {
        return this.prevLayer;
    }

    public UpdateManager getUpdateManager() {
        UpdateManager manager = super.getUpdateManager();
        if (this.getParent() != null && this.getParent().getUpdateManager() != manager || this.getParent() == null && manager != Figure.NO_MANAGER) {
            return manager;
        }
        if (this.getNextLayer() != null) {
            return this.getNextLayer().getUpdateManager();
        }
        return manager;
    }

    public void paint(Graphics graphics) {
        if (this.getPreviousLayer() != null) {
            graphics.pushState();
            this.getPreviousLayer().paint(graphics);
            graphics.popState();
        }
        if (this.isVisible()) {
            super.paint(graphics);
        }
    }

    public void setNextLayer(Layer layer) {
        this.nextLayer = layer;
    }

    public void setPreviousLayer(Layer layer) {
        this.prevLayer = layer;
    }
}

