/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildconfig;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.CoreUtils;
import org.eclipse.ajdt.internal.buildconfig.BuildConfiguration;
import org.eclipse.ajdt.internal.buildconfig.BuildConfigurator;
import org.eclipse.ajdt.internal.buildconfig.ProjectBuildConfigurator;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class UpdateJob
extends Job {
    public static final int BUILD_CONFIG_CHANGED = 1;
    public static final int BUILD_CONFIG_REMOVED = 2;
    public static final int CLASSPATH_CHANGED = 3;
    public static final int SOURCE_ADDED = 4;
    public static final int FILE_MOVED = 5;
    private int type;
    private IResource myRes;
    private IResource myRes2;
    private final BuildConfigurator myBCor;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;

    public UpdateJob(BuildConfigurator myBCor, int type, IResource myRes) {
        super(AspectJUIPlugin.getResourceString("UpdateJob.name"));
        this.setRule((ISchedulingRule)myRes.getProject());
        this.setSystem(true);
        this.setPriority(20);
        this.myBCor = myBCor;
        this.type = type;
        this.myRes = myRes;
    }

    public UpdateJob(BuildConfigurator myBCor, int type, IResource myRes, IResource myRes2) {
        super(AspectJUIPlugin.getResourceString("UpdateJob.name"));
        this.setRule((ISchedulingRule)myRes.getProject());
        this.setSystem(true);
        this.setPriority(20);
        this.myBCor = myBCor;
        this.type = type;
        this.myRes = myRes;
        this.myRes2 = myRes2;
    }

    protected IStatus run(IProgressMonitor monitor) {
        switch (this.type) {
            case 1: {
                this.buildConfigChanged();
                break;
            }
            case 2: {
                this.buildConfigRemoved();
                break;
            }
            case 3: {
                this.classpathChanged();
                break;
            }
            case 4: {
                this.sourceAdded();
                break;
            }
            case 5: {
                this.fileMoved();
            }
        }
        return Status.OK_STATUS;
    }

    private void sourceAdded() {
        BuildConfiguration bc;
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null && (bc = pbc.getActiveBuildConfiguration()) != null && !bc.isIncluded(this.myRes)) {
            bc.update(false);
        }
    }

    private void classpathChanged() {
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null) {
            try {
                IJavaProject jp = JavaCore.create((IProject)this.myRes.getProject());
                IClasspathEntry[] cpes = jp.getRawClasspath();
                ArrayList<IPath> sourcePathes = new ArrayList<IPath>();
                int i = 0;
                while (i < cpes.length) {
                    if (cpes[i].getEntryKind() == 3) {
                        sourcePathes.add(cpes[i].getPath().removeFirstSegments(1));
                    }
                    ++i;
                }
                Iterator iter = pbc.getBuildConfigurations().iterator();
                while (iter.hasNext()) {
                    ((BuildConfiguration)iter.next()).updateSourceFolders(sourcePathes);
                }
            }
            catch (JavaModelException javaModelException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            }
        }
    }

    private void buildConfigRemoved() {
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null) {
            pbc.removeBuildConfiguration((IFile)this.myRes);
        }
    }

    private void buildConfigChanged() {
        BuildConfiguration bc;
        ProjectBuildConfigurator pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject());
        if (pbc != null && (bc = pbc.getBuildConfiguration((IFile)this.myRes)) != null) {
            bc.update(true);
            pbc.configurationChanged(bc);
        }
    }

    private void fileMoved() {
        ProjectBuildConfigurator pbc;
        if (this.myRes2 == null || this.myRes == null) {
            return;
        }
        if (CoreUtils.ASPECTJ_SOURCE_FILTER.accept(this.myRes2.getName()) && CoreUtils.ASPECTJ_SOURCE_FILTER.accept(this.myRes.getName()) && (pbc = this.myBCor.getProjectBuildConfigurator(this.myRes.getProject())) != null) {
            BuildConfiguration bc = pbc.getActiveBuildConfiguration();
            bc.update(true);
        }
    }

    static {
        Factory factory = new Factory("UpdateJob.java", Class.forName("org.eclipse.ajdt.internal.buildconfig.UpdateJob"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.UpdateJob", "org.eclipse.jdt.core.JavaModelException:", "<missing>:"), 136);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "classpathChanged", "org.eclipse.ajdt.internal.buildconfig.UpdateJob", "", "", "", "void"), 115);
    }
}

