/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildconfig.editor;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.internal.buildconfig.editor.BuildInputContext;
import org.eclipse.ajdt.internal.buildconfig.editor.BuildInputContextManager;
import org.eclipse.ajdt.internal.buildconfig.editor.BuildPage;
import org.eclipse.ajdt.internal.buildconfig.editor.BuildSourcePage;
import org.eclipse.ajdt.internal.buildconfig.editor.BuildUndoManager;
import org.eclipse.ajdt.pde.internal.ui.editor.MultiSourceEditor;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.ajdt.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.ajdt.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.ajdt.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.ajdt.pde.internal.ui.editor.context.InputContext;
import org.eclipse.ajdt.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.build.IBuildObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class BuildEditor
extends MultiSourceEditor {
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_5;

    protected void createResourceContexts(InputContextManager manager, IFileEditorInput input) {
        IFile file = input.getFile();
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
        manager.monitorFile(file);
    }

    protected InputContextManager createInputContextManager() {
        BuildInputContextManager manager = new BuildInputContextManager(this);
        manager.setUndoManager(new BuildUndoManager(this));
        return manager;
    }

    public void monitoredFileAdded(IFile file) {
        if (!this.inputContextManager.hasContext("build-context")) {
            FileEditorInput in = new FileEditorInput(file);
            this.inputContextManager.putContext((IEditorInput)in, new BuildInputContext(this, (IEditorInput)in, false));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        IEditorInput in = this.inputContextManager.getPrimaryContext().getInput();
        if (in instanceof IFileEditorInput) {
            IFile changedFile = ((IFileEditorInput)in).getFile();
            AJLog.log((String)("Build configuration file written: " + changedFile.getName()));
        }
    }

    public boolean monitoredFileRemoved(IFile file) {
        return true;
    }

    public void contextAdded(InputContext context) {
        this.addSourcePage(context.getId());
    }

    public void contextRemoved(InputContext context) {
        if (context.isPrimary()) {
            this.close(true);
            return;
        }
        IFormPage page = this.findPage(context.getId());
        if (page != null) {
            this.removePage(context.getId());
        }
    }

    protected void createSystemFileContexts(InputContextManager manager, SystemFileEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    protected void createStorageContexts(InputContextManager manager, IStorageEditorInput input) {
        manager.putContext((IEditorInput)input, new BuildInputContext(this, (IEditorInput)input, true));
    }

    public boolean canCopy(ISelection selection) {
        return true;
    }

    protected void addPages() {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                this.addPage((IFormPage)new BuildPage(this));
            }
        }
        catch (PartInitException partInitException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
            PartInitException e = partInitException;
            PDEPlugin.logException((Throwable)e);
        }
        this.addSourcePage("build-context");
    }

    protected String computeInitialPageId() {
        String firstPageId = super.computeInitialPageId();
        if (firstPageId == null) {
            InputContext primary = this.inputContextManager.getPrimaryContext();
            if (primary.getId().equals("build-context")) {
                firstPageId = "build";
            }
            if (firstPageId == null) {
                firstPageId = "build";
            }
        }
        return firstPageId;
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new BuildSourcePage(editor, title, name);
    }

    protected IPropertySheetPage getPropertySheet(PDEFormPage page) {
        return null;
    }

    public String getTitle() {
        return super.getTitle();
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IBuildModel)model).isValid() : false;
    }

    protected boolean hasKnownTypes() {
        try {
            TransferData[] types = this.getClipboard().getAvailableTypes();
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
            int i = 0;
            while (i < types.length) {
                int j = 0;
                while (j < transfers.length) {
                    if (transfers[j].isSupportedType(types[i])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SWTError sWTError) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(sWTError, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_3);
        }
        return false;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, this, ajc$tjp_4, (JoinPoint.StaticPart)ajc$tjp_5);
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return null;
        }
        return super.getAdapter(key);
    }

    protected InputContext getInputContext(Object object) {
        InputContext context = null;
        if (object instanceof IBuildObject) {
            context = this.inputContextManager.findContext("build-context");
        }
        return context;
    }

    static {
        Factory factory = new Factory("BuildEditor.java", Class.forName("org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "org.eclipse.ui.PartInitException:", "e:"), 116);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "addPages", "org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "", "", "", "void"), 112);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "org.eclipse.swt.SWTError:", "<missing>:"), 163);
        ajc$tjp_3 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("4", "hasKnownTypes", "org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "", "", "", "boolean"), 152);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "java.lang.ClassNotFoundException:", "<missing>:"), 170);
        ajc$tjp_5 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "getAdapter", "org.eclipse.ajdt.internal.buildconfig.editor.BuildEditor", "java.lang.Class:", "key:", "", "java.lang.Object"), 168);
    }
}

