/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.diff;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.ajdt.core.model.AJModel;
import org.eclipse.ajdt.core.model.AJProjectModel;
import org.eclipse.ajdt.core.model.AJRelationship;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.core.model.AJRelationshipType;
import org.eclipse.ajdt.core.model.ModelComparison;
import org.eclipse.ajdt.internal.ui.diff.ChangesViewFilterAction;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.contribution.xref.internal.ui.utils.XRefUIUtils;
import org.eclipse.contribution.xref.ui.XReferenceUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class ChangesView
extends ViewPart {
    private ChangesViewFilterAction filterAction;
    public static final String CROSSCUTTING_VIEW_ID = "org.eclipse.ajdt.ui.diff.ChangesView";
    public static final String MAP_FILE_EXT = "ajmap";
    public static final String DOT_MAP_FILE_EXT = ".ajmap";
    public static final String CURRENT_BUILD = AspectJUIPlugin.getResourceString("changesView.currentBuild");
    private Table table;
    private TableCursor cursor;
    private int selectedRow;
    private int selectedColumn;
    private IJavaElement[] sourceElements;
    private IJavaElement[] targetElements;
    private int lastMouseDownTime;
    private IProject currFromProject;
    private IProject currToProject;
    private String currFromName;
    private String currToName;
    private static Image incomingImage = null;
    private static Image outgoingImage = null;
    private static ILabelProvider labelProvider = new DecoratingJavaLabelProvider((JavaUILabelProvider)new AppearanceAwareLabelProvider());

    public static void refresh(boolean force) {
        IViewPart view = AspectJUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(CROSSCUTTING_VIEW_ID);
        if (view instanceof ChangesView) {
            ChangesView changesView = (ChangesView)view;
            changesView.refreshIfCurrentBuild(force);
        }
    }

    private void refreshIfCurrentBuild(boolean force) {
        if (this.currFromName != null && this.currToName != null && (force || this.currFromName.equals(CURRENT_BUILD) || this.currToName.equals(CURRENT_BUILD))) {
            this.performComparison(this.currFromProject, this.currFromName, this.currToProject, this.currToName);
        }
    }

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 67586);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        String[] titles = new String[]{AspectJUIPlugin.getResourceString("changesView.table.column1"), AspectJUIPlugin.getResourceString("changesView.table.column2"), AspectJUIPlugin.getResourceString("changesView.table.column3"), AspectJUIPlugin.getResourceString("changesView.table.column4")};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i]);
            ++i;
        }
        int c = 0;
        while (c < titles.length) {
            this.table.getColumn(c).pack();
            final int col = c;
            this.table.getColumn(c).addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableItem[] items = ChangesView.this.table.getItems();
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    int i = 1;
                    while (i < items.length) {
                        String value1 = items[i].getText(col);
                        int j = 0;
                        while (j < i) {
                            String value2 = items[j].getText(col);
                            if (collator.compare(value1, value2) < 0) {
                                String[] values = new String[]{items[i].getText(0), items[i].getText(1), items[i].getText(2), items[i].getText(3)};
                                Image[] icons = new Image[]{items[i].getImage(0), items[i].getImage(1), items[i].getImage(2), items[i].getImage(3)};
                                items[i].dispose();
                                TableItem item = new TableItem(ChangesView.this.table, 0, j);
                                item.setText(values);
                                item.setImage(icons);
                                items = ChangesView.this.table.getItems();
                                IJavaElement temp = ChangesView.this.sourceElements[i];
                                System.arraycopy(ChangesView.this.sourceElements, j, ChangesView.this.sourceElements, j + 1, i - j);
                                ((ChangesView)ChangesView.this).sourceElements[j] = temp;
                                temp = ChangesView.this.targetElements[i];
                                System.arraycopy(ChangesView.this.targetElements, j, ChangesView.this.targetElements, j + 1, i - j);
                                ((ChangesView)ChangesView.this).targetElements[j] = temp;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
            ++c;
        }
        this.cursor = new TableCursor(this.table, 4);
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangesView.this.table.setSelection(new TableItem[]{ChangesView.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChangesView.this.navigateTo(ChangesView.this.table.indexOf(ChangesView.this.cursor.getRow()), ChangesView.this.cursor.getColumn());
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangesView.this.lastMouseDownTime = e.time;
            }
        });
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.time - ChangesView.this.lastMouseDownTime < Display.getDefault().getDoubleClickTime()) {
                    this.mouseDoubleClick(event);
                }
            }

            public void mouseDoubleClick(MouseEvent event) {
                Rectangle b = ChangesView.this.cursor.getBounds();
                Point pt = new Point(b.x + event.x, b.y + event.y);
                TableItem row = ChangesView.this.table.getItem(pt);
                if (row == null) {
                    return;
                }
                int i = 0;
                while (i < ChangesView.this.table.getColumnCount()) {
                    Rectangle rect = row.getBounds(i);
                    if (rect.contains(pt)) {
                        ChangesView.this.navigateTo(ChangesView.this.table.indexOf(row), i);
                    }
                    ++i;
                }
            }
        });
        this.makeActions();
        this.contributeToActionBars();
        this.table.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ChangesView.this.cursor.setVisible(true);
                ChangesView.this.cursor.setFocus();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.cursor.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ChangesView.this.cursor.getRow() != null) {
                    ChangesView.this.selectedColumn = ChangesView.this.cursor.getColumn();
                    ChangesView.this.selectedRow = ChangesView.this.table.indexOf(ChangesView.this.cursor.getRow());
                }
                ChangesView.this.cursor.setVisible(false);
                ChangesView.this.table.setSelection(-1);
            }
        });
    }

    private void navigateTo(int row, int column) {
        if (column == 1 && this.sourceElements != null && row < this.sourceElements.length) {
            XRefUIUtils.revealInEditor((IJavaElement)this.sourceElements[row]);
        } else if (column == 3 && this.targetElements != null && row < this.targetElements.length) {
            XRefUIUtils.revealInEditor((IJavaElement)this.targetElements[row]);
        }
    }

    public void dispose() {
        this.sourceElements = null;
        this.targetElements = null;
        this.currFromProject = null;
        this.currFromName = null;
        this.currToProject = null;
        this.currToName = null;
        if (incomingImage != null) {
            incomingImage.dispose();
            incomingImage = null;
        }
        if (outgoingImage != null) {
            outgoingImage.dispose();
            outgoingImage = null;
        }
    }

    public void setFocus() {
        if (this.table.getItemCount() > 0) {
            this.cursor.setVisible(true);
            if (this.selectedColumn >= 0 && this.selectedColumn < this.table.getColumnCount() && this.selectedRow >= 0 && this.selectedRow < this.table.getItemCount()) {
                this.cursor.setSelection(this.selectedRow, this.selectedColumn);
            } else {
                this.cursor.setSelection(0, 0);
            }
            this.cursor.setFocus();
        }
    }

    private void updateDescription(String fromName, String toName, int remove, int total) {
        if (remove == total) {
            this.setContentDescription(AspectJUIPlugin.getFormattedResourceString("changesView.description", new String[]{fromName, toName}));
        } else {
            this.setContentDescription(String.valueOf(AspectJUIPlugin.getFormattedResourceString("changesView.description", new String[]{fromName, toName})) + " " + AspectJUIPlugin.getFormattedResourceString("changesView.filter.dialog.showingXofY", new String[]{new Integer(remove).toString(), new Integer(total).toString()}));
        }
    }

    private AJProjectModel getModelFromName(IProject project, String name) {
        if (name.equals(CURRENT_BUILD)) {
            return AJModel.getInstance().getModelForProject(project);
        }
        IPath mapFile = project.getFile(name).getLocation();
        AJProjectModel model = new AJProjectModel(project);
        model.loadModel(mapFile);
        return model;
    }

    private static Image getIncomingImage() {
        if (incomingImage == null) {
            incomingImage = AspectJImages.CHANGES_ADDED.getImageDescriptor().createImage();
        }
        return incomingImage;
    }

    private static Image getOutgoingImage() {
        if (outgoingImage == null) {
            outgoingImage = AspectJImages.CHANGES_REMOVED.getImageDescriptor().createImage();
        }
        return outgoingImage;
    }

    private List filterRelationshipList(List relationshipList) {
        ArrayList<AJRelationship> filteredList = new ArrayList<AJRelationship>();
        Iterator iter = relationshipList.iterator();
        while (iter.hasNext()) {
            AJRelationship element = (AJRelationship)iter.next();
            if (this.filterAction.getCheckedList().contains(element.getRelationship().getDisplayName())) continue;
            filteredList.add(element);
        }
        return filteredList;
    }

    public void performComparison(IProject fromProject, String fromName, IProject toProject, String toName) {
        TableItem item;
        String targetName;
        String sourceName;
        AJRelationship rel;
        this.currFromProject = fromProject;
        this.currFromName = fromName;
        this.currToProject = toProject;
        this.currToName = toName;
        AJProjectModel fromModel = this.getModelFromName(fromProject, fromName);
        AJProjectModel toModel = this.getModelFromName(toProject, toName);
        if (fromModel == null || toModel == null) {
            return;
        }
        List[] ret = ModelComparison.compare((AJProjectModel)fromModel, (AJProjectModel)toModel);
        List addedList = this.filterRelationshipList(ret[0]);
        List removedList = this.filterRelationshipList(ret[1]);
        int numEntries = addedList.size() + removedList.size();
        this.sourceElements = new IJavaElement[numEntries];
        this.targetElements = new IJavaElement[numEntries];
        int rowCount = 0;
        int totalNoRelationships = ret[0].size() + ret[1].size();
        this.updateDescription(fromName, toName, addedList.size() + removedList.size(), totalNoRelationships);
        this.table.removeAll();
        Iterator iter = addedList.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            sourceName = toModel.getJavaElementLinkName(rel.getSource());
            targetName = toModel.getJavaElementLinkName(rel.getTarget());
            item = new TableItem(this.table, 0);
            item.setText(0, AspectJUIPlugin.getResourceString("changesView.table.added"));
            item.setImage(0, ChangesView.getIncomingImage());
            item.setText(1, sourceName);
            item.setImage(1, labelProvider.getImage((Object)rel.getSource()));
            item.setText(2, rel.getRelationship().getDisplayName());
            item.setImage(2, XReferenceUIPlugin.getDefault().getXReferenceImage());
            item.setText(3, targetName);
            item.setImage(3, labelProvider.getImage((Object)rel.getTarget()));
            this.sourceElements[rowCount] = rel.getSource();
            this.targetElements[rowCount] = rel.getTarget();
            ++rowCount;
        }
        iter = removedList.iterator();
        while (iter.hasNext()) {
            rel = (AJRelationship)iter.next();
            sourceName = fromModel.getJavaElementLinkName(rel.getSource());
            targetName = fromModel.getJavaElementLinkName(rel.getTarget());
            item = new TableItem(this.table, 0);
            item.setText(0, AspectJUIPlugin.getResourceString("changesView.table.removed"));
            item.setImage(0, ChangesView.getOutgoingImage());
            item.setText(1, sourceName);
            item.setImage(1, labelProvider.getImage((Object)rel.getSource()));
            item.setText(2, rel.getRelationship().getDisplayName());
            item.setImage(2, XReferenceUIPlugin.getDefault().getXReferenceImage());
            item.setText(3, targetName);
            item.setImage(3, labelProvider.getImage((Object)rel.getTarget()));
            this.sourceElements[rowCount] = rel.getSource();
            this.targetElements[rowCount] = rel.getTarget();
            ++rowCount;
        }
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        int w = this.table.getClientArea().width - this.table.getColumn(0).getWidth() - this.table.getColumn(2).getWidth();
        this.table.getColumn(1).setWidth(w / 2);
        this.table.getColumn(3).setWidth(w - w / 2);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.filterAction.fillActionBars(this.getViewSite().getActionBars());
    }

    private void makeActions() {
        AJRelationshipType[] relationshipTypes = AJRelationshipManager.getAllRelatinshipTypes();
        ArrayList<String> populatingList = new ArrayList<String>();
        int i = 0;
        while (i < relationshipTypes.length) {
            populatingList.add(relationshipTypes[i].getDisplayName());
            ++i;
        }
        ArrayList<String> defaultFilterList = new ArrayList<String>();
        defaultFilterList.add(AJRelationshipManager.ADVISED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.ASPECT_DECLARATIONS.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.MATCHES_DECLARE.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.ANNOTATED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.SOFTENED_BY.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.USES_POINTCUT.getDisplayName());
        defaultFilterList.add(AJRelationshipManager.POINTCUT_USED_BY.getDisplayName());
        ArrayList checkedList = new ArrayList();
        if (checkedList.size() == 0) {
            checkedList = new ArrayList(defaultFilterList);
        }
        String dlogTitle = AspectJUIPlugin.getResourceString("changesView.filter.dialog.title");
        String dlogMessage = AspectJUIPlugin.getResourceString("changesView.filter.dialog.message");
        this.filterAction = new ChangesViewFilterAction(this.getSite().getShell(), populatingList, checkedList, defaultFilterList, dlogTitle, dlogMessage, AspectJUIPlugin.getResourceString("changesView.filter.action.tooltip"));
    }
}

