/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.actions;

import java.util.Iterator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AdviceElement;
import org.eclipse.ajdt.core.javaelements.PointcutElement;
import org.eclipse.ajdt.core.javaelements.PointcutUtilities;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.OpenActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class AJOpenAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    public AJOpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString((String)"OpenAction.label"));
        this.setToolTipText(ActionMessages.getString((String)"OpenAction.tooltip"));
        this.setDescription(ActionMessages.getString((String)"OpenAction.description"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.open_action");
    }

    public AJOpenAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setText(ActionMessages.getString((String)"OpenAction.declaration.label"));
        this.setEnabled(SelectionConverter.canOperateOn((JavaEditor)this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ISourceReference || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (JavaEditor)this.fEditor)) {
            return;
        }
        try {
            IJavaElement input;
            IJavaElement element = SelectionConverter.codeResolve((JavaEditor)this.fEditor, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString((String)"OpenAction.select_element"));
            if (element == null && (input = SelectionConverter.getInput((JavaEditor)this.fEditor)) instanceof AJCompilationUnit) {
                IJavaElement el;
                AJCompilationUnit ajcu = (AJCompilationUnit)input;
                String sel = selection.getText();
                if (selection.getLength() == 0) {
                    ajcu.requestOriginalContentMode();
                    String source = ajcu.getSource();
                    ajcu.discardOriginalContentMode();
                    sel = PointcutUtilities.findIdentifier((String)source, (int)selection.getOffset());
                }
                if (sel != null && sel.length() > 0 && ((el = ajcu.getElementAt(selection.getOffset())) instanceof AdviceElement || el instanceof PointcutElement)) {
                    element = PointcutUtilities.findPointcut((IJavaElement)el, (String)sel);
                }
            }
            if (element == null) {
                IEditorStatusLine statusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException, (Object)this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter((Class)clazz)) != null) {
                    statusLine.setMessage(true, ActionMessages.getString((String)"OpenAction.error.messageBadSelection"), null);
                }
                this.getShell().getDisplay().beep();
                return;
            }
            input = SelectionConverter.getInput((JavaEditor)this.fEditor);
            int type = element.getElementType();
            if (type == 2 || type == 3 || type == 4) {
                element = input;
            }
            this.run(new Object[]{element});
        }
        catch (JavaModelException javaModelException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
            JavaModelException e = javaModelException;
            this.showError((CoreException)((Object)e));
        }
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray());
    }

    public void run(Object[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            block10: {
                Object element = elements[i];
                try {
                    element = this.getElementToOpen(element);
                    boolean activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                    OpenActionUtil.open((Object)element, (boolean)activateOnOpen);
                }
                catch (JavaModelException javaModelException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException, (Object)this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                    JavaModelException e = javaModelException;
                    JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, ActionMessages.getString((String)"OpenAction.error.message"), (Throwable)e));
                    ErrorDialog.openError((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString((String)"OpenAction.error.messageProblems"), (IStatus)e.getStatus());
                }
                catch (PartInitException partInitException) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException, (Object)this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
                    PartInitException x = partInitException;
                    String name = null;
                    if (element instanceof IJavaElement) {
                        name = ((IJavaElement)element).getElementName();
                    } else if (element instanceof IStorage) {
                        name = ((IStorage)element).getName();
                    } else if (element instanceof IResource) {
                        name = ((IResource)element).getName();
                    }
                    if (name == null) break block10;
                    MessageDialog.openError((Shell)this.getShell(), (String)ActionMessages.getString((String)"OpenAction.error.messageProblems"), (String)ActionMessages.getFormattedString((String)"OpenAction.error.messageArgs", (Object[])new String[]{name, x.getMessage()}));
                }
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) throws JavaModelException {
        return object;
    }

    private String getDialogTitle() {
        return ActionMessages.getString((String)"OpenAction.error.title");
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle((CoreException)e, (Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.getString((String)"OpenAction.error.message"));
    }

    static {
        Factory factory = new Factory("AJOpenAction.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "java.lang.ClassNotFoundException:", "<missing>:"), 151);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "org.eclipse.jface.text.ITextSelection:", "selection:", "", "void"), 118);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "org.eclipse.jdt.core.JavaModelException:", "e:"), 168);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "org.eclipse.jdt.core.JavaModelException:", "e:"), 199);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "[Ljava.lang.Object;:", "elements:", "", "void"), 189);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.editor.actions.AJOpenAction", "org.eclipse.ui.PartInitException:", "x:"), 208);
    }
}

